# HWID

**HWID (Hardware ID)** — это уникальный идентификатор оборудования, который [Windows](https://ru.wikipedia.org/wiki/Windows) использует для активации системы и привязки лицензии к конкретному устройству. Он формируется на основе характеристик ключевых аппаратных компонентов компьютера.

## Как формируется HWID?

HWID создаётся при установке Windows и основан на комбинации аппаратных компонентов, таких как:

*   **Материнская плата** (самый важный элемент, так как её замена обычно приводит к смене HWID)
*   **Процессор**
*   **Жёсткий диск или SSD**
*   **Оперативная память**
*   **Сетевой адаптер**
*   **BIOS** (версия и серийный номер)

Windows считывает уникальные идентификаторы этих компонентов и комбинирует их в единый хэш, который затем используется для идентификации устройства.

## Для чего используется HWID?

### Активация Windows

Система цифровой лицензии Windows использует HWID для привязки лицензии к компьютеру. Когда пользователь активирует Windows, HWID отправляется на сервер Microsoft, и если в будущем переустановить Windows на том же ПК, система автоматически активируется.

Если происходит **значительное изменение аппаратных компонентов** (например, замена материнской платы), HWID изменится, и активация может сброситься.

### Защита от пиратства

Некоторые программы, особенно игры и софт с DRM-защитой, используют HWID для предотвращения нелегального копирования. Например, если программа запущена на другом ПК, её защита может обнаружить несоответствие HWID и заблокировать запуск.

### Отслеживание лицензий в корпоративных средах

В компаниях администраторы могут использовать HWID для управления лицензиями и отслеживания оборудования.

## Можно ли изменить HWID?

Полностью изменить HWID **нельзя** без серьёзных аппаратных модификаций (например, замены материнской платы). Однако есть несколько способов временно подменить HWID:

*   **Изменение параметров BIOS** (если BIOS позволяет менять серийные номера компонентов)
*   **Специальные программы** (существуют инструменты для спуфинга HWID, но они часто используются в серых схемах)
*   **Виртуальные машины** (в виртуальных средах можно подменить HWID на программном уровне)

## Где можно посмотреть HWID?

**Сам HWID как единый идентификатор недоступен** пользователю напрямую, но можно посмотреть уникальные идентификаторы отдельных компонентов, из которых он формируется.

### Через PowerShell

```powershell
Get-WmiObject Win32_ComputerSystemProduct | Select-Object -ExpandProperty UUID
```

Эта команда выдаст UUID устройства, который используется Windows для идентификации.

### Через командную строку

```bat
wmic csproduct get UUID
```

Также можно посмотреть серийные номера отдельных компонентов:

*   **Жёсткий диск:**
    ```bat
    wmic diskdrive get serialnumber
    ```

*   **Материнская плата:**
    ```bat
    wmic baseboard get serialnumber
    ```

*   **BIOS:**
    ```bat
    wmic bios get serialnumber
    ```