# IPFS

<img src="/img/logo/ipfs.png" style="float: right" width="125px">

**IPFS (InterPlanetary File System)** — распределённая файловая система без цензуры с [открытым исходным кодом](https://github.com/ipfs), доступ к которой осуществляется через [специализированные онлайн-шлюзы](https://ipfs.github.io/public-gateway-checker/) и приложения.

## Ключевые особенности

Облака — MEGA, Google Drive и все прочие — подвержены цензуре, любая информация может быть удалена, активно вводится модерация с помощью искусственного интеллекта. Информация также может быть потеряна, если случится поломка серверов или остановка сервиса. В отличие от них, IPFS представляет собой коалицию распределённых, независимых файловых хранилищ: крупных облаков и мелких хостеров. Как только один хостер загружает в IPFS файл, на него генерируется вечная ссылка: этот файл всегда будет доступен именно по этой ссылке. По крайней мере, такова была идея, [в реальности это не всегда так](https://discuss.ipfs.tech/t/two-ipfs-addresses-for-one-file-how-this-happened/19846), из-за того что каждый файл может быть собран немного по-разному и получить разные адреса, но такие «глюки» случаются нечасто и в идеале их быть не должно.

Для того чтобы файл был доступен, хотя бы один хостер должен быть онлайн и раздавать его, поэтому IPFS очень похож на торрент, но в отличие от торрента, файлы IPFS доступны и могут воспроизводиться в браузере (через шлюз) без скачивания. Для того чтобы быть успешным самостоятельным хостером на IPFS, нужно иметь личный сервер, все остальные могут использовать шлюзы; единственным полностью бесплатным и одним из самых популярных шлюзов является **pinata.cloud**; также есть бесплатный шлюз Storacha, требующий данные банковской карты при регистрации.

Важно не перепутать постоянство и вечность информации в IPFS: данные в IPFS постоянны, но не вечны. Это значит, что как только в IPFS был загружен какой-то файл, он получает один, постоянный идентификатор/ссылку; но он может оказаться недоступен, если никто в сети IPFS не хостит этот файл. При этом после того, как кто-то другой начнёт раздавать этот файл, ссылка на него окажется идентичной. Информация в IPFS не циркулирует свободно, не дублируется между разными узлами и поэтому может быть потеряна, но это не делает IPFS менее надёжным, чем проприетарные облака, которые зависят не от узлов, а только от самих себя, и в любой момент могут закрыться по решению владельцев.

IPFS предоставляет прямые ссылки на скачивание файлов без ограничений, в отличие от популярных облачных сервисов. Это делает IPFS популярным среди разработчиков, так как это позволяет читать и получать доступ к файлам программам напрямую. Когда вы копируете ссылку на файл в облаке, вы получаете ссылку не на сам файл, а на страницу его графической загрузки. Может быть огромное количество капч, ограничений и проверок, препятствующих прямому доступу к файлу.

Для примера: Яндекс Диск создаёт временную ссылку на файл, которая полностью истекает; Google Drive создаёт ссылку, которая не имеет срока действия, но ведет на страницу предварительного проомотра; в Dropbox для получения постоянной ссылки необходимо вручную отредактировать её параметр с dl=0 на dl=1; MEGA подобных ссылок вообще не создаёт, передаёт данные через blob. Таким образом, среди множества популярных сервисов только IPFS и Dropbox дают прямую постоянную ссылку на файл, и только IPFS не имеет никакой цензуры. Чтобы вы поняли разницу: при открытии файла mp4 в IPFS вам откроется и проиграется непосредственно само видео, а при открытии файла mp4 в облачном сервисе вам предложат скачать его как пользователю.

IPFS имеет следующую структуру: файлы в системе обозначаются через CID (Content IDentifier), начинающийся на baf или Qm, в зависимости от версии идентификатора (CIDv1 и CIDv0 соответственно). Каждый файл имеет только одно обозначение CID, невозможно заменить один файл другим.

[Пример ссылки на файл в IPFS](https://ipfs.io/ipfs/bafybeiejkem2yl6qbdfl5oeypcm3p4z2nvvqrbzwjtcf622f3x3zygagoa/)

Для изменения файлов используется не менее сложная система — **IPNS (InterPlanetary Naming System)**, смысл которой заключается в том, чтобы вернуть отнятую возможность обновлять файлы, не изменяя при этом саму суть IPFS (хранить все файлы неизменными). IPNS позволяет указывать на различные IPFS-ссылки, обновляя контент. В отличие от IPFS, ссылки IPNS, указывающие на файлы в сети, не являются вечными, имея период валидности, который пользователь назначает самостоятельно (может длиться достаточно долго, например, 30 лет).

Большой проблемой IPNS является обеспечение их постоянной доступности — IPNS-ссылка действительна в течение 48 часов и должна быть перезагружена за это время, дабы не стать неактивной. Существует [гайд](https://github.com/ipfs/kubo/issues/10484#issuecomment-3549358617) по ручной перезагрузке IPNS-ссылок, разработчики [планируют](https://github.com/ipfs/kubo/issues/4435#issuecomment-3549270256) сделать процесс автоматическим, существует сайт-помощник по созданию IPNS. IPNS имеют «пароль» — приватный ключ, генерирующий ссылки в неизменном виде, что позволяет воскрешать их, даже если они стали недоступными.

Из-за такой громоздкой структуры в IPFS/IPNS может быть трудно разобраться новичкам. Тем же, кто, напротив, хочет разобраться больше всех остальных, стоит установить IPFS в виде официальной программы [kubo](https://github.com/ipfs/kubo) на сервер, позволяющей открыть и поддерживать собственный узел, а также продвинуто взаимодействовать с сетью. Это в основном программа командной строки, которая, тем не менее, [имеет и графический интерфейс](https://github.com/ipfs/ipfs-webui).

## Пример использования

1.  Пройдите регистрацию на сайте [pinata.cloud](https://pinata.cloud). Бесплатный лимит в нём — 1 гигабайт, но стоит помнить, что это всего лишь консоль, предоставляющая быстрый доступ. Бесплатный лимит ограничен, и старые файлы придется удалять вручную, чтобы освободить место.
2.  Через [app.pinata.cloud](https://app.pinata.cloud) загрузите файл и получите его CID (baf...). Если вам нужно загрузить несколько файлов или сохранить имя одного файла, загрузите папку с файлом внутри, в ином случае его имя будет потеряно, поэтому рекомендуется загружать контент в IPFS всегда вместе с папкой. Файл будет доступен по ссылке вида `https://ipfs.io/ipfs/ВашCID/НазваниеФайла`, сама папка — то же самое, но без названия файла в конце.
3.  Для создания IPNS-ссылки используйте [IPNS Record Inspector & Creator](https://ipns.ipfs.network/) и выберите `Create Record`. Сгенерируйте private key, обязательно сохраните его и никому не показывайте — он будет использоваться для обновления IPNS-ссылки. После его создания одновременно будет подобран публичный IPNS Name.
4.  В значении `Value` добавьте CID от нужного IPFS-файла.
5.  В самом конце создания ссылки обязательно нажмите `Publish`.
6.  В `Inspect Record` вставьте созданный вами ранее IPNS Name, составляющий тело вашей ссылки; он должен выдать вам корректные данные о ссылке, создали ли вы её или обновили. IPNS-ссылка будет иметь вид `https://ipfs.io/ipns/IPNS Name/НазваниеФайла` и способна перенаправлять на различные файлы внутри IPFS: вы можете сменить CID, а IPNS-ссылка останется той же самой.
7. Для обновления содержимого IPNS-ссылки сначала вставьте ваш IPNS Name в `Inspect Record` и нажмите `Fetch Record`, а затем повторно пройдите её создание через `Create Record`, с тем условием, что теперь вы не генерируете приватный ключ, а импортируете старый. Вам нужно поменять CID от IPFS-файла и через время убедиться, что изменения применились.
8. С течением времени при отсутствии обновлений, републикаций и при непопулярности, ссылка перестанет работать, так как сайт не оживляет IPNS автоматически. Для перезагрузки живой ссылки достаточно вставить IPNS Name в `Inspect Record`, нажать `Fetch Record` и `Republish`, умершую необходимо пересоздать со старым ключом.

Всё готово. Остальное изучение IPFS вам стоит пройти самостоятельно под различные сценарии его использования, благо на него имеется [обширная документация](https://docs.ipfs.tech/). Самое сложное, что можно делать внутри IPFS — хостить целые сайты. Например, существует [зеркало Википедии](https://ipfs.io/ipfs/bafybeiaysi4s6lnjev27ln5icwm6tueaw2vdykrtjkwiphwekaywqhcjze) на IPFS. Внутри IPFS когда-то [действовал поисковик](https://github.com/ipfs-search/ipfs-search), но этот проект был заброшен.
