# Cloudflare WARP

<img src="/img/logo/warp.png" style="float: right" width="200px">

**Cloudflare WARP** — это [VPN-сервис](/network/vpns/vpn-service), предоставляемый [Cloudflare](https://ru.wikipedia.org/wiki/Cloudflare), который предназначен для защиты и ускорения интернет-соединения. WARP не является анонимизирующим VPN, принципиально сохраняя страну подключения пользователя. Поэтому в 99% случаев при подключении у вас будет российский IP-адрес.

В основе работы сервиса WARP лежит протокол **[WireGuard](https://ru.wikipedia.org/wiki/WireGuard)**. Поэтому возможно сгенерировать конфигурационный файл WireGuard, который позволяет подключаться к сети WARP с помощью стандартных клиентов WireGuard, а не только через официальное приложение 1.1.1.1. Для этого существуют неофициальные инструменты и скрипты.

К сожалению, в России активно ограничивается протокол WireGuard, поэтому придётся вместо него использовать [протокол AmneziaWG](/network/vpns/amneziawg).

## Простая генерация конфигурационного файла WARP для AmneziaWG

*   Самый простой способ — использовать онлайн-генераторы конфигов на сайтах (это не мои сайты):
    *   https://warp-mirrors.vercel.app
    *   https://config-generator-warp.vercel.app
    *   https://warp-gen.vercel.app
    *   https://warp.llimonix.pw
    *   https://warp-vless.vercel.app
*   Генераторы в Telegram-ботах (тоже не мои):
    *   [@hostvless_bot](https://t.me/hostvless_bot)
    *   [@warp_generator_bot](https://t.me/warp_generator_bot)
    *   [@warpGuardBot](https://t.me/warpGuardBot)
    *   [@free_vpn_amnezia_bot](https://t.me/free_vpn_amnezia_bot)

::: warning Внимание
**В названии файла могут быть только английские буквы и цифры! Символов, скобок там быть не должно! Если в названии файла оказались символы — переименуйте его.**

Файл конфига должен иметь расширение .conf
Если он скачался с расширением .txt или каким-то другим — поставьте .conf

Пример правильного названия файла: `WARP123.conf`
:::

## Генерация конфигурационного файла WARP для AmneziaWG вручную с помощью скрипта

Нужно выполнить скрипт в bash-терминале. Локальный Linux-компьютер не подойдёт, так как при генерации конфига делаются запросы на сервера, которые заблокированы. Поэтому лучше использовать бесплатные онлайн-терминалы. Самый простой из них — Aeza Terminator.

1.  Зайдите на сайт https://terminator.aeza.net/en/
2.  Выберите **Debian**.
3.  Вставьте команду для выполнения скрипта (Shift + Insert) и нажмите Enter:
    ```shell
    bash <(wget --inet4-only -qO- https://raw.githubusercontent.com/ImMALWARE/bash-warp-generator/main/warp_generator.sh)
    ```
4.  Когда скрипт выполнится, вы можете перейти по ссылке для скачивания конфига файлом, либо копировать конфиг текстом.

::: warning Внимание
**В файле конфига могут быть только английские буквы и цифры! Символов, скобок там быть не должно! Если в названии файла оказались символы — переименуйте его.**

Файл конфига должен иметь расширение .conf
Если он скачался с расширением .txt или каким-то другим — поставьте .conf

Пример правильного названия файла: `WARP123.conf`
:::

### Альтернативы Aeza Terminator

#### pad.ws

1.  Зайдите на https://pad.ws
2.  Continue with Google
3.  В окне Dashboard, если будет кнопка Start, нажмите на неё
4.  Terminal

#### Replit

1.  Зайдите на https://replit.com/new/github/ImMALWARE/bash-warp-generator
2.  Создайте аккаунт
3.  Нажмите Run вверху

**GitHub Codespaces**

1.  Перейдите на https://github.com/ImMALWARE/bash-warp-generator/codespaces
2.  Войдите в аккаунт GitHub
3.  *Create codespace on main*
4.  Дождитесь, пока он загрузится (может занять 10–30 секунд)
5.  В терминале (внизу экрана) введите:
    ```bash
    bash warp_generator.sh
    ```

## ~~Подключение с помощью конфига AmneziaWG через приложение AmneziaWG~~

1.  ~~Скачайте приложение [AmneziaWG (ссылки в этой статье)](/network/vpns/amneziawg)~~
2.  ~~Нажмите на кнопку + или "Добавить туннель", импортируйте конфиг из файла~~
3.  ~~Подключитесь по кнопке~~

## Подключение по AmneziaWG конфигу через приложение AmneziaVPN

1.  Скачайте приложение [AmneziaVPN (ссылки в этой статье)](/network/vpns/amneziavpn)
2.  Выберите "Файл с настройками подключения" и импортируйте скачанный файл
3.  Подтвердите подключение

## WARP в официальном приложении на протоколе MASQUE (экспериментально)

Новые версии официального приложения 1.1.1.1 для Windows, Linux, Android, iOS поддерживают протокол MASQUE, который пока что не заблокирован. Но для первичной регистрации приложение делает запросы к серверам, которые заблокированы. Поэтому порядок действий такой:

1.  Установите официальное приложение 1.1.1.1 из Play Маркета/App Store/с офиц. сайта.
2.  Перед запуском включите любой другой VPN.
3.  Для Android/iOS: Зайдите в настройки (в правом верхнем углу) -> Дополнительно -> Параметры подключения -> Протокол туннелирования. Выберите MASQUE. Для Windows: [выполните команды в командной строке](/windows/run):
    ```bat
    warp-cli registration new
    warp-cli tunnel protocol set MASQUE
    ```
    На Linux выполните те же команды в терминале.
4.  Подключитесь. Больше для подключения не понадобится другой VPN.

**Для Android**: По умолчанию приложение 1.1.1.1 добавляет YouTube в список исключений, поэтому он с этим приложением работать не будет (с AmneziaVPN — будет). Решение — установить [модификацию ReVanced (версию без root)](/apps/revanced).