# ByeByeDPI

<img src="/img/logo/byebyedpi.svg" style="float: right" width="200px">

**ByeByeDPI** или сокращённо ***bbd*** — Android-приложение для противодействия ограничениям [DPI](https://ru.wikipedia.org/wiki/Deep_packet_inspection), которое локально запускает ByeDPI и перенаправляет весь трафик через него.

Не требует каких-либо сторонних серверов, работает локально на вашем устройстве, а значит без потерь в скорости интернета и пинге. Приложение использует систему VPN в Android для перенаправления трафика.

Является аналогом [zapret](/network/vpns/zapret) для устройств без [root-прав](/android/root). Если у вас есть root, лучше установите модуль [zapret](/network/vpns/zapret).

## Установка

Для работы приложения требуется Android 6+.

1.  Настройте [безопасный DNS-сервер](/network/secure-dns).
2.  Скачайте APK-файл из [релизов GitHub](https://github.com/romanvht/ByeDPIAndroid/releases/latest) и установите его.
3.  Для запуска используйте кнопку "Подключить" на главном экране.

**Запустите официальный клиент YouTube** и проверьте, как работает приложение. Для стабильной работы приложения может потребоваться изменить настройки. Если есть какие-то проблемы при воспроизведении, перейдите к следующему шагу.

## Подбор команд противодействия DPI

Если некоторые сайты не работают корректно, стоит попробовать подбор команд.

Для этого:

1.  Зайдите в **настройки ByeByeDPI** (шестерёнка справа вверху).
2.  Активируйте переключатель "Использовать командную строку".
3.  Перейдите в пункт "Подбор стратегий (Beta)".
4.  Перейдите в **настройки Подбора** (шестерёнка справа сверху).
5.  Измените **Количество запросов к домену** на 5.
6.  Вернитесь назад и нажмите на кнопку "Начать подбор".
7.  Дождитесь окончания подбора. Об успешном окончании будет свидетельствовать список, который называется "Стратегии с наибольшим успехом".
8.  Перебирайте стратегии в порядке увеличения номера до тех пор, пока работа YouTube не будет вас устраивать.
9.  Вернитесь в главное меню приложения и подключитесь.

Убедитесь, что во время подбора отключены блокировщики рекламы, AdAway, другие VPN. Если во время проверки произошел сбой — зайдите в настройки подбора (справа сверху), измените "Ожидание между командами в секундах", для начала на 7 и начните подбор заново. Если всё равно происходят сбои — попробуйте очистить все данные ByeByeDPI или удалить приложение и установить его заново.

## Исключения для приложений

Есть возможность настроить приложение так, чтобы ByeByeDPI игнорировал некоторые приложения или работал только с определёнными приложениями. Для этого в настройках (слева вверху) нажмите "Фильтр приложений", выберите черный или белый список соответственно.
<img src="/img/network/vpns/byebyedpi/1.png" style="margin: 15px auto; display: block">

**Белый список** — только выбранные приложения будут работать через ByeByeDPI, все остальные будут работать напрямую.

**Черный список** — выбранные приложения будут работать напрямую, все остальные будут работать через ByeByeDPI.

## Проблемы и решения

1.  **Вылетает подбор**

    Если во время проверки произошел сбой — перейдите в настройки подбора и увеличивайте ожидание между проверками.

2.  **Нет разрешения на активацию VPN**

    Если при попытке подключения вы видите надпись "Нет разрешения на активацию VPN".

    Перейдите в настройки устройства -> "Подключения" -> "VPN".

    Если вы видите, что какое-то приложение постоянно работает в режиме VPN — отключите галочку "всегда включено". Ни в коем случае нельзя, чтобы какое-то приложение подписывалось всегда включено.

3.  **Работает только на Wi-Fi или только на мобильном интернете, или только на одном провайдере**

    Для каждой сети нужна своя стратегия.

    При подключении к другой сети необходимо найти нужные аргументы командной строки, то есть провести повторный подбор. Когда рабочая стратегия для новой сети будет найдена — вы можете *закрепить* её и *подписать*, для какой сети данная стратегия и использовать быстрый запуск стратегий при длительном нажатии на иконку приложения.

4.  **На телевизоре (приставке) пропадает интернет при запуске ByeByeDPI**

    Используйте белый список, укажите только те приложения, которые должны работать через BBD.

5.  **Самопроизвольное отключение ByeByeDPI**

    Необходимо отключить любые режимы энергосбережения для ByeByeDPI в настройках батареи.

    Проверить, нет ли приложения, которое может автоматически запускать режим VPN (например, NUM).

    Отключить различные оптимизаторы.

6.  **Можно ли использовать с MacroDroid/Tasker?**

    Да, в ByeByeDPI в версии 1.6.3 был расширен функционал `ToggleActivity`.

    В Activity можно передать дополнительные параметры и менять стратегию, например, при смене сети.

| Параметр      | Действие                                     | Тип    |
| ------------- | -------------------------------------------- | ------ |
| `strategy`    | Сменить стратегию и подключиться             | String |
| `only_update` | Только обновить стратегию без подключения    | Bool   |
| `only_start`  | Запустить сервис без смены стратегии         | Bool   |
| `only_stop`   | Остановить сервис без смены стратегии        | Bool   |