# blockcheck

<img src="/img/logo/zapret.png" style="float: right" width="130px">

**blockcheck** — скрипт-анализатор способов обхода [DPI](https://ru.wikipedia.org/wiki/Deep_packet_inspection). Используется для автоматизированного подбора стратегий для [zapret](/network/vpns/zapret) в текущей сети по заданным параметрам. Входит в состав оригинального [репозитория разработчика zapret](https://github.com/bol-van/zapret) и [пакета для совместимости с Windows](https://github.com/bol-van/zapret-win-bundle).

## Перед запуском

Очень желательно перед запуском ознакомиться с [оригинальными инструкциями от разработчика](https://github.com/bol-van/zapret?tab=readme-ov-file#быстрый-старт) и установить [безопасный DNS-сервер](/network/secure-dns)! По умолчанию, провайдер имеет возможность перехватывать DNS-запросы и перенаправлять их на свои серверы. Именно из-за этого отображается страница, где написано "Доступ к информационному ресурсу ограничен". Поэтому сначала нужно не дать провайдеру перехватывать DNS-запросы, а уже потом настраивать zapret. [Инструкция по установке безопасного DNS-сервера](/network/secure-dns).

Также перед запуском подбора стратегий убедитесь, что у вас отключены все средства обхода блокировок (VPN, zapret и пр.)!

Проверить, поддерживает ли сайт TLS 1.3 и QUIC, можно на https://http3check.net

## Windows

1.  Скачайте [архив](https://github.com/bol-van/zapret-win-bundle/archive/refs/heads/master.zip) со всем необходимым для работы zapret на Windows.
2.  Распакуйте в любую папку, например, в `C:\zapret-win-bundle`.
3.  Запустите `blockcheck.cmd` в папке `zapret-win-bundle-master\blockcheck`.

## Linux 
1.  Перейдите на страницу [последнего релиза zapret](https://github.com/bol-van/zapret/releases/latest)
2.  Скачайте архив `zapret-vXX.X.zip`, распакуйте его в любую папку.
3.  Откройте терминал в этой папке, запустите `install_bin.sh`, затем `./blockcheck.sh`.

## Запуск подбора стратегий
При запуске начнётся диалог для определения основных параметров подбора.
*  **domain(s)** — список тестируемых доменов через пробел. Напишите домены заблокированных сайтов, на которых хотите проверить работу zapret с различными параметрами. В ходе подбора стратегии, которые сработают для доступа к этим сайтам, будут удачными. Пример:
    ```
    amnezia.org linkedin.com matrix.to rutracker.org signal.org www.facebook.com xvpn.io
    ```
Эти сайты поддерживают IPv6, TLS 1.3, QUIC (HTTP/3).
*  **ip protocol version(s)** — тестируемые версии IP. Ответьте `4` для проверки только IPv4, чего будет достаточно в большинстве случаев. Если вам нужно проверять и IPv4, и IPv6 - ответьте `46`.
*  **check http** — включить тест plain HTTP. Ответьте `N`, чтобы не тратить время на проверку незащищённого протокола HTTP, который сейчас почти не используется.
*  **check http tls 1.2** — включить тест HTTPS c TLS 1.2.

    Когда отвечать «**Y**» (Да): практически всегда. Это основной и самый важный тест. Большинство сайтов поддерживают TLS 1.2, и DPI-системы в первую очередь нацелены на анализ именно такого трафика. Если вы найдете рабочую стратегию для TLS 1.2, она будет наиболее универсальной и, скорее всего, будет работать и для TLS 1.3. Рекомендуется всегда начинать с этого теста.

*  **check https tls 1.3** — включить тест HTTPS c TLS 1.3.

    Когда отвечать «**Y**» (Да): включайте этот тест, если не удалось найти стабильно работающую стратегию с помощью теста TLS 1.2. Поскольку в TLS 1.3 сертификат шифруется, для обхода блокировки могут сработать более простые методы, которые были бессильны против DPI, анализирующего трафик TLS 1.2.

    Когда отвечать «**N**» (Нет): при первом запуске скрипта для экономии времени. Сначала лучше найти универсальное решение (для TLS 1.2), и только если его нет — искать частное решение (только для TLS 1.3).

*  **check http QUIC** — включить тест по протоколу HTTP/3 (QUIC). Это новейший протокол для работы веб-сайтов. В отличие от обычного HTTPS, работающего поверх TCP, он использует протокол QUIC (на базе UDP).

    Когда отвечать «**Y**» (Да): включайте этот тест, если стандартные проверки для HTTPS (TLS 1.2 и 1.3) не дали стабильного результата. QUIC — это ещё один шанс найти лазейку.

    Когда отвечать «**N**» (Нет): при первом запуске, чтобы не тратить время. Сначала лучше проверить более универсальные методы. Важный момент: далеко не все сайты поддерживают HTTP/3. Если вы будете тестировать домен, который не работает по этому протоколу, тест всегда будет провальным, даже если никакой блокировки нет. Сайты из примера выше (Rutracker, Signal и др.) поддерживают QUIC, поэтому на них проверку проводить можно.

*  **how many times to repeat each test** — сколько раз подряд будет проверяться каждая стратегия обхода. Она будет считаться успешной, только если все попытки пройдут удачно. Зачем это нужно? Иногда у провайдеров несколько систем блокировки или трафик идёт по разным каналам. Из-за этого обход может работать нестабильно: то сайт открывается, то нет.

    Когда отвечать **1** (значение по умолчанию): в 99% случаев. Это самый быстрый вариант, и его обычно достаточно для поиска рабочей стратегии.

    Когда отвечать **3**: если вы уже запускали blockcheck, нашли стратегию, но она работает нестабильно. Указав 3, вы заставите скрипт искать только надёжные методы. Учтите, что тестирование займёт больше времени.

*  **quick, standard, force** — уровень сканирования. 

    **quick** — быстрый. Находит первую попавшуюся рабочую стратегию и сразу же прекращает дальнейшие тесты для этого сайта. Выбирайте, если вам нужен результат максимально быстро. Минус: найденная стратегия может быть не самой стабильной или эффективной.

    **standard** — стандартный (рекомендуется). Проводит достаточно глубокий анализ, чтобы найти надёжную и эффективную стратегию. Он не останавливается на первом же успехе, а проверяет основные популярные методы, но при этом пропускает избыточные тесты. Выбирать стоит почти всегда.

    **force** — полный. Проверяет абсолютно все заложенные в скрипт стратегии и их комбинации. Он не остановится, даже если самый простой метод уже сработал. Выбирайте только если режимы quick и standard не нашли ни одного рабочего решения. Минус: тестирование может занять очень много времени.

Сохраните полученный * SUMMARY с найденными стратегиями. Полная история проверки хранится в `blockcheck.log` рядом с одноимённым `.cmd` или `.sh` (до момента перезапуска подбора).
<img src="/img/network/vpns/blockcheck/1.png" style="margin: 15px auto; display: block">
В * SUMMARY выделены три строчки. Каждая — сработавшая для своего теста стратегия.

В [моей сборке zapret](/network/vpns/zapret) есть файл `config.txt`, в котором легко можно отредактировать стратегию. Все стратегии из blockcheck предназначены только для HTTPS (TCP и UDP). Поэтому нужно заменить только те строки в `config.txt`, которые отвечают за HTTPS (TCP и UDP).

TCP стратегия в `config.txt` начинается с `--filter-tcp=443 --hostlist-auto={hosts} --hostlist-exclude={ignore}`, UDP начинается с `--filter-udp=443 --hostlist-auto={hosts} --hostlist-exclude={ignore}`, обе заканчиваются на `--new`. Всё, что между ними, стоит заменить на найденные стратегии из blockcheck.

## Пример действий замены стратегий
Первая стратегия со скриншота выше содержит `--wf-tcp=443`. Значит, она для TCP. Значит, нужно в `config.txt` заменить эту строку:
```
--filter-tcp=443 --hostlist-auto={hosts} --hostlist-exclude={ignore} --ip-id=zero --dpi-desync=multisplit --dpi-desync-split-seqovl=681 --dpi-desync-split-pos=1 --dpi-desync-split-seqovl-pattern={tlsgoogle} --new
```

`--filter-tcp=443 --hostlist-auto={hosts} --hostlist-exclude={ignore}` и `--new` трогать не нужно.
```
--filter-tcp=443 --hostlist-auto={hosts} --hostlist-exclude={ignore} <удалено> --new
```
В первой стратегии со скриншота параметры `--wf-l3=ipv4` (только IPv4) и `--wf-tcp=443` (он в самом начале config.txt) нам не нужны, убираем их. Всё остальное подставляем вместо "<удалено>". Получается так:
```
--filter-tcp=443 --hostlist-auto={hosts} --hostlist-exclude={ignore} --dpi-desync=fake --dpi-desync-ttl=4 --orig-ttl=1 --orig-mod-start=s1 --orig-mod-cutoff=d1 --new
```

Последняя стратегия со скриншота содержит `wf-udp=443`. Значит, она для UDP. Значит нужно в `config.txt` заменить эту строку:
```
--filter-udp=443 --hostlist-auto={hosts} --hostlist-exclude={ignore} --dpi-desync=fake --dpi-desync-repeats=6 --dpi-desync-fake-quic={quicgoogle} --new
```

`--filter-udp=443 --hostlist-auto={hosts} --hostlist-exclude={ignore}` и `--new` трогать не нужно.
```
--filter-udp=443 --hostlist-auto={hosts} --hostlist-exclude={ignore} <удалено> --new
```

В последней стратегии со скриншота параметры `--wf-l3=ipv4` (только IPv4) и `--wf-udp=443` (он в самом начале config.txt) нам не нужны, убираем их. Всё остальное подставляем вместо "<удалено>". Получается так:
```
--filter-udp=443 --hostlist-auto={hosts} --hostlist-exclude={ignore} --dpi-desync=fake --dpi-desync-repeats=10 --new
```

После замен, попробуйте запустить `start_now.bat` и проверить работоспособность нового конфига.
