# AmneziaWG

<img src="/img/logo/amneziawg.png" style="float: right" width="150px">

**AmneziaWG** — это модифицированный протокол ([форк](https://ru.wikipedia.org/wiki/Форк)) WireGuard, разработанный командой проекта [AmneziaVPN](/network/vpns/amneziavpn) для **обхода ограничения** протокола WireGuard. AmneziaWG вносит изменения в протокол WireGuard, чтобы затруднить его обнаружение системами [DPI](https://ru.wikipedia.org/wiki/Deep_packet_inspection), которые используются для идентификации и ограничения VPN-трафика.

Таким образом, AmneziaWG сохраняет высокую производительность, добавляя дополнительный уровень скрытности, что делает его отличным выбором для тех, кому нужно быстрое и незаметное VPN-соединение.

*   Доступно с AmneziaVPN на всех платформах.
*   Низкое энергопотребление.
*   Минимальное количество настроек.
*   Не распознается системами DPI-анализа, устойчив к ограничению.
*   Работает по сетевому протоколу UDP.

AmneziaWG работает в рамках обратной совместимости. То есть реализация AmneziaWG позволяет изменить некоторые статичные параметры в WireGuard, по которым этот протокол обычно и распознают системы DPI. Если не указывать эти параметры, протокол станет обычным WireGuard.

В AmneziaWG изменены заголовки всех пакетов:

*   Пакета рукопожатия (Initiator to Responder).
*   Ответного пакета (Responder to Initiator).
*   Пакета данных.
*   Специального пакета "Under Load" – по умолчанию стоят рандомные значения, но их можно самостоятельно поменять в настройках.

Так как заголовки у каждого пользователя разные, то написать универсальное правило на основе заголовков для систем отслеживания, чтобы вычислить протокол и заблокировать его, просто невозможно.

Еще одно слабое место WireGuard - это размеры пакетов авторизации. В AmneziaWG к каждому auth-пакету дописываются рандомные байты, чтобы изменить их размер. Так "init и response пакеты" рукопожатия дополнительно имеют "мусор" в начале данных, размер которого определяется значениями S1 и S2. По умолчанию инициирующий пакет рукопожатия имеет фиксированный размер (148 байт), а после добавления мусора, его размер будет равен 148 байтам +S1.

В реализации AmneziaWG предусмотрен и еще один трюк для более надежной маскировки. Перед началом сессии AmneziaWG отправляет некоторое количество "мусорных" пакетов, чтобы окончательно запутать системы DPI. Количество таких пакетов и их минимальный и максимальный размер в байтах тоже задается в настройках, параметрами Jc, Jmin и Jmax.

## Параметры файла конфигурации AmneziaWG

*   **Jc** (Junk packet count) — количество пакетов со случайными данными, которые отправляются перед началом сессии
*   **Jmin** (Junk packet minimum size) — минимальный размер пакета для Junk packet. То есть все рандомно генерируемые пакеты будут иметь размер не меньше чем Jmin
*   **Jmax** (Junk packet maximum size) — максимальный размер для Junk пакетов
*   **S1** (Init packet junk size) — размер случайных данных, которые будут добавлены к init пакету, размер которого изначально фиксированный
*   **S2** (Response packet junk size) — размер случайных данных, которые будут добавлены к ответу, размер которого изначально фиксированный
*   **H1** (Init packet magic header) — заголовок первого байта рукопожатия
*   **H2** (Response packet magic header) — заголовок первого байта ответа на рукопожатие
*   **H4** (Transport packet magic header) — заголовок пакета передаваемых данных
*   **H3** (Underload packet magic header) — заголовок пакета UnderLoad

## Приложения AmneziaWG

Подключаться к VPN-серверу по конфигурационному файлу AmneziaWG можно в приложении [AmneziaVPN](/network/vpns/amneziavpn) и в одноименном приложении AmneziaWG.

*   AmneziaWG на Windows 7 и выше: https://github.com/amnezia-vpn/amneziawg-windows-client/releases
*   На macOS и iOS: https://apps.apple.com/us/app/amneziawg/id6478942365
*   На Linux: https://github.com/amnezia-vpn/amneziawg-go (проще установить AmneziaVPN)
*   На Android: https://play.google.com/store/apps/details?id=org.amnezia.awg
*   AmneziaVPN (на все платформы): [AmneziaVPN](/network/vpns/amneziavpn)

Источник: https://docs.amnezia.org/ru/documentation/amnezia-wg/

## Частые ошибки в приложениях AmneziaWG

### Две запятые подряд: ","

По какой-то причине конфиг сгенерировался неверно, удалите его, попробуйте перегенерировать снова другим способом или скачайте уже рабочий. [Гайд по генерации конфига](/network/vpns/warp).

### Название туннеля недействительно: "WARP (1)"

Переименуйте файл .conf, в нём не должно быть пробелов и скобок.

### Неверный ключ для секции [Interface]: "s1"

Импортировать конфиг WARP нужно не в WireGuard, а в AmneziaWG! Скачайте AmneziaWG по ссылкам выше!

### Неправильное имя

В мобильном приложении AmneziaWG названия конфигов могут иметь длину не более 15 символов, в ином случае происходит эта ошибка.

### Включить обфускацию WireGuard

В случае если в конфиге отсутствуют значения S1 и S2, AmneziaVPN не даст подключиться к нему и предложит включить обфускацию. Приложение AmneziaWG умеет читать такие сломанные конфиги, но использовать их всё равно не рекомендуется.

### Unable to create Wintun interface

#### Решение 1: Удаление записи в реестре
1.  Откройте "Редактор реестра" в Windows. Его можно найти в поиске, либо [выполнить команду](/windows/run) `regedit`.
2.  Перейдите в **HKEY_CLASSES_ROOT** -> **CLSID**. Найдите и удалите раздел `{3d09c1ca-2bcc-40b7-b9bb-3f3ec143a87b}`.
3.  Перезапустите приложение AmneziaWG.

#### Решение 2: Переустановка AmneziaWG от имени администратора:

1.  Удалите AmneziaWG в "Программах и компонентах"
2.  Скопируйте полный путь к .msi файлу установщика AmneziaWG. Для этого, **удерживая Shift**, нажмите правой кнопкой мыши по нему -> Копировать как путь
3.  Откройте [Командную строку от имени администратора](/windows/run)
4.  Вставьте в командную строку скопированный путь, нажав по ней правой кнопкой мыши, нажмите Enter

Таким образом, msi файл будет открыт от имени администратора, возможно, это решит проблему.

#### Решение 3: Удаление драйвера wintun:

1.  Удалите AmneziaWG в "Программах и компонентах"
2.  Откройте [Командную строку от имени администратора](/windows/run)
3.  Выполните команды:
    ```bat
    dism /online /get-drivers /format:table > drivers.txt
    notepad drivers.txt
    ```
4.  Найдите `wintun.inf`, нам нужен его oem-номер. В моём случае это `oem7.inf`:
    <img src="/img/network/vpns/amneziawg/1.png">
5.  Выполните команду для его удаления:
    ```bat
    pnputil.exe /d oem7.inf
    ```
    ::: warning Внимание
    Вместо 7 подставьте номер, который соответствует wintun.inf в вашем блокноте!
    :::
6.  Скопируйте полный путь к .msi файлу установщика AmneziaWG. Для этого **удерживая Shift** нажмите правой кнопкой мыши по нему -> Копировать как путь
7.  Вставьте в командную строку скопированный путь, просто нажав по ней правой кнопкой мыши, нажмите Enter. Установите AmneziaWG.

#### Решение 4: AmneziaVPN вместо AmneziaWG

Приложение [AmneziaVPN](/network/vpns/amneziavpn) полностью поддерживает конфиги протокола AmneziaWG. [Ссылки на скачивание тут](/network/vpns/amneziavpn).

### Не работают соединения к локальной сети

Откройте конфигурационный файл для редактирования:

<img src="/img/network/vpns/amneziawg/2.png"/>

Уберите галочку "Блокировать нетуннелированный трафик"