# Безопасный DNS-сервер

**DNS** (Domain Name System) — это система доменных имен, которая переводит понятные человеку доменные имена (например, `wiki.malw.link`) в IP-адреса. Когда вы вводите адрес веб-сайта в браузере, браузер отправляет запрос на DNS-сервер, чтобы узнать, на каком IP-адресе расположен `wiki.malw.link`, куда нужно отправить запрос.

По умолчанию, DNS-запросы не зашифрованы и могут быть перехвачены. Поэтому лучше настроить DNS over HTTPS и DNS over TLS. Они чаще всего называются "Безопасным DNS-сервером".

**DNS over HTTPS** — это протокол, который шифрует DNS-запросы с помощью HTTPS. Это помогает предотвратить прослушивание и перехват запросов в процессе их передачи между устройством и DNS-сервером.

**DNS over TLS** — это еще один метод шифрования DNS-запросов, но в отличие от DoH, он использует протокол TLS. DoT также обеспечивает безопасное соединение между клиентом и сервером, защищая DNS-запросы от перехвата.

Эти типы DNS-серверов можно настроить в браузерах и в последних версиях Windows 11.

## Настройка DoH/DoT

Если DNS-сервер уже настроен в системе, нет смысла настраивать его ещё и в браузере.

У Cloudflare самые быстрые DNS-серверы.

### Windows 11, версия 22H2 и выше

#### Для Ethernet-соединения

Параметры > Сеть и Интернет > Ethernet > Назначение DNS-сервера > Изменить > Вручную

#### Для беспроводной сети:

Параметры > Сеть и Интернет > Wi-Fi > Свойства [название_беспроводной_сети] > Назначение DNS-сервера > Изменить > Вручную

Заполните настройки как на скриншоте:
<img src="/img/network/secure-dns/1.png" style="margin: 15px auto; display: block;">

### Chrome на ПК

Скопируйте адрес `chrome://settings/security`, вставьте в адресную строку, перейдите. В "Дополнительных настройках" включите "Использовать безопасный DNS-сервер", в выпадающем меню выберите Cloudflare.

### Firefox на ПК

Скопируйте адрес `about:settings#privacy`, вставьте в адресную строку, перейдите. В самом низу будет раздел "DNS через HTTPS". Выберите "Максимальную защиту", в выпадающем меню выберите Cloudflare.

### Android 9 и выше

Найдите в настройках "Частный DNS-сервер". На каждой прошивке пункт находится в разных разделах, поэтому проще всего использовать поиск. В меню "Частный DNS-сервер" выберите "Вручную" и введите адрес `dns.cloudflare.com`.

### Chrome на Android

Настройки Chrome -> Конфиденциальность и безопасность -> включите "Использовать безопасный DNS-сервер" -> Выбрать другого поставщика -> введите: `https://cloudflare-dns.com/dns-query`