---
layout: home

hero:
  name: "Malw.link Wiki"
  tagline: "(>⩊<)"
  image:
    src: '/img/main_cat.png'
  actions:
    - theme: brand
      text: Принять участие в написании
      link: https://github.com/ImMALWARE/wiki.malw.link?tab=contributing-ov-file
    - theme: alt
      text: Поддержать донатом
      link: https://boosty.to/notmalware/donate
    - theme: alt
      text: Почта для связи
      link: mailto:contact@malw.link
    - theme: alt
      text: Основной сайт
      link: https://malw.link
---
<BackdropAnimation />
<script setup>
import BackdropAnimation from '/.vitepress/theme/components/main_mountains.vue'
</script>
# Список всех статей
## Программы на ПК
- [AutoTotal](/apps/autototal)
<!-- - [Autoruns](/apps/autoruns) -->
<!-- - [Bulk Crap Uninstaller](/apps/bulk-crap-uninstaller) -->
- <img src="/img/logo/homebrew.png" class="inline">[Homebrew](/apps/homebrew)

- <img src="/img/logo/powershell.png" class="inline">[MalwTool](/apps/malwtool)
<!-- - [Millenium for Steam](/apps/millenium-for-steam) -->
<!-- - [NanaZip](/apps/nanazip) -->
- <img src="/img/logo/rufus.png" class="inline">[Rufus](/apps/rufus)

- <img src="/img/logo/spicetify.png" class="inline">[Spicetify](/apps/spicetify)
<!-- - [System Informer](/apps/system-informer) -->
<!-- - [th-ch/YouTube Music](/apps/youtube-music) -->
- <img src="/img/logo/ubo.svg" class="inline">[uBlock Origin](/apps/ubo)
<!-- - [UniGetUI](/apps/unigetui) -->
- <img src="/img/logo/vencord.png" class="inline">[Vencord и Vesktop](/apps/vencord)

- <img src="/img/logo/ventoy.png" class="inline">[Ventoy](/apps/ventoy)

- <img src="/img/logo/winget.png" class="inline">[winget](/apps/winget)

- <img src="/img/logo/scoop.png" class="inline">[scoop](/apps/scoop)

- <img src="/img/logo/wireshark.png" class="inline">[Wireshark](/apps/wireshark)

- <img src="/img/logo/yt-dlp.png" class="inline">[yt-dlp](/apps/yt-dlp)

## Программы на Android
<!-- - [App Manager](/apps/app-manager) -->
- <img src="/img/logo/nfc-card-emulator.png" class="inline">[NFC Card Emulator (Эмулятор карт)](/apps/nfc-card-emulator)
- <img src="/img/logo/pcapdroid.png" class="inline">[PCAPdroid](/apps/pcapdroid)
- <img src="/img/logo/revanced.png" class="inline">[ReVanced](/apps/revanced)
- <img src="/img/logo/smarttube.png" class="inline">[SmartTube](/apps/smarttube)
- <img src="/img/logo/ytdlnis.png" class="inline">[YTDLnis](/apps/ytdlnis)

## Сервисы
- <img src="/img/logo/ipfs.png" class="inline">[IPFS](/services/ipfs)

## Про сеть
- [Безопасный DNS-сервер](/network/secure-dns)
- [Отслеживание списка доменов, к которым обращаются приложения](/network/get-domains)
- [Ускорение устаревших серверов (недоступно в России)](/network/vpns)
<!-- - [Matrix](/networks/matrix) -->

## Windows
- <img src="/img/logo/run.png" class="inline"/>[Выполнение команды в Windows](/windows/run)

- <img src="/img/logo/file-ext.png" class="inline"/>[Отображение расширений файлов в Windows](/windows/file-ext)

- <img src="/img/logo/cleanmgr.png" class="inline"/>[Очистка диска в Windows](/windows/cleanmgr)

- <img src="/img/logo/get-help.png" class="inline"/>[Приложение Get Help в Windows](/windows/get-help)

- <img src="/img/logo/windows11.png" class="inline"/>[Переустановка Windows без флешки](/windows/install-without-usb)
<!-- - [%appdata%](/windows/appdata) -->
- [HWID](/windows/hwid)
<!-- - [TrustedInstaller](/windows/trusted-installer) -->
- <img src="/img/logo/wsa.png" class="inline"/>[Windows Subsystem for Android](/windows/wsa)

## Android
- [Удаление системных приложений без root](/android/uninstall-apps)
<!-- - [Magisk](/android/magisk) -->
<!-- - [root-права](/android/root) -->

## Другое
- <img src="/img/logo/chrome.svg" class="inline"/>[Активация всех расширений в Google Chrome](/other/chrome-ext)

<img src="/img/tongue_cat.webp" style="margin: 45px auto; width: 400px"/>