/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.physics_api_krunch.voxel;

import java.nio.ByteBuffer;
import org.jetbrains.annotations.NotNull;
import org.valkyrienskies.physics_api.voxel.updates.DenseVoxelShapeUpdate;
import org.valkyrienskies.physics_api.voxel.updates.SparseVoxelShapeUpdate;

public class KrunchVoxelChunk16UpdateSerializer {
    private KrunchVoxelChunk16UpdateSerializer() {
    }

    public static void serializeDenseVoxelChunk16Update(@NotNull DenseVoxelShapeUpdate denseVoxelShapeUpdate, @NotNull ByteBuffer byteBuffer) {
        byteBuffer.putInt(denseVoxelShapeUpdate.getRegionX());
        byteBuffer.putInt(denseVoxelShapeUpdate.getRegionY());
        byteBuffer.putInt(denseVoxelShapeUpdate.getRegionZ());
        for (int x2 = 0; x2 < 16; ++x2) {
            for (int y2 = 0; y2 < 16; ++y2) {
                for (int z2 = 0; z2 < 16; ++z2) {
                    byteBuffer.putInt(denseVoxelShapeUpdate.getVoxel(x2, y2, z2));
                }
            }
        }
    }

    public static void serializeSparseVoxelChunk16Update(@NotNull SparseVoxelShapeUpdate sparseVoxelShapeUpdate, @NotNull ByteBuffer byteBuffer) {
        byteBuffer.putInt(sparseVoxelShapeUpdate.getRegionX());
        byteBuffer.putInt(sparseVoxelShapeUpdate.getRegionY());
        byteBuffer.putInt(sparseVoxelShapeUpdate.getRegionZ());
        byteBuffer.putInt(sparseVoxelShapeUpdate.getUpdatesPositions().size());
        for (int i2 = 0; i2 < sparseVoxelShapeUpdate.getUpdatesPositions().size(); ++i2) {
            short updatePos = sparseVoxelShapeUpdate.getUpdatesPositions().getShort(i2);
            int updateValue = sparseVoxelShapeUpdate.getUpdatesTypes().getInt(i2);
            byteBuffer.putShort(updatePos);
            byteBuffer.putInt(updateValue);
        }
    }
}

