/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.mixin.server.world;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.storage.DimensionDataStorage;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.internal.world.VsiPlayer;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.MinecraftPlayer;

@Mixin(value={ChunkMap.class}, priority=1100)
public abstract class MixinChunkMap {
    @Shadow
    @Final
    ServerLevel f_140133_;
    @Shadow
    @Final
    private Supplier<DimensionDataStorage> f_140137_;

    @Inject(method={"getPlayers"}, at={@At(value="RETURN")}, cancellable=true)
    private void postGetPlayersWatchingChunk(ChunkPos chunkPos, boolean onlyOnWatchDistanceEdge, CallbackInfoReturnable<List<ServerPlayer>> cir) {
        Iterator<VsiPlayer> playersWatchingShipChunk = VSGameUtilsKt.getShipObjectWorld(this.f_140133_).getIPlayersWatchingShipChunk(chunkPos.f_45578_, chunkPos.f_45579_, VSGameUtilsKt.getDimensionId((Level)this.f_140133_));
        if (!playersWatchingShipChunk.hasNext()) {
            return;
        }
        List oldReturnValue = (List)cir.getReturnValue();
        HashSet watchingPlayers = new HashSet(oldReturnValue);
        playersWatchingShipChunk.forEachRemaining(iPlayer -> {
            MinecraftPlayer minecraftPlayer = (MinecraftPlayer)iPlayer;
            ServerPlayer playerEntity = (ServerPlayer)minecraftPlayer.getPlayerEntityReference().get();
            if (playerEntity != null) {
                watchingPlayers.add(playerEntity);
            }
        });
        cir.setReturnValue(new ArrayList(watchingPlayers));
    }

    @WrapOperation(method={"anyPlayerCloseEnoughForSpawning"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ChunkMap$DistanceManager;hasPlayersNearby(J)Z")})
    private boolean onHasPlayersNearby(ChunkMap.DistanceManager instance, long l2, Operation<Boolean> original, @Local(argsOnly=true) ChunkPos arg) {
        return (Boolean)original.call(new Object[]{instance, new ChunkPos(BlockPos.m_274446_((Position)VSGameUtilsKt.toWorldCoordinates((Level)this.f_140133_, arg.m_151394_(63)))).m_45588_()});
    }

    @WrapOperation(method={"playerIsCloseEnoughForSpawning"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ChunkMap;euclideanDistanceSquared(Lnet/minecraft/world/level/ChunkPos;Lnet/minecraft/world/entity/Entity;)D")})
    private double onEuclideanDistanceSquared(ChunkPos d0, Entity d1, Operation<Double> original) {
        return (Double)original.call(new Object[]{new ChunkPos(BlockPos.m_274446_((Position)VSGameUtilsKt.toWorldCoordinates((Level)this.f_140133_, d0.m_151394_(63)))), d1});
    }

    @Inject(method={"save"}, at={@At(value="HEAD")}, cancellable=true)
    private void preSave(ChunkAccess chunkAccess, CallbackInfoReturnable<Boolean> cir) {
        ChunkPos pos = chunkAccess.m_7697_();
        ServerShip ship = VSGameUtilsKt.getShipManagingPos(this.f_140133_, pos);
        if (ship != null && !ship.getActiveChunksSet().contains(pos.f_45578_, pos.f_45579_)) {
            cir.setReturnValue((Object)false);
        }
    }
}

