/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.mixin.mod_compat.sodium;

import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkUpdateType;
import me.jellysquid.mods.sodium.client.render.chunk.RenderSection;
import me.jellysquid.mods.sodium.client.render.chunk.RenderSectionManager;
import me.jellysquid.mods.sodium.client.render.chunk.lists.SortedRenderLists;
import me.jellysquid.mods.sodium.client.render.chunk.lists.VisibleChunkCollector;
import me.jellysquid.mods.sodium.client.render.viewport.Viewport;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.valkyrienskies.core.api.ships.ClientShip;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.mixinducks.mod_compat.sodium.RenderSectionManagerDuck;

@Mixin(value={RenderSectionManager.class}, remap=false)
public abstract class MixinRenderSectionManager
implements RenderSectionManagerDuck {
    @Unique
    private final WeakHashMap<ClientShip, SortedRenderLists> shipRenderLists = new WeakHashMap();
    @Shadow
    @Final
    private ClientLevel world;
    @Shadow
    private SortedRenderLists renderLists;
    @Shadow
    private Map<ChunkUpdateType, ArrayDeque<RenderSection>> rebuildLists;

    @Override
    public WeakHashMap<ClientShip, SortedRenderLists> vs_getShipRenderLists() {
        return this.shipRenderLists;
    }

    @Shadow
    protected abstract RenderSection getRenderSection(int var1, int var2, int var3);

    @Shadow
    public abstract void tickVisibleRenders();

    @Inject(at={@At(value="TAIL")}, method={"createTerrainRenderList"})
    private void afterIterateChunks(Camera camera, Viewport viewport, int frame, boolean spectator, CallbackInfo ci2) {
        Iterator iterator = VSGameUtilsKt.getShipObjectWorld(Minecraft.m_91087_()).getLoadedShips().iterator();
        while (iterator.hasNext()) {
            ClientShip ship = (ClientShip)iterator.next();
            VisibleChunkCollector collector = new VisibleChunkCollector(frame);
            ship.getActiveChunksSet().forEach((x2, z2) -> {
                LevelChunk levelChunk = this.world.m_6325_(x2, z2);
                for (int y2 = this.world.m_151560_(); y2 < this.world.m_151561_(); ++y2) {
                    RenderSection section;
                    LevelChunkSection levelChunkSection = levelChunk.m_183278_(y2 - this.world.m_151560_());
                    if (levelChunkSection.m_188008_() || (section = this.getRenderSection(x2, y2, z2)) == null) continue;
                    collector.visit(section, true);
                }
            });
            this.shipRenderLists.put(ship, collector.createRenderLists());
            for (Map.Entry entry : collector.getRebuildLists().entrySet()) {
                this.rebuildLists.get(entry.getKey()).addAll((Collection)entry.getValue());
            }
        }
        this.rebuildLists.forEach((type, rebuildLists) -> {
            ArrayList<RenderSection> rebuildSorted = new ArrayList<RenderSection>((Collection<RenderSection>)rebuildLists);
            rebuildSorted.sort(Comparator.comparingDouble(section -> section.getSquaredDistance(camera.m_90588_())));
            rebuildLists.clear();
            rebuildLists.addAll(rebuildSorted);
        });
    }

    @WrapMethod(method={"tickVisibleRenders"})
    private void tickVisibleShipRenders(Operation<Void> original) {
        original.call(new Object[0]);
        SortedRenderLists trueRenderLists = this.renderLists;
        Iterator<SortedRenderLists> iterator = this.shipRenderLists.values().iterator();
        while (iterator.hasNext()) {
            SortedRenderLists currentShipRenderLists;
            this.renderLists = currentShipRenderLists = iterator.next();
            original.call(new Object[0]);
        }
        this.renderLists = trueRenderLists;
    }

    @Inject(at={@At(value="TAIL")}, method={"resetRenderLists"})
    private void afterResetLists(CallbackInfo ci2) {
        this.shipRenderLists.clear();
    }
}

