/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.mixin.mod_compat.create.entity;

import com.simibubi.create.api.behaviour.movement.MovementBehaviour;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.OrientedContraptionEntity;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.contraptions.actors.harvester.HarvesterMovementBehaviour;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.kinetics.base.BlockBreakingMovementBehaviour;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3d;
import org.joml.Matrix3dc;
import org.joml.Matrix4d;
import org.joml.Matrix4dc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.valkyrienskies.core.api.ships.ContraptionWingProvider;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.LoadedShip;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.common.CompatUtil;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.entity.ShipMountedToData;
import org.valkyrienskies.mod.common.entity.ShipMountedToDataProvider;
import org.valkyrienskies.mod.common.util.IEntityDraggingInformationProvider;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;
import org.valkyrienskies.mod.compat.CreateConversionsKt;
import org.valkyrienskies.mod.mixinducks.mod_compat.create.MixinAbstractContraptionEntityDuck;

@Mixin(value={AbstractContraptionEntity.class})
public abstract class MixinAbstractContraptionEntity
extends Entity
implements MixinAbstractContraptionEntityDuck,
ContraptionWingProvider,
IEntityDraggingInformationProvider,
ShipMountedToDataProvider {
    @Unique
    private static final Logger LOGGER = LogManager.getLogger((String)"Clockwork.MixinAbstractContraptionEntity");
    @Unique
    private int wingGroupId = -1;
    @Shadow(remap=false)
    protected Contraption contraption;
    @Unique
    private boolean vs$forceStall = false;
    @Shadow
    private boolean skipActorStop;
    @Shadow
    @Final
    private static EntityDataAccessor<Boolean> STALLED;

    public MixinAbstractContraptionEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Shadow
    protected abstract StructureTransform makeStructureTransform();

    @Override
    public StructureTransform getStructureTransform() {
        return this.makeStructureTransform();
    }

    @Shadow
    public abstract Vec3 getPassengerPosition(Entity var1, float var2);

    @Shadow
    public abstract Vec3 applyRotation(Vec3 var1, float var2);

    @Shadow
    public abstract Vec3 getAnchorVec();

    @Shadow
    public abstract Vec3 getPrevAnchorVec();

    @Override
    @Nullable
    public ShipMountedToData provideShipMountedToData(@NotNull Entity passenger, @Nullable Float partialTicks) {
        LoadedShip shipObjectEntityMountedTo = VSGameUtilsKt.getLoadedShipManagingPos(passenger.m_9236_(), (Vector3dc)VectorConversionsMCKt.toJOML(this.m_20182_()));
        if (shipObjectEntityMountedTo == null) {
            return null;
        }
        Vec3 transformedPos = this.getPassengerPosition(passenger, partialTicks == null ? 1.0f : partialTicks.floatValue());
        if (transformedPos == null) {
            transformedPos = this.m_20318_(partialTicks == null ? 0.0f : partialTicks.floatValue());
        }
        return new ShipMountedToData(shipObjectEntityMountedTo, (Vector3dc)VectorConversionsMCKt.toJOML(transformedPos));
    }

    @Redirect(method={"moveCollidedEntitiesOnDisassembly"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;setPos(DDD)V"))
    private void redirectSetPos(Entity instance, double x2, double y2, double z2) {
        Vec3 result = CompatUtil.INSTANCE.toSameSpaceAs(instance.m_20193_(), x2, y2, z2, instance.m_20182_());
        if (instance.m_20182_().m_82554_(result) < 20.0) {
            instance.m_6034_(result.f_82479_, result.f_82480_, result.f_82481_);
        } else {
            LOGGER.warn("Warning distance too high ignoring setPos request");
        }
    }

    @Redirect(method={"moveCollidedEntitiesOnDisassembly"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;teleportTo(DDD)V"))
    private void redirectTeleportTo(Entity instance, double x2, double y2, double z2) {
        Vec3 result = CompatUtil.INSTANCE.toSameSpaceAs(instance.m_20193_(), x2, y2, z2, instance.m_20182_());
        if (instance.m_20182_().m_82554_(result) < 20.0) {
            if (VSGameUtilsKt.isBlockInShipyard(instance.m_20193_(), result.f_82479_, result.f_82480_, result.f_82481_) && instance instanceof AbstractMinecart) {
                result.m_82520_(0.0, 0.5, 0.0);
            }
            instance.m_6021_(result.f_82479_, result.f_82480_, result.f_82481_);
        } else {
            LOGGER.warn("Warning distance too high ignoring teleportTo request");
        }
    }

    @Inject(method={"toGlobalVector(Lnet/minecraft/world/phys/Vec3;FZ)Lnet/minecraft/world/phys/Vec3;"}, at={@At(value="HEAD")}, cancellable=true)
    private void redirectToGlobalVector(Vec3 localVec, float partialTicks, boolean prevAnchor, CallbackInfoReturnable<Vec3> cir) {
        if (partialTicks != 1.0f && !prevAnchor) {
            Vec3 anchor = this.getAnchorVec();
            Vec3 oldAnchor = this.getPrevAnchorVec();
            Vec3 lerpedAnchor = new Vec3(Mth.m_14139_((double)partialTicks, (double)oldAnchor.f_82479_, (double)anchor.f_82479_), Mth.m_14139_((double)partialTicks, (double)oldAnchor.f_82480_, (double)anchor.f_82480_), Mth.m_14139_((double)partialTicks, (double)oldAnchor.f_82481_, (double)anchor.f_82481_));
            Vec3 rotationOffset = VecHelper.getCenterOf((Vec3i)BlockPos.f_121853_);
            localVec = localVec.m_82546_(rotationOffset);
            localVec = this.applyRotation(localVec, partialTicks);
            localVec = localVec.m_82549_(rotationOffset).m_82549_(lerpedAnchor);
            cir.setReturnValue((Object)localVec);
        }
    }

    @Shadow
    public abstract Vec3 toGlobalVector(Vec3 var1, float var2);

    @Shadow
    public abstract Vec3 getPrevPositionVec();

    @Unique
    private boolean vs$shouldMod(MovementBehaviour moveBehaviour) {
        return moveBehaviour instanceof BlockBreakingMovementBehaviour || moveBehaviour instanceof HarvesterMovementBehaviour;
    }

    @Unique
    private BlockPos vs$getTargetPos(MovementBehaviour instance, MovementContext context, BlockPos pos, Vec3 actorPosition) {
        Ship ship;
        if (this.vs$shouldMod(instance) && context.world.m_8055_(pos).m_60795_() && VSGameUtilsKt.isBlockInShipyard(context.world, pos) && (ship = VSGameUtilsKt.getShipManagingPos(context.world, pos)) != null) {
            Vector3d actorPosInWorld = ship.getTransform().getShipToWorld().transformPosition(VectorConversionsMCKt.toJOML(actorPosition));
            return BlockPos.m_274561_((double)actorPosInWorld.x(), (double)actorPosInWorld.y(), (double)actorPosInWorld.z());
        }
        return pos;
    }

    @Shadow
    public abstract boolean isStalled();

    @Shadow
    protected abstract boolean shouldActorTrigger(MovementContext var1, StructureTemplate.StructureBlockInfo var2, MovementBehaviour var3, Vec3 var4, BlockPos var5);

    @Shadow
    protected abstract boolean isActorActive(MovementContext var1, MovementBehaviour var2);

    @Shadow
    protected abstract void onContraptionStalled();

    @Inject(method={"tickActors"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void preTickActors(CallbackInfo ci2) {
        ci2.cancel();
        boolean stalledPreviously = this.contraption.stalled;
        if (!this.m_9236_().f_46443_) {
            this.contraption.stalled = this.vs$forceStall;
        }
        this.skipActorStop = true;
        for (MutablePair pair : this.contraption.getActors()) {
            MovementContext context = (MovementContext)pair.right;
            StructureTemplate.StructureBlockInfo blockInfo = (StructureTemplate.StructureBlockInfo)pair.left;
            MovementBehaviour actor = (MovementBehaviour)MovementBehaviour.REGISTRY.get((StateHolder)blockInfo.f_74676_());
            if (actor == null) continue;
            Vec3 oldMotion = context.motion;
            Vec3 actorPosition = this.toGlobalVector(VecHelper.getCenterOf((Vec3i)blockInfo.f_74675_()).m_82549_(actor.getActiveAreaOffset(context)), 1.0f);
            BlockPos gridPosition = this.vs$getTargetPos(actor, context, BlockPos.m_274446_((Position)actorPosition), actorPosition);
            boolean newPosVisited = !context.stall && this.shouldActorTrigger(context, blockInfo, actor, actorPosition, gridPosition);
            context.rotation = v2 -> this.applyRotation((Vec3)v2, 1.0f);
            context.position = actorPosition;
            if (!this.isActorActive(context, actor) && !actor.mustTickWhileDisabled()) continue;
            if (newPosVisited && !context.stall) {
                actor.visitNewPosition(context, gridPosition);
                if (!this.m_6084_()) break;
                context.firstMovement = false;
            }
            if (!oldMotion.equals((Object)context.motion)) {
                actor.onSpeedChanged(context, oldMotion, context.motion);
                if (!this.m_6084_()) break;
            }
            actor.tick(context);
            if (!this.m_6084_()) break;
            this.contraption.stalled |= context.stall;
        }
        if (!this.m_6084_()) {
            this.contraption.stop(this.m_9236_());
            return;
        }
        this.skipActorStop = false;
        for (Entity entity : this.m_20197_()) {
            if (!(entity instanceof OrientedContraptionEntity)) continue;
            OrientedContraptionEntity orientedCE = (OrientedContraptionEntity)entity;
            if (this.contraption.getBearingPosOf(entity.m_20148_()) == null || orientedCE.getContraption() == null || !orientedCE.getContraption().stalled) continue;
            this.contraption.stalled = true;
            break;
        }
        if (!this.m_9236_().f_46443_) {
            if (!stalledPreviously && this.contraption.stalled) {
                this.onContraptionStalled();
            }
            this.f_19804_.m_135381_(STALLED, (Object)this.contraption.stalled);
            return;
        }
        this.contraption.stalled = this.isStalled();
    }

    @Override
    public void vs$setForceStall(boolean forceStall) {
        this.vs$forceStall = forceStall;
    }

    @Inject(method={"getContactPointMotion"}, at={@At(value="HEAD")})
    private void modGetContactPointMotion(Vec3 globalContactPoint, CallbackInfoReturnable<Vec3> cir) {
        Ship ship;
        if (VSGameUtilsKt.isBlockInShipyard(this.m_9236_(), this.getAnchorVec().f_82479_, this.getAnchorVec().f_82480_, this.getAnchorVec().f_82481_) != VSGameUtilsKt.isBlockInShipyard(this.m_9236_(), this.getPrevAnchorVec().f_82479_, this.getPrevAnchorVec().f_82480_, this.getPrevAnchorVec().f_82481_) && (ship = VSGameUtilsKt.getShipManagingPos(this.m_9236_(), (Position)this.getAnchorVec())) != null) {
            Vec3 result = VectorConversionsMCKt.toMinecraft((Vector3dc)ship.getWorldToShip().transformPosition(VectorConversionsMCKt.toJOML(this.getPrevPositionVec())));
            this.f_19854_ = result.f_82479_;
            this.f_19855_ = result.f_82480_;
            this.f_19856_ = result.f_82481_;
        }
    }

    public int getWingGroupId() {
        return this.wingGroupId;
    }

    public void setWingGroupId(int wingGroupId) {
        this.wingGroupId = wingGroupId;
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void postTick(CallbackInfo ci2) {
        ServerLevel serverLevel;
        LoadedServerShip ship;
        AbstractContraptionEntity thisAsAbstractContraptionEntity = (AbstractContraptionEntity)AbstractContraptionEntity.class.cast(this);
        Level level = thisAsAbstractContraptionEntity.m_9236_();
        if (this.wingGroupId != -1 && level instanceof ServerLevel && (ship = VSGameUtilsKt.getLoadedShipManagingPos(serverLevel = (ServerLevel)level, (Vector3dc)VectorConversionsMCKt.toJOML(thisAsAbstractContraptionEntity.m_20182_()))) != null) {
            try {
                ship.getWingManager().setWingGroupTransform(this.wingGroupId, this.computeContraptionWingTransform());
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }

    @NotNull
    public Matrix4dc computeContraptionWingTransform() {
        AbstractContraptionEntity thisAsAbstractContraptionEntity = (AbstractContraptionEntity)AbstractContraptionEntity.class.cast(this);
        Matrix3d rotationMatrix = CreateConversionsKt.toJOML(thisAsAbstractContraptionEntity.getRotationState().asMatrix());
        Vector3d pos = VectorConversionsMCKt.toJOML(thisAsAbstractContraptionEntity.getAnchorVec());
        return new Matrix4d((Matrix3dc)rotationMatrix).setTranslation((Vector3dc)pos);
    }

    @Override
    public boolean vs$shouldDrag() {
        return false;
    }
}

