/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.mixin.mod_compat.create;

import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.ContraptionCollider;
import com.simibubi.create.foundation.collision.Matrix3d;
import javax.annotation.Nullable;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.primitives.AABBd;
import org.joml.primitives.AABBdc;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.IEntityDraggingInformationProvider;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

@Mixin(value={ContraptionCollider.class})
public abstract class MixinContraptionCollider {
    @Unique
    private static final Logger LOGGER = LogManager.getLogger((String)"Clockwork.MixinContraptionCollider");
    @Unique
    private static AbstractContraptionEntity contraptionEnt;
    @Unique
    private static AbstractContraptionEntity hDFTContraptionEntity;
    @Unique
    private static AbstractContraptionEntity bounceEntityContraptionEntity;

    @Shadow
    static Vec3 collide(Vec3 p_20273_, Entity e2) {
        return p_20273_;
    }

    @Unique
    private static AABB entityGetBoundingBox(AbstractContraptionEntity abstractContraptionEntity, Entity instance) {
        Ship ship;
        AABB tempAabb = instance.m_20191_();
        if (!VSGameUtilsKt.isBlockInShipyard(instance.m_20193_(), instance.m_20183_()) && VSGameUtilsKt.isBlockInShipyard(contraptionEnt.m_20193_(), BlockPos.m_274446_((Position)contraptionEnt.getAnchorVec())) && (ship = VSGameUtilsKt.getShipManagingPos(instance.m_20193_(), (Position)contraptionEnt.getAnchorVec())) != null) {
            AABBd temp = new AABBd();
            temp.set((AABBdc)VectorConversionsMCKt.toJOML(tempAabb)).transform(ship.getWorldToShip());
            tempAabb = VectorConversionsMCKt.toMinecraft((AABBdc)temp);
        }
        return tempAabb;
    }

    @Unique
    private static Vec3 entityPosition(AbstractContraptionEntity abstractContraptionEntity, Entity instance, boolean old) {
        Ship ship;
        Vec3 tempVec;
        Vec3 vec3 = tempVec = old ? new Vec3(instance.f_19854_, instance.f_19855_, instance.f_19856_) : instance.m_20182_();
        if (!VSGameUtilsKt.isBlockInShipyard(instance.m_20193_(), instance.m_20183_()) && VSGameUtilsKt.isBlockInShipyard(abstractContraptionEntity.m_20193_(), BlockPos.m_274446_((Position)abstractContraptionEntity.getAnchorVec())) && (ship = VSGameUtilsKt.getShipManagingPos(abstractContraptionEntity.m_20193_(), abstractContraptionEntity.getContraption().anchor)) != null) {
            Vector3d translatedPos = ship.getTransform().getWorldToShip().transformPosition(VectorConversionsMCKt.toJOML(tempVec));
            tempVec = VectorConversionsMCKt.toMinecraft((Vector3dc)translatedPos);
        }
        return tempVec;
    }

    @Unique
    private static Vec3 getSetEntityDeltaMovement(AbstractContraptionEntity abstractContraptionEntity, Entity instance, @Nullable Vec3 motion) {
        Ship ship;
        Vec3 tempVec = instance.m_20184_();
        if (!VSGameUtilsKt.isBlockInShipyard(instance.m_20193_(), instance.m_20183_()) && VSGameUtilsKt.isBlockInShipyard(abstractContraptionEntity.m_20193_(), new BlockPos((Vec3i)abstractContraptionEntity.getContraption().anchor)) && (ship = VSGameUtilsKt.getShipManagingPos(instance.m_20193_(), abstractContraptionEntity.getContraption().anchor)) != null) {
            if (motion != null) {
                motion = !VSGameUtilsKt.isBlockInShipyard(abstractContraptionEntity.m_20193_(), BlockPos.m_274446_((Position)abstractContraptionEntity.getAnchorVec())) ? VectorConversionsMCKt.toMinecraft((Vector3dc)ship.getWorldToShip().transformDirection(VectorConversionsMCKt.toJOML(motion))) : VectorConversionsMCKt.toMinecraft((Vector3dc)ship.getShipToWorld().transformDirection(VectorConversionsMCKt.toJOML(motion)));
                ((IEntityDraggingInformationProvider)instance).getDraggingInformation().setLastShipStoodOn(ship.getId());
                instance.m_20256_(motion);
                motion = null;
            }
            tempVec = VectorConversionsMCKt.toMinecraft((Vector3dc)ship.getWorldToShip().transformDirection(VectorConversionsMCKt.toJOML(tempVec)));
        }
        if (motion != null) {
            instance.m_20256_(motion);
        }
        return tempVec;
    }

    @Inject(method={"collideEntities"}, at={@At(value="HEAD")}, remap=false)
    private static void injectHead(AbstractContraptionEntity contraptionEntity, CallbackInfo ci2) {
        contraptionEnt = contraptionEntity;
    }

    private static void warn1(Vector3d vec3) {
        LOGGER.warn("Warning setPosDistance too high ignoring setPos request [" + vec3.x + "," + vec3.y + "," + vec3.z + "]");
    }

    private static void warn2(double x2, double y2, double z2) {
        LOGGER.warn("Warning DEFAULT setPosDistance too high ignoring setPos request [" + x2 + "," + y2 + "," + z2 + "]");
    }

    private static void setOfPos(AbstractContraptionEntity abstractContraptionEntity, Entity instance, double x2, double y2, double z2) {
        if (VSGameUtilsKt.isBlockInShipyard(instance.m_20193_(), BlockPos.m_274561_((double)x2, (double)y2, (double)z2)) && !VSGameUtilsKt.isBlockInShipyard(instance.m_20193_(), instance.m_20183_())) {
            Ship ship = VSGameUtilsKt.getShipManagingPos(instance.m_20193_(), abstractContraptionEntity.getContraption().anchor);
            if (ship != null) {
                Vector3d newPos = new Vector3d(x2, y2, z2);
                ship.getShipToWorld().transformPosition((Vector3dc)newPos, newPos);
                if (instance.m_20182_().m_82554_(VectorConversionsMCKt.toMinecraft((Vector3dc)newPos)) < 20.0) {
                    instance.m_6034_(newPos.x, newPos.y, newPos.z);
                } else {
                    MixinContraptionCollider.warn1(newPos);
                }
            }
        } else {
            Vec3 vec3 = new Vec3(x2, y2, z2);
            if (instance.m_20182_().m_82554_(vec3) < 20.0) {
                instance.m_6034_(x2, y2, z2);
            } else {
                MixinContraptionCollider.warn2(x2, y2, z2);
            }
        }
    }

    @Redirect(method={"collideEntities"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;setPos(DDD)V"))
    private static void redirectSetPos(Entity instance, double x2, double y2, double z2) {
        MixinContraptionCollider.setOfPos(contraptionEnt, instance, x2, y2, z2);
    }

    @Redirect(method={"collideEntities"}, at=@At(value="INVOKE", target="Lcom/simibubi/create/content/contraptions/AbstractContraptionEntity;getBoundingBox()Lnet/minecraft/world/phys/AABB;"))
    private static AABB redirectContraptionGetBoundingBox(AbstractContraptionEntity instance) {
        return VSGameUtilsKt.transformAabbToWorld(instance.m_20193_(), instance.m_20191_());
    }

    @Redirect(method={"collideEntities"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;getBoundingBox()Lnet/minecraft/world/phys/AABB;"))
    private static AABB redirectEntityGetBoundingBox(Entity instance) {
        return MixinContraptionCollider.entityGetBoundingBox(contraptionEnt, instance);
    }

    @Redirect(method={"collideEntities"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;position()Lnet/minecraft/world/phys/Vec3;"))
    private static Vec3 redirectEntityPosition(Entity instance) {
        return MixinContraptionCollider.entityPosition(contraptionEnt, instance, false);
    }

    @Redirect(method={"collideEntities"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;getDeltaMovement()Lnet/minecraft/world/phys/Vec3;"))
    private static Vec3 redirectEntityGetDeltaMovement(Entity instance) {
        return MixinContraptionCollider.getSetEntityDeltaMovement(contraptionEnt, instance, null);
    }

    @Redirect(method={"collideEntities"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;setDeltaMovement(Lnet/minecraft/world/phys/Vec3;)V"))
    private static void redirectEntitySetDeltaMovement(Entity instance, Vec3 motion) {
        MixinContraptionCollider.getSetEntityDeltaMovement(contraptionEnt, instance, motion);
    }

    @Redirect(method={"collideEntities"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;getX()D"))
    private static double redirectEntityGetX(Entity instance) {
        return MixinContraptionCollider.entityPosition((AbstractContraptionEntity)MixinContraptionCollider.contraptionEnt, (Entity)instance, (boolean)false).f_82479_;
    }

    @Redirect(method={"collideEntities"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;getY()D"))
    private static double redirectEntityGetY(Entity instance) {
        return MixinContraptionCollider.entityPosition((AbstractContraptionEntity)MixinContraptionCollider.contraptionEnt, (Entity)instance, (boolean)false).f_82480_;
    }

    @Redirect(method={"collideEntities"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;getZ()D"))
    private static double redirectEntityGetZ(Entity instance) {
        return MixinContraptionCollider.entityPosition((AbstractContraptionEntity)MixinContraptionCollider.contraptionEnt, (Entity)instance, (boolean)false).f_82481_;
    }

    @Redirect(method={"collideEntities"}, at=@At(value="FIELD", target="Lnet/minecraft/world/entity/Entity;xo:D", opcode=180))
    private static double redirectEntityGetXo(Entity instance) {
        return MixinContraptionCollider.entityPosition((AbstractContraptionEntity)MixinContraptionCollider.contraptionEnt, (Entity)instance, (boolean)true).f_82479_;
    }

    @Redirect(method={"collideEntities"}, at=@At(value="FIELD", target="Lnet/minecraft/world/entity/Entity;zo:D", opcode=180))
    private static double redirectEntityGetZo(Entity instance) {
        return MixinContraptionCollider.entityPosition((AbstractContraptionEntity)MixinContraptionCollider.contraptionEnt, (Entity)instance, (boolean)true).f_82481_;
    }

    private static Vec3 aaaaaaaaaaaaaa(AbstractContraptionEntity abstractContraptionEntity, Entity entity, Vec3 anchorVec, Matrix3d rotationMatrix, float yawOffset) {
        Ship ship;
        if (VSGameUtilsKt.isBlockInShipyard(abstractContraptionEntity.m_20193_(), abstractContraptionEntity.getContraption().anchor) && !VSGameUtilsKt.isBlockInShipyard(abstractContraptionEntity.m_20193_(), entity.m_20183_()) && (ship = VSGameUtilsKt.getShipManagingPos(abstractContraptionEntity.m_20193_(), abstractContraptionEntity.getContraption().anchor)) != null) {
            Vec3 entityPosition = MixinContraptionCollider.entityPosition(abstractContraptionEntity, entity, false);
            Vec3 centerY = new Vec3(0.0, MixinContraptionCollider.entityGetBoundingBox(contraptionEnt, entity).m_82376_() / 2.0, 0.0);
            Vec3 position = entityPosition;
            position = position.m_82549_(centerY);
            position = position.m_82546_(VecHelper.CENTER_OF_ORIGIN);
            position = position.m_82546_(anchorVec);
            position = VecHelper.rotate((Vec3)position, (double)(-yawOffset), (Direction.Axis)Direction.Axis.Y);
            position = rotationMatrix.transform(position);
            position = position.m_82549_(VecHelper.CENTER_OF_ORIGIN);
            position = position.m_82546_(centerY);
            position = position.m_82546_(entityPosition);
            return position;
        }
        return ContraptionCollider.getWorldToLocalTranslation((Entity)entity, (Vec3)anchorVec, (Matrix3d)rotationMatrix, (float)yawOffset);
    }

    @Redirect(method={"collideEntities"}, at=@At(value="INVOKE", target="Lcom/simibubi/create/content/contraptions/AbstractContraptionEntity;getPrevPositionVec()Lnet/minecraft/world/phys/Vec3;"))
    private static Vec3 redirectGetPrevPositionVec(AbstractContraptionEntity instance) {
        Ship ship;
        Vec3 prevPos = instance.getPrevPositionVec();
        if (VSGameUtilsKt.isBlockInShipyard(instance.m_9236_(), BlockPos.m_274446_((Position)instance.getAnchorVec())) && !VSGameUtilsKt.isBlockInShipyard(instance.m_9236_(), BlockPos.m_274446_((Position)instance.getPrevAnchorVec())) && (ship = VSGameUtilsKt.getShipManagingPos(instance.m_9236_(), (Position)instance.getAnchorVec())) != null) {
            Vec3 result = VectorConversionsMCKt.toMinecraft((Vector3dc)ship.getWorldToShip().transformPosition(VectorConversionsMCKt.toJOML(instance.getPrevPositionVec())));
            instance.f_19854_ = result.f_82479_;
            instance.f_19855_ = result.f_82480_;
            instance.f_19856_ = result.f_82481_;
            prevPos = result;
        }
        if (VSGameUtilsKt.isBlockInShipyard(instance.m_20193_(), BlockPos.m_274446_((Position)prevPos)) || VSGameUtilsKt.isBlockInShipyard(instance.m_20193_(), BlockPos.m_274446_((Position)instance.m_20182_()))) {
            // empty if block
        }
        return prevPos;
    }

    @Redirect(method={"collideEntities"}, at=@At(value="INVOKE", target="Lcom/simibubi/create/content/contraptions/ContraptionCollider;getWorldToLocalTranslation(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/phys/Vec3;Lcom/simibubi/create/foundation/collision/Matrix3d;F)Lnet/minecraft/world/phys/Vec3;"))
    private static Vec3 redirectGetWorldToLocalTranslation(Entity entity, Vec3 anchorVec, Matrix3d rotationMatrix, float yawOffset) {
        return MixinContraptionCollider.aaaaaaaaaaaaaa(contraptionEnt, entity, anchorVec, rotationMatrix, yawOffset);
    }

    @Unique
    private static Vec3 adjustCollide(Vec3 contactPoint, Entity entity) {
        Ship ship;
        Vec3 result = MixinContraptionCollider.collide(contactPoint, entity);
        if (VSGameUtilsKt.isBlockInShipyard(entity.m_20193_(), contactPoint.f_82479_, contactPoint.f_82480_, contactPoint.f_82481_) && !VSGameUtilsKt.isBlockInShipyard(entity.m_20193_(), entity.m_20183_())) {
            Ship ship2 = VSGameUtilsKt.getShipManagingPos(entity.m_20193_(), (Position)contactPoint);
            if (ship2 != null) {
                Vec3 temp = VectorConversionsMCKt.toMinecraft((Vector3dc)ship2.getShipToWorld().transformPosition(VectorConversionsMCKt.toJOML(contactPoint)));
                result = MixinContraptionCollider.collide(temp, entity);
                result = VectorConversionsMCKt.toMinecraft((Vector3dc)ship2.getWorldToShip().transformPosition(VectorConversionsMCKt.toJOML(result)));
            }
        } else if (!VSGameUtilsKt.isBlockInShipyard(entity.m_20193_(), contactPoint.f_82479_, contactPoint.f_82480_, contactPoint.f_82481_) && VSGameUtilsKt.isBlockInShipyard(entity.m_20193_(), entity.m_20183_()) && (ship = VSGameUtilsKt.getShipManagingPos(entity.m_20193_(), entity.m_20183_())) != null) {
            Vec3 temp = VectorConversionsMCKt.toMinecraft((Vector3dc)ship.getWorldToShip().transformPosition(VectorConversionsMCKt.toJOML(contactPoint)));
            result = MixinContraptionCollider.collide(temp, entity);
            result = VectorConversionsMCKt.toMinecraft((Vector3dc)ship.getShipToWorld().transformPosition(VectorConversionsMCKt.toJOML(result)));
        }
        return result;
    }

    @Redirect(method={"collideEntities"}, at=@At(value="INVOKE", target="Lcom/simibubi/create/content/contraptions/ContraptionCollider;collide(Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/entity/Entity;)Lnet/minecraft/world/phys/Vec3;"))
    private static Vec3 redirectEntityGetBoundingBoxCollide(Vec3 contactPoint, Entity entity) {
        return MixinContraptionCollider.adjustCollide(contactPoint, entity);
    }

    private static AABB redirectEntityGetBoundingBox2(Entity instance) {
        return MixinContraptionCollider.entityGetBoundingBox(contraptionEnt, instance);
    }

    private static Vec3 redirectEntityPosition2(Entity instance) {
        return MixinContraptionCollider.entityPosition(contraptionEnt, instance, false);
    }

    @Inject(method={"worldToLocalPos(Lnet/minecraft/world/phys/Vec3;Lcom/simibubi/create/content/contraptions/AbstractContraptionEntity;)Lnet/minecraft/world/phys/Vec3;"}, at={@At(value="HEAD")}, cancellable=true)
    private static void modPosition(Vec3 entity, AbstractContraptionEntity contraptionEntity, CallbackInfoReturnable<Vec3> cir) {
        Ship ship;
        if (VSGameUtilsKt.isBlockInShipyard(contraptionEntity.m_20193_(), new BlockPos((Vec3i)contraptionEntity.getContraption().anchor)) && !VSGameUtilsKt.isBlockInShipyard(contraptionEntity.m_20193_(), BlockPos.m_274446_((Position)entity)) && (ship = VSGameUtilsKt.getShipManagingPos(contraptionEntity.m_20193_(), contraptionEntity.getContraption().anchor)) != null) {
            cir.setReturnValue((Object)ContraptionCollider.worldToLocalPos((Vec3)entity, (Vec3)VectorConversionsMCKt.toMinecraft((Vector3dc)ship.getShipToWorld().transformPosition(VectorConversionsMCKt.toJOML(contraptionEntity.getAnchorVec()))), (AbstractContraptionEntity.ContraptionRotationState)contraptionEntity.getRotationState()));
        }
    }

    @ModifyVariable(method={"handleDamageFromTrain"}, at=@At(value="HEAD"), argsOnly=true)
    private static AbstractContraptionEntity injectHandleDamageFromTrain(AbstractContraptionEntity abstractContraptionEntity) {
        hDFTContraptionEntity = abstractContraptionEntity;
        return hDFTContraptionEntity;
    }

    @Redirect(method={"handleDamageFromTrain"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;getDeltaMovement()Lnet/minecraft/world/phys/Vec3;"))
    private static Vec3 redirectEntityGetDeltaMovementFromTrain(Entity instance) {
        return MixinContraptionCollider.getSetEntityDeltaMovement(hDFTContraptionEntity, instance, null);
    }

    @ModifyVariable(method={"bounceEntity"}, at=@At(value="HEAD"), argsOnly=true)
    private static AbstractContraptionEntity injectBounceEntity(AbstractContraptionEntity abstractContraptionEntity) {
        bounceEntityContraptionEntity = abstractContraptionEntity;
        return bounceEntityContraptionEntity;
    }

    @Redirect(method={"bounceEntity"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;position()Lnet/minecraft/world/phys/Vec3;"))
    private static Vec3 redirectEntityPositionBounceEntity(Entity instance) {
        return MixinContraptionCollider.entityPosition(bounceEntityContraptionEntity, instance, false);
    }

    @Redirect(method={"bounceEntity"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;getDeltaMovement()Lnet/minecraft/world/phys/Vec3;"))
    private static Vec3 redirectEntityGetDeltaMovementBounceEntity(Entity instance) {
        return MixinContraptionCollider.getSetEntityDeltaMovement(bounceEntityContraptionEntity, instance, null);
    }

    @Redirect(method={"bounceEntity"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;setDeltaMovement(Lnet/minecraft/world/phys/Vec3;)V"))
    private static void redirectEntitySetDeltaMovementBounceEntity(Entity instance, Vec3 motion) {
        MixinContraptionCollider.getSetEntityDeltaMovement(bounceEntityContraptionEntity, instance, motion);
    }
}

