/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.mixin.feature.world_border;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.phys.AABB;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.mixinducks.world.OfLevel;

@Mixin(value={WorldBorder.class})
public class MixinWorldBorder
implements OfLevel {
    @Unique
    @Nullable
    private Level level;

    @ModifyReturnValue(method={"isWithinBounds(Lnet/minecraft/core/BlockPos;)Z"}, at={@At(value="RETURN")})
    public boolean shipsWithinBounds(boolean isWithinBounds, BlockPos pos) {
        return isWithinBounds || this.level != null && VSGameUtilsKt.getShipManagingPos(this.level, pos) != null;
    }

    @ModifyReturnValue(method={"isWithinBounds(Lnet/minecraft/world/level/ChunkPos;)Z"}, at={@At(value="RETURN")})
    public boolean shipsWithinBounds(boolean isWithinBounds, ChunkPos pos) {
        return isWithinBounds || this.level != null && VSGameUtilsKt.getShipManagingPos(this.level, pos) != null;
    }

    @ModifyReturnValue(method={"isWithinBounds(DD)Z"}, at={@At(value="RETURN")})
    public boolean shipsWithinBounds(boolean isWithinBounds, double x2, double z2) {
        return isWithinBounds || this.level != null && VSGameUtilsKt.getShipManagingPos(this.level, (int)x2 >> 4, (int)z2 >> 4) != null;
    }

    @ModifyReturnValue(method={"isWithinBounds(DDD)Z"}, at={@At(value="RETURN")})
    public boolean shipsWithinBounds(boolean isWithinBounds, double x2, double z2, double offset) {
        return isWithinBounds || this.level != null && VSGameUtilsKt.getShipManagingPos(this.level, (int)x2 >> 4, (int)z2 >> 4) != null;
    }

    @ModifyReturnValue(method={"isWithinBounds(Lnet/minecraft/world/phys/AABB;)Z"}, at={@At(value="RETURN")})
    public boolean shipsWithinBounds(boolean isWithinBounds, AABB aabb) {
        if (isWithinBounds || this.level == null) {
            return isWithinBounds;
        }
        Ship s1 = VSGameUtilsKt.getShipManagingPos(this.level, (int)aabb.f_82288_ >> 4, (int)aabb.f_82290_ >> 4);
        Ship s2 = VSGameUtilsKt.getShipManagingPos(this.level, (int)aabb.f_82291_ >> 4, (int)aabb.f_82293_ >> 4);
        return s1 != null && s2 != null && s1.getId() == s2.getId();
    }

    @Override
    @Nullable
    public Level getLevel() {
        return this.level;
    }

    @Override
    public void setLevel(@Nullable Level level) {
        this.level = level;
    }
}

