/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.mixin.feature.render_ship_debug_bb;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Iterator;
import java.util.function.BiConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector2d;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.primitives.AABBic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.valkyrienskies.core.api.ships.ClientShip;
import org.valkyrienskies.core.api.ships.properties.ShipTransform;
import org.valkyrienskies.core.internal.world.VsiClientShipWorld;
import org.valkyrienskies.mod.common.VSClientGameUtils;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.DragInfoReporter;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

@Mixin(value={DebugRenderer.class})
public class MixinDebugRenderer {
    @Unique
    private static RenderType XRAY_LINES;

    @Inject(method={"render"}, at={@At(value="HEAD")})
    private void postRender(PoseStack matrices, MultiBufferSource.BufferSource vertexConsumersIgnore, double cameraX, double cameraY, double cameraZ, CallbackInfo ci2) {
        MultiBufferSource.BufferSource bufferSource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        VsiClientShipWorld shipObjectClientWorld = VSGameUtilsKt.getShipObjectWorld(world);
        if (Minecraft.m_91087_().m_91290_().m_114377_()) {
            matrices.m_85836_();
            matrices.m_85837_(-cameraX, -cameraY, -cameraZ);
            Entity camera = Minecraft.m_91087_().m_91288_();
            Vec3 eyeVec = camera.m_20299_(0.0f);
            Vec3 viewVec = camera.m_20252_(0.0f).m_82490_(20.0);
            Vec3 targetVec = eyeVec.m_82549_(viewVec);
            BlockHitResult hit = world.m_45547_(new ClipContext(eyeVec, targetVec, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, camera));
            if (Minecraft.m_91087_().m_91299_()) {
                return;
            }
            Iterator iterator = shipObjectClientWorld.getLoadedShips().iterator();
            while (iterator.hasNext()) {
                ClientShip shipObjectClient = (ClientShip)iterator.next();
                ShipTransform shipRenderTransform = shipObjectClient.getRenderTransform();
                Vector3dc shipRenderPosition = shipRenderTransform.getPosition();
                boolean xrayEligible = Minecraft.m_91087_().f_91074_.m_5833_() || Minecraft.m_91087_().f_91074_.m_7500_() || shipObjectClient.getRenderAABB().containsPoint((Vector3dc)VectorConversionsMCKt.toJOML(Minecraft.m_91087_().f_91074_.m_20182_())) || shipObjectClient.getRenderAABB().intersectsLineSegment(cameraX, cameraY, cameraZ, hit.f_82445_.f_82479_, hit.f_82445_.f_82480_, hit.f_82445_.f_82481_, new Vector2d()) != -1;
                AABBic shipAABB = shipObjectClient.getShipAABB();
                AABB renderAABB = VectorConversionsMCKt.toMinecraft(shipObjectClient.getRenderAABB());
                if (shipAABB == null) {
                    LevelRenderer.m_109646_((PoseStack)matrices, (VertexConsumer)bufferSource.m_6299_((RenderType)(xrayEligible ? XRAY_LINES : RenderType.f_110371_)), (AABB)renderAABB.m_82400_(0.25), (float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    continue;
                }
                Vector3d centerOfShip = shipAABB.center(new Vector3d());
                AABB shipVoxelAABBAfterOffset = new AABB((double)shipAABB.minX() - centerOfShip.x(), (double)shipAABB.minY() - centerOfShip.y(), (double)shipAABB.minZ() - centerOfShip.z(), (double)shipAABB.maxX() - centerOfShip.x(), (double)shipAABB.maxY() - centerOfShip.y(), (double)shipAABB.maxZ() - centerOfShip.z());
                matrices.m_85836_();
                VSClientGameUtils.transformRenderWithShip(shipRenderTransform, matrices, centerOfShip.x(), centerOfShip.y(), centerOfShip.z(), 0.0, 0.0, 0.0);
                LevelRenderer.m_109646_((PoseStack)matrices, (VertexConsumer)bufferSource.m_6299_((RenderType)RenderType.f_110371_), (AABB)shipVoxelAABBAfterOffset, (float)0.5f, (float)0.0f, (float)0.0f, (float)1.0f);
                Vector3d centerOfMass = shipRenderTransform.getPositionInModel().sub((Vector3dc)centerOfShip, new Vector3d());
                double comBoxSize = 0.25;
                AABB comBox = AABB.m_165882_((Vec3)VectorConversionsMCKt.toMinecraft((Vector3dc)centerOfMass), (double)0.25, (double)0.25, (double)0.25);
                LevelRenderer.m_109646_((PoseStack)matrices, (VertexConsumer)bufferSource.m_6299_((RenderType)(xrayEligible ? XRAY_LINES : RenderType.f_110371_)), (AABB)comBox, (float)0.98039216f, (float)0.7607843f, (float)0.07450981f, (float)1.0f);
                if (xrayEligible) {
                    MixinDebugRenderer.vs_renderGizmoInsideAABB(matrices, bufferSource.m_6299_(XRAY_LINES), shipVoxelAABBAfterOffset, centerOfMass.x, centerOfMass.y, centerOfMass.z, 1.0f, 0.125f);
                }
                matrices.m_85849_();
                LevelRenderer.m_109646_((PoseStack)matrices, (VertexConsumer)bufferSource.m_6299_((RenderType)RenderType.f_110371_), (AABB)renderAABB, (float)0.91764706f, (float)0.0f, (float)0.8509804f, (float)1.0f);
                Vector3dc dragForce = DragInfoReporter.INSTANCE.getShipDragValues().get(shipObjectClient.getId());
                Vector3dc liftForce = DragInfoReporter.INSTANCE.getShipLiftValues().get(shipObjectClient.getId());
                if (dragForce != null) {
                    MixinDebugRenderer.vs_renderForce(matrices, bufferSource.m_6299_((RenderType)RenderType.f_110371_), shipRenderPosition, dragForce, 0.01, 10.0, 0.0f, 0.5f, 1.0f, 1.0f);
                }
                if (liftForce == null) continue;
                MixinDebugRenderer.vs_renderForce(matrices, bufferSource.m_6299_((RenderType)RenderType.f_110371_), shipRenderPosition, liftForce, 0.01, 10.0, 0.0f, 1.0f, 0.5f, 1.0f);
            }
            matrices.m_85849_();
        }
        bufferSource.m_109911_();
    }

    @Unique
    private static void vs_renderForce(PoseStack poseStack, VertexConsumer vertexConsumer, Vector3dc pos, Vector3dc force, double scale, double cap, float r2, float g2, float b2, float alpha) {
        Matrix4f m4 = poseStack.m_85850_().m_252922_();
        Matrix3f m3 = poseStack.m_85850_().m_252943_();
        Vector3d diff = new Vector3d(Math.min(Math.max(-cap, force.x() * scale), cap), Math.min(Math.max(-cap, force.y() * scale), cap), Math.min(Math.max(-cap, force.z() * scale), cap));
        vertexConsumer.m_252986_(m4, (float)pos.x(), (float)pos.y(), (float)pos.z()).m_85950_(r2, g2, b2, alpha).m_252939_(m3, (float)diff.x, (float)diff.y, (float)diff.z).m_5752_();
        vertexConsumer.m_252986_(m4, (float)(pos.x() + diff.x), (float)(pos.y() + diff.y), (float)(pos.z() + diff.z)).m_85950_(1.0f, 1.0f, 1.0f, 0.0f).m_252939_(m3, (float)diff.x, (float)diff.y, (float)diff.z).m_5752_();
    }

    @Unique
    private static void vs_renderGizmoInsideAABB(PoseStack poseStack, VertexConsumer vertexConsumer, AABB aABB, double cx2, double cy2, double cz2, float alpha, float gizmoSize) {
        MixinDebugRenderer.vs_renderGizmoInsideAABB(poseStack, vertexConsumer, aABB.f_82288_, aABB.f_82289_, aABB.f_82290_, aABB.f_82291_, aABB.f_82292_, aABB.f_82293_, cx2, cy2, cz2, alpha, gizmoSize);
    }

    @Unique
    private static void vs_renderGizmoInsideAABB(PoseStack poseStack, VertexConsumer vertexConsumer, double minX, double minY, double minZ, double maxX, double maxY, double maxZ, double cx2, double cy2, double cz2, float alpha, float gizmoSize) {
        Matrix4f m4 = poseStack.m_85850_().m_252922_();
        Matrix3f m3 = poseStack.m_85850_().m_252943_();
        float mx2 = (float)minX;
        float my2 = (float)minY;
        float mz2 = (float)minZ;
        float Mx = (float)maxX;
        float My = (float)maxY;
        float Mz = (float)maxZ;
        float fx2 = (float)cx2;
        float fy2 = (float)cy2;
        float fz2 = (float)cz2;
        Vector3f p1 = new Vector3f();
        Vector3f p2 = new Vector3f();
        Vector3f color = new Vector3f();
        BiConsumer<Vector3f, Vector3f> line = (a2, b2) -> {
            float dx2 = b2.x - a2.x;
            float dy2 = b2.y - a2.y;
            float dz2 = b2.z - a2.z;
            vertexConsumer.m_252986_(m4, a2.x, a2.y, a2.z).m_85950_(color.x, color.y, color.z, alpha).m_252939_(m3, dx2, dy2, dz2).m_5752_();
            vertexConsumer.m_252986_(m4, b2.x, b2.y, b2.z).m_85950_(color.x, color.y, color.z, alpha).m_252939_(m3, dx2, dy2, dz2).m_5752_();
        };
        color.set(1.0f, 0.0f, 0.0f);
        line.accept(p1.set(mx2, fy2, fz2), p2.set(Mx, fy2, fz2));
        line.accept(p1.set(mx2, fy2 - gizmoSize, fz2 - gizmoSize), p2.set(mx2, fy2 + gizmoSize, fz2 + gizmoSize));
        line.accept(p1.set(mx2, fy2 - gizmoSize, fz2 + gizmoSize), p2.set(mx2, fy2 + gizmoSize, fz2 - gizmoSize));
        float backX = Mx - gizmoSize;
        line.accept(p1.set(backX, fy2 - gizmoSize, fz2), p2.set(Mx, fy2, fz2));
        line.accept(p1.set(backX, fy2 + gizmoSize, fz2), p2.set(Mx, fy2, fz2));
        line.accept(p1.set(backX, fy2, fz2 - gizmoSize), p2.set(Mx, fy2, fz2));
        line.accept(p1.set(backX, fy2, fz2 + gizmoSize), p2.set(Mx, fy2, fz2));
        color.set(0.0f, 1.0f, 0.0f);
        line.accept(p1.set(fx2, my2, fz2), p2.set(fx2, My, fz2));
        line.accept(p1.set(fx2 - gizmoSize, my2, fz2 - gizmoSize), p2.set(fx2 + gizmoSize, my2, fz2 + gizmoSize));
        line.accept(p1.set(fx2 - gizmoSize, my2, fz2 + gizmoSize), p2.set(fx2 + gizmoSize, my2, fz2 - gizmoSize));
        float backY = My - gizmoSize;
        line.accept(p1.set(fx2 - gizmoSize, backY, fz2), p2.set(fx2, My, fz2));
        line.accept(p1.set(fx2 + gizmoSize, backY, fz2), p2.set(fx2, My, fz2));
        line.accept(p1.set(fx2, backY, fz2 - gizmoSize), p2.set(fx2, My, fz2));
        line.accept(p1.set(fx2, backY, fz2 + gizmoSize), p2.set(fx2, My, fz2));
        color.set(0.0f, 0.0f, 1.0f);
        line.accept(p1.set(fx2, fy2, mz2), p2.set(fx2, fy2, Mz));
        line.accept(p1.set(fx2 - gizmoSize, fy2 - gizmoSize, mz2), p2.set(fx2 + gizmoSize, fy2 + gizmoSize, mz2));
        line.accept(p1.set(fx2 - gizmoSize, fy2 + gizmoSize, mz2), p2.set(fx2 + gizmoSize, fy2 - gizmoSize, mz2));
        float backZ = Mz - gizmoSize;
        line.accept(p1.set(fx2 - gizmoSize, fy2, backZ), p2.set(fx2, fy2, Mz));
        line.accept(p1.set(fx2 + gizmoSize, fy2, backZ), p2.set(fx2, fy2, Mz));
        line.accept(p1.set(fx2, fy2 - gizmoSize, backZ), p2.set(fx2, fy2, Mz));
        line.accept(p1.set(fx2, fy2 + gizmoSize, backZ), p2.set(fx2, fy2, Mz));
    }

    static {
        new RenderStateShard(null, null, null){

            public static RenderType createXrayLines() {
                return RenderType.m_173215_((String)"xray_lines", (VertexFormat)DefaultVertexFormat.f_166851_, (VertexFormat.Mode)VertexFormat.Mode.LINES, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RenderStateShard.f_173095_).m_110673_(RenderStateShard.f_110130_).m_110669_(RenderStateShard.f_110119_).m_110685_(RenderStateShard.f_110139_).m_110675_(RenderStateShard.f_110129_).m_110687_(RenderStateShard.f_110114_).m_110661_(RenderStateShard.f_110110_).m_110663_(RenderStateShard.f_110111_).m_110691_(false));
            }
        };
        XRAY_LINES = 1.createXrayLines();
    }
}

