/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.mixin.feature.mass_tooltip;

import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.valkyrienskies.mod.common.BlockStateInfo;
import org.valkyrienskies.mod.common.config.VSGameConfig;
import org.valkyrienskies.mod.mixinducks.feature.mass_tooltip.MassTooltipVisibility;
import oshi.util.tuples.Pair;

@Mixin(value={BlockItem.class})
public class MixinBlockItem {
    @Inject(method={"appendHoverText"}, at={@At(value="HEAD")})
    private void ValkyrienSkies$addMassToTooltip(ItemStack itemStack, Level level, List<Component> list, TooltipFlag tooltipFlag, CallbackInfo ci2) {
        MassTooltipVisibility visibility = VSGameConfig.CLIENT.getTooltip().getMassTooltipVisibility();
        if (visibility.isVisible(tooltipFlag)) {
            try {
                BlockItem item = (BlockItem)itemStack.m_41720_();
                Double mass = (Double)Objects.requireNonNull(BlockStateInfo.INSTANCE.get(item.m_40614_().m_49966_())).getFirst();
                list.add((Component)Component.m_237115_((String)"tooltip.valkyrienskies.mass").m_130946_((String)(VSGameConfig.CLIENT.getTooltip().getUseImperialUnits() ? this.getImperialText(mass) : ": " + mass + "kg")).m_130940_(ChatFormatting.DARK_GRAY));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Unique
    private Pair<Integer, Integer> convertToImperial(double mass) {
        double ounces = mass * 35.274;
        double pounds = Math.floor(ounces / 16.0);
        return new Pair((Object)((int)pounds), (Object)((int)Math.floor((ounces / 16.0 - pounds) * 16.0)));
    }

    @Unique
    private String getImperialText(double mass) {
        Object impText = ": ";
        Pair<Integer, Integer> imperial = this.convertToImperial(mass);
        if ((Integer)imperial.getA() > 0) {
            impText = (String)impText + String.valueOf(imperial.getA());
            impText = (Integer)imperial.getA() == 1 ? (String)impText + "lb. " : (String)impText + "lbs. ";
        }
        if ((Integer)imperial.getB() > 0) {
            impText = (String)impText + String.valueOf(imperial.getB()) + "oz.";
        }
        return impText;
    }
}

