/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.mixin.client;

import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Quaternionf;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.primitives.AABBdc;
import org.joml.primitives.AABBi;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.valkyrienskies.core.api.ships.ClientShip;
import org.valkyrienskies.core.api.ships.properties.ShipTransform;
import org.valkyrienskies.core.internal.world.VsiClientShipWorld;
import org.valkyrienskies.mod.client.IVSCamera;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.config.VSGameConfig;
import org.valkyrienskies.mod.common.util.EntityDragger;
import org.valkyrienskies.mod.common.util.IEntityDraggingInformationProvider;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;
import org.valkyrienskies.mod.common.world.RaycastUtilsKt;

@Mixin(value={Camera.class})
public abstract class MixinCamera
implements IVSCamera {
    @Shadow
    private boolean f_90549_;
    @Shadow
    private BlockGetter f_90550_;
    @Shadow
    private Entity f_90551_;
    @Shadow
    @Final
    private Vector3f f_90554_;
    @Shadow
    @Final
    private Vector3f f_90555_;
    @Shadow
    @Final
    private Vector3f f_90556_;
    @Shadow
    private float f_90557_;
    @Shadow
    private float f_90558_;
    @Shadow
    @Final
    private Quaternionf f_90559_;
    @Shadow
    private boolean f_90560_;
    @Shadow
    private float f_90562_;
    @Shadow
    private float f_90563_;
    @Shadow
    private Vec3 f_90552_;
    @Unique
    private int vs$sealedGraceTicks = 0;
    @Unique
    private BlockPos vs$lastSealedCheckPos = BlockPos.f_121853_;

    @Shadow
    protected abstract double m_90566_(double var1);

    @Shadow
    protected abstract void m_90568_(double var1, double var3, double var5);

    @Shadow
    protected abstract void m_90584_(double var1, double var3, double var5);

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void onTick(CallbackInfo ci2) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && player.m_9236_() != null && player instanceof IEntityDraggingInformationProvider) {
            IEntityDraggingInformationProvider provider = (IEntityDraggingInformationProvider)player;
            if (this.f_90549_) {
                Vec3 relativePosition = Vec3.f_82478_;
                if (provider.getDraggingInformation().isEntityBeingDraggedByAShip()) {
                    relativePosition = EntityDragger.INSTANCE.serversideEyePosition((Entity)player);
                } else if (VSGameUtilsKt.getShipMountedTo((Entity)player) != null) {
                    relativePosition = VectorConversionsMCKt.toMinecraft((Vector3dc)VSGameUtilsKt.getShipMountedToData((Entity)player, null).getMountPosInShip().add(0.0, (double)player.m_20236_(player.m_20089_()), 0.0, new Vector3d()));
                }
                boolean isInSealedArea = false;
                if (!isInSealedArea) {
                    if (relativePosition != Vec3.f_82478_ && VSGameUtilsKt.isBlockInShipyard(player.m_9236_(), BlockPos.m_274446_((Position)relativePosition))) {
                        if (BlockPos.m_274446_((Position)relativePosition).equals((Object)this.vs$lastSealedCheckPos)) {
                            isInSealedArea = provider.vs$isInSealedArea();
                        } else {
                            isInSealedArea = VSGameUtilsKt.isPositionSealed(player.m_9236_(), BlockPos.m_274446_((Position)relativePosition));
                            this.vs$lastSealedCheckPos = BlockPos.m_274446_((Position)relativePosition);
                        }
                    } else if (!VSGameUtilsKt.isBlockInShipyard(player.m_9236_(), BlockPos.m_274446_((Position)relativePosition))) {
                        VsiClientShipWorld shipWorld = VSGameUtilsKt.getShipObjectWorld(player.f_108545_);
                        for (ClientShip ship : shipWorld.getAllShips().getIntersecting((AABBdc)VectorConversionsMCKt.toJOML(player.m_20191_().m_82400_(1.0)))) {
                            relativePosition = VectorConversionsMCKt.toMinecraft((Vector3dc)ship.getWorldToShip().transformPosition((Vector3dc)VectorConversionsMCKt.toJOML(player.m_20182_()), new Vector3d()));
                            if (!VSGameUtilsKt.isPositionSealed(player.m_9236_(), BlockPos.m_274446_((Position)relativePosition))) continue;
                            this.vs$lastSealedCheckPos = BlockPos.m_274446_((Position)relativePosition);
                            isInSealedArea = true;
                            break;
                        }
                    }
                }
                if (provider.vs$isInSealedArea()) {
                    this.vs$sealedGraceTicks = VSGameConfig.CLIENT.getSealedAreaCameraGracePeriod();
                }
                provider.vs$setInSealedArea(isInSealedArea);
                if (this.vs$sealedGraceTicks > 0) {
                    --this.vs$sealedGraceTicks;
                }
            }
        }
    }

    @WrapMethod(method={"getFluidInCamera"})
    private FogType redirectGetFluidInCamera(Operation<FogType> original) {
        if (this.vs$sealedGraceTicks > 0) {
            return FogType.NONE;
        }
        return (FogType)original.call(new Object[0]);
    }

    @Override
    public void setupWithShipMounted(@NotNull BlockGetter level, @NotNull Entity renderViewEntity, boolean thirdPerson, boolean thirdPersonReverse, float partialTicks, @NotNull ClientShip shipMountedTo, @NotNull Vector3dc inShipPlayerPosition) {
        ShipTransform renderTransform = shipMountedTo.getRenderTransform();
        Vector3d playerBasePos = renderTransform.getShipToWorldMatrix().transformPosition(inShipPlayerPosition, new Vector3d());
        Vector3d playerEyePos = renderTransform.getShipCoordinatesToWorldCoordinatesRotation().transform(new Vector3d(0.0, (double)Mth.m_14179_((float)partialTicks, (float)this.f_90563_, (float)this.f_90562_), 0.0)).add((Vector3dc)playerBasePos);
        this.f_90549_ = true;
        this.f_90550_ = level;
        this.f_90551_ = renderViewEntity;
        this.f_90560_ = thirdPerson;
        this.setRotationWithShipTransform(renderViewEntity.m_5675_(partialTicks), renderViewEntity.m_5686_(partialTicks), renderTransform);
        this.m_90584_(playerEyePos.x(), playerEyePos.y(), playerEyePos.z());
        if (thirdPerson) {
            AABBi boundingBox;
            double dist;
            if (thirdPersonReverse) {
                this.setRotationWithShipTransform(this.f_90558_ + 180.0f, -this.f_90557_, renderTransform);
            }
            double d2 = dist = (dist = (double)((boundingBox = (AABBi)shipMountedTo.getShipVoxelAABB()).lengthX() + boundingBox.lengthY() + boundingBox.lengthZ()) / 3.0 * 1.5) > 4.0 ? dist : 4.0;
            if (this.f_90550_ instanceof Level) {
                this.m_90568_(-this.getMaxZoomIgnoringMountedShip((Level)this.f_90550_, 4.0 * (dist / 4.0), shipMountedTo), 0.0, 0.0);
            } else {
                this.m_90568_(-this.m_90566_(4.0 * (dist / 4.0)), 0.0, 0.0);
            }
        }
    }

    @Unique
    private void setRotationWithShipTransform(float yaw, float pitch, ShipTransform renderTransform) {
        Quaterniond originalRotation = new Quaterniond().rotateY(Math.toRadians(-yaw)).rotateX(Math.toRadians(pitch)).normalize();
        Quaterniond newRotation = renderTransform.getShipCoordinatesToWorldCoordinatesRotation().mul((Quaterniondc)originalRotation, new Quaterniond());
        this.f_90557_ = pitch;
        this.f_90558_ = yaw;
        this.f_90559_.set((Quaterniondc)newRotation);
        this.f_90554_.set(0.0f, 0.0f, 1.0f);
        this.f_90559_.transform(this.f_90554_);
        this.f_90555_.set(0.0f, 1.0f, 0.0f);
        this.f_90559_.transform(this.f_90555_);
        this.f_90556_.set(1.0f, 0.0f, 0.0f);
        this.f_90559_.transform(this.f_90556_);
    }

    @Unique
    private double getMaxZoomIgnoringMountedShip(Level level, double maxZoom, @NotNull ClientShip toIgnore) {
        for (int i2 = 0; i2 < 8; ++i2) {
            double e2;
            Vec3 vec32;
            BlockHitResult hitResult;
            float f2 = (i2 & 1) * 2 - 1;
            float g2 = (i2 >> 1 & 1) * 2 - 1;
            float h2 = (i2 >> 2 & 1) * 2 - 1;
            Vec3 vec3 = this.f_90552_.m_82520_((double)(f2 *= 0.1f), (double)(g2 *= 0.1f), (double)(h2 *= 0.1f));
            if ((hitResult = RaycastUtilsKt.clipIncludeShips(level, new ClipContext(vec3, vec32 = new Vec3(this.f_90552_.f_82479_ - (double)this.f_90554_.x() * maxZoom + (double)f2 + (double)h2, this.f_90552_.f_82480_ - (double)this.f_90554_.y() * maxZoom + (double)g2, this.f_90552_.f_82481_ - (double)this.f_90554_.z() * maxZoom + (double)h2), ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, this.f_90551_), true, toIgnore.getId())).m_6662_() == HitResult.Type.MISS || !((e2 = hitResult.m_82450_().m_82554_(this.f_90552_)) < maxZoom)) continue;
            maxZoom = e2;
        }
        return maxZoom;
    }
}

