/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.util;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.valkyrienskies.core.api.ships.PhysShip;
import org.valkyrienskies.core.api.ships.ShipPhysicsListener;
import org.valkyrienskies.core.api.world.PhysLevel;
import org.valkyrienskies.mod.common.config.VSGameConfig;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001f\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bR\u0017\u0010\n\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0011"}, d2={"Lorg/valkyrienskies/mod/common/util/BuoyancyHandlerAttachment;", "Lorg/valkyrienskies/core/api/ships/ShipPhysicsListener;", "Lorg/valkyrienskies/core/api/ships/PhysShip;", "physShip", "Lorg/valkyrienskies/core/api/world/PhysLevel;", "physLevel", "", "physTick", "(Lorg/valkyrienskies/core/api/ships/PhysShip;Lorg/valkyrienskies/core/api/world/PhysLevel;)V", "Lorg/valkyrienskies/mod/common/util/BuoyancyHandlerAttachment$BuoyancyData;", "buoyancyData", "Lorg/valkyrienskies/mod/common/util/BuoyancyHandlerAttachment$BuoyancyData;", "getBuoyancyData", "()Lorg/valkyrienskies/mod/common/util/BuoyancyHandlerAttachment$BuoyancyData;", "<init>", "()V", "BuoyancyData", "valkyrienskies-120"})
public final class BuoyancyHandlerAttachment
implements ShipPhysicsListener {
    @NotNull
    private final BuoyancyData buoyancyData = new BuoyancyData(0.0, 1, null);

    @NotNull
    public final BuoyancyData getBuoyancyData() {
        return this.buoyancyData;
    }

    public void physTick(@NotNull PhysShip physShip, @NotNull PhysLevel physLevel) {
        Intrinsics.checkNotNullParameter((Object)physShip, (String)"physShip");
        Intrinsics.checkNotNullParameter((Object)physLevel, (String)"physLevel");
        if (!VSGameConfig.SERVER.getEnablePocketBuoyancy()) {
            return;
        }
        physShip.setBuoyantFactor(1.0 + this.buoyancyData.getPocketVolumeTotal() * VSGameConfig.SERVER.getBuoyancyFactorPerPocketVolume());
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\b\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0015J\u0010\u0010\u0003\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001a\u0010\u0006\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\n\u001a\u00020\t2\b\u0010\b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\r\u001a\u00020\fH\u00d6\u0001\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u0010\u001a\u00020\u000fH\u00d6\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011R\"\u0010\u0005\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0005\u0010\u0012\u001a\u0004\b\u0013\u0010\u0004\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0017"}, d2={"Lorg/valkyrienskies/mod/common/util/BuoyancyHandlerAttachment$BuoyancyData;", "", "", "component1", "()D", "pocketVolumeTotal", "copy", "(D)Lorg/valkyrienskies/mod/common/util/BuoyancyHandlerAttachment$BuoyancyData;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "D", "getPocketVolumeTotal", "setPocketVolumeTotal", "(D)V", "<init>", "valkyrienskies-120"})
    public static final class BuoyancyData {
        private volatile double pocketVolumeTotal;

        public BuoyancyData(double pocketVolumeTotal) {
            this.pocketVolumeTotal = pocketVolumeTotal;
        }

        public /* synthetic */ BuoyancyData(double d2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                d2 = 0.0;
            }
            this(d2);
        }

        public final double getPocketVolumeTotal() {
            return this.pocketVolumeTotal;
        }

        public final void setPocketVolumeTotal(double d2) {
            this.pocketVolumeTotal = d2;
        }

        public final double component1() {
            return this.pocketVolumeTotal;
        }

        @NotNull
        public final BuoyancyData copy(double pocketVolumeTotal) {
            return new BuoyancyData(pocketVolumeTotal);
        }

        public static /* synthetic */ BuoyancyData copy$default(BuoyancyData buoyancyData, double d2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                d2 = buoyancyData.pocketVolumeTotal;
            }
            return buoyancyData.copy(d2);
        }

        @NotNull
        public String toString() {
            return "BuoyancyData(pocketVolumeTotal=" + this.pocketVolumeTotal + ")";
        }

        public int hashCode() {
            return Double.hashCode(this.pocketVolumeTotal);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BuoyancyData)) {
                return false;
            }
            BuoyancyData buoyancyData = (BuoyancyData)other;
            return Double.compare(this.pocketVolumeTotal, buoyancyData.pocketVolumeTotal) == 0;
        }

        public BuoyancyData() {
            this(0.0, 1, null);
        }
    }
}

