/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.assembly;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Clearable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3i;
import org.joml.Vector3ic;
import org.joml.primitives.AABBic;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.impl.networking.simple.SimplePacket;
import org.valkyrienskies.core.impl.networking.simple.SimplePacketNetworking;
import org.valkyrienskies.core.internal.VsiCore;
import org.valkyrienskies.core.internal.ships.VsiServerShip;
import org.valkyrienskies.core.internal.world.chunks.VsiTerrainUpdate;
import org.valkyrienskies.core.util.events.EventEmitterImpl;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.assembly.ICopyableBlock;
import org.valkyrienskies.mod.common.assembly.VSAssemblyEvents;
import org.valkyrienskies.mod.common.networking.PacketRestartChunkUpdates;
import org.valkyrienskies.mod.common.networking.PacketStopChunkUpdates;
import org.valkyrienskies.mod.common.util.MinecraftPlayer;
import org.valkyrienskies.mod.common.util.SplittingDisablerAttachment;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;
import org.valkyrienskies.mod.util.LoggingKt;
import org.valkyrienskies.mod.util.RelocationUtilKt;
import org.valkyrienskies.mod.util.StructureTemplateFillFromVoxelSet;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u000489:;B\t\b\u0002\u00a2\u0006\u0004\b6\u00107J)\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00052\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0007\u00a2\u0006\u0004\b\u0006\u0010\u0007J#\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\bH\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ/\u0010\u0011\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\f2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\b2\b\b\u0002\u0010\u000f\u001a\u00020\u000eH\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012J[\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\r\u001a\u00020\f2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u00182\b\b\u0002\u0010\u001b\u001a\u00020\u001aH\u0007\u00a2\u0006\u0004\b\u001d\u0010\u001eJ/\u0010\u001f\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\f2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\b2\b\b\u0002\u0010\u000f\u001a\u00020\u000eH\u0007\u00a2\u0006\u0004\b\u001f\u0010 JA\u0010\u001f\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020!2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\"2\u0006\u0010\u001b\u001a\u00020\u001a2\b\b\u0002\u0010\u000f\u001a\u00020\u000e2\b\b\u0002\u0010#\u001a\u00020\u001aH\u0007\u00a2\u0006\u0004\b\u001f\u0010$J\u0017\u0010'\u001a\u00020\u001a2\b\u0010&\u001a\u0004\u0018\u00010%\u00a2\u0006\u0004\b'\u0010(J-\u0010-\u001a\u00020,2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010)\u001a\u00020\u00132\u0006\u0010*\u001a\u00020\u001a2\u0006\u0010+\u001a\u00020\u001a\u00a2\u0006\u0004\b-\u0010.R\u0017\u00100\u001a\u00020/8\u0006\u00a2\u0006\f\n\u0004\b0\u00101\u001a\u0004\b2\u00103R\u0014\u00104\u001a\u00020\u001c8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b4\u00105\u00a8\u0006<"}, d2={"Lorg/valkyrienskies/mod/common/assembly/ShipAssembler;", "", "", "Lnet/minecraft/core/BlockPos;", "blocks", "Lkotlin/Pair;", "findMinAndMax", "(Ljava/lang/Iterable;)Lkotlin/Pair;", "", "Lnet/minecraft/world/level/ChunkPos;", "getDistinctChunksFromBlockPosSet", "(Ljava/util/Set;)Ljava/util/Set;", "Lnet/minecraft/server/level/ServerLevel;", "level", "", "scale", "Lorg/valkyrienskies/mod/common/assembly/ShipAssembler$AssembleContext;", "assembleToShipFull", "(Lnet/minecraft/server/level/ServerLevel;Ljava/util/Set;D)Lorg/valkyrienskies/mod/common/assembly/ShipAssembler$AssembleContext;", "Lorg/valkyrienskies/core/api/ships/ServerShip;", "fromShip", "toShip", "minStructurePos", "maxStructurePos", "Lorg/joml/Vector3i;", "toCenter", "", "removeOriginal", "Lorg/valkyrienskies/mod/common/assembly/ShipAssembler$MoveContext;", "moveBlocksFromTo", "(Lnet/minecraft/server/level/ServerLevel;Ljava/util/Set;Lorg/valkyrienskies/core/api/ships/ServerShip;Lorg/valkyrienskies/core/api/ships/ServerShip;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/BlockPos;Lorg/joml/Vector3i;Z)Lorg/valkyrienskies/mod/common/assembly/ShipAssembler$MoveContext;", "assembleToShip", "(Lnet/minecraft/server/level/ServerLevel;Ljava/util/Set;D)Lorg/valkyrienskies/core/api/ships/ServerShip;", "Lnet/minecraft/world/level/Level;", "", "shouldDisableSplitting", "(Lnet/minecraft/world/level/Level;Ljava/util/List;ZDZ)Lorg/valkyrienskies/core/api/ships/ServerShip;", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "isValidShipBlock", "(Lnet/minecraft/world/level/block/state/BlockState;)Z", "ship", "deleteBlocks", "dropBlocks", "", "deleteShip", "(Lnet/minecraft/server/level/ServerLevel;Lorg/valkyrienskies/core/api/ships/ServerShip;ZZ)I", "Lorg/apache/logging/log4j/Logger;", "ASSEMBLY_LOGGER", "Lorg/apache/logging/log4j/Logger;", "getASSEMBLY_LOGGER", "()Lorg/apache/logging/log4j/Logger;", "failedMove", "Lorg/valkyrienskies/mod/common/assembly/ShipAssembler$MoveContext;", "<init>", "()V", "SingleItemMap", "AssembleContext", "MoveContext", "ICopyableProcessor", "valkyrienskies-120"})
@SourceDebugExtension(value={"SMAP\nShipAssembler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShipAssembler.kt\norg/valkyrienskies/mod/common/assembly/ShipAssembler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,392:1\n1#2:393\n774#3:394\n865#3,2:395\n1863#3,2:397\n1368#3:399\n1454#3,5:400\n1557#3:405\n1628#3,3:406\n1863#3,2:409\n1734#3,3:411\n827#3:414\n855#3,2:415\n1863#3,2:417\n*S KotlinDebug\n*F\n+ 1 ShipAssembler.kt\norg/valkyrienskies/mod/common/assembly/ShipAssembler\n*L\n165#1:394\n165#1:395,2\n210#1:397,2\n215#1:399\n215#1:400,5\n216#1:405\n216#1:406,3\n218#1:409,2\n285#1:411,3\n290#1:414\n290#1:415,2\n293#1:417,2\n*E\n"})
public final class ShipAssembler {
    @NotNull
    public static final ShipAssembler INSTANCE = new ShipAssembler();
    @NotNull
    private static final Logger ASSEMBLY_LOGGER = LoggingKt.logger("Sandwich Factory");
    @NotNull
    private static final MoveContext failedMove = new MoveContext(false, new Vector3d(), new Vector3d());

    private ShipAssembler() {
    }

    @NotNull
    public final Logger getASSEMBLY_LOGGER() {
        return ASSEMBLY_LOGGER;
    }

    @JvmStatic
    @NotNull
    public static final Pair<BlockPos, BlockPos> findMinAndMax(@NotNull Iterable<? extends BlockPos> blocks) {
        Intrinsics.checkNotNullParameter(blocks, (String)"blocks");
        BlockPos.MutableBlockPos minCorner = new BlockPos.MutableBlockPos(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
        BlockPos.MutableBlockPos maxCorner = new BlockPos.MutableBlockPos(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
        for (BlockPos blockPos : blocks) {
            minCorner.m_142451_(Math.min(minCorner.m_123341_(), blockPos.m_123341_()));
            minCorner.m_142448_(Math.min(minCorner.m_123342_(), blockPos.m_123342_()));
            minCorner.m_142443_(Math.min(minCorner.m_123343_(), blockPos.m_123343_()));
            maxCorner.m_142451_(Math.max(maxCorner.m_123341_(), blockPos.m_123341_()));
            maxCorner.m_142448_(Math.max(maxCorner.m_123342_(), blockPos.m_123342_()));
            maxCorner.m_142443_(Math.max(maxCorner.m_123343_(), blockPos.m_123343_()));
        }
        return TuplesKt.to((Object)minCorner, (Object)maxCorner);
    }

    @JvmStatic
    private static final Set<ChunkPos> getDistinctChunksFromBlockPosSet(Set<? extends BlockPos> blocks) {
        HashSet<ChunkPos> chunkSet = new HashSet<ChunkPos>();
        for (BlockPos blockPos : blocks) {
            ChunkPos chunkPos = new ChunkPos(blockPos);
            chunkSet.add(chunkPos);
        }
        return chunkSet;
    }

    @JvmStatic
    @NotNull
    public static final AssembleContext assembleToShipFull(@NotNull ServerLevel level, @NotNull Set<? extends BlockPos> blocks, double scale) {
        ServerShip serverShip;
        double oldScale;
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter(blocks, (String)"blocks");
        if (blocks.isEmpty()) {
            RuntimeException error = new RuntimeException("Assembly function received an empty set of blocks");
            ASSEMBLY_LOGGER.error((Object)error);
            throw error;
        }
        Pair<BlockPos, BlockPos> pair = ShipAssembler.findMinAndMax((Iterable<? extends BlockPos>)blocks);
        BlockPos minB = (BlockPos)pair.component1();
        BlockPos maxB = (BlockPos)pair.component2();
        Vector3d oldMin = VectorConversionsMCKt.toJOMLD((Vec3i)minB);
        Vector3d oldMax = VectorConversionsMCKt.toJOMLD((Vec3i)maxB);
        Vector3d offset = oldMax.get(new Vector3d()).sub((Vector3dc)oldMin).add(1.0, 1.0, 1.0).div(2.0);
        Vector3d fromCenter = offset.get(new Vector3d()).add((Vector3dc)oldMin);
        Intrinsics.checkNotNull((Object)fromCenter);
        LoadedServerShip loadedServerShip = VSGameUtilsKt.getLoadedShipManagingPos(level, (Vector3dc)fromCenter);
        ServerShip fromShip = loadedServerShip != null ? (ServerShip)loadedServerShip : VSGameUtilsKt.getShipManagingPos(level, (Vector3dc)fromCenter);
        ServerShip serverShip2 = fromShip;
        double d2 = oldScale = serverShip2 != null && (serverShip2 = serverShip2.getTransform()) != null && (serverShip2 = serverShip2.getScaling()) != null ? serverShip2.x() : 1.0;
        ServerShip serverShip3 = fromShip;
        if (serverShip3 == null || (serverShip3 = serverShip3.getShipToWorld()) == null || (serverShip3 = serverShip3.transformPosition(fromCenter.get(new Vector3d()))) == null) {
            serverShip3 = fromCenter.get(new Vector3d());
        }
        ServerShip worldOldCenter = serverShip3;
        ServerShip toShip = VSGameUtilsKt.getShipObjectWorld(level).createNewShipAtBlock((Vector3ic)new Vector3i((Vector3dc)worldOldCenter, 2), false, scale * oldScale, VSGameUtilsKt.getDimensionId((Level)level));
        toShip.setStatic(fromShip == null || fromShip.isStatic());
        MoveContext moveContext = ShipAssembler.moveBlocksFromTo$default(level, blocks, fromShip, toShip, minB, maxB, toShip.getChunkClaim().getCenterBlockCoordinates(VSGameUtilsKt.getYRange((Level)level), new Vector3i()), false, 128, null);
        boolean wasSuccessful = moveContext.component1();
        Vector3d toCenter = moveContext.component3();
        if (!wasSuccessful) {
            VSGameUtilsKt.getShipObjectWorld(level).deleteShip(toShip);
            AssertionError error = new AssertionError((Object)"Couldn't move blocks");
            ASSEMBLY_LOGGER.error((Object)error);
            throw error;
        }
        Vector3d it2 = new Vector3d(toShip.getInertiaData().getCenterOfMass()).sub((Vector3dc)new Vector3d((Vector3dc)toCenter));
        boolean bl2 = false;
        ServerShip serverShip4 = fromShip;
        if (serverShip4 == null || (serverShip4 = serverShip4.getShipToWorld()) == null || (serverShip4 = serverShip4.transformDirection(it2)) == null) {
            serverShip4 = it2;
        }
        ServerShip posOffset = serverShip4;
        Intrinsics.checkNotNull((Object)toShip, (String)"null cannot be cast to non-null type org.valkyrienskies.core.internal.ships.VsiServerShip");
        VsiServerShip vsiServerShip = (VsiServerShip)toShip;
        VsiCore vsiCore = VSGameUtilsKt.getVsCore();
        ServerShip serverShip5 = fromShip;
        if (serverShip5 == null || (serverShip5 = serverShip5.getVelocity()) == null) {
            serverShip5 = (Vector3dc)new Vector3d();
        }
        if ((serverShip = fromShip) == null || (serverShip = serverShip.getAngularVelocity()) == null) {
            serverShip = (Vector3dc)new Vector3d();
        }
        VsiCore vsiCore2 = VSGameUtilsKt.getVsCore();
        ServerShip serverShip6 = fromShip;
        if (serverShip6 == null || (serverShip6 = serverShip6.getShipToWorld()) == null || (serverShip6 = serverShip6.transformPosition(new Vector3d((Vector3dc)fromCenter))) == null) {
            serverShip6 = fromCenter;
        }
        Vector3d vector3d = serverShip6.add((Vector3dc)posOffset);
        Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"add(...)");
        Vector3dc vector3dc = (Vector3dc)vector3d;
        ServerShip serverShip7 = fromShip;
        if (serverShip7 == null || (serverShip7 = serverShip7.getTransform()) == null || (serverShip7 = serverShip7.getShipToWorldRotation()) == null) {
            serverShip7 = (Quaterniondc)new Quaterniond();
        }
        vsiServerShip.unsafeSetKinematics(vsiCore.newBodyKinematics((Vector3dc)serverShip5, (Vector3dc)serverShip, vsiCore2.newBodyTransform(vector3dc, (Quaterniondc)serverShip7, (Vector3dc)new Vector3d(scale * oldScale, scale * oldScale, scale * oldScale), (Vector3dc)toCenter)));
        toShip.setStatic(false);
        return new AssembleContext(toShip, fromCenter, toCenter);
    }

    public static /* synthetic */ AssembleContext assembleToShipFull$default(ServerLevel serverLevel, Set set, double d2, int n2, Object object) {
        if ((n2 & 4) != 0) {
            d2 = 1.0;
        }
        return ShipAssembler.assembleToShipFull(serverLevel, set, d2);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final MoveContext moveBlocksFromTo(@NotNull ServerLevel level, @NotNull Set<? extends BlockPos> blocks, @Nullable ServerShip fromShip, @Nullable ServerShip toShip, @NotNull BlockPos minStructurePos, @NotNull BlockPos maxStructurePos, @NotNull Vector3i toCenter, boolean removeOriginal) {
        Iterator $this$mapTo$iv$iv;
        Object element$iv$iv3;
        void $this$flatMapTo$iv$iv;
        Object sourcePos;
        Object object;
        Object object2;
        Iterable iterable;
        Level level2;
        StructureTemplateFillFromVoxelSet structureTemplateFillFromVoxelSet;
        StructureTemplate template;
        Ref.BooleanRef wasSplittingEnabled;
        Vector3d fromCenter;
        Vector3d offset;
        Map eventData;
        long fromId;
        Set blocks2;
        block17: {
            block16: {
                void it2;
                void $this$filterTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)level, (String)"level");
                Intrinsics.checkNotNullParameter(blocks, (String)"blocks");
                Intrinsics.checkNotNullParameter((Object)minStructurePos, (String)"minStructurePos");
                Intrinsics.checkNotNullParameter((Object)maxStructurePos, (String)"maxStructurePos");
                Intrinsics.checkNotNullParameter((Object)toCenter, (String)"toCenter");
                Iterable $this$filter$iv = blocks;
                boolean $i$f$filter = false;
                Iterable iterable2 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                    BlockPos it3 = (BlockPos)element$iv$iv2;
                    boolean bl2 = false;
                    BlockState it4 = level.m_8055_(it3);
                    boolean bl3 = false;
                    boolean bl4 = !it4.m_60795_() && !VSGameUtilsKt.inAssemblyBlacklist(it4);
                    if (!bl4) continue;
                    destination$iv$iv.add(element$iv$iv2);
                }
                blocks2 = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                if (blocks2.isEmpty()) {
                    return failedMove;
                }
                ServerShip serverShip = fromShip;
                fromId = serverShip != null ? serverShip.getId() : -1L;
                eventData = new LinkedHashMap();
                Vector3d oldMin = VectorConversionsMCKt.toJOMLD((Vec3i)minStructurePos);
                Vector3d oldMax = VectorConversionsMCKt.toJOMLD((Vec3i)maxStructurePos);
                offset = oldMax.get(new Vector3d()).sub((Vector3dc)oldMin).add(1.0, 1.0, 1.0).div(2.0);
                fromCenter = offset.get(new Vector3d()).add((Vector3dc)oldMin);
                wasSplittingEnabled = new Ref.BooleanRef();
                wasSplittingEnabled.element = true;
                if (fromShip instanceof LoadedServerShip) {
                    SplittingDisablerAttachment splittingDisabler;
                    SplittingDisablerAttachment splittingDisablerAttachment = splittingDisabler = (SplittingDisablerAttachment)((LoadedServerShip)fromShip).getAttachment(SplittingDisablerAttachment.class);
                    wasSplittingEnabled.element = !(splittingDisablerAttachment != null ? !splittingDisablerAttachment.canSplit() : false);
                    SplittingDisablerAttachment splittingDisablerAttachment2 = splittingDisabler;
                    if (splittingDisablerAttachment2 != null) {
                        splittingDisablerAttachment2.disableSplitting();
                    }
                }
                EventEmitterImpl<VSAssemblyEvents.BeforeCopy> eventEmitterImpl = VSAssemblyEvents.INSTANCE.getBeforeCopy();
                Vector3dc vector3dc = (Vector3dc)oldMin;
                Vector3dc vector3dc2 = (Vector3dc)oldMax;
                Intrinsics.checkNotNull((Object)fromCenter);
                eventEmitterImpl.emit((Object)new VSAssemblyEvents.BeforeCopy(level, vector3dc, vector3dc2, (Vector3dc)fromCenter, fromShip, blocks2, eventData));
                template = new StructureTemplate();
                StructureTemplateFillFromVoxelSet cfr_ignored_0 = (StructureTemplateFillFromVoxelSet)template;
                structureTemplateFillFromVoxelSet = (StructureTemplateFillFromVoxelSet)template;
                level2 = (Level)level;
                iterable = blocks2;
                object2 = fromShip;
                if (object2 == null) break block16;
                ServerShip serverShip2 = object2;
                Iterable iterable3 = iterable;
                Level level3 = level2;
                object = structureTemplateFillFromVoxelSet;
                boolean bl5 = false;
                List list = CollectionsKt.listOf((Object)it2);
                structureTemplateFillFromVoxelSet = object;
                level2 = level3;
                iterable = iterable3;
                List list2 = list;
                object2 = list2;
                if (list2 != null) break block17;
            }
            object2 = CollectionsKt.emptyList();
        }
        structureTemplateFillFromVoxelSet.vs$fillFromVoxelSet(level2, iterable, (List<ServerShip>)object2, new SingleItemMap(fromId, fromCenter, new Vector3d(), null, 8, null), minStructurePos, maxStructurePos);
        ChunkPos toChunkCenter = new ChunkPos(toCenter.x >> 4, toCenter.z >> 4);
        int fromChunkX = (minStructurePos.m_123341_() + maxStructurePos.m_123341_()) / 2 >> 4;
        int fromChunkZ = (minStructurePos.m_123343_() + maxStructurePos.m_123343_()) / 2 >> 4;
        int deltaX = fromChunkX - toChunkCenter.f_45578_;
        int deltaZ = fromChunkZ - toChunkCenter.f_45579_;
        Map chunksToBeUpdated = new LinkedHashMap();
        Iterable $this$forEach$iv = ShipAssembler.getDistinctChunksFromBlockPosSet(blocks2);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            sourcePos = (ChunkPos)element$iv;
            boolean bl6 = false;
            ChunkPos destPos = new ChunkPos(sourcePos.f_45578_ - deltaX, sourcePos.f_45579_ - deltaZ);
            chunksToBeUpdated.put(sourcePos, new Pair(sourcePos, (Object)destPos));
        }
        List chunkPairs = CollectionsKt.toList((Iterable)chunksToBeUpdated.values());
        Iterable $this$flatMap$iv = chunkPairs;
        boolean $i$f$flatMap = false;
        sourcePos = $this$flatMap$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv3 : $this$flatMapTo$iv$iv) {
            Pair it5 = (Pair)element$iv$iv3;
            boolean bl7 = false;
            Iterable list$iv$iv = TuplesKt.toList((Pair)it5);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List chunkPoses = (List)destination$iv$iv;
        Iterable $this$map$iv = chunkPoses;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        element$iv$iv3 = $this$mapTo$iv$iv.iterator();
        while (element$iv$iv3.hasNext()) {
            void it6;
            Object item$iv$iv = element$iv$iv3.next();
            ChunkPos bl7 = (ChunkPos)item$iv$iv;
            object = destination$iv$iv2;
            boolean bl8 = false;
            object.add(VectorConversionsMCKt.toJOML((ChunkPos)it6));
        }
        List chunkPosesJOML = (List)destination$iv$iv2;
        List list = level.m_6907_();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"players(...)");
        Iterator $this$forEach$iv2 = list;
        boolean $i$f$forEach2 = false;
        $this$mapTo$iv$iv = $this$forEach$iv2.iterator();
        while ($this$mapTo$iv$iv.hasNext()) {
            Object element$iv = $this$mapTo$iv$iv.next();
            ServerPlayer player = (ServerPlayer)element$iv;
            boolean bl9 = false;
            ASSEMBLY_LOGGER.debug("Pausing chunk updates for " + player.m_7755_());
            SimplePacketNetworking $this$moveBlocksFromTo_u24lambda_u248_u24lambda_u247 = VSGameUtilsKt.getVsCore().getSimplePacketNetworking();
            boolean bl10 = false;
            SimplePacket simplePacket = new PacketStopChunkUpdates(chunkPosesJOML);
            Intrinsics.checkNotNull((Object)player);
            MinecraftPlayer minecraftPlayer = VSGameUtilsKt.getPlayerWrapper((Player)player);
            Intrinsics.checkNotNullExpressionValue((Object)minecraftPlayer, (String)"<get-playerWrapper>(...)");
            $this$moveBlocksFromTo_u24lambda_u248_u24lambda_u247.sendToClient1(simplePacket, minecraftPlayer);
        }
        if (removeOriginal) {
            for (BlockPos pos : blocks2) {
                if (level.m_7702_(pos) != null) {
                    BlockEntity it7;
                    boolean bl11 = false;
                    Clearable.m_18908_((Object)it7);
                }
                level.m_7731_(pos, Blocks.f_50375_.m_49966_(), 2);
            }
            for (BlockPos pos : blocks2) {
                BlockState block = level.m_8055_(pos);
                level.m_7471_(pos, false);
                int flags = 107;
                int recursionLeft = 511;
                level.m_6550_(pos, block, RelocationUtilKt.getAIR());
                level.m_7260_(pos, block, RelocationUtilKt.getAIR(), flags);
                level.m_6289_(pos, RelocationUtilKt.getAIR().m_60734_());
                RelocationUtilKt.getAIR().m_60762_((LevelAccessor)level, pos, flags, recursionLeft - 1);
                RelocationUtilKt.getAIR().m_60705_((LevelAccessor)level, pos, flags, recursionLeft);
                RelocationUtilKt.getAIR().m_60762_((LevelAccessor)level, pos, flags, recursionLeft);
                level.m_7726_().m_7827_().m_7174_(pos);
            }
        }
        Vector3d it8 = new Vector3d((Vector3ic)toCenter).sub((Vector3dc)offset).ceil();
        boolean bl12 = false;
        BlockPos cornerOfShip = new BlockPos((int)it8.x, (int)it8.y, (int)it8.z);
        Vector3d centerOfShip = VectorConversionsMCKt.toJOMLD((Vec3i)cornerOfShip).add((Vector3dc)offset);
        ServerShip serverShip = toShip;
        StructurePlaceSettings structureSettings = new StructurePlaceSettings().m_74383_((StructureProcessor)new ICopyableProcessor((Map<Long, Long>)new SingleItemMap<Long, Long>(fromId, serverShip != null ? serverShip.getId() : -1L, -1L, ShipAssembler::moveBlocksFromTo$lambda$11), new SingleItemMap(fromId, new Pair((Object)fromCenter, (Object)new Vector3d((Vector3dc)centerOfShip)), new Pair((Object)new Vector3d(), (Object)new Vector3d()), null, 8, null)));
        structureSettings.m_74385_(cornerOfShip);
        VSAssemblyEvents.INSTANCE.getOnPasteBeforeBlocksAreLoaded().emit((Object)new VSAssemblyEvents.OnPasteBeforeBlocksAreLoaded(level, fromShip, toShip, (Pair<? extends Vector3dc, ? extends Vector3dc>)new Pair((Object)fromCenter, (Object)centerOfShip), eventData));
        template.m_230328_((ServerLevelAccessor)level, cornerOfShip, cornerOfShip, structureSettings, level.f_46441_, 2);
        int timeAtExecution = level.m_7654_().m_129921_();
        MinecraftServer minecraftServer = level.m_7654_();
        Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"getServer(...)");
        VSGameUtilsKt.executeIf(minecraftServer, (Function0<Boolean>)((Function0)() -> ShipAssembler.moveBlocksFromTo$lambda$12(chunkPoses, level, timeAtExecution)), () -> ShipAssembler.moveBlocksFromTo$lambda$16(level, timeAtExecution, chunkPoses, fromShip, toShip, fromCenter, centerOfShip, eventData, wasSplittingEnabled, chunkPosesJOML));
        Intrinsics.checkNotNull((Object)centerOfShip);
        return new MoveContext(true, fromCenter, centerOfShip);
    }

    public static /* synthetic */ MoveContext moveBlocksFromTo$default(ServerLevel serverLevel, Set set, ServerShip serverShip, ServerShip serverShip2, BlockPos blockPos, BlockPos blockPos2, Vector3i vector3i, boolean bl2, int n2, Object object) {
        if ((n2 & 0x80) != 0) {
            bl2 = true;
        }
        return ShipAssembler.moveBlocksFromTo(serverLevel, set, serverShip, serverShip2, blockPos, blockPos2, vector3i, bl2);
    }

    @JvmStatic
    @NotNull
    public static final ServerShip assembleToShip(@NotNull ServerLevel level, @NotNull Set<? extends BlockPos> blocks, double scale) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter(blocks, (String)"blocks");
        return ShipAssembler.assembleToShipFull(level, blocks, scale).getShip();
    }

    public static /* synthetic */ ServerShip assembleToShip$default(ServerLevel serverLevel, Set set, double d2, int n2, Object object) {
        if ((n2 & 4) != 0) {
            d2 = 1.0;
        }
        return ShipAssembler.assembleToShip(serverLevel, set, d2);
    }

    @Deprecated(message="Old")
    @NotNull
    public final ServerShip assembleToShip(@NotNull Level level, @NotNull List<? extends BlockPos> blocks, boolean removeOriginal, double scale, boolean shouldDisableSplitting) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter(blocks, (String)"blocks");
        return ShipAssembler.assembleToShip((ServerLevel)level, CollectionsKt.toSet((Iterable)blocks), scale);
    }

    public static /* synthetic */ ServerShip assembleToShip$default(ShipAssembler shipAssembler, Level level, List list, boolean bl2, double d2, boolean bl3, int n2, Object object) {
        if ((n2 & 8) != 0) {
            d2 = 1.0;
        }
        if ((n2 & 0x10) != 0) {
            bl3 = false;
        }
        return shipAssembler.assembleToShip(level, list, bl2, d2, bl3);
    }

    public final boolean isValidShipBlock(@Nullable BlockState state) {
        if (state == null) {
            return false;
        }
        if (state.m_60795_()) {
            return false;
        }
        Block block = state.m_60734_();
        Intrinsics.checkNotNullExpressionValue((Object)block, (String)"getBlock(...)");
        Block block2 = block;
        return !VSGameUtilsKt.inAssemblyBlacklist(state);
    }

    public final int deleteShip(@NotNull ServerLevel level, @NotNull ServerShip ship, boolean deleteBlocks, boolean dropBlocks) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)ship, (String)"ship");
        if (ship instanceof LoadedServerShip) {
            SplittingDisablerAttachment splittingDisabler;
            SplittingDisablerAttachment splittingDisablerAttachment = splittingDisabler = (SplittingDisablerAttachment)((LoadedServerShip)ship).getAttachment(SplittingDisablerAttachment.class);
            if (splittingDisablerAttachment != null) {
                splittingDisablerAttachment.disableSplitting();
            }
        }
        if (deleteBlocks) {
            int n2;
            AABBic aABBic = ship.getShipAABB();
            if (aABBic == null) {
                return 0;
            }
            AABBic aabb = aABBic;
            int x2 = aabb.minX();
            if (x2 <= (n2 = aabb.maxX())) {
                while (true) {
                    int n3;
                    int y2;
                    if ((y2 = aabb.minY()) <= (n3 = aabb.maxY())) {
                        while (true) {
                            int n4;
                            int z2;
                            if ((z2 = aabb.minZ()) <= (n4 = aabb.maxZ())) {
                                while (true) {
                                    boolean bl2 = dropBlocks ? level.m_46961_(new BlockPos(x2, y2, z2), true) : level.m_7731_(new BlockPos(x2, y2, z2), Blocks.f_50016_.m_49966_(), 2);
                                    if (z2 == n4) break;
                                    ++z2;
                                }
                            }
                            if (y2 == n3) break;
                            ++y2;
                        }
                    }
                    if (x2 == n2) break;
                    ++x2;
                }
            }
        }
        VSGameUtilsKt.getVsCore().deleteShips(VSGameUtilsKt.getShipObjectWorld(level), CollectionsKt.listOf((Object)ship));
        return 1;
    }

    private static final long moveBlocksFromTo$lambda$11(long it2) {
        return it2;
    }

    private static final boolean moveBlocksFromTo$lambda$12(List $chunkPoses, ServerLevel $level, int $timeAtExecution) {
        boolean bl2;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$chunkPoses, (String)"$chunkPoses");
            Intrinsics.checkNotNullParameter((Object)$level, (String)"$level");
            Iterable $this$all$iv = $chunkPoses;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl2 = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    ChunkPos p0 = (ChunkPos)element$iv;
                    boolean bl3 = false;
                    if (VSGameUtilsKt.isTickingChunk((Level)$level, p0)) continue;
                    bl2 = false;
                    break block3;
                }
                bl2 = true;
            }
        }
        return bl2 || $level.m_7654_().m_129921_() - $timeAtExecution > 60;
    }

    /*
     * WARNING - void declaration
     */
    private static final void moveBlocksFromTo$lambda$16(ServerLevel $level, int $timeAtExecution, List $chunkPoses, ServerShip $fromShip, ServerShip $toShip, Vector3d $fromCenter, Vector3d $centerOfShip, Map $eventData, Ref.BooleanRef $wasSplittingEnabled, List $chunkPosesJOML) {
        block7: {
            Iterator $this$filterNotTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)$level, (String)"$level");
            Intrinsics.checkNotNullParameter((Object)$chunkPoses, (String)"$chunkPoses");
            Intrinsics.checkNotNullParameter((Object)$eventData, (String)"$eventData");
            Intrinsics.checkNotNullParameter((Object)$wasSplittingEnabled, (String)"$wasSplittingEnabled");
            Intrinsics.checkNotNullParameter((Object)$chunkPosesJOML, (String)"$chunkPosesJOML");
            if ($level.m_7654_().m_129921_() - $timeAtExecution > 60) {
                void $this$filterNot$iv;
                ASSEMBLY_LOGGER.warn("Timed out waiting for chunks to start ticking after assembly! Forcibly resuming...");
                ASSEMBLY_LOGGER.warn("All chunks involved in assembly: " + $chunkPoses);
                Iterable iterable = $chunkPoses;
                Logger logger = ASSEMBLY_LOGGER;
                boolean $i$f$filterNot = false;
                void var12_14 = $this$filterNot$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterNotTo = false;
                Iterator iterator = $this$filterNotTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Object element$iv$iv = iterator.next();
                    ChunkPos it2 = (ChunkPos)element$iv$iv;
                    boolean bl2 = false;
                    if (VSGameUtilsKt.isTickingChunk((Level)$level, it2)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                logger.warn("Chunks that were supposed to be ticking: " + (List)destination$iv$iv);
            }
            List list = $level.m_6907_();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"players(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            $this$filterNotTo$iv$iv = $this$forEach$iv.iterator();
            while ($this$filterNotTo$iv$iv.hasNext()) {
                Object element$iv = $this$filterNotTo$iv$iv.next();
                ServerPlayer player = (ServerPlayer)element$iv;
                boolean bl3 = false;
                ASSEMBLY_LOGGER.debug("Resuming chunk updates for " + player.m_7755_());
                SimplePacketNetworking $this$moveBlocksFromTo_u24lambda_u2416_u24lambda_u2415_u24lambda_u2414 = VSGameUtilsKt.getVsCore().getSimplePacketNetworking();
                boolean bl4 = false;
                SimplePacket simplePacket = new PacketRestartChunkUpdates($chunkPosesJOML);
                Intrinsics.checkNotNull((Object)player);
                MinecraftPlayer minecraftPlayer = VSGameUtilsKt.getPlayerWrapper((Player)player);
                Intrinsics.checkNotNullExpressionValue((Object)minecraftPlayer, (String)"<get-playerWrapper>(...)");
                $this$moveBlocksFromTo_u24lambda_u2416_u24lambda_u2415_u24lambda_u2414.sendToClient1(simplePacket, minecraftPlayer);
            }
            VSAssemblyEvents.INSTANCE.getOnPasteAfterBlocksAreLoaded().emit((Object)new VSAssemblyEvents.OnPasteAfterBlocksAreLoaded($level, $fromShip, $toShip, (Pair<? extends Vector3dc, ? extends Vector3dc>)new Pair((Object)$fromCenter, (Object)$centerOfShip), $eventData));
            for (ChunkPos pos : $chunkPoses) {
                LevelChunk worldChunk;
                if ($level.m_6325_(pos.f_45578_, pos.f_45579_) == null || worldChunk.m_7103_() == null) continue;
                int n2 = worldChunk.m_151559_();
                for (int sectionY = 0; sectionY < n2; ++sectionY) {
                    LevelChunkSection section;
                    LevelChunkSection[] chunkSections;
                    Vector3i sectionPos = new Vector3i(pos.f_45578_, worldChunk.m_151568_(sectionY), pos.f_45579_);
                    if (chunkSections[sectionY] == null || section.m_188008_()) continue;
                    VsiTerrainUpdate update = VSGameUtilsKt.toDenseVoxelUpdate(section, (Vector3ic)sectionPos);
                    VSGameUtilsKt.getShipObjectWorld($level).forceUpdateConnectivityChunk(VSGameUtilsKt.getDimensionId((Level)$level), sectionPos.x, sectionPos.y, sectionPos.z, update);
                }
            }
            if (!($fromShip instanceof LoadedServerShip)) break block7;
            SplittingDisablerAttachment splittingDisabler = (SplittingDisablerAttachment)((LoadedServerShip)$fromShip).getAttachment(SplittingDisablerAttachment.class);
            if ($wasSplittingEnabled.element) {
                SplittingDisablerAttachment splittingDisablerAttachment = splittingDisabler;
                if (splittingDisablerAttachment != null) {
                    splittingDisablerAttachment.enableSplitting();
                }
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\t\u001a\u00020\u0002\u0012\u0006\u0010\n\u001a\u00020\u0005\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0010\u0010\u0003\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0006\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\b\u0010\u0007J.\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\t\u001a\u00020\u00022\b\b\u0002\u0010\n\u001a\u00020\u00052\b\b\u0002\u0010\u000b\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0004\b\f\u0010\rJ\u001a\u0010\u0010\u001a\u00020\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0013\u001a\u00020\u0012H\u00d6\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010\u0016\u001a\u00020\u0015H\u00d6\u0001\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u0017\u0010\t\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\u0018\u001a\u0004\b\u0019\u0010\u0004R\u0017\u0010\n\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\n\u0010\u001a\u001a\u0004\b\u001b\u0010\u0007R\u0017\u0010\u000b\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010\u001a\u001a\u0004\b\u001c\u0010\u0007\u00a8\u0006\u001f"}, d2={"Lorg/valkyrienskies/mod/common/assembly/ShipAssembler$AssembleContext;", "", "Lorg/valkyrienskies/core/api/ships/ServerShip;", "component1", "()Lorg/valkyrienskies/core/api/ships/ServerShip;", "Lorg/joml/Vector3d;", "component2", "()Lorg/joml/Vector3d;", "component3", "ship", "fromCenter", "toCenter", "copy", "(Lorg/valkyrienskies/core/api/ships/ServerShip;Lorg/joml/Vector3d;Lorg/joml/Vector3d;)Lorg/valkyrienskies/mod/common/assembly/ShipAssembler$AssembleContext;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Lorg/valkyrienskies/core/api/ships/ServerShip;", "getShip", "Lorg/joml/Vector3d;", "getFromCenter", "getToCenter", "<init>", "(Lorg/valkyrienskies/core/api/ships/ServerShip;Lorg/joml/Vector3d;Lorg/joml/Vector3d;)V", "valkyrienskies-120"})
    public static final class AssembleContext {
        @NotNull
        private final ServerShip ship;
        @NotNull
        private final Vector3d fromCenter;
        @NotNull
        private final Vector3d toCenter;

        public AssembleContext(@NotNull ServerShip ship, @NotNull Vector3d fromCenter, @NotNull Vector3d toCenter) {
            Intrinsics.checkNotNullParameter((Object)ship, (String)"ship");
            Intrinsics.checkNotNullParameter((Object)fromCenter, (String)"fromCenter");
            Intrinsics.checkNotNullParameter((Object)toCenter, (String)"toCenter");
            this.ship = ship;
            this.fromCenter = fromCenter;
            this.toCenter = toCenter;
        }

        @NotNull
        public final ServerShip getShip() {
            return this.ship;
        }

        @NotNull
        public final Vector3d getFromCenter() {
            return this.fromCenter;
        }

        @NotNull
        public final Vector3d getToCenter() {
            return this.toCenter;
        }

        @NotNull
        public final ServerShip component1() {
            return this.ship;
        }

        @NotNull
        public final Vector3d component2() {
            return this.fromCenter;
        }

        @NotNull
        public final Vector3d component3() {
            return this.toCenter;
        }

        @NotNull
        public final AssembleContext copy(@NotNull ServerShip ship, @NotNull Vector3d fromCenter, @NotNull Vector3d toCenter) {
            Intrinsics.checkNotNullParameter((Object)ship, (String)"ship");
            Intrinsics.checkNotNullParameter((Object)fromCenter, (String)"fromCenter");
            Intrinsics.checkNotNullParameter((Object)toCenter, (String)"toCenter");
            return new AssembleContext(ship, fromCenter, toCenter);
        }

        public static /* synthetic */ AssembleContext copy$default(AssembleContext assembleContext, ServerShip serverShip, Vector3d vector3d, Vector3d vector3d2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                serverShip = assembleContext.ship;
            }
            if ((n2 & 2) != 0) {
                vector3d = assembleContext.fromCenter;
            }
            if ((n2 & 4) != 0) {
                vector3d2 = assembleContext.toCenter;
            }
            return assembleContext.copy(serverShip, vector3d, vector3d2);
        }

        @NotNull
        public String toString() {
            return "AssembleContext(ship=" + this.ship + ", fromCenter=" + this.fromCenter + ", toCenter=" + this.toCenter + ")";
        }

        public int hashCode() {
            int result = this.ship.hashCode();
            result = result * 31 + this.fromCenter.hashCode();
            result = result * 31 + this.toCenter.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AssembleContext)) {
                return false;
            }
            AssembleContext assembleContext = (AssembleContext)other;
            if (!Intrinsics.areEqual((Object)this.ship, (Object)assembleContext.ship)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.fromCenter, (Object)assembleContext.fromCenter)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.toCenter, (Object)assembleContext.toCenter);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001BC\u0012\u001a\u0010\u0014\u001a\u0016\u0012\b\u0012\u00060\u0012j\u0002`\u0013\u0012\b\u0012\u00060\u0012j\u0002`\u00130\u0011\u0012\u001e\u0010\u001a\u001a\u001a\u0012\u0004\u0012\u00020\u0012\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00190\u00180\u0011\u00a2\u0006\u0004\b\u001c\u0010\u001dJA\u0010\f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u0015\u0010\u000f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000eH\u0014\u00a2\u0006\u0004\b\u000f\u0010\u0010R+\u0010\u0014\u001a\u0016\u0012\b\u0012\u00060\u0012j\u0002`\u0013\u0012\b\u0012\u00060\u0012j\u0002`\u00130\u00118\u0006\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017R/\u0010\u001a\u001a\u001a\u0012\u0004\u0012\u00020\u0012\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00190\u00180\u00118\u0006\u00a2\u0006\f\n\u0004\b\u001a\u0010\u0015\u001a\u0004\b\u001b\u0010\u0017\u00a8\u0006\u001e"}, d2={"Lorg/valkyrienskies/mod/common/assembly/ShipAssembler$ICopyableProcessor;", "Lnet/minecraft/world/level/levelgen/structure/templatesystem/StructureProcessor;", "Lnet/minecraft/world/level/LevelReader;", "levelReader", "Lnet/minecraft/core/BlockPos;", "oldBPos", "newBPos", "Lnet/minecraft/world/level/levelgen/structure/templatesystem/StructureTemplate$StructureBlockInfo;", "oldStructureBlockInfo", "newStructureBlockInfo", "Lnet/minecraft/world/level/levelgen/structure/templatesystem/StructurePlaceSettings;", "structurePlaceSettings", "processBlock", "(Lnet/minecraft/world/level/LevelReader;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/levelgen/structure/templatesystem/StructureTemplate$StructureBlockInfo;Lnet/minecraft/world/level/levelgen/structure/templatesystem/StructureTemplate$StructureBlockInfo;Lnet/minecraft/world/level/levelgen/structure/templatesystem/StructurePlaceSettings;)Lnet/minecraft/world/level/levelgen/structure/templatesystem/StructureTemplate$StructureBlockInfo;", "Lnet/minecraft/world/level/levelgen/structure/templatesystem/StructureProcessorType;", "getType", "()Lnet/minecraft/world/level/levelgen/structure/templatesystem/StructureProcessorType;", "", "", "Lorg/valkyrienskies/core/api/ships/properties/ShipId;", "oldShipIdToNewShipId", "Ljava/util/Map;", "getOldShipIdToNewShipId", "()Ljava/util/Map;", "Lkotlin/Pair;", "Lorg/joml/Vector3d;", "centerPositions", "getCenterPositions", "<init>", "(Ljava/util/Map;Ljava/util/Map;)V", "valkyrienskies-120"})
    public static final class ICopyableProcessor
    extends StructureProcessor {
        @NotNull
        private final Map<Long, Long> oldShipIdToNewShipId;
        @NotNull
        private final Map<Long, Pair<Vector3d, Vector3d>> centerPositions;

        public ICopyableProcessor(@NotNull Map<Long, Long> oldShipIdToNewShipId, @NotNull Map<Long, ? extends Pair<? extends Vector3d, ? extends Vector3d>> centerPositions) {
            Intrinsics.checkNotNullParameter(oldShipIdToNewShipId, (String)"oldShipIdToNewShipId");
            Intrinsics.checkNotNullParameter(centerPositions, (String)"centerPositions");
            this.oldShipIdToNewShipId = oldShipIdToNewShipId;
            this.centerPositions = centerPositions;
        }

        @NotNull
        public final Map<Long, Long> getOldShipIdToNewShipId() {
            return this.oldShipIdToNewShipId;
        }

        @NotNull
        public final Map<Long, Pair<Vector3d, Vector3d>> getCenterPositions() {
            return this.centerPositions;
        }

        @Nullable
        public StructureTemplate.StructureBlockInfo m_7382_(@NotNull LevelReader levelReader, @NotNull BlockPos oldBPos, @NotNull BlockPos newBPos, @NotNull StructureTemplate.StructureBlockInfo oldStructureBlockInfo, @NotNull StructureTemplate.StructureBlockInfo newStructureBlockInfo, @NotNull StructurePlaceSettings structurePlaceSettings) {
            Intrinsics.checkNotNullParameter((Object)levelReader, (String)"levelReader");
            Intrinsics.checkNotNullParameter((Object)oldBPos, (String)"oldBPos");
            Intrinsics.checkNotNullParameter((Object)newBPos, (String)"newBPos");
            Intrinsics.checkNotNullParameter((Object)oldStructureBlockInfo, (String)"oldStructureBlockInfo");
            Intrinsics.checkNotNullParameter((Object)newStructureBlockInfo, (String)"newStructureBlockInfo");
            Intrinsics.checkNotNullParameter((Object)structurePlaceSettings, (String)"structurePlaceSettings");
            Block block = newStructureBlockInfo.f_74676_().m_60734_();
            if (!(block instanceof ICopyableBlock)) {
                return newStructureBlockInfo;
            }
            ICopyableBlock iCopyableBlock = (ICopyableBlock)block;
            ServerLevel serverLevel = ((ServerLevelAccessor)levelReader).m_6018_();
            Intrinsics.checkNotNullExpressionValue((Object)serverLevel, (String)"getLevel(...)");
            BlockState blockState = newStructureBlockInfo.f_74676_();
            Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"state(...)");
            iCopyableBlock.onPaste(serverLevel, newBPos, blockState, this.oldShipIdToNewShipId, this.centerPositions, newStructureBlockInfo.f_74677_());
            return newStructureBlockInfo;
        }

        @Nullable
        protected StructureProcessorType<?> m_6953_() {
            return null;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\t\u001a\u00020\u0002\u0012\u0006\u0010\n\u001a\u00020\u0005\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0010\u0010\u0003\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0006\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\b\u0010\u0007J.\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\t\u001a\u00020\u00022\b\b\u0002\u0010\n\u001a\u00020\u00052\b\b\u0002\u0010\u000b\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0004\b\f\u0010\rJ\u001a\u0010\u000f\u001a\u00020\u00022\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u0012\u001a\u00020\u0011H\u00d6\u0001\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0010\u0010\u0015\u001a\u00020\u0014H\u00d6\u0001\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u0017\u0010\t\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\u0017\u001a\u0004\b\u0018\u0010\u0004R\u0017\u0010\n\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\n\u0010\u0019\u001a\u0004\b\u001a\u0010\u0007R\u0017\u0010\u000b\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010\u0019\u001a\u0004\b\u001b\u0010\u0007\u00a8\u0006\u001e"}, d2={"Lorg/valkyrienskies/mod/common/assembly/ShipAssembler$MoveContext;", "", "", "component1", "()Z", "Lorg/joml/Vector3d;", "component2", "()Lorg/joml/Vector3d;", "component3", "wasSuccessful", "fromCenter", "toCenter", "copy", "(ZLorg/joml/Vector3d;Lorg/joml/Vector3d;)Lorg/valkyrienskies/mod/common/assembly/ShipAssembler$MoveContext;", "other", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Z", "getWasSuccessful", "Lorg/joml/Vector3d;", "getFromCenter", "getToCenter", "<init>", "(ZLorg/joml/Vector3d;Lorg/joml/Vector3d;)V", "valkyrienskies-120"})
    public static final class MoveContext {
        private final boolean wasSuccessful;
        @NotNull
        private final Vector3d fromCenter;
        @NotNull
        private final Vector3d toCenter;

        public MoveContext(boolean wasSuccessful, @NotNull Vector3d fromCenter, @NotNull Vector3d toCenter) {
            Intrinsics.checkNotNullParameter((Object)fromCenter, (String)"fromCenter");
            Intrinsics.checkNotNullParameter((Object)toCenter, (String)"toCenter");
            this.wasSuccessful = wasSuccessful;
            this.fromCenter = fromCenter;
            this.toCenter = toCenter;
        }

        public final boolean getWasSuccessful() {
            return this.wasSuccessful;
        }

        @NotNull
        public final Vector3d getFromCenter() {
            return this.fromCenter;
        }

        @NotNull
        public final Vector3d getToCenter() {
            return this.toCenter;
        }

        public final boolean component1() {
            return this.wasSuccessful;
        }

        @NotNull
        public final Vector3d component2() {
            return this.fromCenter;
        }

        @NotNull
        public final Vector3d component3() {
            return this.toCenter;
        }

        @NotNull
        public final MoveContext copy(boolean wasSuccessful, @NotNull Vector3d fromCenter, @NotNull Vector3d toCenter) {
            Intrinsics.checkNotNullParameter((Object)fromCenter, (String)"fromCenter");
            Intrinsics.checkNotNullParameter((Object)toCenter, (String)"toCenter");
            return new MoveContext(wasSuccessful, fromCenter, toCenter);
        }

        public static /* synthetic */ MoveContext copy$default(MoveContext moveContext, boolean bl2, Vector3d vector3d, Vector3d vector3d2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                bl2 = moveContext.wasSuccessful;
            }
            if ((n2 & 2) != 0) {
                vector3d = moveContext.fromCenter;
            }
            if ((n2 & 4) != 0) {
                vector3d2 = moveContext.toCenter;
            }
            return moveContext.copy(bl2, vector3d, vector3d2);
        }

        @NotNull
        public String toString() {
            return "MoveContext(wasSuccessful=" + this.wasSuccessful + ", fromCenter=" + this.fromCenter + ", toCenter=" + this.toCenter + ")";
        }

        public int hashCode() {
            int result = Boolean.hashCode(this.wasSuccessful);
            result = result * 31 + this.fromCenter.hashCode();
            result = result * 31 + this.toCenter.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MoveContext)) {
                return false;
            }
            MoveContext moveContext = (MoveContext)other;
            if (this.wasSuccessful != moveContext.wasSuccessful) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.fromCenter, (Object)moveContext.fromCenter)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.toCenter, (Object)moveContext.toCenter);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0010&\n\u0002\b\u0005\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0003B7\u0012\u0006\u0010\u000e\u001a\u00028\u0000\u0012\u0006\u0010\u0012\u001a\u00028\u0001\u0012\u0006\u0010\u0014\u001a\u00028\u0001\u0012\u0016\b\u0002\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0016\u00a2\u0006\u0004\b-\u0010.J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\u000b\u001a\u00020\u00042\u0006\u0010\n\u001a\u00028\u0001H\u0016\u00a2\u0006\u0004\b\u000b\u0010\tJ\u001a\u0010\f\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0007\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\u00028\u00008\u0006\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0012\u001a\u00028\u00018\u0006\u00a2\u0006\f\n\u0004\b\u0012\u0010\u000f\u001a\u0004\b\u0013\u0010\u0011R\u0017\u0010\u0014\u001a\u00028\u00018\u0006\u00a2\u0006\f\n\u0004\b\u0014\u0010\u000f\u001a\u0004\b\u0015\u0010\u0011R%\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u00168\u0006\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001c\u001a\u00020\u001b8\u0016X\u0096D\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001fR \u0010!\u001a\b\u0012\u0004\u0012\u00028\u00000 8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b!\u0010\"\u001a\u0004\b#\u0010$R \u0010&\u001a\b\u0012\u0004\u0012\u00028\u00010%8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b&\u0010'\u001a\u0004\b(\u0010)R,\u0010+\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010*0 8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b+\u0010\"\u001a\u0004\b,\u0010$\u00a8\u0006/"}, d2={"Lorg/valkyrienskies/mod/common/assembly/ShipAssembler$SingleItemMap;", "K", "V", "", "", "isEmpty", "()Z", "key", "containsKey", "(Ljava/lang/Object;)Z", "value", "containsValue", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", "mkey", "Ljava/lang/Object;", "getMkey", "()Ljava/lang/Object;", "mvalue", "getMvalue", "default", "getDefault", "Lkotlin/Function1;", "defaultFn", "Lkotlin/jvm/functions/Function1;", "getDefaultFn", "()Lkotlin/jvm/functions/Function1;", "", "size", "I", "getSize", "()I", "", "keys", "Ljava/util/Set;", "getKeys", "()Ljava/util/Set;", "", "values", "Ljava/util/Collection;", "getValues", "()Ljava/util/Collection;", "", "entries", "getEntries", "<init>", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)V", "valkyrienskies-120"})
    public static final class SingleItemMap<K, V>
    implements Map<K, V>,
    KMappedMarker {
        private final K mkey;
        private final V mvalue;
        private final V default;
        @Nullable
        private final Function1<K, V> defaultFn;
        private final int size;
        @NotNull
        private final Set<K> keys;
        @NotNull
        private final Collection<V> values;
        @NotNull
        private final Set<Map.Entry<K, V>> entries;

        public SingleItemMap(K mkey, V mvalue, V v2, @Nullable Function1<? super K, ? extends V> defaultFn) {
            this.mkey = mkey;
            this.mvalue = mvalue;
            this.default = v2;
            this.defaultFn = defaultFn;
            this.size = 1;
            this.keys = SetsKt.setOf(this.mkey);
            this.values = SetsKt.setOf(this.mvalue);
            this.entries = SetsKt.setOf((Object)new Map.Entry<K, V>(this){
                private final K key;
                private final V value;
                {
                    this.key = $receiver.getMkey();
                    this.value = $receiver.getMvalue();
                }

                public K getKey() {
                    return this.key;
                }

                public V getValue() {
                    return this.value;
                }

                public V setValue(V newValue) {
                    throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                }
            });
        }

        public /* synthetic */ SingleItemMap(Object object, Object object2, Object object3, Function1 function1, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 8) != 0) {
                function1 = null;
            }
            this(object, object2, object3, function1);
        }

        public final K getMkey() {
            return this.mkey;
        }

        public final V getMvalue() {
            return this.mvalue;
        }

        public final V getDefault() {
            return this.default;
        }

        @Nullable
        public final Function1<K, V> getDefaultFn() {
            return this.defaultFn;
        }

        public int getSize() {
            return this.size;
        }

        @NotNull
        public Set<K> getKeys() {
            return this.keys;
        }

        @NotNull
        public Collection<V> getValues() {
            return this.values;
        }

        @NotNull
        public Set<Map.Entry<K, V>> getEntries() {
            return this.entries;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean containsKey(Object key) {
            return true;
        }

        @Override
        public boolean containsValue(Object value) {
            return true;
        }

        @Override
        @Nullable
        public V get(Object key) {
            Object object;
            if (Intrinsics.areEqual((Object)key, this.mkey)) {
                object = this.mvalue;
            } else {
                object = this.defaultFn;
                if (object == null || (object = object.invoke(key)) == null) {
                    object = this.default;
                }
            }
            return object;
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public V put(K key, V value) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> from) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public V remove(Object key) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public boolean remove(Object key, Object value) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public void replaceAll(BiFunction<? super K, ? super V, ? extends V> p0) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public V putIfAbsent(K p0, V p1) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public boolean replace(K p0, V p1, V p2) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public V replace(K p0, V p1) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public V computeIfAbsent(K p0, Function<? super K, ? extends V> p1) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public V computeIfPresent(K p0, BiFunction<? super K, ? super V, ? extends V> p1) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public V compute(K p0, BiFunction<? super K, ? super V, ? extends V> p1) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public V merge(K p0, V p1, BiFunction<? super V, ? super V, ? extends V> p2) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }
    }
}

