/*
 * Decompiled with CFR 0.152.
 */
package g_mungus.vlib.mixin.specialSaveBehavior;

import g_mungus.vlib.VLib;
import g_mungus.vlib.v2.api.VLibAPI;
import g_mungus.vlib.v2.api.experimental.HasSpecialSaveBehavior;
import g_mungus.vlib.v2.api.extension.NBTExtKt;
import g_mungus.vlib.v2.api.extension.ServerLevelExtKt;
import g_mungus.vlib.v2.api.extension.ShipExtKt;
import java.util.Objects;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.block.TestHingeBlock;
import org.valkyrienskies.mod.common.blockentity.TestHingeBlockEntity;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

@Mixin(value={TestHingeBlockEntity.class}, remap=false)
public abstract class MixinTestHingeBlockEntity
extends BlockEntity
implements HasSpecialSaveBehavior {
    @Unique
    private ResourceLocation vlib$constraintTemplate = null;
    @Unique
    private BlockPos vlib$templateOffset = null;
    @Unique
    private final String vlib$templateKey = "vlib$templateLocation";
    @Unique
    private final String vlib$offsetKey = "vlib$structure_offset";

    @Shadow
    public BlockPos getOtherHingePos() {
        return null;
    }

    public MixinTestHingeBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    @Override
    public void executeWhenSavingShip() {
        BlockPos hingePos = this.getOtherHingePos();
        Level level = this.m_58904_();
        if (level instanceof ServerLevel) {
            ServerShip ship;
            ServerLevel serverLevel = (ServerLevel)level;
            if (hingePos != null && (ship = VSGameUtilsKt.getShipManagingPos((ServerLevel)serverLevel, (BlockPos)this.getOtherHingePos())) != null) {
                ResourceLocation location = new ResourceLocation("vlib", Objects.requireNonNull(ship.getSlug()));
                BlockPos corner = ShipExtKt.getTemplateCorner((Ship)ship);
                VLibAPI.saveShipToTemplate(ship, location, serverLevel);
                VLibAPI.discardShip(ship, serverLevel);
                this.vlib$constraintTemplate = location;
                this.vlib$templateOffset = hingePos.m_121996_((Vec3i)corner);
            }
        }
    }

    @Override
    public void executeAfterLoadingShip() {
        Level level = this.m_58904_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.vlib$constraintTemplate != null) {
                ServerPlayer player = (ServerPlayer)serverLevel.m_8795_(it -> true).get(0);
                TestHingeBlock block = (TestHingeBlock)this.m_58900_().m_60734_();
                block.m_6227_(this.m_58900_(), (Level)serverLevel, this.m_58899_(), (Player)player, InteractionHand.MAIN_HAND, BlockHitResult.m_82426_((Vec3)player.m_20182_(), (Direction)player.m_6350_(), (BlockPos)player.m_20183_()));
                serverLevel.m_215082_().m_230407_(this.vlib$constraintTemplate).ifPresent(structureTemplate -> {
                    BlockPos hingePos = this.getOtherHingePos();
                    BlockPos structurePos = hingePos.m_121996_((Vec3i)this.vlib$templateOffset);
                    ServerShip ship = VSGameUtilsKt.getShipManagingPos((ServerLevel)serverLevel, (BlockPos)hingePos);
                    if (ship != null) {
                        ServerLevelExtKt.scheduleCallback(serverLevel, 3, (Function0<Unit>)((Function0)() -> {
                            structureTemplate.m_230328_((ServerLevelAccessor)serverLevel, structurePos, structurePos, new StructurePlaceSettings(), serverLevel.f_46441_, 0);
                            Vector3dc positionInWorld = ship.getTransform().getPositionInWorld();
                            Vector3dc targetPos = this.getTargetPos(serverLevel);
                            Vector3d cogInWorld = ship.getShipToWorld().transformPosition(ship.getInertiaData().getCenterOfMassInShip(), new Vector3d());
                            ShipExtKt.teleport(ship, serverLevel, (Vector3dc)targetPos.add((Vector3dc)cogInWorld, new Vector3d()).add(0.5, 0.5, 0.5).sub(positionInWorld));
                            return Unit.INSTANCE;
                        }));
                    } else {
                        VLib.INSTANCE.getLOGGER().error("SHIP IS NULL");
                    }
                });
            }
        }
    }

    @Unique
    Vector3dc getTargetPos(ServerLevel serverLevel) {
        ServerShip ship = VSGameUtilsKt.getShipManagingPos((ServerLevel)serverLevel, (BlockPos)this.m_58899_());
        BlockPos blockPos = this.m_58899_().m_121955_(((Direction)this.m_58900_().m_61143_((Property)DirectionalBlock.f_52588_)).m_122436_());
        Vector3d pos = VectorConversionsMCKt.toJOML((Vec3)blockPos.m_252807_());
        return ship != null ? ship.getShipToWorld().transformPosition((Vector3dc)pos, new Vector3d()) : pos;
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        if (this.vlib$constraintTemplate != null) {
            tag.m_128359_("vlib$templateLocation", this.vlib$constraintTemplate.toString());
            NBTExtKt.putVec3i(tag, "vlib$structure_offset", (Vec3i)this.vlib$templateOffset);
        }
    }

    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        Tag template = tag.m_128423_("vlib$templateLocation");
        if (template != null) {
            this.vlib$constraintTemplate = new ResourceLocation(template.m_7916_());
            BlockPos vec = NBTExtKt.getVec3i(tag, "vlib$structure_offset");
            this.vlib$templateOffset = vec != null ? new BlockPos((Vec3i)vec) : null;
        }
    }
}

