/*
 * Decompiled with CFR 0.152.
 */
package edn.stratodonut.trackwork.wheel;

import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3d;
import org.joml.Matrix3dc;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.core.api.ships.properties.ShipInertiaData;
import org.valkyrienskies.core.api.ships.properties.ShipTransform;
import org.valkyrienskies.core.internal.ShipTeleportData;
import org.valkyrienskies.core.internal.physics.PhysicsEntityData;
import org.valkyrienskies.core.internal.physics.PhysicsEntityServer;
import org.valkyrienskies.core.internal.physics.VSCollisionShapeData;
import org.valkyrienskies.core.internal.physics.VSSphereCollisionShapeData;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.ValkyrienSkiesMod;
import org.valkyrienskies.mod.common.util.DimensionIdProvider;

public class WheelEntity {
    @Nullable
    public static PhysicsEntityServer getInLevel(ServerLevel level, long id) {
        if (!WheelEntity.aliveInLevel(level, id)) {
            return null;
        }
        return (PhysicsEntityServer)VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).retrieveLoadedPhysicsEntities().get(id);
    }

    public static boolean aliveInLevel(ServerLevel level, long id) {
        return VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).retrieveLoadedPhysicsEntities().containsKey(id);
    }

    public static void createInLevel(ServerLevel level, PhysicsEntityData data) {
        VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).createPhysicsEntity(data, ((DimensionIdProvider)level).getDimensionId());
    }

    public static void removeInLevel(ServerLevel level, long id) {
        if (WheelEntity.aliveInLevel(level, id)) {
            VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).deletePhysicsEntity(id);
        }
    }

    public static boolean moveTo(ServerLevel level, long id, Vector3dc pos) {
        if (!WheelEntity.aliveInLevel(level, id)) {
            return false;
        }
        PhysicsEntityServer serverData = (PhysicsEntityServer)VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).retrieveLoadedPhysicsEntities().get(id);
        ShipTeleportData teleportData = ValkyrienSkiesMod.getVsCore().newShipTeleportData(pos, (Quaterniondc)new Quaterniond(), (Vector3dc)new Vector3d(), (Vector3dc)new Vector3d(), null, null, null);
        VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).teleportPhysicsEntity(serverData, teleportData);
        return true;
    }

    public static final class DataBuilder {
        private DataBuilder() {
        }

        @NotNull
        public static PhysicsEntityData createBasicData(long shipId, @NotNull ShipTransform transform, double radius, double mass) {
            double inertia = 0.4 * mass * radius * radius;
            ShipInertiaData inertiaData = ValkyrienSkiesMod.getVsCore().newShipInertiaData((Vector3dc)new Vector3d(), mass * radius, (Matrix3dc)new Matrix3d().scale(inertia));
            VSSphereCollisionShapeData collisionShapeData = new VSSphereCollisionShapeData(radius);
            return new PhysicsEntityData(shipId, transform, inertiaData, (Vector3dc)new Vector3d(), (Vector3dc)new Vector3d(), (VSCollisionShapeData)collisionShapeData, -1, 0.8, 0.6, 0.6, false);
        }
    }
}

