/*
 * Decompiled with CFR 0.152.
 */
package edn.stratodonut.trackwork.tracks.forces;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.mojang.datafixers.util.Pair;
import edn.stratodonut.trackwork.TrackworkUtil;
import edn.stratodonut.trackwork.tracks.data.SimpleWheelData;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Math;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.valkyrienskies.core.api.bodies.properties.BodyKinematics;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.PhysShip;
import org.valkyrienskies.core.api.ships.ShipPhysicsListener;
import org.valkyrienskies.core.api.ships.properties.ShipTransform;
import org.valkyrienskies.core.api.world.PhysLevel;
import org.valkyrienskies.core.impl.game.ships.PhysShipImpl;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public final class SimpleWheelController
implements ShipPhysicsListener {
    @JsonIgnore
    public static final double RPM_TO_RADS = 0.10471975512;
    @JsonIgnore
    public static final double MAXIMUM_SLIP = 10.0;
    @JsonIgnore
    public static final double MAXIMUM_SLIP_LATERAL = 15.0;
    @JsonIgnore
    public static final double MAX_FREESPIN_SLIP = 0.07;
    @JsonIgnore
    public static final double MAXIMUM_G = 490.5;
    public static final Vector3dc UP = new Vector3d(0.0, 1.0, 0.0);
    private final HashMap<Long, SimpleWheelData> trackData = new HashMap();
    private final HashMap<Long, SimpleWheelData.ExtraWheelData> steeringData = new HashMap();
    @JsonIgnore
    private final ConcurrentHashMap<Long, TrackworkUtil.ClipResult> suspensionData = new ConcurrentHashMap();
    @JsonIgnore
    private final ConcurrentLinkedQueue<Pair<Long, SimpleWheelData.SimpleWheelCreateData>> createdTrackData = new ConcurrentLinkedQueue();
    @JsonIgnore
    private final ConcurrentHashMap<Long, SimpleWheelData.SimpleWheelUpdateData> trackUpdateData = new ConcurrentHashMap();
    private final ConcurrentLinkedQueue<Long> removedTracks = new ConcurrentLinkedQueue();
    @Deprecated(forRemoval=true)
    private int nextBearingID = 0;
    private volatile Vector3dc suspensionAdjust = new Vector3d(0.0, 1.0, 0.0);
    private volatile float suspensionStiffness = 1.0f;
    private volatile float suspensionDampening = 1.2f;
    private float debugTick = 0.0f;

    public static SimpleWheelController getOrCreate(LoadedServerShip ship) {
        if (ship.getAttachment(SimpleWheelController.class) == null) {
            ship.setAttachment(SimpleWheelController.class, (Object)new SimpleWheelController());
        }
        return (SimpleWheelController)ship.getAttachment(SimpleWheelController.class);
    }

    public void physTick(@NotNull PhysShip physShip, @NotNull PhysLevel physLevel) {
        while (!this.createdTrackData.isEmpty()) {
            Pair createData = (Pair)this.createdTrackData.remove();
            this.trackData.put((Long)createData.getFirst(), SimpleWheelData.from((SimpleWheelData.SimpleWheelCreateData)createData.getSecond()));
        }
        this.trackUpdateData.forEach((id, data) -> {
            SimpleWheelData old = this.trackData.get(id);
            if (old != null) {
                this.trackData.put((Long)id, old.updateWith((SimpleWheelData.SimpleWheelUpdateData)data));
                this.steeringData.put((Long)id, SimpleWheelData.ExtraWheelData.from(data));
            }
        });
        this.trackUpdateData.clear();
        while (!this.removedTracks.isEmpty()) {
            Long removeId = (Long)this.removedTracks.remove();
            this.trackData.remove(removeId);
        }
        if (this.trackData.isEmpty()) {
            return;
        }
        Vector3d netLinearForce = new Vector3d(0.0);
        Vector3d netTorque = new Vector3d(0.0);
        double coefficientOfPower = Math.min((double)2.0, (double)(3.0 / (double)this.trackData.size()));
        this.trackData.forEach((id, data) -> {
            ComputeResult computeResult = this.computeForce((SimpleWheelData)data, (PhysShipImpl)physShip, coefficientOfPower, physLevel, this.steeringData.getOrDefault(id, SimpleWheelData.ExtraWheelData.empty()));
            this.suspensionData.put((Long)id, computeResult.clipResult);
            if (computeResult.linearForce.isFinite()) {
                netLinearForce.add(computeResult.linearForce);
                netTorque.add(computeResult.torque);
            }
        });
        if (netLinearForce.isFinite() && netLinearForce.length() / ((PhysShipImpl)physShip).getMass() < 490.5) {
            physShip.applyInvariantForce((Vector3dc)netLinearForce);
            if (netTorque.isFinite()) {
                physShip.applyInvariantTorque((Vector3dc)netTorque);
            }
        }
    }

    private ComputeResult computeForce(SimpleWheelData data, PhysShipImpl ship, double coefficientOfPower, PhysLevel physLevel, SimpleWheelData.ExtraWheelData steeringInfo) {
        Direction.Axis axis = steeringInfo.wheelAxis();
        float steeringValue = steeringInfo.steeringValue();
        float axialOffset = steeringInfo.axialOffset();
        float horizontalOffset = steeringInfo.horizontalOffset();
        double susScaled = steeringInfo.susScaled();
        double restOffset = steeringInfo.wheelRadius() - 0.5;
        BodyKinematics pose = ship.getKinematics();
        ShipTransform shipTransform = ship.getTransform();
        double m = ship.getMass();
        Vector3d localUp = shipTransform.getShipToWorldRotation().transform(UP, new Vector3d());
        double gravity_factor = Math.max((double)0.3, (double)localUp.dot(UP));
        Vec3 start = VectorConversionsMCKt.toMinecraft((Vector3dc)data.wheelOriginPosition);
        Vec3 worldSpaceNormal = VectorConversionsMCKt.toMinecraft((Vector3dc)ship.getTransform().getShipToWorldRotation().transform((Vector3dc)VectorConversionsMCKt.toJOML((Vec3)TrackworkUtil.getActionNormal(axis)), new Vector3d()).mul(susScaled + 0.5));
        Vec3 worldSpaceStart = VectorConversionsMCKt.toMinecraft((Vector3dc)ship.getShipToWorld().transformPosition(VectorConversionsMCKt.toJOML((Vec3)start.m_82520_(0.0, -restOffset, 0.0))));
        Vec3 worldSpaceOffset = VectorConversionsMCKt.toMinecraft((Vector3dc)ship.getTransform().getShipToWorldRotation().transform((Vector3dc)TrackworkUtil.getForwardVec3d(axis, 1.0f).mul((double)horizontalOffset).add((Vector3dc)TrackworkUtil.getAxisAsVec(axis).mul((double)axialOffset)), new Vector3d()));
        TrackworkUtil.ClipResult clipResult = TrackworkUtil.clipAndResolvePhys(physLevel, (PhysShip)ship, (Vector3dc)TrackworkUtil.getAxisAsVec(axis).rotateAxis((double)(steeringValue * Math.toRadians((float)30.0f)), 0.0, 1.0, 0.0), (Vector3dc)VectorConversionsMCKt.toJOML((Vec3)worldSpaceStart.m_82549_(worldSpaceOffset)), (Vector3dc)VectorConversionsMCKt.toJOML((Vec3)worldSpaceNormal), steeringInfo.wheelRadius(), 2, ship.getId());
        Vector3d forceVec = clipResult.trackTangent().mul(steeringInfo.wheelRadius() / 0.5, new Vector3d());
        double suspensionTravel = clipResult.equals(TrackworkUtil.ClipResult.MISS) ? susScaled : clipResult.suspensionLength().length() - 0.5;
        Vector3d suspensionForce = VectorConversionsMCKt.toJOML((Vec3)worldSpaceNormal.m_82490_(susScaled - suspensionTravel)).negate();
        boolean isOnGround = !clipResult.equals(TrackworkUtil.ClipResult.MISS);
        Vector3d wheelContactPosition = VectorConversionsMCKt.toJOML((Vec3)worldSpaceStart.m_82549_(worldSpaceOffset));
        Vector3d wheelNormal = VectorConversionsMCKt.toJOML((Vec3)worldSpaceNormal);
        Vector3d trackRelPosShip = data.wheelOriginPosition.sub(shipTransform.getPositionInShip(), new Vector3d());
        Vector3d tForce = new Vector3d();
        Vector3d trackNormal = wheelNormal.normalize(new Vector3d());
        Vector3d trackSurface = forceVec.mul((double)data.wheelRPM * 0.10471975512 * 0.5, new Vector3d());
        Vector3dc velocityAtPosition = TrackworkUtil.accumulatedVelocity(shipTransform, pose, (Vector3dc)wheelContactPosition);
        if (isOnGround) {
            velocityAtPosition = velocityAtPosition.sub(clipResult.groundVelocity(), new Vector3d());
        }
        double suspensionCompressionDelta = 0.0;
        if (data.lastSuspensionForce != null) {
            suspensionCompressionDelta = suspensionForce.sub(data.lastSuspensionForce, new Vector3d()).dot((Vector3dc)trackNormal);
        }
        data.lastSuspensionForce = suspensionForce;
        if (isOnGround) {
            double suspensionDelta = velocityAtPosition.dot((Vector3dc)trackNormal) + suspensionCompressionDelta;
            double tilt = 1.0 + this.tilt((Vector3dc)trackRelPosShip);
            Vector3d springForce = suspensionForce.mul(m * 4.0 * coefficientOfPower * (double)this.suspensionStiffness * tilt, new Vector3d());
            tForce.add((Vector3dc)springForce);
            Vector3d damperForce = trackNormal.mul(m * -suspensionDelta * coefficientOfPower * (double)this.suspensionDampening, new Vector3d());
            tForce.add((Vector3dc)damperForce);
            if (data.wheelRPM == 0.0f) {
                tForce = new Vector3d(0.0, tForce.y(), 0.0);
            }
        }
        if (isOnGround || trackSurface.lengthSquared() > 0.0) {
            Vector3d surfaceVelocity = velocityAtPosition.sub((Vector3dc)trackNormal.mul(velocityAtPosition.dot((Vector3dc)trackNormal), new Vector3d()), new Vector3d());
            Vector3d slipVelocity = trackSurface.sub((Vector3dc)surfaceVelocity, new Vector3d());
            Vector3d driveDir = forceVec.normalize(new Vector3d());
            Vector3d driveSlip = driveDir.mul(driveDir.dot((Vector3dc)slipVelocity), new Vector3d());
            Vector3d lateralSlip = slipVelocity.sub((Vector3dc)driveSlip, new Vector3d());
            if (isOnGround) {
                slipVelocity = data.isFreespin ? driveSlip.normalize(Math.min((double)driveSlip.length(), (double)0.07), new Vector3d()).add((Vector3dc)lateralSlip.normalize(Math.min((double)lateralSlip.length(), (double)15.0), new Vector3d())) : driveSlip.normalize(Math.min((double)driveSlip.length(), (double)10.0), new Vector3d()).add((Vector3dc)lateralSlip.normalize(Math.min((double)lateralSlip.length(), (double)15.0), new Vector3d()), new Vector3d());
                tForce.add((Vector3dc)slipVelocity.mul(1.0 * m * coefficientOfPower * gravity_factor, new Vector3d()));
            } else if (!data.isFreespin && forceVec.length() != 0.0) {
                slipVelocity = driveSlip.normalize(Math.min((double)driveSlip.length(), (double)10.0), new Vector3d());
                tForce.add((Vector3dc)slipVelocity.mul(1.0 * m * coefficientOfPower * gravity_factor, new Vector3d()));
            }
        }
        Vector3d trackRelPos = shipTransform.getShipToWorldRotation().transform((Vector3dc)trackRelPosShip, new Vector3d());
        Vector3d torque = trackRelPos.cross((Vector3dc)tForce, new Vector3d());
        return new ComputeResult((Vector3dc)tForce, (Vector3dc)torque, clipResult);
    }

    public Vector3d getActionVec3d(Direction.Axis axis, float length, float steeringValue) {
        return TrackworkUtil.getForwardVec3d(axis, length).rotateAxis((double)(steeringValue * Math.toRadians((float)30.0f)), 0.0, 1.0, 0.0);
    }

    public final void addTrackBlock(BlockPos pos, SimpleWheelData.SimpleWheelCreateData data) {
        this.createdTrackData.add((Pair<Long, SimpleWheelData.SimpleWheelCreateData>)new Pair((Object)pos.m_121878_(), (Object)data));
    }

    public final double updateTrackBlock(BlockPos pos, SimpleWheelData.SimpleWheelUpdateData data) {
        this.trackUpdateData.put(pos.m_121878_(), data);
        return (double)Math.round((double)(this.suspensionAdjust.y() * 16.0)) / 16.0 * (double)((9.0f + 1.0f / (this.suspensionStiffness * 2.0f - 1.0f)) / 10.0f);
    }

    public final void removeTrackBlock(BlockPos pos) {
        this.removedTracks.add(pos.m_121878_());
    }

    public final float setDamperCoefficient(float delta) {
        this.suspensionStiffness = Math.clamp((float)1.0f, (float)4.0f, (float)(this.suspensionStiffness + delta));
        return this.suspensionStiffness;
    }

    public final void adjustSuspension(Vector3f delta) {
        Vector3dc old = this.suspensionAdjust;
        this.suspensionAdjust = new Vector3d(Math.clamp((double)-0.5, (double)0.5, (double)(old.x() + (double)(delta.x() * 5.0f))), Math.clamp((double)0.1, (double)1.0, (double)(old.y() + (double)delta.y())), Math.clamp((double)-0.5, (double)0.5, (double)(old.z() + (double)(delta.z() * 5.0f))));
    }

    public final void resetSuspension() {
        double y = this.suspensionAdjust.y();
        this.suspensionAdjust = new Vector3d(0.0, y, 0.0);
    }

    private double tilt(Vector3dc relPos) {
        return Math.signum((double)relPos.x()) * this.suspensionAdjust.z() + Math.signum((double)relPos.z()) * this.suspensionAdjust.x();
    }

    @Nonnull
    public TrackworkUtil.ClipResult getSuspensionData(BlockPos pos) {
        return this.suspensionData.getOrDefault(pos.m_121878_(), TrackworkUtil.ClipResult.MISS);
    }

    public static <T> boolean areQueuesEqual(Queue<T> left, Queue<T> right) {
        return Arrays.equals(left.toArray(), right.toArray());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SimpleWheelController)) {
            return false;
        }
        SimpleWheelController otherController = (SimpleWheelController)other;
        return Objects.equals(this.trackData, otherController.trackData) && Objects.equals(this.trackUpdateData, otherController.trackUpdateData) && SimpleWheelController.areQueuesEqual(this.createdTrackData, otherController.createdTrackData) && SimpleWheelController.areQueuesEqual(this.removedTracks, otherController.removedTracks);
    }

    private record ComputeResult(Vector3dc linearForce, Vector3dc torque, TrackworkUtil.ClipResult clipResult) {
    }
}

