/*
 * Decompiled with CFR 0.152.
 */
package edn.stratodonut.trackwork.tracks.forces;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.mojang.datafixers.util.Pair;
import edn.stratodonut.trackwork.TrackworkUtil;
import edn.stratodonut.trackwork.tracks.data.PhysTrackData;
import edn.stratodonut.trackwork.tracks.forces.PhysEntityTrackController;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Math;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.valkyrienskies.core.api.bodies.properties.BodyKinematics;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.PhysShip;
import org.valkyrienskies.core.api.ships.ShipPhysicsListener;
import org.valkyrienskies.core.api.ships.properties.ShipTransform;
import org.valkyrienskies.core.api.world.PhysLevel;
import org.valkyrienskies.core.impl.game.ships.PhysShipImpl;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public final class PhysicsTrackController
implements ShipPhysicsListener {
    @JsonIgnore
    public static final double RPM_TO_RADS = 0.10471975512;
    @JsonIgnore
    public static final double MAXIMUM_SLIP = 10.0;
    @JsonIgnore
    public static final double MAXIMUM_G = 490.5;
    public static final Vector3dc UP = new Vector3d(0.0, 1.0, 0.0);
    @Deprecated
    private final HashMap<Integer, PhysTrackData> trackData = new HashMap();
    private final HashMap<Long, PhysTrackData> trackData2 = new HashMap();
    @JsonIgnore
    private final HashMap<Long, TrackworkUtil.ClipResult> suspensionData = new HashMap();
    @JsonIgnore
    private final ConcurrentLinkedQueue<Pair<Long, PhysTrackData.PhysTrackCreateData>> createdTrackData = new ConcurrentLinkedQueue();
    @JsonIgnore
    private final ConcurrentHashMap<Long, PhysTrackData.PhysTrackUpdateData> trackUpdateData = new ConcurrentHashMap();
    private final ConcurrentLinkedQueue<Long> removedTracks = new ConcurrentLinkedQueue();
    private int nextBearingID = 0;
    private volatile Vector3dc suspensionAdjust = new Vector3d(0.0, 1.0, 0.0);
    private volatile float suspensionStiffness = 1.0f;
    @JsonIgnore
    @Deprecated(forRemoval=true)
    private volatile float suspensionDampening = 1.2f;
    @JsonIgnore
    @Deprecated(forRemoval=true)
    private float debugTick = 0.0f;

    public static PhysicsTrackController getOrCreate(LoadedServerShip ship) {
        if (ship.getAttachment(PhysicsTrackController.class) == null) {
            ship.setAttachment(PhysicsTrackController.class, (Object)new PhysicsTrackController());
        }
        return (PhysicsTrackController)ship.getAttachment(PhysicsTrackController.class);
    }

    public void physTick(@NotNull PhysShip physShip, @NotNull PhysLevel physLevel) {
        if (!this.trackData.isEmpty()) {
            this.trackData.forEach((id, data) -> this.trackData2.put(data.blockPos, (PhysTrackData)data));
            this.trackData.clear();
        }
        while (!this.createdTrackData.isEmpty()) {
            Pair createData = (Pair)this.createdTrackData.remove();
            this.trackData2.put((Long)createData.getFirst(), PhysTrackData.from((PhysTrackData.PhysTrackCreateData)createData.getSecond()));
        }
        this.trackUpdateData.forEach((id, data) -> {
            PhysTrackData old = this.trackData2.get(id);
            if (old != null) {
                this.trackData2.put((Long)id, old.updateWith((PhysTrackData.PhysTrackUpdateData)data));
            }
        });
        this.trackUpdateData.clear();
        while (!this.removedTracks.isEmpty()) {
            Long removeId = (Long)this.removedTracks.remove();
            if (removeId == null) continue;
            this.trackData2.remove(removeId);
        }
        if (this.trackData2.isEmpty()) {
            return;
        }
        Vector3d netLinearForce = new Vector3d(0.0);
        Vector3d netTorque = new Vector3d(0.0);
        long[] ignoreIds = PhysEntityTrackController.getWheelIds(physShip.getId()).stream().mapToLong(l -> l).toArray();
        double coefficientOfPower = Math.min((double)2.0, (double)(14.0 / (double)this.trackData2.size()));
        this.trackData2.forEach((id, data) -> {
            ComputeResult computeResult = this.computeForce((PhysTrackData)data, (PhysShipImpl)physShip, physLevel, coefficientOfPower, ignoreIds);
            this.suspensionData.put((Long)id, computeResult.clipResult);
            if (computeResult.linearForce.isFinite()) {
                netLinearForce.add(computeResult.linearForce);
                netTorque.add(computeResult.torque);
            }
        });
        if (netLinearForce.isFinite() && netLinearForce.length() / physShip.getMass() < 490.5) {
            physShip.applyWorldForce((Vector3dc)netLinearForce, physShip.getKinematics().getPosition());
            if (netTorque.isFinite()) {
                physShip.applyWorldTorque((Vector3dc)netTorque);
            }
        }
    }

    private ComputeResult computeForce(PhysTrackData data, PhysShipImpl ship, @NotNull PhysLevel physLevel, double coefficientOfPower, long[] ignoreIds) {
        boolean istrackGrounded;
        Vec3 start = Vec3.m_82512_((Vec3i)BlockPos.m_122022_((long)data.blockPos));
        Direction.Axis axis = data.wheelAxis;
        double restOffset = data.wheelRadius - 0.5;
        double suspensionRestPosition = data.effectiveSuspensionTravel;
        Vec3 worldSpaceNormal = VectorConversionsMCKt.toMinecraft((Vector3dc)ship.getTransform().getShipToWorldRotation().transform((Vector3dc)VectorConversionsMCKt.toJOML((Vec3)TrackworkUtil.getActionNormal(data.wheelAxis)), new Vector3d()).mul(data.effectiveSuspensionTravel + 0.5));
        Vec3 worldSpaceStart = VectorConversionsMCKt.toMinecraft((Vector3dc)ship.getShipToWorld().transformPosition(VectorConversionsMCKt.toJOML((Vec3)start.m_82520_(0.0, -restOffset, 0.0))));
        Vector3d worldSpaceForward = ship.getTransform().getShipToWorldRotation().transform((Vector3dc)TrackworkUtil.getForwardVec3d(axis, 1.0f), new Vector3d());
        Vec3 worldSpaceHorizontalOffset = VectorConversionsMCKt.toMinecraft((Vector3dc)worldSpaceForward.mul((double)data.horizontalOffset, new Vector3d()));
        TrackworkUtil.ClipResult clipResult = TrackworkUtil.clipAndResolvePhys(physLevel, (PhysShip)ship, (Vector3dc)TrackworkUtil.getAxisAsVec(axis), (Vector3dc)VectorConversionsMCKt.toJOML((Vec3)worldSpaceStart.m_82549_(worldSpaceHorizontalOffset)), (Vector3dc)VectorConversionsMCKt.toJOML((Vec3)worldSpaceNormal), data.wheelRadius, 1, ignoreIds);
        Vector3d trackContactPosition = VectorConversionsMCKt.toJOML((Vec3)worldSpaceStart);
        Vector3d trackTangentForce = clipResult.trackTangent().mul(data.wheelRadius / 0.5, new Vector3d());
        if (data.inWater) {
            trackTangentForce = ship.getTransform().getShipToWorldRotation().transform(TrackworkUtil.getForwardVec3d(axis, 1.0f)).mul(data.wheelRadius / 0.5).mul(0.2);
        }
        double suspensionTravel = clipResult.equals(TrackworkUtil.ClipResult.MISS) ? suspensionRestPosition : clipResult.suspensionLength().length() - 0.5;
        Vector3d suspensionForce = VectorConversionsMCKt.toJOML((Vec3)worldSpaceNormal.m_82490_(suspensionRestPosition - suspensionTravel)).negate();
        double suspensionCompressionDelta = 0.0;
        if (data.lastSuspensionForce != null) {
            suspensionCompressionDelta = suspensionForce.sub(data.lastSuspensionForce, new Vector3d()).length();
        }
        data.lastSuspensionForce = suspensionForce;
        BodyKinematics pose = ship.getKinematics();
        ShipTransform shipTransform = ship.getTransform();
        double m = ship.getMass();
        Vector3d trackRelPosShip = VectorConversionsMCKt.toJOML((Vec3)start).sub(shipTransform.getPositionInShip(), new Vector3d());
        Vector3d tForce = new Vector3d();
        Vector3d trackNormal = VectorConversionsMCKt.toJOML((Vec3)worldSpaceNormal).normalize(new Vector3d());
        Vector3d trackSurface = trackTangentForce.mul((double)data.trackRPM * 0.10471975512 * 0.5, new Vector3d());
        Vector3dc velocityAtPosition = TrackworkUtil.accumulatedVelocity(shipTransform, pose, (Vector3dc)trackContactPosition);
        boolean bl = istrackGrounded = !clipResult.equals(TrackworkUtil.ClipResult.MISS);
        if (istrackGrounded) {
            velocityAtPosition = velocityAtPosition.sub(clipResult.groundVelocity(), new Vector3d());
        }
        if (istrackGrounded) {
            double suspensionDelta = velocityAtPosition.dot((Vector3dc)trackNormal) + suspensionCompressionDelta;
            double tilt = 1.0 + this.tilt((Vector3dc)trackRelPosShip);
            tForce.add((Vector3dc)suspensionForce.mul(m * 1.0 * coefficientOfPower * (double)this.suspensionStiffness * tilt, new Vector3d()));
            tForce.add((Vector3dc)trackNormal.mul(m * 0.6 * -suspensionDelta * coefficientOfPower * (double)this.suspensionStiffness, new Vector3d()));
            if (data.trackRPM == 0.0f) {
                tForce = new Vector3d(0.0, tForce.y(), 0.0);
            }
        }
        if (istrackGrounded || trackSurface.lengthSquared() > 0.0) {
            Vector3d surfaceVelocity = velocityAtPosition.sub((Vector3dc)trackNormal.mul(velocityAtPosition.dot((Vector3dc)trackNormal), new Vector3d()), new Vector3d());
            Vector3d slipVelocity = trackSurface.sub((Vector3dc)surfaceVelocity, new Vector3d());
            if (!istrackGrounded) {
                slipVelocity = surfaceVelocity.normalize(new Vector3d()).mul(slipVelocity.dot((Vector3dc)surfaceVelocity.normalize(new Vector3d())), new Vector3d());
            }
            tForce = tForce.add((Vector3dc)slipVelocity.normalize(Math.min((double)slipVelocity.length(), (double)10.0), new Vector3d()).mul(1.0 * m * coefficientOfPower), new Vector3d());
        }
        Vector3d trackRelPos = shipTransform.getShipToWorldRotation().transform((Vector3dc)trackRelPosShip, new Vector3d());
        Vector3d torque = trackRelPos.cross((Vector3dc)tForce, new Vector3d());
        return new ComputeResult((Vector3dc)tForce, (Vector3dc)torque, clipResult);
    }

    public void addTrackBlock(PhysTrackData.PhysTrackCreateData data) {
        this.createdTrackData.add((Pair<Long, PhysTrackData.PhysTrackCreateData>)new Pair((Object)data.blockPos().m_121878_(), (Object)data));
    }

    public double updateTrackBlock(BlockPos pos, PhysTrackData.PhysTrackUpdateData data) {
        this.trackUpdateData.put(pos.m_121878_(), data);
        return (double)Math.round((double)(this.suspensionAdjust.y() * 16.0)) / 16.0 * (double)((9.0f + 1.0f / (this.suspensionStiffness * 2.0f - 1.0f)) / 10.0f);
    }

    public void removeTrackBlock(long id) {
        this.removedTracks.add(id);
    }

    public float setSuspensionDampening(float delta) {
        this.suspensionStiffness = Math.clamp((float)1.0f, (float)4.0f, (float)(this.suspensionStiffness + delta));
        return this.suspensionStiffness;
    }

    @Deprecated
    public float setDamperCoefficient(float delta) {
        return this.setSuspensionDampening(delta);
    }

    public void adjustSuspension(Vector3f delta) {
        Vector3dc old = this.suspensionAdjust;
        this.suspensionAdjust = new Vector3d(Math.clamp((double)-0.5, (double)0.5, (double)(old.x() + (double)(delta.x() * 5.0f))), Math.clamp((double)0.1, (double)1.0, (double)(old.y() + (double)delta.y())), Math.clamp((double)-0.5, (double)0.5, (double)(old.z() + (double)(delta.z() * 5.0f))));
    }

    public void resetSuspension() {
        double y = this.suspensionAdjust.y();
        this.suspensionAdjust = new Vector3d(0.0, y, 0.0);
    }

    private double tilt(Vector3dc relPos) {
        return Math.signum((double)relPos.x()) * this.suspensionAdjust.z() + Math.signum((double)relPos.z()) * this.suspensionAdjust.x();
    }

    @Nonnull
    public TrackworkUtil.ClipResult getSuspensionData(BlockPos pos) {
        return this.suspensionData.getOrDefault(pos.m_121878_(), TrackworkUtil.ClipResult.MISS);
    }

    public static <T> boolean areQueuesEqual(Queue<T> left, Queue<T> right) {
        return Arrays.equals(left.toArray(), right.toArray());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PhysicsTrackController)) {
            return false;
        }
        PhysicsTrackController otherController = (PhysicsTrackController)other;
        return Objects.equals(this.trackData2, otherController.trackData2) && Objects.equals(this.trackUpdateData, otherController.trackUpdateData) && PhysicsTrackController.areQueuesEqual(this.createdTrackData, otherController.createdTrackData) && PhysicsTrackController.areQueuesEqual(this.removedTracks, otherController.removedTracks) && this.nextBearingID == otherController.nextBearingID && Float.compare(this.suspensionStiffness, otherController.suspensionStiffness) == 0;
    }

    private record ComputeResult(Vector3dc linearForce, Vector3dc torque, TrackworkUtil.ClipResult clipResult) {
    }
}

