/*
 * Decompiled with CFR 0.152.
 */
package edn.stratodonut.trackwork.tracks.forces;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.mojang.datafixers.util.Pair;
import edn.stratodonut.trackwork.TrackworkMod;
import edn.stratodonut.trackwork.tracks.data.PhysEntityTrackData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.joml.Math;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.PhysShip;
import org.valkyrienskies.core.api.ships.ShipPhysicsListener;
import org.valkyrienskies.core.api.ships.properties.ShipTransform;
import org.valkyrienskies.core.api.world.PhysLevel;
import org.valkyrienskies.core.impl.game.ships.PhysShipImpl;
import org.valkyrienskies.mod.api.ValkyrienSkies;
import org.valkyrienskies.mod.common.ValkyrienSkiesMod;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public final class PhysEntityTrackController
implements ShipPhysicsListener {
    @JsonIgnore
    public static final double RPM_TO_RADS = 0.10471975512;
    @JsonIgnore
    public static final Vector3dc UP = new Vector3d(0.0, 1.0, 0.0);
    @Deprecated
    public final HashMap<Integer, PhysEntityTrackData> trackData = new HashMap();
    public final HashMap<Long, PhysEntityTrackData> trackData2 = new HashMap();
    @JsonIgnore
    private final ConcurrentLinkedQueue<Pair<Long, PhysEntityTrackData.CreateData>> createdTrackData = new ConcurrentLinkedQueue();
    @JsonIgnore
    private final ConcurrentHashMap<Long, PhysEntityTrackData.UpdateData> trackUpdateData = new ConcurrentHashMap();
    private final ConcurrentLinkedQueue<Long> removedTracks = new ConcurrentLinkedQueue();
    private final HashMap<Long, Integer> posToJointId = new HashMap();
    @JsonIgnore
    private static final ConcurrentHashMap<Long, List<Long>> ignoreIdsPerVehicle = new ConcurrentHashMap();
    @JsonIgnore
    @Deprecated(forRemoval=true)
    private int nextBearingID = 0;

    public static PhysEntityTrackController getOrCreate(LoadedServerShip ship) {
        return (PhysEntityTrackController)ship.getOrPutAttachment(PhysEntityTrackController.class, PhysEntityTrackController::new);
    }

    public void physTick(@NotNull PhysShip physShip, @NotNull PhysLevel physLevel) {
        while (!this.removedTracks.isEmpty()) {
            Long removeId = (Long)this.removedTracks.remove();
            this.trackData2.remove(removeId);
        }
        while (!this.createdTrackData.isEmpty()) {
            Pair createData = (Pair)this.createdTrackData.remove();
            if (createData.getFirst() != null && createData.getSecond() != null) {
                this.trackData2.put((Long)createData.getFirst(), PhysEntityTrackData.from((PhysEntityTrackData.CreateData)createData.getSecond()));
                continue;
            }
            TrackworkMod.warn("Tried to create a PE track of ID {} with no data!", createData.getFirst());
        }
        this.trackUpdateData.forEach((id, data) -> {
            PhysEntityTrackData old = this.trackData2.get(id);
            if (old != null) {
                this.trackData2.put((Long)id, old.updateWith((PhysEntityTrackData.UpdateData)data));
            }
        });
        this.trackUpdateData.clear();
        if (this.trackData2.isEmpty()) {
            return;
        }
        double coefficientOfPower = Math.min((double)1.0, (double)(4.0 / (double)this.trackData2.size()));
        ArrayList<Long> ignoreIds = new ArrayList<Long>();
        this.trackData2.forEach((id, data) -> {
            ignoreIds.add(data.shiptraptionID);
            PhysShip wheel = physLevel.getShipById(data.shiptraptionID);
            Pair<Vector3dc, Vector3dc> forces = this.computeForce((PhysEntityTrackData)data, (PhysShip)((PhysShipImpl)physShip), (PhysShip)((PhysShipImpl)wheel), coefficientOfPower);
            if (forces != null) {
                // empty if block
            }
        });
        ignoreIds.add(physShip.getId());
        ignoreIdsPerVehicle.put(physShip.getId(), ignoreIds);
    }

    private Pair<@NotNull Vector3dc, @NotNull Vector3dc> computeForce(PhysEntityTrackData data, PhysShip ship, PhysShip wheel, double coefficientOfPower) {
        if (wheel != null) {
            double m = ship.getMass();
            ShipTransform shipTransform = ship.getTransform();
            Vector3d wheelAxis = shipTransform.getShipToWorldRotation().transform(data.wheelAxis, new Vector3d());
            double wheelSpeed = wheel.getKinematics().getAngularVelocity().dot((Vector3dc)wheelAxis);
            double slip = Math.clamp((double)-3.0, (double)3.0, (double)(-data.trackRPM - wheelSpeed));
            Vector3d driveTorque = wheelAxis.mul(-slip * m * 0.4 * coefficientOfPower, new Vector3d());
            return new Pair((Object)new Vector3d(0.0), (Object)driveTorque);
        }
        return null;
    }

    public void addTrackBlock(BlockPos pos, PhysEntityTrackData.CreateData data, int axleId) {
        this.createdTrackData.add((Pair<Long, PhysEntityTrackData.CreateData>)new Pair((Object)pos.m_121878_(), (Object)data));
        this.posToJointId.put(pos.m_121878_(), axleId);
    }

    public void updateTrackBlock(BlockPos pos, PhysEntityTrackData.UpdateData data) {
        this.trackUpdateData.put(pos.m_121878_(), data);
    }

    public void removeTrackBlock(ServerLevel level, BlockPos pos) {
        this.removedTracks.add(pos.m_121878_());
        this.posToJointId.computeIfPresent(pos.m_121878_(), (k, id) -> {
            ValkyrienSkiesMod.getOrCreateGTPA((String)ValkyrienSkies.getDimensionId((Level)level)).removeJoint(id.intValue());
            return null;
        });
    }

    @Nonnull
    public static List<Long> getWheelIds(long vehicleId) {
        return ignoreIdsPerVehicle.getOrDefault(vehicleId, new ArrayList());
    }

    @Deprecated
    public void resetController() {
    }

    public static <T> boolean areQueuesEqual(Queue<T> left, Queue<T> right) {
        return Arrays.equals(left.toArray(), right.toArray());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PhysEntityTrackController)) {
            return false;
        }
        PhysEntityTrackController otherController = (PhysEntityTrackController)other;
        return Objects.equals(this.trackData2, otherController.trackData2) && Objects.equals(this.trackUpdateData, otherController.trackUpdateData) && PhysEntityTrackController.areQueuesEqual(this.createdTrackData, otherController.createdTrackData) && PhysEntityTrackController.areQueuesEqual(this.removedTracks, otherController.removedTracks);
    }
}

