/*
 * Decompiled with CFR 0.152.
 */
package edn.stratodonut.trackwork.tracks.blocks;

import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.infrastructure.config.AllConfigs;
import com.tterrag.registrate.builders.BlockEntityBuilder;
import edn.stratodonut.trackwork.TrackAmbientGroups;
import edn.stratodonut.trackwork.TrackDamageSources;
import edn.stratodonut.trackwork.TrackPackets;
import edn.stratodonut.trackwork.TrackSounds;
import edn.stratodonut.trackwork.TrackworkUtil;
import edn.stratodonut.trackwork.sounds.TrackSoundScapes;
import edn.stratodonut.trackwork.tracks.blocks.OleoWheelBlock;
import edn.stratodonut.trackwork.tracks.blocks.SuspensionTrackBlockEntity;
import edn.stratodonut.trackwork.tracks.data.OleoWheelData;
import edn.stratodonut.trackwork.tracks.forces.OleoWheelController;
import edn.stratodonut.trackwork.tracks.network.OleoWheelPacket;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import org.jetbrains.annotations.NotNull;
import org.joml.Math;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.core.api.bodies.properties.BodyKinematics;
import org.valkyrienskies.core.api.bodies.properties.BodyTransform;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.core.impl.bodies.properties.BodyKinematicsImpl;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

public class OleoWheelBlockEntity
extends SmartBlockEntity {
    private float wheelRadius;
    private float suspensionTravel;
    private double suspensionScale;
    private float steeringValue = 0.0f;
    protected final Random random = new Random();
    private float wheelTravel;
    private float prevWheelTravel;
    private float prevFreeWheelAngle;
    private float horizontalOffset;
    private float axialOffset;
    private boolean isFreespin = true;
    @NotNull
    protected final Supplier<Ship> ship = () -> VSGameUtilsKt.getLoadedShipManagingPos((Level)this.f_58857_, (Vec3i)pos);

    public OleoWheelBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
        this.setLazyTickRate(10);
    }

    public static BlockEntityBuilder.BlockEntityFactory<OleoWheelBlockEntity> factory(float wheelRadius, float suspensionTravel) {
        return (t, p, s) -> {
            OleoWheelBlockEntity be = new OleoWheelBlockEntity(t, p, s);
            be.wheelRadius = wheelRadius;
            be.suspensionTravel = suspensionTravel;
            return be;
        };
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public void remove() {
        LoadedServerShip ship;
        super.remove();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_ && (ship = (LoadedServerShip)this.ship.get()) != null) {
            OleoWheelController controller = OleoWheelController.getOrCreate(ship);
            controller.removeTrackBlock(this.m_58899_());
        }
    }

    public void tick() {
        super.tick();
        if (this.f_58857_.f_46443_ && this.ship.get() != null) {
            Vector3d pos = VectorConversionsMCKt.toJOML((Vec3)Vec3.m_82539_((Vec3i)this.m_58899_()));
            Vector3d ground = VSGameUtilsKt.getWorldCoordinates((Level)this.f_58857_, (BlockPos)this.m_58899_(), (Vector3d)pos.sub((Vector3dc)OleoWheelController.UP.mul((double)this.wheelTravel * 1.2, new Vector3d())));
            BlockPos blockpos = BlockPos.m_274446_((Position)VectorConversionsMCKt.toMinecraft((Vector3dc)ground));
            BlockState blockstate = this.f_58857_.m_8055_(blockpos);
            if (blockstate.m_280296_()) {
                Ship s = this.ship.get();
                Vector3d reversedWheelVel = s.getShipTransform().getShipToWorldRotation().transform(TrackworkUtil.getForwardVec3d(((Direction)this.m_58900_().m_61143_(OleoWheelBlock.AXLE_FACING)).m_122434_(), this.getWheelSpeed()));
                if (Math.abs((float)this.getWheelSpeed()) > 64.0f && blockstate.m_60799_() != RenderShape.INVISIBLE) {
                    this.f_58857_.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockstate).setPos(blockpos), pos.x + (this.random.nextDouble() - 0.5), pos.y + 0.25, pos.z + (this.random.nextDouble() - 0.5) * (double)this.wheelRadius, reversedWheelVel.x() * -1.0, 10.5, reversedWheelVel.z() * -1.0);
                }
                DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> this.lambda$tick$3(s, (Vector3dc)ground, (Vector3dc)reversedWheelVel));
            }
        }
        if (this.f_58857_.f_46443_) {
            this.prevFreeWheelAngle += this.getWheelSpeed() * 3.0f / 10.0f;
        }
        if (this.f_58857_.f_46443_) {
            return;
        }
        Direction axleDir = (Direction)this.m_58900_().m_61143_(OleoWheelBlock.AXLE_FACING);
        Direction.Axis axleAxis = axleDir.m_122434_();
        Direction strutDir = (Direction)this.m_58900_().m_61143_(OleoWheelBlock.STRUT_FACING);
        double restOffset = this.wheelRadius - 0.5f;
        double susScaled = (double)this.suspensionTravel * this.suspensionScale;
        LoadedServerShip ship = (LoadedServerShip)this.ship.get();
        if (ship != null) {
            boolean stowed;
            boolean bl = stowed = strutDir != Direction.DOWN;
            if (stowed) {
                this.steeringValue = 0.0f;
                OleoWheelData data = new OleoWheelData(this.m_58899_().m_121878_(), this.getSteeringValue(), 0.0, axleAxis, this.getPointAxialOffset(), this.getPointHorizontalOffset(), this.wheelRadius, 0.0f, true);
                OleoWheelController controller = OleoWheelController.getOrCreate(ship);
                this.suspensionScale = controller.updateTrackBlock(this.m_58899_(), data);
                this.prevWheelTravel = this.wheelTravel;
                this.wheelTravel = (float)((double)this.suspensionTravel + restOffset);
                return;
            }
            int bestSignal = this.f_58857_.m_277185_(this.m_58899_().m_121945_(axleDir), axleDir) - this.f_58857_.m_277185_(this.m_58899_().m_121945_(axleDir.m_122424_()), axleDir.m_122424_());
            float targetSteeringValue = (float)bestSignal / 15.0f * (float)(axleDir.m_122421_() == Direction.AxisDirection.POSITIVE ? 1 : -1);
            float oldSteeringValue = this.steeringValue;
            Direction axleCw = axleDir.m_122427_();
            this.isFreespin = !this.f_58857_.m_276987_(this.m_58899_().m_121945_(axleCw), axleCw) && !this.f_58857_.m_276987_(this.m_58899_().m_121945_(axleCw.m_122424_()), axleCw.m_122424_());
            float steeringSpeed = 0.5f;
            this.steeringValue = Mth.m_14179_((float)steeringSpeed, (float)this.steeringValue, (float)targetSteeringValue);
            float deltaSteeringValue = oldSteeringValue - this.steeringValue;
            OleoWheelController controller = OleoWheelController.getOrCreate(ship);
            OleoWheelData data = new OleoWheelData(this.m_58899_().m_121878_(), this.getSteeringValue(), susScaled, axleAxis, this.getPointAxialOffset(), this.getPointHorizontalOffset(), this.wheelRadius, 0.0f, this.isFreespin);
            TrackworkUtil.ClipResult clipResult = controller.getSuspensionData(this.m_58899_());
            double suspensionTravel = clipResult.equals(TrackworkUtil.ClipResult.MISS) ? susScaled : clipResult.suspensionLength().length() - 0.5;
            boolean isOnGround = !clipResult.equals(TrackworkUtil.ClipResult.MISS);
            this.suspensionScale = controller.updateTrackBlock(this.m_58899_(), data);
            float newWheelTravel = (float)(suspensionTravel + restOffset);
            float delta = newWheelTravel - this.wheelTravel;
            this.prevWheelTravel = this.wheelTravel;
            this.wheelTravel = newWheelTravel;
            if (Math.abs((float)delta) > 0.01f || Math.abs((float)deltaSteeringValue) > 0.05f) {
                this.syncToClient();
            }
            List hits = this.f_58857_.m_45976_(LivingEntity.class, new AABB(this.m_58899_()).m_82406_(0.25).m_82363_(0.0, -1.5, 0.0));
            Vec3 worldPos = VectorConversionsMCKt.toMinecraft((Vector3dc)ship.getShipToWorld().transformPosition(VectorConversionsMCKt.toJOML((Vec3)Vec3.m_82512_((Vec3i)this.m_58899_()))));
            for (LivingEntity e : hits) {
                SuspensionTrackBlockEntity.push((Entity)e, worldPos);
                float speed = Math.abs((float)this.getWheelSpeed());
                if (speed > 1.0f) {
                    e.m_6469_(TrackDamageSources.runOver(this.f_58857_), speed / 16.0f * (float)((Integer)AllConfigs.server().kinetics.crushingDamage.get()).intValue());
                }
                if (!(e instanceof ServerPlayer)) continue;
                ServerPlayer p = (ServerPlayer)e;
                p.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket((Entity)p));
            }
            if ((double)delta < -0.3) {
                this.f_58857_.m_5594_(null, this.m_58899_(), (SoundEvent)TrackSounds.SUSPENSION_CREAK.get(), SoundSource.BLOCKS, Math.clamp((float)0.0f, (float)2.0f, (float)(Math.abs((float)(delta * 3.0f * (this.getWheelSpeed() / 256.0f))) * 0.5f)), Math.lerp((float)1.2f, (float)0.8f, (float)(-delta)) + 0.4f * this.random.nextFloat());
            }
            if (isOnGround && (double)this.random.nextFloat() < (double)Math.abs((float)(this.getWheelSpeed() / 256.0f)) * 0.1) {
                this.f_58857_.m_5594_(null, this.m_58899_(), (SoundEvent)TrackSounds.WHEEL_ROCKTOSS.get(), SoundSource.BLOCKS, Math.max((float)0.2f, (float)(Math.abs((float)(this.getWheelSpeed() / 256.0f)) * 0.5f)), 0.8f + 0.4f * this.random.nextFloat());
            }
        }
    }

    public void lazyTick() {
        super.lazyTick();
        if (!this.f_58857_.f_46443_ && this.ship.get() != null) {
            this.syncToClient();
        }
    }

    protected void syncToClient() {
        if (!this.f_58857_.f_46443_) {
            TrackPackets.getChannel().send(this.packetTarget(), (Object)new OleoWheelPacket(this.m_58899_(), this.wheelTravel, this.getSteeringValue(), this.horizontalOffset));
        }
    }

    public Vector3d getTangentVecWithSteering(Direction.Axis axis, float length) {
        return TrackworkUtil.getForwardVec3d(axis, length).rotateAxis((double)(this.getSteeringValue() * Math.toRadians((float)30.0f)), 0.0, 1.0, 0.0);
    }

    public float getFreeWheelAngle(float partialTick) {
        return (this.prevFreeWheelAngle + this.getWheelSpeed() * partialTick * 3.0f / 10.0f) % 360.0f;
    }

    public float getWheelSpeed() {
        Ship s;
        if (this.isFreespin && (s = this.ship.get()) != null) {
            Vector3d vel = s.getVelocity().add((Vector3dc)s.getOmega().cross((Vector3dc)s.getShipToWorld().transformPosition(VectorConversionsMCKt.toJOML((Vec3)Vec3.m_82539_((Vec3i)this.m_58899_()))).sub(s.getTransform().getPositionInWorld()), new Vector3d()), new Vector3d());
            Direction.Axis axis = ((Direction)this.m_58900_().m_61143_(OleoWheelBlock.AXLE_FACING)).m_122434_();
            int sign = axis == Direction.Axis.X ? 1 : -1;
            return (float)sign * (float)TrackworkUtil.roundTowardZero(vel.dot((Vector3dc)s.getShipToWorld().transformDirection(this.getTangentVecWithSteering(axis, 1.0f))) * (double)9.3f * 1.0 / (double)this.wheelRadius);
        }
        return 0.0f;
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128350_("WheelTravel", this.wheelTravel);
        compound.m_128350_("HorizontalOffset", this.horizontalOffset);
        compound.m_128350_("AxialOffset", this.axialOffset);
        super.write(compound, clientPacket);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        this.wheelTravel = compound.m_128457_("WheelTravel");
        this.horizontalOffset = compound.m_128457_("HorizontalOffset");
        this.axialOffset = compound.m_128457_("AxialOffset");
        this.prevWheelTravel = this.wheelTravel;
        super.read(compound, clientPacket);
    }

    public float getWheelRadius() {
        return this.wheelRadius;
    }

    public float getWheelTravel(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.prevWheelTravel, (float)this.wheelTravel);
    }

    public void setSteeringValue(float value) {
        this.steeringValue = value;
    }

    public float getSteeringValue() {
        return this.steeringValue;
    }

    public void setOffset(Vector3dc offset, Direction face) {
        Direction.Axis axis = ((Direction)this.m_58900_().m_61143_(OleoWheelBlock.AXLE_FACING)).m_122434_();
        if (face.m_122434_() == axis) {
            this.setHorizontalOffset(offset, axis);
        } else {
            this.setAxialOffset(offset, axis);
        }
    }

    public void setAxialOffset(Vector3dc offset, Direction.Axis axis) {
        double factor = offset.dot((Vector3dc)TrackworkUtil.getAxisAsVec(axis));
        this.axialOffset = Math.clamp((float)-0.4f, (float)0.4f, (float)((float)Math.round((double)(factor * 8.0)) / 8.0f));
        this.syncToClient();
    }

    public float getPointAxialOffset() {
        return this.axialOffset;
    }

    public void setHorizontalOffset(Vector3dc offset, Direction.Axis axis) {
        double factor = offset.dot((Vector3dc)this.getTangentVecWithSteering(axis, 1.0f));
        this.horizontalOffset = Math.clamp((float)-0.4f, (float)0.4f, (float)((float)Math.round((double)(factor * 8.0)) / 8.0f));
        this.syncToClient();
    }

    public float getPointHorizontalOffset() {
        return this.horizontalOffset;
    }

    public void handlePacket(OleoWheelPacket p) {
        this.prevWheelTravel = this.wheelTravel;
        this.wheelTravel = p.wheelTravel;
        this.steeringValue = p.steeringValue;
        this.horizontalOffset = p.horizontalOffset;
    }

    private /* synthetic */ Runnable lambda$tick$3(Ship s, Vector3dc ground, Vector3dc reversedWheelVel) {
        return () -> {
            float wheelSpeed = this.getWheelSpeed();
            float pitch = Mth.m_14036_((float)(Math.abs((float)wheelSpeed) / 256.0f + 0.45f), (float)0.85f, (float)3.0f);
            if (Math.abs((float)wheelSpeed) < 8.0f) {
                return;
            }
            TrackSoundScapes.play(TrackAmbientGroups.WHEEL_GROUND_AMBIENT, this.f_58858_, pitch);
            Vector3dc shipSpeed = TrackworkUtil.accumulatedVelocity(s.getTransform(), (BodyKinematics)new BodyKinematicsImpl(s.getVelocity(), s.getAngularVelocity(), (BodyTransform)s.getTransform()), ground);
            float slip = (float)reversedWheelVel.negate(new Vector3d()).sub(shipSpeed).length();
            pitch = Mth.m_14036_((float)(Math.abs((float)slip) / 10.0f + 0.45f), (float)0.85f, (float)3.0f);
            TrackSoundScapes.play(TrackAmbientGroups.WHEEL_GROUND_SLIP, this.f_58858_, pitch);
        };
    }
}

