/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.eureka.ship;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.core.api.ships.PhysShip;
import org.valkyrienskies.eureka.EurekaConfig;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0007\u001a=\u0010\n\u001a\u00020\t2\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0004\b\n\u0010\u000b\u001a\u001f\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010\u001a\u001f\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0010\u00a8\u0006\u0013"}, d2={"Lorg/valkyrienskies/core/api/ships/PhysShip;", "ship", "Lorg/joml/Vector3dc;", "omega", "vel", "forces", "", "linear", "yaw", "", "stabilize", "(Lorg/valkyrienskies/core/api/ships/PhysShip;Lorg/joml/Vector3dc;Lorg/joml/Vector3dc;Lorg/valkyrienskies/core/api/ships/PhysShip;ZZ)V", "", "smoothing", "x", "smoothingATan", "(DD)D", "max", "smoothingATanMax", "eureka-1201"})
public final class StabilizeKt {
    public static final void stabilize(@NotNull PhysShip ship, @NotNull Vector3dc omega, @NotNull Vector3dc vel, @NotNull PhysShip forces, boolean linear, boolean yaw) {
        Intrinsics.checkNotNullParameter((Object)ship, (String)"ship");
        Intrinsics.checkNotNullParameter((Object)omega, (String)"omega");
        Intrinsics.checkNotNullParameter((Object)vel, (String)"vel");
        Intrinsics.checkNotNullParameter((Object)forces, (String)"forces");
        Vector3d shipUp = new Vector3d(0.0, 1.0, 0.0);
        Vector3d worldUp = new Vector3d(0.0, 1.0, 0.0);
        ship.getTransform().getShipToWorldRotation().transform(shipUp);
        double angleBetween = shipUp.angle((Vector3dc)worldUp);
        Vector3d idealAngularAcceleration = new Vector3d();
        if (angleBetween > 0.01) {
            Vector3d stabilizationRotationAxisNormalized = shipUp.cross((Vector3dc)worldUp, new Vector3d()).normalize();
            idealAngularAcceleration.add((Vector3dc)stabilizationRotationAxisNormalized.mul(angleBetween, stabilizationRotationAxisNormalized));
        }
        idealAngularAcceleration.sub(omega.x(), !yaw ? 0.0 : omega.y(), omega.z());
        Vector3d stabilizationTorque = ship.getTransform().getShipToWorldRotation().transform(ship.getMomentOfInertia().transform(ship.getTransform().getShipToWorldRotation().transformInverse(idealAngularAcceleration)));
        double speed = ship.getVelocity().length();
        stabilizationTorque.mul(EurekaConfig.SERVER.getStabilizationTorqueConstant() / Math.max(1.0, speed * speed * EurekaConfig.SERVER.getScaledInstability() / ship.getMass() + speed * EurekaConfig.SERVER.getUnscaledInstability()));
        Intrinsics.checkNotNull((Object)stabilizationTorque);
        forces.applyInvariantTorque((Vector3dc)stabilizationTorque);
        if (linear) {
            Vector3d idealVelocity = new Vector3d(vel).negate();
            idealVelocity.y = 0.0;
            double s = EurekaConfig.SERVER.getLinearStabilizeMaxAntiVelocity() * (1.0 - 1.0 / StabilizeKt.smoothingATanMax(EurekaConfig.SERVER.getLinearMaxMass(), ship.getMass() * EurekaConfig.SERVER.getLinearMassScaling() + 1.0)) / 10.0;
            if (idealVelocity.lengthSquared() > s * s) {
                idealVelocity.normalize(s);
            }
            idealVelocity.mul(ship.getMass() * ((double)10 - EurekaConfig.SERVER.getAntiVelocityMassRelevance()));
            Intrinsics.checkNotNull((Object)idealVelocity);
            forces.applyInvariantForce((Vector3dc)idealVelocity);
        }
    }

    private static final double smoothingATan(double smoothing, double x) {
        return Math.atan(x * smoothing) / smoothing;
    }

    private static final double smoothingATanMax(double max, double x) {
        return StabilizeKt.smoothingATan(1.0 / (max * 0.638), x);
    }
}

