/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.util.sound;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.valkyrienskies.clockwork.ClockworkSoundScapes;
import org.valkyrienskies.clockwork.util.sound.ContinuousSound;
import org.valkyrienskies.clockwork.util.sound.RepeatingSound;
import org.valkyrienskies.core.api.ships.Ship;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u000b\u0018\u00002\u00020\u0001BA\u0012\b\b\u0002\u0010#\u001a\u00020\u0004\u0012\n\b\u0002\u0010&\u001a\u0004\u0018\u00010%\u0012\n\b\u0002\u0010(\u001a\u0004\u0018\u00010\u001d\u0012\n\b\u0002\u0010+\u001a\u0004\u0018\u00010*\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b6\u00107B#\b\u0016\u0012\u0006\u0010#\u001a\u00020\u0004\u0012\u0006\u0010&\u001a\u00020%\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b6\u00108J9\u0010\u000b\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\b\u0010\b\u001a\u0004\u0018\u00010\u00072\b\u0010\n\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\u000b\u0010\fJ-\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0015\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0015\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0013\u0010\u0017J\r\u0010\u0019\u001a\u00020\u0018\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\r\u0010\u001b\u001a\u00020\u0018\u00a2\u0006\u0004\b\u001b\u0010\u001aJ\r\u0010\u001c\u001a\u00020\u0018\u00a2\u0006\u0004\b\u001c\u0010\u001aJ\r\u0010\u001e\u001a\u00020\u001d\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0011\u0010 \u001a\u0004\u0018\u00010\u001dH\u0002\u00a2\u0006\u0004\b \u0010\u001fJ\r\u0010!\u001a\u00020\u0004\u00a2\u0006\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b#\u0010$R\u0016\u0010&\u001a\u0004\u0018\u00010%8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b&\u0010'R\u0018\u0010(\u001a\u0004\u0018\u00010\u001d8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b(\u0010)R\u0016\u0010+\u001a\u0004\u0018\u00010*8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b+\u0010,R\u0018\u0010\b\u001a\u0004\u0018\u00010\u00078\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\b\u0010-R(\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00110.8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u000b\u0010/\u001a\u0004\b0\u00101\"\u0004\b2\u00103R(\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00150.8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u000f\u0010/\u001a\u0004\b4\u00101\"\u0004\b5\u00103\u00a8\u00069"}, d2={"Lorg/valkyrienskies/clockwork/util/sound/SoundScape;", "", "Lnet/minecraft/sounds/SoundEvent;", "sound", "", "relativeVolume", "relativePitch", "Lorg/valkyrienskies/core/api/ships/Ship;", "ship", "Lnet/minecraft/core/BlockPos;", "pos", "continuous", "(Lnet/minecraft/sounds/SoundEvent;FFLorg/valkyrienskies/core/api/ships/Ship;Lnet/minecraft/core/BlockPos;)Lorg/valkyrienskies/clockwork/util/sound/SoundScape;", "", "delay", "repeating", "(Lnet/minecraft/sounds/SoundEvent;FFI)Lorg/valkyrienskies/clockwork/util/sound/SoundScape;", "Lorg/valkyrienskies/clockwork/util/sound/ContinuousSound;", "continuousSound", "add", "(Lorg/valkyrienskies/clockwork/util/sound/ContinuousSound;)Lorg/valkyrienskies/clockwork/util/sound/SoundScape;", "Lorg/valkyrienskies/clockwork/util/sound/RepeatingSound;", "repeatingSound", "(Lorg/valkyrienskies/clockwork/util/sound/RepeatingSound;)Lorg/valkyrienskies/clockwork/util/sound/SoundScape;", "", "play", "()V", "tick", "remove", "Lnet/minecraft/world/phys/Vec3;", "getMeanPos", "()Lnet/minecraft/world/phys/Vec3;", "determineMeanPos", "getVolume", "()F", "pitch", "F", "Lorg/valkyrienskies/clockwork/ClockworkSoundScapes$AmbienceGroup;", "group", "Lorg/valkyrienskies/clockwork/ClockworkSoundScapes$AmbienceGroup;", "meanPos", "Lnet/minecraft/world/phys/Vec3;", "Lorg/valkyrienskies/clockwork/ClockworkSoundScapes$PitchGroup;", "pitchGroup", "Lorg/valkyrienskies/clockwork/ClockworkSoundScapes$PitchGroup;", "Lorg/valkyrienskies/core/api/ships/Ship;", "", "Ljava/util/List;", "getContinuous", "()Ljava/util/List;", "setContinuous", "(Ljava/util/List;)V", "getRepeating", "setRepeating", "<init>", "(FLorg/valkyrienskies/clockwork/ClockworkSoundScapes$AmbienceGroup;Lnet/minecraft/world/phys/Vec3;Lorg/valkyrienskies/clockwork/ClockworkSoundScapes$PitchGroup;Lorg/valkyrienskies/core/api/ships/Ship;)V", "(FLorg/valkyrienskies/clockwork/ClockworkSoundScapes$AmbienceGroup;Lorg/valkyrienskies/core/api/ships/Ship;)V", "clockwork"})
@SourceDebugExtension(value={"SMAP\nSoundScape.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SoundScape.kt\norg/valkyrienskies/clockwork/util/sound/SoundScape\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,107:1\n1#2:108\n*E\n"})
public final class SoundScape {
    private final float pitch;
    @Nullable
    private final ClockworkSoundScapes.AmbienceGroup group;
    @Nullable
    private Vec3 meanPos;
    @Nullable
    private final ClockworkSoundScapes.PitchGroup pitchGroup;
    @Nullable
    private Ship ship;
    @NotNull
    private List<ContinuousSound> continuous;
    @NotNull
    private List<RepeatingSound> repeating;

    public SoundScape(float pitch, @Nullable ClockworkSoundScapes.AmbienceGroup group, @Nullable Vec3 meanPos, @Nullable ClockworkSoundScapes.PitchGroup pitchGroup, @Nullable Ship ship) {
        this.pitch = pitch;
        this.group = group;
        this.meanPos = meanPos;
        this.pitchGroup = pitchGroup;
        this.ship = ship;
        this.continuous = new ArrayList();
        this.repeating = new ArrayList();
    }

    public /* synthetic */ SoundScape(float f, ClockworkSoundScapes.AmbienceGroup ambienceGroup, Vec3 vec3, ClockworkSoundScapes.PitchGroup pitchGroup, Ship ship, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            f = 0.0f;
        }
        if ((n & 2) != 0) {
            ambienceGroup = null;
        }
        if ((n & 4) != 0) {
            vec3 = null;
        }
        if ((n & 8) != 0) {
            pitchGroup = null;
        }
        if ((n & 0x10) != 0) {
            ship = null;
        }
        this(f, ambienceGroup, vec3, pitchGroup, ship);
    }

    @NotNull
    public final List<ContinuousSound> getContinuous() {
        return this.continuous;
    }

    public final void setContinuous(@NotNull List<ContinuousSound> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.continuous = list;
    }

    @NotNull
    public final List<RepeatingSound> getRepeating() {
        return this.repeating;
    }

    public final void setRepeating(@NotNull List<RepeatingSound> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.repeating = list;
    }

    public SoundScape(float pitch, @NotNull ClockworkSoundScapes.AmbienceGroup group, @Nullable Ship ship) {
        Intrinsics.checkNotNullParameter((Object)((Object)group), (String)"group");
        this(pitch, group, null, ClockworkSoundScapes.INSTANCE.getGroupFromPitch(pitch), ship);
    }

    @NotNull
    public final SoundScape continuous(@NotNull SoundEvent sound, float relativeVolume, float relativePitch, @Nullable Ship ship, @Nullable BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)sound, (String)"sound");
        return this.add(new ContinuousSound(sound, this, this.pitch * relativePitch, relativeVolume, ship, pos));
    }

    @NotNull
    public final SoundScape repeating(@NotNull SoundEvent sound, float relativeVolume, float relativePitch, int delay) {
        Intrinsics.checkNotNullParameter((Object)sound, (String)"sound");
        return this.add(new RepeatingSound(sound, this, this.pitch * relativePitch, relativeVolume, delay));
    }

    @NotNull
    public final SoundScape add(@NotNull ContinuousSound continuousSound) {
        Intrinsics.checkNotNullParameter((Object)((Object)continuousSound), (String)"continuousSound");
        this.continuous.add(continuousSound);
        return this;
    }

    @NotNull
    public final SoundScape add(@NotNull RepeatingSound repeatingSound) {
        Intrinsics.checkNotNullParameter((Object)repeatingSound, (String)"repeatingSound");
        this.repeating.add(repeatingSound);
        return this;
    }

    public final void play() {
        this.continuous.forEach(SoundScape::play$lambda$0);
    }

    public final void tick() {
        if (AnimationTickHolder.getTicks() % 5 == 0) {
            this.meanPos = null;
        }
        this.repeating.forEach(SoundScape::tick$lambda$1);
    }

    public final void remove() {
        this.continuous.forEach(SoundScape::remove$lambda$2);
    }

    @NotNull
    public final Vec3 getMeanPos() {
        Vec3 vec3;
        if (this.meanPos == null) {
            Vec3 vec32;
            Vec3 it = vec32 = this.determineMeanPos();
            boolean bl = false;
            this.meanPos = it;
            Vec3 vec33 = vec32;
            vec3 = vec33;
            Intrinsics.checkNotNull((Object)vec33);
        } else {
            Vec3 vec34 = this.meanPos;
            vec3 = vec34;
            Intrinsics.checkNotNull((Object)vec34);
        }
        return vec3;
    }

    private final Vec3 determineMeanPos() {
        this.meanPos = Vec3.f_82478_;
        int amount = 0;
        if (this.ship != null) {
            for (ContinuousSound sound : this.continuous) {
                Vec3 vec3 = this.meanPos;
                Intrinsics.checkNotNull((Object)vec3);
                this.meanPos = vec3.m_82549_(VecHelper.getCenterOf((Vec3i)((Vec3i)sound.getNewPos())));
                ++amount;
            }
        } else {
            for (BlockPos pos : ClockworkSoundScapes.INSTANCE.getAllLocations(this.group, this.pitchGroup)) {
                Vec3 vec3 = this.meanPos;
                Intrinsics.checkNotNull((Object)vec3);
                this.meanPos = vec3.m_82549_(VecHelper.getCenterOf((Vec3i)((Vec3i)pos)));
                ++amount;
            }
        }
        if (amount == 0) {
            return this.meanPos;
        }
        Vec3 vec3 = this.meanPos;
        Intrinsics.checkNotNull((Object)vec3);
        return vec3.m_82490_((double)(1.0f / (float)amount));
    }

    public final float getVolume() {
        Entity renderViewEntity = Minecraft.m_91087_().f_91075_;
        float distanceMultiplier = 0.0f;
        if (renderViewEntity != null) {
            double distanceTo = renderViewEntity.m_20182_().m_82554_(this.getMeanPos());
            distanceMultiplier = (float)Mth.m_14139_((double)(distanceTo / (double)16), (double)2.0, (double)0.0);
        }
        int soundCount = ClockworkSoundScapes.INSTANCE.getSoundCount(this.group, this.pitchGroup);
        float max = 0.75f;
        float argMax = 15.0f;
        return Mth.m_14036_((float)((float)soundCount / (argMax * 10.0f)), (float)0.025f, (float)max) * distanceMultiplier;
    }

    private static final void play$lambda$0(ContinuousSound sound) {
        if (sound != null) {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)sound);
        }
    }

    private static final void tick$lambda$1(RepeatingSound obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        obj.tick();
    }

    private static final void remove$lambda$2(ContinuousSound obj) {
        Intrinsics.checkNotNullParameter((Object)((Object)obj), (String)"obj");
        obj.remove();
    }

    public SoundScape() {
        this(0.0f, null, null, null, null, 31, null);
    }
}

