/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.util.sound;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.clockwork.util.sound.SoundScape;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.client.audio.VelocityTickableSoundInstance;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B;\u0012\u0006\u0010\u0014\u001a\u00020\u0013\u0012\u0006\u0010\u001b\u001a\u00020\u001a\u0012\u0006\u0010\u001f\u001a\u00020\u0003\u0012\u0006\u0010%\u001a\u00020$\u0012\u0006\u0010+\u001a\u00020\u0003\u0012\n\b\u0002\u0010/\u001a\u0004\u0018\u00010.\u00a2\u0006\u0004\b>\u0010?BA\b\u0010\u0012\u0006\u0010\u0014\u001a\u00020\u0013\u0012\u0006\u0010%\u001a\u00020$\u0012\u0006\u0010\u001f\u001a\u00020\u0003\u0012\u0006\u0010+\u001a\u00020\u0003\u0012\n\b\u0002\u0010/\u001a\u0004\u0018\u00010.\u0012\n\b\u0002\u00105\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0004\b>\u0010@J\u000f\u0010\u0004\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0006\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0005J\u000f\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\n\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\n\u0010\tJ\u000f\u0010\u000b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u000b\u0010\tJ\r\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\r\u0010\u0012\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0012\u0010\u0011R\"\u0010\u0014\u001a\u00020\u00138\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0017\u0010\u001b\u001a\u00020\u001a8\u0006\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u001d\u0010\u001eR\"\u0010\u001f\u001a\u00020\u00038\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\u0005\"\u0004\b\"\u0010#R\"\u0010%\u001a\u00020$8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b%\u0010&\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\"\u0010+\u001a\u00020\u00038\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b+\u0010 \u001a\u0004\b,\u0010\u0005\"\u0004\b-\u0010#R$\u0010/\u001a\u0004\u0018\u00010.8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b/\u00100\u001a\u0004\b1\u00102\"\u0004\b3\u00104R\"\u00105\u001a\u00020\f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b5\u00106\u001a\u0004\b7\u0010\u000e\"\u0004\b8\u00109R\u0014\u0010=\u001a\u00020:8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b;\u0010<\u00a8\u0006A"}, d2={"Lorg/valkyrienskies/clockwork/util/sound/ContinuousSound;", "Lnet/minecraft/client/resources/sounds/AbstractTickableSoundInstance;", "Lorg/valkyrienskies/mod/client/audio/VelocityTickableSoundInstance;", "", "getVolume", "()F", "getPitch", "", "getX", "()D", "getY", "getZ", "Lnet/minecraft/core/BlockPos;", "getNewPos", "()Lnet/minecraft/core/BlockPos;", "", "tick", "()V", "remove", "Lnet/minecraft/sounds/SoundEvent;", "soundEvent", "Lnet/minecraft/sounds/SoundEvent;", "getSoundEvent", "()Lnet/minecraft/sounds/SoundEvent;", "setSoundEvent", "(Lnet/minecraft/sounds/SoundEvent;)V", "Lnet/minecraft/sounds/SoundSource;", "soundSource", "Lnet/minecraft/sounds/SoundSource;", "getSoundSource", "()Lnet/minecraft/sounds/SoundSource;", "sharedPitch", "F", "getSharedPitch", "setSharedPitch", "(F)V", "Lorg/valkyrienskies/clockwork/util/sound/SoundScape;", "scape", "Lorg/valkyrienskies/clockwork/util/sound/SoundScape;", "getScape", "()Lorg/valkyrienskies/clockwork/util/sound/SoundScape;", "setScape", "(Lorg/valkyrienskies/clockwork/util/sound/SoundScape;)V", "relativeVolume", "getRelativeVolume", "setRelativeVolume", "Lorg/valkyrienskies/core/api/ships/Ship;", "ship", "Lorg/valkyrienskies/core/api/ships/Ship;", "getShip", "()Lorg/valkyrienskies/core/api/ships/Ship;", "setShip", "(Lorg/valkyrienskies/core/api/ships/Ship;)V", "originalPos", "Lnet/minecraft/core/BlockPos;", "getOriginalPos", "setOriginalPos", "(Lnet/minecraft/core/BlockPos;)V", "Lorg/joml/Vector3dc;", "getVelocity", "()Lorg/joml/Vector3dc;", "velocity", "<init>", "(Lnet/minecraft/sounds/SoundEvent;Lnet/minecraft/sounds/SoundSource;FLorg/valkyrienskies/clockwork/util/sound/SoundScape;FLorg/valkyrienskies/core/api/ships/Ship;)V", "(Lnet/minecraft/sounds/SoundEvent;Lorg/valkyrienskies/clockwork/util/sound/SoundScape;FFLorg/valkyrienskies/core/api/ships/Ship;Lnet/minecraft/core/BlockPos;)V", "clockwork"})
public final class ContinuousSound
extends AbstractTickableSoundInstance
implements VelocityTickableSoundInstance {
    @NotNull
    private SoundEvent soundEvent;
    @NotNull
    private final SoundSource soundSource;
    private float sharedPitch;
    @NotNull
    private SoundScape scape;
    private float relativeVolume;
    @Nullable
    private Ship ship;
    @NotNull
    private BlockPos originalPos;

    public ContinuousSound(@NotNull SoundEvent soundEvent, @NotNull SoundSource soundSource, float sharedPitch, @NotNull SoundScape scape, float relativeVolume, @Nullable Ship ship) {
        Intrinsics.checkNotNullParameter((Object)soundEvent, (String)"soundEvent");
        Intrinsics.checkNotNullParameter((Object)soundSource, (String)"soundSource");
        Intrinsics.checkNotNullParameter((Object)scape, (String)"scape");
        super(soundEvent, soundSource, RandomSource.m_216327_());
        this.soundEvent = soundEvent;
        this.soundSource = soundSource;
        this.sharedPitch = sharedPitch;
        this.scape = scape;
        this.relativeVolume = relativeVolume;
        this.ship = ship;
        BlockPos blockPos = BlockPos.m_274561_((double)this.f_119575_, (double)this.f_119576_, (double)this.f_119577_);
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"containing(...)");
        this.originalPos = blockPos;
        this.f_119578_ = true;
        this.f_119579_ = 0;
        this.f_119582_ = false;
    }

    public /* synthetic */ ContinuousSound(SoundEvent soundEvent, SoundSource soundSource, float f, SoundScape soundScape, float f2, Ship ship, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            ship = null;
        }
        this(soundEvent, soundSource, f, soundScape, f2, ship);
    }

    @NotNull
    public final SoundEvent getSoundEvent() {
        return this.soundEvent;
    }

    public final void setSoundEvent(@NotNull SoundEvent soundEvent) {
        Intrinsics.checkNotNullParameter((Object)soundEvent, (String)"<set-?>");
        this.soundEvent = soundEvent;
    }

    @NotNull
    public final SoundSource getSoundSource() {
        return this.soundSource;
    }

    public final float getSharedPitch() {
        return this.sharedPitch;
    }

    public final void setSharedPitch(float f) {
        this.sharedPitch = f;
    }

    @NotNull
    public final SoundScape getScape() {
        return this.scape;
    }

    public final void setScape(@NotNull SoundScape soundScape) {
        Intrinsics.checkNotNullParameter((Object)soundScape, (String)"<set-?>");
        this.scape = soundScape;
    }

    public final float getRelativeVolume() {
        return this.relativeVolume;
    }

    public final void setRelativeVolume(float f) {
        this.relativeVolume = f;
    }

    @Nullable
    public final Ship getShip() {
        return this.ship;
    }

    public final void setShip(@Nullable Ship ship) {
        this.ship = ship;
    }

    @NotNull
    public final BlockPos getOriginalPos() {
        return this.originalPos;
    }

    public final void setOriginalPos(@NotNull BlockPos blockPos) {
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"<set-?>");
        this.originalPos = blockPos;
    }

    @NotNull
    public Vector3dc getVelocity() {
        Ship ship = this.ship;
        if (ship == null || (ship = ship.getVelocity()) == null) {
            ship = (Vector3dc)new Vector3d();
        }
        return ship;
    }

    public ContinuousSound(@NotNull SoundEvent soundEvent, @NotNull SoundScape scape, float sharedPitch, float relativeVolume, @Nullable Ship ship, @Nullable BlockPos originalPos) {
        Intrinsics.checkNotNullParameter((Object)soundEvent, (String)"soundEvent");
        Intrinsics.checkNotNullParameter((Object)scape, (String)"scape");
        this(soundEvent, SoundSource.AMBIENT, sharedPitch, scape, relativeVolume, null, 32, null);
        this.f_119578_ = true;
        this.f_119579_ = 0;
        this.f_119582_ = false;
        BlockPos blockPos = originalPos;
        if (blockPos == null) {
            BlockPos blockPos2 = BlockPos.f_121853_;
            blockPos = blockPos2;
            Intrinsics.checkNotNullExpressionValue((Object)blockPos2, (String)"ZERO");
        }
        this.originalPos = blockPos;
    }

    public /* synthetic */ ContinuousSound(SoundEvent soundEvent, SoundScape soundScape, float f, float f2, Ship ship, BlockPos blockPos, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            ship = null;
        }
        if ((n & 0x20) != 0) {
            blockPos = null;
        }
        this(soundEvent, soundScape, f, f2, ship, blockPos);
    }

    public float m_7769_() {
        return this.scape.getVolume() * this.relativeVolume;
    }

    public float m_7783_() {
        return this.sharedPitch;
    }

    public double m_7772_() {
        return this.scape.getMeanPos().f_82479_;
    }

    public double m_7780_() {
        return this.scape.getMeanPos().f_82480_;
    }

    public double m_7778_() {
        return this.scape.getMeanPos().f_82481_;
    }

    @NotNull
    public final BlockPos getNewPos() {
        if (this.ship == null) {
            return this.originalPos;
        }
        Ship ship = this.ship;
        Intrinsics.checkNotNull((Object)ship);
        BlockPos blockPos = BlockPos.m_274446_((Position)((Position)VSGameUtilsKt.toWorldCoordinates((Ship)ship, (Vec3)new Vec3(this.f_119575_, this.f_119576_, this.f_119577_))));
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"containing(...)");
        return blockPos;
    }

    public void m_7788_() {
        if (this.ship != null) {
            Ship ship = this.ship;
            Intrinsics.checkNotNull((Object)ship);
            BlockPos blockPos = BlockPos.m_274561_((double)this.f_119575_, (double)this.f_119576_, (double)this.f_119577_);
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"containing(...)");
            Vector3d newPosition = VSGameUtilsKt.toWorldCoordinates((Ship)ship, (BlockPos)blockPos);
            this.f_119575_ = newPosition.x;
            this.f_119576_ = newPosition.y;
            this.f_119577_ = newPosition.z;
        }
    }

    public final void remove() {
        this.m_119609_();
    }
}

