/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.util.blocktype;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.valkyrienskies.clockwork.platform.api.network.ClientNetworkContext;
import org.valkyrienskies.clockwork.platform.api.network.S2CCWPacket;
import org.valkyrienskies.clockwork.util.blocktype.ISyncableStorage;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u001c\u0010\u0006B\u0011\b\u0016\u0012\u0006\u0010\u001e\u001a\u00020\u001d\u00a2\u0006\u0004\b\u001c\u0010\u001fJ\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\t\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\t\u0010\nR$\u0010\f\u001a\u0004\u0018\u00010\u000b8\u0016@\u0016X\u0096\u000e\u00a2\u0006\u0012\n\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0013\u001a\u00020\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018R\u0014\u0010\u001a\u001a\u00020\u00198\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001b\u00a8\u0006 "}, d2={"Lorg/valkyrienskies/clockwork/util/blocktype/SyncableStoragePacket;", "Lorg/valkyrienskies/clockwork/platform/api/network/S2CCWPacket;", "Lnet/minecraft/network/FriendlyByteBuf;", "buffer", "", "write", "(Lnet/minecraft/network/FriendlyByteBuf;)V", "Lorg/valkyrienskies/clockwork/platform/api/network/ClientNetworkContext;", "context", "handle", "(Lorg/valkyrienskies/clockwork/platform/api/network/ClientNetworkContext;)V", "Lnet/minecraft/world/entity/player/Player;", "player", "Lnet/minecraft/world/entity/player/Player;", "getPlayer", "()Lnet/minecraft/world/entity/player/Player;", "setPlayer", "(Lnet/minecraft/world/entity/player/Player;)V", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/core/BlockPos;", "Lnet/minecraft/core/NonNullList;", "Lnet/minecraft/world/item/ItemStack;", "inventory", "Lnet/minecraft/core/NonNullList;", "", "inventorySize", "I", "<init>", "Lorg/valkyrienskies/clockwork/util/blocktype/ISyncableStorage;", "be", "(Lorg/valkyrienskies/clockwork/util/blocktype/ISyncableStorage;)V", "clockwork"})
public final class SyncableStoragePacket
implements S2CCWPacket {
    @Nullable
    private Player player;
    @NotNull
    private final BlockPos pos;
    @NotNull
    private final NonNullList<ItemStack> inventory;
    private final int inventorySize;

    @Override
    @Nullable
    public Player getPlayer() {
        return this.player;
    }

    @Override
    public void setPlayer(@Nullable Player player) {
        this.player = player;
    }

    public SyncableStoragePacket(@NotNull FriendlyByteBuf buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.pos = buffer.m_130135_();
        CompoundTag nbt = buffer.m_130260_();
        if (nbt == null) {
            this.inventory = NonNullList.m_122780_((int)1, (Object)ItemStack.f_41583_);
            this.inventorySize = 1;
        } else {
            this.inventorySize = nbt.m_128451_("size");
            this.inventory = NonNullList.m_122780_((int)this.inventorySize, (Object)ItemStack.f_41583_);
            ContainerHelper.m_18980_((CompoundTag)nbt, this.inventory);
        }
    }

    public SyncableStoragePacket(@NotNull ISyncableStorage be) {
        Intrinsics.checkNotNullParameter((Object)be, (String)"be");
        this.pos = be.getBlockPositionFromISS();
        this.inventory = be.getStorageInventory();
        this.inventorySize = be.getStorageInventorySize();
    }

    @Override
    public void write(@NotNull FriendlyByteBuf buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        buffer.m_130064_(this.pos);
        CompoundTag nbt = new CompoundTag();
        ContainerHelper.m_18973_((CompoundTag)nbt, this.inventory);
        nbt.m_128405_("size", this.inventorySize);
        buffer.m_130079_(nbt);
    }

    @Override
    public void handle(@NotNull ClientNetworkContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        context.enqueueWork(() -> SyncableStoragePacket.handle$lambda$0(this));
        context.setPacketHandled(true);
    }

    private static final void handle$lambda$0(SyncableStoragePacket this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (Minecraft.m_91087_().f_91073_ != null) {
            ClientLevel clientLevel = Minecraft.m_91087_().f_91073_;
            Intrinsics.checkNotNull((Object)clientLevel);
            if (clientLevel.m_7702_(this$0.pos) instanceof ISyncableStorage) {
                ClientLevel clientLevel2 = Minecraft.m_91087_().f_91073_;
                Intrinsics.checkNotNull((Object)clientLevel2);
                ISyncableStorage ce = (ISyncableStorage)clientLevel2.m_7702_(this$0.pos);
                if (ce != null) {
                    ce.sync(this$0.inventory);
                }
            }
        }
    }
}

