/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.util.beam;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.ULong;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.valkyrienskies.clockwork.util.render.RenderUtil;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0012\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b<\u0010=J\u0017\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J#\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\u000b\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u000b\u0010\u0005J3\u0010\u0011\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\r2\b\b\u0002\u0010\u000f\u001a\u00020\u00022\b\b\u0002\u0010\u0010\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012JA\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00062\b\b\u0002\u0010\u0016\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J'\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0087\u0001\u0010-\u001a\u00020,2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u00062\u0006\u0010!\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\u00022\u0006\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020$2\b\b\u0002\u0010'\u001a\u00020$2\b\b\u0002\u0010(\u001a\u00020\u00022\b\b\u0002\u0010)\u001a\u00020\u00022\b\b\u0002\u0010*\u001a\u00020\u00022\b\b\u0002\u0010+\u001a\u00020\u0002\u00a2\u0006\u0004\b-\u0010.J\u00a5\u0001\u00101\u001a\u00020,2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u00062\u0006\u0010!\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\u00022\u0006\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020$2\b\b\u0002\u0010'\u001a\u00020$2\b\b\u0002\u0010(\u001a\u00020\u00022\b\b\u0002\u0010/\u001a\u00020$2\b\b\u0002\u0010)\u001a\u00020\u00022\b\b\u0002\u0010*\u001a\u00020\u00022\b\b\u0002\u0010+\u001a\u00020\u00022\b\b\u0002\u00100\u001a\u00020\u00022\b\b\u0002\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b1\u00102J\u0093\u0001\u00104\u001a\u00020,2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020\u00062\u0006\u00103\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\u00022\u0006\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020$2\b\b\u0002\u0010'\u001a\u00020$2\b\b\u0002\u0010(\u001a\u00020\u00022\b\b\u0002\u0010)\u001a\u00020\u00022\b\b\u0002\u0010*\u001a\u00020\u00022\b\b\u0002\u0010+\u001a\u00020\u00022\b\b\u0002\u00100\u001a\u00020\u00022\b\b\u0002\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b4\u00105Js\u0010:\u001a\u00020,2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u00062\u0006\u00106\u001a\u00020\u00062\u0006\u00107\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u00022\b\b\u0002\u00108\u001a\u00020$2\b\b\u0002\u00109\u001a\u00020\u00022\b\b\u0002\u0010#\u001a\u00020\u00022\u0006\u0010%\u001a\u00020$\u00a2\u0006\u0004\b:\u0010;\u00a8\u0006>"}, d2={"Lorg/valkyrienskies/clockwork/util/beam/BeamRenderer;", "", "", "x", "frac", "(F)F", "Lnet/minecraft/world/phys/Vec3;", "fwd", "Lkotlin/Pair;", "safePerpBasis", "(Lnet/minecraft/world/phys/Vec3;)Lkotlin/Pair;", "smoothstep01", "time", "", "seed", "periodSeconds", "dutySeconds", "joltEnvelope", "(FJFF)F", "t", "u", "v", "maxShake", "shakeOffset", "(FFJLnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/Vec3;F)Lnet/minecraft/world/phys/Vec3;", "warbleMulSinWithJolt", "(FFJ)F", "Lcom/mojang/blaze3d/vertex/PoseStack;", "poseStack", "Lcom/mojang/blaze3d/vertex/VertexConsumer;", "vc", "camPosWorld", "blockOriginWorld", "startLocal", "endLocal", "width", "", "argb", "segments", "rampSteps", "minWidthFrac", "tileWorldUnits", "scrollSpeed", "timeSeconds", "", "renderBeamRibbon", "(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/Vec3;FIIIFFFF)V", "ribbons", "uScale", "renderBeamTube", "(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/Vec3;FIIIFIFFFFJ)V", "rightUnit", "renderBeamRibbonWithRight", "(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/Vec3;FIIIFFFFFJ)V", "hitPosLocal", "normalWorld", "rays", "burstLen", "renderImpactBurst", "(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/Vec3;JFIFFI)V", "<init>", "()V", "clockwork"})
public final class BeamRenderer {
    @NotNull
    public static final BeamRenderer INSTANCE = new BeamRenderer();

    private BeamRenderer() {
    }

    private final float frac(float x) {
        return x - (float)Math.floor(x);
    }

    private final Pair<Vec3, Vec3> safePerpBasis(Vec3 fwd) {
        Vec3 ref = Math.abs(fwd.f_82480_) < 0.99 ? new Vec3(0.0, 1.0, 0.0) : new Vec3(1.0, 0.0, 0.0);
        Vec3 u = fwd.m_82537_(ref);
        Vec3 uN = u.m_82556_() < 1.0E-12 ? new Vec3(1.0, 0.0, 0.0) : u.m_82541_();
        Vec3 v = fwd.m_82537_(uN);
        Vec3 vN = v.m_82556_() < 1.0E-12 ? new Vec3(0.0, 0.0, 1.0) : v.m_82541_();
        return TuplesKt.to((Object)uN, (Object)vN);
    }

    private final float smoothstep01(float x) {
        float t = RangesKt.coerceIn((float)x, (float)0.0f, (float)1.0f);
        return t * t * (3.0f - 2.0f * t);
    }

    private final float joltEnvelope(float time, long seed, float periodSeconds, float dutySeconds) {
        int k = (int)Math.floor(time / periodSeconds);
        float tIn = time - (float)k * periodSeconds;
        long r = RenderUtil.INSTANCE.hash64(seed ^ ULong.constructor-impl((long)(ULong.constructor-impl((long)k) * -3335678366873096957L)));
        float has = (float)r > 0.65f ? 1.0f : 0.0f;
        float x = RangesKt.coerceIn((float)(tIn / dutySeconds), (float)0.0f, (float)1.0f);
        float attack = this.smoothstep01(x);
        float decay = this.smoothstep01(1.0f - x);
        float pulse = attack * decay;
        return has * pulse;
    }

    static /* synthetic */ float joltEnvelope$default(BeamRenderer beamRenderer, float f, long l, float f2, float f3, int n, Object object) {
        if ((n & 4) != 0) {
            f2 = 0.8f;
        }
        if ((n & 8) != 0) {
            f3 = 0.1f;
        }
        return beamRenderer.joltEnvelope(f, l, f2, f3);
    }

    private final Vec3 shakeOffset(float t, float time, long seed, Vec3 u, Vec3 v, float maxShake) {
        float j = this.joltEnvelope(time, seed, 0.85f, 0.12f);
        if (j <= 0.0f) {
            Vec3 vec3 = Vec3.f_82478_;
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"ZERO");
            return vec3;
        }
        double ph0 = (double)(time * 28.0f + t * 6.0f) * (Math.PI * 2);
        double ph1 = (double)(time * 33.0f + t * 9.0f + 1.3f) * (Math.PI * 2);
        float sx = (float)Math.sin(ph0);
        float sy = (float)Math.sin(ph1);
        float amt = maxShake * j;
        Vec3 vec3 = u.m_82490_((double)(sx * amt)).m_82549_(v.m_82490_((double)(sy * amt)));
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"add(...)");
        return vec3;
    }

    static /* synthetic */ Vec3 shakeOffset$default(BeamRenderer beamRenderer, float f, float f2, long l, Vec3 vec3, Vec3 vec32, float f3, int n, Object object) {
        if ((n & 0x20) != 0) {
            f3 = 0.06f;
        }
        return beamRenderer.shakeOffset(f, f2, l, vec3, vec32, f3);
    }

    private final float warbleMulSinWithJolt(float t, float time, long seed) {
        float spatialFreq = 8.0f;
        float temporalFreq = 2.5f;
        double phase = (double)(t * spatialFreq - time * temporalFreq) * (Math.PI * 2);
        float s = (float)Math.sin(phase);
        float baseAmp = 0.2f;
        float mul = 1.0f + s * baseAmp;
        float j = this.joltEnvelope(time, seed, 0.85f, 0.12f);
        float joltAmp = 0.45f;
        return RangesKt.coerceIn((float)(mul += j * joltAmp), (float)0.55f, (float)1.75f);
    }

    public final void renderBeamRibbon(@NotNull PoseStack poseStack, @NotNull VertexConsumer vc, @NotNull Vec3 camPosWorld, @NotNull Vec3 blockOriginWorld, @NotNull Vec3 startLocal, @NotNull Vec3 endLocal, float width, int argb, int segments, int rampSteps, float minWidthFrac, float tileWorldUnits, float scrollSpeed, float timeSeconds) {
        Vec3 camLocal;
        Vec3 toCam;
        Vec3 toCamN;
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)vc, (String)"vc");
        Intrinsics.checkNotNullParameter((Object)camPosWorld, (String)"camPosWorld");
        Intrinsics.checkNotNullParameter((Object)blockOriginWorld, (String)"blockOriginWorld");
        Intrinsics.checkNotNullParameter((Object)startLocal, (String)"startLocal");
        Intrinsics.checkNotNullParameter((Object)endLocal, (String)"endLocal");
        Vec3 dir = endLocal.m_82546_(startLocal);
        double len = dir.m_82553_();
        if (len < 1.0E-4) {
            return;
        }
        Vec3 fwd = dir.m_82541_();
        Vec3 right = fwd.m_82537_(toCamN = (toCam = (camLocal = camPosWorld.m_82546_(blockOriginWorld)).m_82546_(startLocal)).m_82556_() > 1.0E-8 ? toCam.m_82541_() : new Vec3(0.0, 0.0, 1.0));
        if (right.m_82556_() < 1.0E-8) {
            right = fwd.m_82537_(new Vec3(0.0, 1.0, 0.0));
        }
        if (right.m_82556_() < 1.0E-8) {
            right = fwd.m_82537_(new Vec3(1.0, 0.0, 0.0));
        }
        right = right.m_82541_();
        float a0 = (float)(argb >>> 24 & 0xFF) / 255.0f;
        float r0 = (float)(argb >>> 16 & 0xFF) / 255.0f;
        float g0 = (float)(argb >>> 8 & 0xFF) / 255.0f;
        float b0 = (float)(argb & 0xFF) / 255.0f;
        Matrix4f pose = poseStack.m_85850_().m_252922_();
        float tiles = RangesKt.coerceAtLeast((float)((float)len / tileWorldUnits), (float)0.001f);
        float scroll = timeSeconds * scrollSpeed;
        for (int i = 0; i < segments; ++i) {
            float t0 = (float)i / (float)segments;
            float t1 = (float)(i + 1) / (float)segments;
            Vec3 p0 = startLocal.m_82549_(fwd.m_82490_(len * (double)t0));
            Vec3 p1 = startLocal.m_82549_(fwd.m_82490_(len * (double)t1));
            float fade0 = 1.0f - t0;
            float fade1 = 1.0f - t1;
            float half0 = BeamRenderer.renderBeamRibbon$widthAtSeg(rampSteps, width, minWidthFrac, i) * 0.5f;
            float half1 = BeamRenderer.renderBeamRibbon$widthAtSeg(rampSteps, width, minWidthFrac, i + 1) * 0.5f;
            Vec3 o0 = right.m_82490_((double)half0);
            Vec3 o1 = right.m_82490_((double)half1);
            float v0 = this.frac(t0 * tiles + scroll);
            float v1 = this.frac(t1 * tiles + scroll);
            Vec3 vec3 = p0.m_82546_(o0);
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"subtract(...)");
            BeamRenderer.renderBeamRibbon$emit(vc, pose, r0, g0, b0, a0, vec3, 0.0f, v0, fade0);
            Vec3 vec32 = p0.m_82549_(o0);
            Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"add(...)");
            BeamRenderer.renderBeamRibbon$emit(vc, pose, r0, g0, b0, a0, vec32, 1.0f, v0, fade0);
            Vec3 vec33 = p1.m_82549_(o1);
            Intrinsics.checkNotNullExpressionValue((Object)vec33, (String)"add(...)");
            BeamRenderer.renderBeamRibbon$emit(vc, pose, r0, g0, b0, a0, vec33, 1.0f, v1, fade1);
            Vec3 vec34 = p1.m_82546_(o1);
            Intrinsics.checkNotNullExpressionValue((Object)vec34, (String)"subtract(...)");
            BeamRenderer.renderBeamRibbon$emit(vc, pose, r0, g0, b0, a0, vec34, 0.0f, v1, fade1);
        }
    }

    public static /* synthetic */ void renderBeamRibbon$default(BeamRenderer beamRenderer, PoseStack poseStack, VertexConsumer vertexConsumer, Vec3 vec3, Vec3 vec32, Vec3 vec33, Vec3 vec34, float f, int n, int n2, int n3, float f2, float f3, float f4, float f5, int n4, Object object) {
        if ((n4 & 0x200) != 0) {
            n3 = 0;
        }
        if ((n4 & 0x400) != 0) {
            f2 = 0.2f;
        }
        if ((n4 & 0x800) != 0) {
            f3 = 0.5f;
        }
        if ((n4 & 0x1000) != 0) {
            f4 = 1.5f;
        }
        if ((n4 & 0x2000) != 0) {
            f5 = 0.0f;
        }
        beamRenderer.renderBeamRibbon(poseStack, vertexConsumer, vec3, vec32, vec33, vec34, f, n, n2, n3, f2, f3, f4, f5);
    }

    public final void renderBeamTube(@NotNull PoseStack poseStack, @NotNull VertexConsumer vc, @NotNull Vec3 camPosWorld, @NotNull Vec3 blockOriginWorld, @NotNull Vec3 startLocal, @NotNull Vec3 endLocal, float width, int argb, int segments, int rampSteps, float minWidthFrac, int ribbons, float tileWorldUnits, float scrollSpeed, float timeSeconds, float uScale, long seed) {
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)vc, (String)"vc");
        Intrinsics.checkNotNullParameter((Object)camPosWorld, (String)"camPosWorld");
        Intrinsics.checkNotNullParameter((Object)blockOriginWorld, (String)"blockOriginWorld");
        Intrinsics.checkNotNullParameter((Object)startLocal, (String)"startLocal");
        Intrinsics.checkNotNullParameter((Object)endLocal, (String)"endLocal");
        Vec3 dir = endLocal.m_82546_(startLocal);
        double len = dir.m_82553_();
        if (len < 1.0E-4) {
            return;
        }
        Vec3 fwd = dir.m_82541_();
        Vec3 ref = Math.abs(fwd.f_82480_) < 0.99 ? new Vec3(0.0, 1.0, 0.0) : new Vec3(1.0, 0.0, 0.0);
        Vec3 u = fwd.m_82537_(ref).m_82541_();
        Vec3 v = fwd.m_82537_(u).m_82541_();
        for (int k = 0; k < ribbons; ++k) {
            double ang = (double)k / (double)ribbons * (Math.PI * 2);
            Vec3 right = u.m_82490_(Math.cos(ang)).m_82549_(v.m_82490_(Math.sin(ang))).m_82541_();
            Intrinsics.checkNotNull((Object)right);
            this.renderBeamRibbonWithRight(poseStack, vc, startLocal, endLocal, right, width, argb, segments, rampSteps, minWidthFrac, tileWorldUnits, scrollSpeed, timeSeconds, uScale, seed);
        }
    }

    public static /* synthetic */ void renderBeamTube$default(BeamRenderer beamRenderer, PoseStack poseStack, VertexConsumer vertexConsumer, Vec3 vec3, Vec3 vec32, Vec3 vec33, Vec3 vec34, float f, int n, int n2, int n3, float f2, int n4, float f3, float f4, float f5, float f6, long l, int n5, Object object) {
        if ((n5 & 0x200) != 0) {
            n3 = 0;
        }
        if ((n5 & 0x400) != 0) {
            f2 = 0.2f;
        }
        if ((n5 & 0x800) != 0) {
            n4 = 4;
        }
        if ((n5 & 0x1000) != 0) {
            f3 = 0.5f;
        }
        if ((n5 & 0x2000) != 0) {
            f4 = 2.0f;
        }
        if ((n5 & 0x4000) != 0) {
            f5 = 0.0f;
        }
        if ((n5 & 0x8000) != 0) {
            f6 = 1.0f;
        }
        if ((n5 & 0x10000) != 0) {
            l = 0L;
        }
        beamRenderer.renderBeamTube(poseStack, vertexConsumer, vec3, vec32, vec33, vec34, f, n, n2, n3, f2, n4, f3, f4, f5, f6, l);
    }

    public final void renderBeamRibbonWithRight(@NotNull PoseStack poseStack, @NotNull VertexConsumer vc, @NotNull Vec3 startLocal, @NotNull Vec3 endLocal, @NotNull Vec3 rightUnit, float width, int argb, int segments, int rampSteps, float minWidthFrac, float tileWorldUnits, float scrollSpeed, float timeSeconds, float uScale, long seed) {
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)vc, (String)"vc");
        Intrinsics.checkNotNullParameter((Object)startLocal, (String)"startLocal");
        Intrinsics.checkNotNullParameter((Object)endLocal, (String)"endLocal");
        Intrinsics.checkNotNullParameter((Object)rightUnit, (String)"rightUnit");
        Vec3 dir = endLocal.m_82546_(startLocal);
        double len = dir.m_82553_();
        if (len < 1.0E-4) {
            return;
        }
        Vec3 fwd = dir.m_82541_();
        Vec3 right = rightUnit;
        if (right.m_82556_() < 1.0E-8) {
            return;
        }
        if (Math.abs(right.m_82541_().m_82526_(fwd)) > 0.98) {
            Vec3 u;
            Intrinsics.checkNotNull((Object)fwd);
            right = u = (Vec3)this.safePerpBasis(fwd).component1();
        }
        right = right.m_82541_();
        float a0 = (float)(argb >>> 24 & 0xFF) / 255.0f;
        float r0 = (float)(argb >>> 16 & 0xFF) / 255.0f;
        float g0 = (float)(argb >>> 8 & 0xFF) / 255.0f;
        float b0 = (float)(argb & 0xFF) / 255.0f;
        Matrix4f pose = poseStack.m_85850_().m_252922_();
        float tiles = RangesKt.coerceAtLeast((float)((float)len / tileWorldUnits), (float)0.001f);
        float scroll = timeSeconds * scrollSpeed;
        for (int i = 0; i < segments; ++i) {
            float t0 = (float)i / (float)segments;
            float t1 = (float)(i + 1) / (float)segments;
            Vec3 p0 = startLocal.m_82549_(fwd.m_82490_(len * (double)t0));
            Vec3 p1 = startLocal.m_82549_(fwd.m_82490_(len * (double)t1));
            float fade0 = 1.0f;
            float fade1 = 1.0f;
            float base0 = BeamRenderer.renderBeamRibbonWithRight$widthAtSeg$0(rampSteps, width, minWidthFrac, i);
            float base1 = BeamRenderer.renderBeamRibbonWithRight$widthAtSeg$0(rampSteps, width, minWidthFrac, i + 1);
            float warbleFade0 = this.smoothstep01((t0 - 0.05f) / 0.12f);
            float warbleFade1 = this.smoothstep01((t1 - 0.05f) / 0.12f);
            float w0 = base0 * (1.0f + (this.warbleMulSinWithJolt(t0, timeSeconds, seed) - 1.0f) * warbleFade0);
            float w1 = base1 * (1.0f + (this.warbleMulSinWithJolt(t1, timeSeconds, seed) - 1.0f) * warbleFade1);
            float half0 = w0 * 0.5f;
            float half1 = w1 * 0.5f;
            Vec3 o0 = right.m_82490_((double)half0);
            Vec3 o1 = right.m_82490_((double)half1);
            float v0 = this.frac(t0 * tiles + scroll);
            float v1 = this.frac(t1 * tiles + scroll);
            float u0 = 0.0f;
            float u1 = uScale;
            Vec3 vec3 = p0.m_82546_(o0);
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"subtract(...)");
            BeamRenderer.renderBeamRibbonWithRight$emit$1(vc, pose, r0, g0, b0, a0, vec3, u0, v0, fade0);
            Vec3 vec32 = p0.m_82549_(o0);
            Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"add(...)");
            BeamRenderer.renderBeamRibbonWithRight$emit$1(vc, pose, r0, g0, b0, a0, vec32, u1, v0, fade0);
            Vec3 vec33 = p1.m_82549_(o1);
            Intrinsics.checkNotNullExpressionValue((Object)vec33, (String)"add(...)");
            BeamRenderer.renderBeamRibbonWithRight$emit$1(vc, pose, r0, g0, b0, a0, vec33, u1, v1, fade1);
            Vec3 vec34 = p1.m_82546_(o1);
            Intrinsics.checkNotNullExpressionValue((Object)vec34, (String)"subtract(...)");
            BeamRenderer.renderBeamRibbonWithRight$emit$1(vc, pose, r0, g0, b0, a0, vec34, u0, v1, fade1);
        }
    }

    public static /* synthetic */ void renderBeamRibbonWithRight$default(BeamRenderer beamRenderer, PoseStack poseStack, VertexConsumer vertexConsumer, Vec3 vec3, Vec3 vec32, Vec3 vec33, float f, int n, int n2, int n3, float f2, float f3, float f4, float f5, float f6, long l, int n4, Object object) {
        if ((n4 & 0x100) != 0) {
            n3 = 0;
        }
        if ((n4 & 0x200) != 0) {
            f2 = 0.2f;
        }
        if ((n4 & 0x400) != 0) {
            f3 = 0.5f;
        }
        if ((n4 & 0x800) != 0) {
            f4 = 2.0f;
        }
        if ((n4 & 0x1000) != 0) {
            f5 = 0.0f;
        }
        if ((n4 & 0x2000) != 0) {
            f6 = 1.0f;
        }
        if ((n4 & 0x4000) != 0) {
            l = 0L;
        }
        beamRenderer.renderBeamRibbonWithRight(poseStack, vertexConsumer, vec3, vec32, vec33, f, n, n2, n3, f2, f3, f4, f5, f6, l);
    }

    public final void renderImpactBurst(@NotNull PoseStack poseStack, @NotNull VertexConsumer vc, @NotNull Vec3 camPosWorld, @NotNull Vec3 blockOriginWorld, @NotNull Vec3 hitPosLocal, @NotNull Vec3 normalWorld, long seed, float time, int rays, float burstLen, float width, int argb) {
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)vc, (String)"vc");
        Intrinsics.checkNotNullParameter((Object)camPosWorld, (String)"camPosWorld");
        Intrinsics.checkNotNullParameter((Object)blockOriginWorld, (String)"blockOriginWorld");
        Intrinsics.checkNotNullParameter((Object)hitPosLocal, (String)"hitPosLocal");
        Intrinsics.checkNotNullParameter((Object)normalWorld, (String)"normalWorld");
        Vec3 n = normalWorld.m_82541_();
        for (int i = 0; i < rays; ++i) {
            double z = RenderUtil.INSTANCE.rand01(i) * 2.0 - 1.0;
            double ang = RenderUtil.INSTANCE.rand01((long)i + 77L) * Math.PI * 2.0;
            double rr = Math.sqrt(1.0 - z * z);
            Vec3 d = new Vec3(rr * Math.cos(ang), z, rr * Math.sin(ang));
            if (d.m_82526_(n) < 0.0) {
                d = d.m_82490_(-1.0);
            }
            double len = (double)(burstLen * (0.35f + (float)RenderUtil.INSTANCE.rand01((long)i + 999L) * 0.65f)) * ((double)1.0f + (double)0.5f * Math.sin((double)(time + (float)RenderUtil.INSTANCE.rand01((long)i + 555L)) * Math.PI));
            Vec3 endLocal = hitPosLocal.m_82549_(d.m_82541_().m_82490_(len));
            Intrinsics.checkNotNull((Object)endLocal);
            BeamRenderer.renderBeamRibbon$default(this, poseStack, vc, camPosWorld, blockOriginWorld, hitPosLocal, endLocal, width, argb, 1, 0, 0.0f, 0.0f, 0.0f, 0.0f, 15360, null);
        }
    }

    public static /* synthetic */ void renderImpactBurst$default(BeamRenderer beamRenderer, PoseStack poseStack, VertexConsumer vertexConsumer, Vec3 vec3, Vec3 vec32, Vec3 vec33, Vec3 vec34, long l, float f, int n, float f2, float f3, int n2, int n3, Object object) {
        if ((n3 & 0x100) != 0) {
            n = 12;
        }
        if ((n3 & 0x200) != 0) {
            f2 = 0.8f;
        }
        if ((n3 & 0x400) != 0) {
            f3 = 0.06f;
        }
        beamRenderer.renderImpactBurst(poseStack, vertexConsumer, vec3, vec32, vec33, vec34, l, f, n, f2, f3, n2);
    }

    private static final float renderBeamRibbon$widthAtSeg(int $rampSteps, float $width, float $minWidthFrac, int segIndex) {
        if ($rampSteps <= 0) {
            return $width;
        }
        float t = RangesKt.coerceIn((float)((float)segIndex / (float)$rampSteps), (float)0.0f, (float)1.0f);
        float s = t * t * (3.0f - 2.0f * t);
        return $width * ($minWidthFrac + (1.0f - $minWidthFrac) * s);
    }

    private static final void renderBeamRibbon$emit(VertexConsumer $vc, Matrix4f pose, float r0, float g0, float b0, float a0, Vec3 pos, float u, float v, float alphaMul) {
        $vc.m_252986_(pose, (float)pos.f_82479_, (float)pos.f_82480_, (float)pos.f_82481_).m_85950_(r0, g0, b0, a0 * alphaMul).m_7421_(u, v).m_85969_(0xF000F0).m_5752_();
    }

    private static final float renderBeamRibbonWithRight$widthAtSeg$0(int $rampSteps, float $width, float $minWidthFrac, int segIndex) {
        if ($rampSteps <= 0) {
            return $width;
        }
        float t = RangesKt.coerceIn((float)((float)segIndex / (float)$rampSteps), (float)0.0f, (float)1.0f);
        float s = t * t * (3.0f - 2.0f * t);
        return $width * ($minWidthFrac + (1.0f - $minWidthFrac) * s);
    }

    private static final void renderBeamRibbonWithRight$emit$1(VertexConsumer $vc, Matrix4f pose, float r0, float g0, float b0, float a0, Vec3 pos, float u, float v, float alphaMul) {
        $vc.m_252986_(pose, (float)pos.f_82479_, (float)pos.f_82480_, (float)pos.f_82481_).m_85950_(r0, g0, b0, a0 * alphaMul).m_7421_(u, v).m_85969_(0xF000F0).m_5752_();
    }
}

