/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.util.arc;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.valkyrienskies.clockwork.ClockworkRenderTypes;
import org.valkyrienskies.clockwork.util.arc.LightningBolt;
import org.valkyrienskies.clockwork.util.arc.LightningManager;
import org.valkyrienskies.clockwork.util.render.RenderUtil;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u001a\u0010\u0019J\u001d\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJM\u0010\u0016\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0016\u0010\u0017J\r\u0010\u0018\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001b"}, d2={"Lorg/valkyrienskies/clockwork/util/arc/LightningRenderer;", "", "Lcom/mojang/blaze3d/vertex/PoseStack;", "ms", "", "partialTick", "", "onRenderLevelStage", "(Lcom/mojang/blaze3d/vertex/PoseStack;F)V", "", "now", "Lorg/valkyrienskies/clockwork/util/arc/LightningBolt;", "inst", "Lcom/mojang/blaze3d/vertex/VertexConsumer;", "vc", "Lorg/joml/Matrix4f;", "pose", "Lnet/minecraft/world/phys/Vec3;", "camPos", "", "argb", "argb2", "renderPolylineRibbon", "(JFLorg/valkyrienskies/clockwork/util/arc/LightningBolt;Lcom/mojang/blaze3d/vertex/VertexConsumer;Lorg/joml/Matrix4f;Lnet/minecraft/world/phys/Vec3;II)V", "spawnTestBolt", "()V", "<init>", "clockwork"})
public final class LightningRenderer {
    @NotNull
    public static final LightningRenderer INSTANCE = new LightningRenderer();

    private LightningRenderer() {
    }

    public final void onRenderLevelStage(@NotNull PoseStack ms, float partialTick) {
        Intrinsics.checkNotNullParameter((Object)ms, (String)"ms");
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel clientLevel = mc.f_91073_;
        if (clientLevel == null) {
            return;
        }
        ClientLevel level = clientLevel;
        long now = level.m_46467_();
        List<LightningBolt> bolts = LightningManager.INSTANCE.instances(now);
        if (bolts.isEmpty()) {
            return;
        }
        Vec3 camPos = mc.f_91063_.m_109153_().m_90583_();
        Matrix4f pose = ms.m_85850_().m_252922_();
        MultiBufferSource.BufferSource bufferSource = mc.m_91269_().m_110104_();
        Intrinsics.checkNotNullExpressionValue((Object)bufferSource, (String)"bufferSource(...)");
        MultiBufferSource.BufferSource buffers = bufferSource;
        RenderType rt = ClockworkRenderTypes.Companion.getWANDER_LIGHTNING();
        VertexConsumer vc = buffers.m_6299_(rt);
        for (LightningBolt inst : bolts) {
            Intrinsics.checkNotNull((Object)vc);
            Intrinsics.checkNotNull((Object)pose);
            Intrinsics.checkNotNull((Object)camPos);
            this.renderPolylineRibbon(now, partialTick, inst, vc, pose, camPos, 16240623, 12820707);
        }
        buffers.m_109912_(rt);
    }

    public final void renderPolylineRibbon(long now, float partialTick, @NotNull LightningBolt inst, @NotNull VertexConsumer vc, @NotNull Matrix4f pose, @NotNull Vec3 camPos, int argb, int argb2) {
        Intrinsics.checkNotNullParameter((Object)inst, (String)"inst");
        Intrinsics.checkNotNullParameter((Object)vc, (String)"vc");
        Intrinsics.checkNotNullParameter((Object)pose, (String)"pose");
        Intrinsics.checkNotNullParameter((Object)camPos, (String)"camPos");
        float age = (float)(now - inst.getBirthGameTime()) + partialTick;
        float fade = RangesKt.coerceIn((float)(1.0f - age / (float)inst.getLifeTicks()), (float)0.0f, (float)1.0f);
        float red = (float)(argb >>> 16 & 0xFF) / 255.0f;
        float green = (float)(argb >>> 8 & 0xFF) / 255.0f;
        float blue = (float)(argb & 0xFF) / 255.0f;
        float red2 = (float)(argb2 >>> 16 & 0xFF) / 255.0f;
        float green2 = (float)(argb2 >>> 8 & 0xFF) / 255.0f;
        float blue2 = (float)(argb2 & 0xFF) / 255.0f;
        List<List<Vec3>> lines = RenderUtil.INSTANCE.generatePolylinesFollow(inst, now, partialTick);
        for (List<Vec3> poly : lines) {
            int n = poly.size();
            int n2 = n - 1;
            for (int i = 0; i < n2; ++i) {
                float t = (float)i / (float)(n - 1);
                float taper = RangesKt.coerceIn((float)(1.0f - t), (float)0.0f, (float)1.0f);
                Vec3 a = poly.get(i).m_82546_(camPos);
                Vec3 b = poly.get(i + 1).m_82546_(camPos);
                Intrinsics.checkNotNull((Object)a);
                Intrinsics.checkNotNull((Object)b);
                RenderUtil.INSTANCE.addRibbonSegment(vc, pose, a, b, inst.getThickness() * (0.35f + 0.65f * taper), red, green, blue, 0.65f * fade);
                RenderUtil.INSTANCE.addRibbonSegment(vc, pose, a, b, inst.getThickness() * 1.6f * (0.35f + 0.65f * taper), red2, green2, blue2, 0.18f * fade);
            }
        }
    }

    public final void spawnTestBolt() {
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel clientLevel = mc.f_91073_;
        if (clientLevel == null) {
            return;
        }
        ClientLevel level = clientLevel;
        Camera cam = mc.f_91063_.m_109153_();
        Vec3 start = cam.m_90583_().m_82549_(new Vec3(cam.m_253058_().mul(2.0f, new Vector3f())));
        Vec3 end = start.m_82549_(new Vec3(cam.m_253058_().mul(16.0f))).m_82520_(0.0, -2.0, 0.0);
        LightningManager.INSTANCE.spawn((Function0<? extends Vec3>)((Function0)() -> LightningRenderer.spawnTestBolt$lambda$0(start)), (Function0<? extends Vec3>)((Function0)() -> LightningRenderer.spawnTestBolt$lambda$1(end)), System.nanoTime(), 60);
    }

    private static final Vec3 spawnTestBolt$lambda$0(Vec3 $start) {
        Intrinsics.checkNotNull((Object)$start);
        return $start;
    }

    private static final Vec3 spawnTestBolt$lambda$1(Vec3 $end) {
        Intrinsics.checkNotNull((Object)$end);
        return $end;
    }
}

