/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.valkyrienskies.kelvin.api.GasType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0019\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001HB\t\b\u0002\u00a2\u0006\u0004\bF\u0010GJ\u0019\u0010\u0006\u001a\u00020\u00052\n\u0010\u0004\u001a\u00060\u0002j\u0002`\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J!\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\n\u0010\n\u001a\u00060\u0002j\u0002`\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ!\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\n\u0010\n\u001a\u00060\u0002j\u0002`\u0003\u00a2\u0006\u0004\b\r\u0010\fJ!\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\n\u0010\n\u001a\u00060\u0002j\u0002`\u0003\u00a2\u0006\u0004\b\u000e\u0010\fJ-\u0010\u0014\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0014\u0010\u0015J-\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0017\u0010\u0015J-\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\b\u00a2\u0006\u0004\b\u0017\u0010\u0019J1\u0010\u001d\u001a\u00020\b2\"\u0010\u001c\u001a\u001e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\b0\u001aj\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\b`\u001b\u00a2\u0006\u0004\b\u001d\u0010\u001eJA\u0010 \u001a\u00020\b2\"\u0010\u001c\u001a\u001e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\b0\u001aj\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\b`\u001b2\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\b\u00a2\u0006\u0004\b \u0010!J9\u0010\"\u001a\u00020\b2\"\u0010\u001c\u001a\u001e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\b0\u001aj\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\b`\u001b2\u0006\u0010\u0016\u001a\u00020\b\u00a2\u0006\u0004\b\"\u0010#JY\u0010-\u001a\u00020\b2\u0006\u0010$\u001a\u00020\b2\u0006\u0010%\u001a\u00020\b2\u0006\u0010&\u001a\u00020\b2\u0006\u0010'\u001a\u00020\b2\u0006\u0010(\u001a\u00020\b2\u0006\u0010)\u001a\u00020\b2\u0006\u0010*\u001a\u00020\b2\b\b\u0002\u0010+\u001a\u00020\b2\b\b\u0002\u0010,\u001a\u00020\b\u00a2\u0006\u0004\b-\u0010.J1\u0010/\u001a\u00020\b2\"\u0010\u001c\u001a\u001e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\b0\u001aj\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\b`\u001b\u00a2\u0006\u0004\b/\u0010\u001eJC\u00101\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b002\"\u0010\u001c\u001a\u001e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\b0\u001aj\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\b`\u001b\u00a2\u0006\u0004\b1\u00102RF\u00103\u001a&\u0012\b\u0012\u00060\u0002j\u0002`\u0003\u0012\u0004\u0012\u00020\u00050\u001aj\u0012\u0012\b\u0012\u00060\u0002j\u0002`\u0003\u0012\u0004\u0012\u00020\u0005`\u001b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b3\u00104\u001a\u0004\b5\u00106\"\u0004\b7\u00108R\u0014\u00109\u001a\u00020\b8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b9\u0010:R\u0014\u0010;\u001a\u00020\b8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b;\u0010:R\u0017\u0010<\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b<\u0010=\u001a\u0004\b>\u0010?R\u0014\u0010@\u001a\u00020\b8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b@\u0010:R\u0014\u0010A\u001a\u00020\b8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\bA\u0010:R\u0014\u0010B\u001a\u00020\b8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\bB\u0010:R\u0014\u0010C\u001a\u00020\b8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\bC\u0010:R\u0014\u0010D\u001a\u00020\b8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\bD\u0010:R\u0014\u0010E\u001a\u00020\b8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\bE\u0010:\u00a8\u0006I"}, d2={"Lorg/valkyrienskies/clockwork/util/AerodynamicUtils;", "", "", "Lorg/valkyrienskies/core/api/world/properties/DimensionId;", "id", "Lorg/valkyrienskies/clockwork/util/AerodynamicUtils$Parameters;", "getAtmosphereForDimension", "(Ljava/lang/String;)Lorg/valkyrienskies/clockwork/util/AerodynamicUtils$Parameters;", "", "y", "dimension", "getAirDensityForY", "(DLjava/lang/String;)D", "getAirPressureForY", "getAirTemperatureForY", "volume", "mass", "temperature", "Lorg/valkyrienskies/kelvin/api/GasType;", "gasType", "getDensityFromTemperature", "(DDDLorg/valkyrienskies/kelvin/api/GasType;)D", "temp", "calcPressure", "standardDensity", "(DDDD)D", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "gasMasses", "densityAverage", "(Ljava/util/HashMap;)D", "pressure", "densityFromPressureAverage", "(Ljava/util/HashMap;DD)D", "dynamicViscosityAverage", "(Ljava/util/HashMap;D)D", "pressureOne", "pressureTwo", "radius", "length", "densityA", "densityB", "viscosity", "pumpPressure", "previousFlowRate", "calculateFlow", "(DDDDDDDDD)D", "specificHeatAverage", "Lkotlin/Triple;", "extraHeatInfoAverage", "(Ljava/util/HashMap;)Lkotlin/Triple;", "dimensionMap", "Ljava/util/HashMap;", "getDimensionMap", "()Ljava/util/HashMap;", "setDimensionMap", "(Ljava/util/HashMap;)V", "DEFAULT_MAX", "D", "DEFAULT_SEA_LEVEL", "defaultParameters", "Lorg/valkyrienskies/clockwork/util/AerodynamicUtils$Parameters;", "getDefaultParameters", "()Lorg/valkyrienskies/clockwork/util/AerodynamicUtils$Parameters;", "DRAG_COEFFICIENT", "GRAVITATIONAL_ACCELERATION", "UNIVERSAL_GAS_CONSTANT", "AIR_MOLAR_MASS", "DUCT_RADIUS", "DUCT_AREA", "<init>", "()V", "Parameters", "clockwork"})
@SourceDebugExtension(value={"SMAP\nAerodynamicUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AerodynamicUtils.kt\norg/valkyrienskies/clockwork/util/AerodynamicUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,577:1\n1863#2,2:578\n1863#2,2:580\n1863#2,2:582\n1863#2,2:584\n1863#2,2:586\n*S KotlinDebug\n*F\n+ 1 AerodynamicUtils.kt\norg/valkyrienskies/clockwork/util/AerodynamicUtils\n*L\n374#1:578,2\n409#1:580,2\n441#1:582,2\n513#1:584,2\n544#1:586,2\n*E\n"})
public final class AerodynamicUtils {
    @NotNull
    public static final AerodynamicUtils INSTANCE = new AerodynamicUtils();
    @NotNull
    private static HashMap<String, Parameters> dimensionMap = new HashMap();
    public static final double DEFAULT_MAX = 562.0;
    public static final double DEFAULT_SEA_LEVEL = 62.0;
    @NotNull
    private static final Parameters defaultParameters = new Parameters(562.0, 62.0, 0, 4, null);
    public static final double DRAG_COEFFICIENT = 2.18;
    public static final double GRAVITATIONAL_ACCELERATION = 9.80665;
    public static final double UNIVERSAL_GAS_CONSTANT = 8.314;
    public static final double AIR_MOLAR_MASS = 0.0289644;
    public static final double DUCT_RADIUS = 0.1875;
    public static final double DUCT_AREA = 0.11045;

    private AerodynamicUtils() {
    }

    @NotNull
    public final HashMap<String, Parameters> getDimensionMap() {
        return dimensionMap;
    }

    public final void setDimensionMap(@NotNull HashMap<String, Parameters> hashMap) {
        Intrinsics.checkNotNullParameter(hashMap, (String)"<set-?>");
        dimensionMap = hashMap;
    }

    @NotNull
    public final Parameters getDefaultParameters() {
        return defaultParameters;
    }

    @NotNull
    public final Parameters getAtmosphereForDimension(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Parameters parameters = dimensionMap.get(id);
        if (parameters == null) {
            parameters = defaultParameters;
        }
        return parameters;
    }

    public final double getAirDensityForY(double y, @NotNull String dimension) {
        Intrinsics.checkNotNullParameter((Object)dimension, (String)"dimension");
        Parameters parameters = this.getAtmosphereForDimension(dimension);
        double maxHeight = parameters.component1();
        double seaLevel = parameters.component2();
        if (maxHeight <= 0.0) {
            return 0.0;
        }
        double worldScale = 71000.0 / (maxHeight - seaLevel);
        double realAltitude = (y - seaLevel) * worldScale >= 0.0 ? (y - seaLevel) * worldScale : 0.0;
        int layer = realAltitude < 11000.0 ? 0 : (realAltitude < 20000.0 ? 1 : (realAltitude < 32000.0 ? 2 : (realAltitude < 47000.0 ? 3 : (realAltitude < 51000.0 ? 4 : (realAltitude < 71000.0 ? 5 : 6)))));
        double hb = switch (layer) {
            case 0 -> 0.0;
            case 1 -> 11000.0;
            case 2 -> 20000.0;
            case 3 -> 32000.0;
            case 4 -> 47000.0;
            case 5 -> 51000.0;
            case 6 -> 71000.0;
            default -> 0.0;
        };
        double pb = switch (layer) {
            case 0 -> 1.225;
            case 1 -> 0.36391;
            case 2 -> 0.08803;
            case 3 -> 0.01322;
            case 4 -> 0.00143;
            case 5 -> 8.6E-4;
            case 6 -> 6.4E-5;
            default -> 0.0;
        };
        double Tb = switch (layer) {
            case 0 -> 288.15;
            case 1 -> 216.65;
            case 2 -> 216.65;
            case 3 -> 228.65;
            case 4 -> 270.65;
            case 5 -> 270.65;
            case 6 -> 214.65;
            default -> 0.0;
        };
        double g0 = 9.80665;
        double R = 8.314;
        double M = 0.0289644;
        double L = switch (layer) {
            case 0 -> 0.0065;
            case 1 -> 0.0;
            case 2 -> -0.001;
            case 3 -> -0.0028;
            case 4 -> 0.0;
            case 5 -> 0.0028;
            case 6 -> 0.002;
            default -> 0.0;
        };
        return !(L == 0.0) ? pb * Math.pow((Tb - (realAltitude - hb) * L) / Tb, g0 * M / (R * L) - 1.0) : pb * Math.exp(-g0 * M * (realAltitude - hb) / (R * Tb));
    }

    public final double getAirPressureForY(double y, @NotNull String dimension) {
        Intrinsics.checkNotNullParameter((Object)dimension, (String)"dimension");
        Parameters parameters = this.getAtmosphereForDimension(dimension);
        double maxHeight = parameters.component1();
        double seaLevel = parameters.component2();
        if (maxHeight <= 0.0) {
            return 0.0;
        }
        double worldScale = 71000.0 / (maxHeight - seaLevel);
        double realAltitude = (y - seaLevel) * worldScale >= 0.0 ? (y - seaLevel) * worldScale : 0.0;
        int layer = realAltitude < 11000.0 ? 0 : (realAltitude < 20000.0 ? 1 : (realAltitude < 32000.0 ? 2 : (realAltitude < 47000.0 ? 3 : (realAltitude < 51000.0 ? 4 : (realAltitude < 71000.0 ? 5 : 6)))));
        double hb = switch (layer) {
            case 0 -> 0.0;
            case 1 -> 11000.0;
            case 2 -> 20000.0;
            case 3 -> 32000.0;
            case 4 -> 47000.0;
            case 5 -> 51000.0;
            case 6 -> 71000.0;
            default -> 0.0;
        };
        double pb = switch (layer) {
            case 0 -> 101325.0;
            case 1 -> 22632.1;
            case 2 -> 5474.89;
            case 3 -> 868.02;
            case 4 -> 110.91;
            case 5 -> 66.94;
            case 6 -> 3.96;
            default -> 0.0;
        };
        double Tb = switch (layer) {
            case 0 -> 288.15;
            case 1 -> 216.65;
            case 2 -> 216.65;
            case 3 -> 228.65;
            case 4 -> 270.65;
            case 5 -> 270.65;
            case 6 -> 214.65;
            default -> 0.0;
        };
        double g0 = 9.80665;
        double R = 8.314;
        double M = 0.0289644;
        double L = switch (layer) {
            case 0 -> 0.0065;
            case 1 -> 0.0;
            case 2 -> -0.001;
            case 3 -> -0.0028;
            case 4 -> 0.0;
            case 5 -> 0.0028;
            case 6 -> 0.002;
            default -> 0.0;
        };
        return !(L == 0.0) ? pb * Math.pow(1.0 - L / Tb * (realAltitude - hb), g0 * M / (R * L)) : pb * Math.exp(-g0 * M * (realAltitude - hb) / (R * Tb));
    }

    public final double getAirTemperatureForY(double y, @NotNull String dimension) {
        Intrinsics.checkNotNullParameter((Object)dimension, (String)"dimension");
        Parameters parameters = this.getAtmosphereForDimension(dimension);
        double maxHeight = parameters.component1();
        double seaLevel = parameters.component2();
        if (maxHeight <= 0.0) {
            return 0.0;
        }
        double worldScale = 71000.0 / (maxHeight - seaLevel);
        double realAltitude = (y - seaLevel) * worldScale >= 0.0 ? (y - seaLevel) * worldScale : 0.0;
        int layer = realAltitude < 11000.0 ? 0 : (realAltitude < 20000.0 ? 1 : (realAltitude < 32000.0 ? 2 : (realAltitude < 47000.0 ? 3 : (realAltitude < 51000.0 ? 4 : (realAltitude < 71000.0 ? 5 : 6)))));
        double hb = switch (layer) {
            case 0 -> 0.0;
            case 1 -> 11000.0;
            case 2 -> 20000.0;
            case 3 -> 32000.0;
            case 4 -> 47000.0;
            case 5 -> 51000.0;
            case 6 -> 71000.0;
            default -> 0.0;
        };
        double Tb = switch (layer) {
            case 0 -> 288.15;
            case 1 -> 216.65;
            case 2 -> 216.65;
            case 3 -> 228.65;
            case 4 -> 270.65;
            case 5 -> 270.65;
            case 6 -> 214.65;
            default -> 0.0;
        };
        double L = switch (layer) {
            case 0 -> 0.0065;
            case 1 -> 0.0;
            case 2 -> -0.001;
            case 3 -> -0.0028;
            case 4 -> 0.0;
            case 5 -> 0.0028;
            case 6 -> 0.002;
            default -> 0.0;
        };
        return !(L == 0.0) ? Tb - (realAltitude - hb) * L : Tb;
    }

    public final double getDensityFromTemperature(double volume, double mass, double temperature, @NotNull GasType gasType) {
        Intrinsics.checkNotNullParameter((Object)gasType, (String)"gasType");
        if (volume == 0.0) {
            return 0.0;
        }
        double density = mass / volume;
        if (!(temperature == 0.0)) {
            double molarMass = gasType.getDensity() * 22.4;
            double pressure = this.calcPressure(mass, volume, temperature, gasType);
            density = molarMass * pressure / (8.314 * temperature);
        }
        return density;
    }

    public final double calcPressure(double mass, double volume, double temp, @NotNull GasType gasType) {
        Intrinsics.checkNotNullParameter((Object)gasType, (String)"gasType");
        if (volume == 0.0) {
            return 0.0;
        }
        double adjustedTemp = Math.max(temp, 0.001);
        double pressure = 0.0;
        double molarMass = gasType.getDensity() * 22.4;
        double moles = mass / molarMass;
        pressure = moles * 8.314 * adjustedTemp / volume;
        return pressure;
    }

    public final double calcPressure(double mass, double volume, double temp, double standardDensity) {
        if (volume == 0.0 || mass == 0.0) {
            return 0.0;
        }
        double adjustedTemp = Math.max(temp, 1.0E-4);
        double pressure = 0.0;
        double density = mass / volume;
        double molarMass = standardDensity * 22.4;
        double specificGasConstant = 8.314 / molarMass * 1000.0;
        double moles = mass / molarMass;
        pressure = density * specificGasConstant * adjustedTemp;
        return pressure;
    }

    public final double densityAverage(@NotNull HashMap<GasType, Double> gasMasses) {
        Intrinsics.checkNotNullParameter(gasMasses, (String)"gasMasses");
        Collection<Double> collection = gasMasses.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        double totalMass = CollectionsKt.sumOfDouble((Iterable)collection);
        if (totalMass == 0.0) {
            return 0.0;
        }
        HashMap massPerGas = new HashMap();
        HashMap gasWeight = new HashMap();
        Set<GasType> set = gasMasses.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        Iterator<Object> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv = iterator.next();
            GasType it = (GasType)element$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Double)gasMasses.get(it), (double)0.0)) continue;
            Map map = massPerGas;
            Double d = gasMasses.get(it);
            Intrinsics.checkNotNull((Object)d);
            map.put(it, d);
        }
        for (Object e : massPerGas.keySet()) {
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            GasType gas = (GasType)e;
            Map map = gasWeight;
            Object v = massPerGas.get(gas);
            Intrinsics.checkNotNull(v);
            map.put(gas, ((Number)v).doubleValue() / totalMass);
        }
        double density = 0.0;
        for (Object object : gasWeight.keySet()) {
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"next(...)");
            GasType gas = (GasType)object;
            Object v = gasWeight.get(gas);
            Intrinsics.checkNotNull(v);
            density += ((Number)v).doubleValue() * gas.getDensity();
        }
        return density;
    }

    public final double densityFromPressureAverage(@NotNull HashMap<GasType, Double> gasMasses, double temp, double pressure) {
        Intrinsics.checkNotNullParameter(gasMasses, (String)"gasMasses");
        Collection<Double> collection = gasMasses.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        double totalMass = CollectionsKt.sumOfDouble((Iterable)collection);
        if (totalMass == 0.0) {
            return 0.0;
        }
        HashMap massPerGas = new HashMap();
        HashMap gasWeight = new HashMap();
        Set<GasType> set = gasMasses.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        Iterator<Object> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv = iterator.next();
            GasType it = (GasType)element$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Double)gasMasses.get(it), (double)0.0)) continue;
            Map map = massPerGas;
            Double d = gasMasses.get(it);
            Intrinsics.checkNotNull((Object)d);
            map.put(it, d);
        }
        for (Object e : massPerGas.keySet()) {
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            GasType gas = (GasType)e;
            Map map = gasWeight;
            Object v = massPerGas.get(gas);
            Intrinsics.checkNotNull(v);
            map.put(gas, ((Number)v).doubleValue() / totalMass);
        }
        double density = 0.0;
        for (Object object : gasWeight.keySet()) {
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"next(...)");
            GasType gas = (GasType)object;
            double molarMass = gas.getDensity() * 22.4;
            double specificGasConstant = 8.314 / molarMass;
            Object v = gasWeight.get(gas);
            Intrinsics.checkNotNull(v);
            density += ((Number)v).doubleValue() * (pressure / (specificGasConstant * temp));
        }
        return density;
    }

    public final double dynamicViscosityAverage(@NotNull HashMap<GasType, Double> gasMasses, double temp) {
        Intrinsics.checkNotNullParameter(gasMasses, (String)"gasMasses");
        Collection<Double> collection = gasMasses.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        double totalMass = CollectionsKt.sumOfDouble((Iterable)collection);
        if (totalMass == 0.0) {
            return 0.0;
        }
        HashMap massPerGas = new HashMap();
        HashMap gasWeight = new HashMap();
        Set<GasType> set = gasMasses.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        Iterator<Object> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv = iterator.next();
            GasType it = (GasType)element$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Double)gasMasses.get(it), (double)0.0)) continue;
            Map map = massPerGas;
            Double d = gasMasses.get(it);
            Intrinsics.checkNotNull((Object)d);
            map.put(it, d);
        }
        for (Object e : massPerGas.keySet()) {
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            GasType gas = (GasType)e;
            Map map = gasWeight;
            Object v = massPerGas.get(gas);
            Intrinsics.checkNotNull(v);
            map.put(gas, ((Number)v).doubleValue() / totalMass);
        }
        double viscosity = 0.0;
        for (Object object : gasWeight.keySet()) {
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"next(...)");
            GasType gas = (GasType)object;
            Object v = gasWeight.get(gas);
            Intrinsics.checkNotNull(v);
            viscosity += ((Number)v).doubleValue() * (gas.getViscosity() * (temp / 273.15) * ((273.15 + gas.getSutherlandConstant()) / (temp + gas.getSutherlandConstant())));
        }
        return viscosity;
    }

    public final double calculateFlow(double pressureOne, double pressureTwo, double radius, double length, double densityA, double densityB, double viscosity, double pumpPressure, double previousFlowRate) {
        double flowRate = 0.0;
        if (densityA <= 0.0 && densityB <= 0.0) {
            return flowRate;
        }
        double density = pressureOne > pressureTwo ? densityA : densityB;
        double pipeRoughness = 1.2E-4;
        double pipeDiameter = radius * 2.0;
        double pressureDrop = pressureOne - pressureTwo + pumpPressure;
        if (pressureOne <= 1.0E-4 && Math.abs(pumpPressure) > 0.0) {
            pressureDrop = Math.min(pressureDrop, 0.0);
        }
        if (pressureTwo <= 1.0E-4 && pumpPressure < 0.0) {
            pressureDrop = Math.max(pressureDrop, 0.0);
        }
        double finalPressureDrop = pressureDrop;
        double Re = Math.max(density * previousFlowRate * pipeDiameter / viscosity, 1.0E-4);
        double f = Re < 2000.0 ? 64.0 / Re : (Re > 4000.0 ? 0.25 / Math.pow(Math.log10(pipeRoughness / pipeDiameter / 3.7 + 5.74 / Math.pow(Re, 0.9)), 2.0) : Mth.m_14085_((double)(64.0 / Re), (double)(0.25 / Math.pow(Math.log10(pipeRoughness / pipeDiameter / 3.7 + 5.74 / Math.pow(Re, 0.9)), 2.0)), (double)((Re - 2000.0) / 2000.0)));
        double flowSpeed = 2.0 * Math.abs(finalPressureDrop) / (f * (length / pipeDiameter) * density);
        double sqrtFlowSpeed = Math.signum(finalPressureDrop) * Math.sqrt(flowSpeed);
        double volumetricFlowRate = sqrtFlowSpeed * (Math.pow(Math.PI * radius, 2.0) / 4.0);
        flowRate = volumetricFlowRate * density;
        return flowRate;
    }

    public static /* synthetic */ double calculateFlow$default(AerodynamicUtils aerodynamicUtils, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, int n, Object object) {
        if ((n & 0x80) != 0) {
            d8 = 0.0;
        }
        if ((n & 0x100) != 0) {
            d9 = 0.0;
        }
        return aerodynamicUtils.calculateFlow(d, d2, d3, d4, d5, d6, d7, d8, d9);
    }

    public final double specificHeatAverage(@NotNull HashMap<GasType, Double> gasMasses) {
        Intrinsics.checkNotNullParameter(gasMasses, (String)"gasMasses");
        Collection<Double> collection = gasMasses.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        double totalMass = CollectionsKt.sumOfDouble((Iterable)collection);
        if (totalMass == 0.0) {
            return 0.0;
        }
        HashMap massPerGas = new HashMap();
        HashMap gasWeight = new HashMap();
        Set<GasType> set = gasMasses.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        Iterator<Object> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv = iterator.next();
            GasType it = (GasType)element$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Double)gasMasses.get(it), (double)0.0)) continue;
            Map map = massPerGas;
            Double d = gasMasses.get(it);
            Intrinsics.checkNotNull((Object)d);
            map.put(it, d);
        }
        for (Object e : massPerGas.keySet()) {
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            GasType gas = (GasType)e;
            Map map = gasWeight;
            Object v = massPerGas.get(gas);
            Intrinsics.checkNotNull(v);
            map.put(gas, ((Number)v).doubleValue() / totalMass);
        }
        double specificHeat = 0.0;
        for (Object object : gasWeight.keySet()) {
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"next(...)");
            GasType gas = (GasType)object;
            Object v = gasWeight.get(gas);
            Intrinsics.checkNotNull(v);
            specificHeat += ((Number)v).doubleValue() * gas.getSpecificHeatCapacity();
        }
        return specificHeat;
    }

    @NotNull
    public final Triple<Double, Double, Double> extraHeatInfoAverage(@NotNull HashMap<GasType, Double> gasMasses) {
        Intrinsics.checkNotNullParameter(gasMasses, (String)"gasMasses");
        Collection<Double> collection = gasMasses.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        double totalMass = CollectionsKt.sumOfDouble((Iterable)collection);
        if (totalMass == 0.0) {
            return new Triple((Object)0.0, (Object)0.0, (Object)0.0);
        }
        HashMap massPerGas = new HashMap();
        HashMap gasWeight = new HashMap();
        Set<GasType> set = gasMasses.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv = iterator.next();
            GasType it = (GasType)element$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Double)gasMasses.get(it), (double)0.0)) continue;
            Map map = massPerGas;
            Double d = gasMasses.get(it);
            Intrinsics.checkNotNull((Object)d);
            map.put(it, d);
        }
        for (Object e : massPerGas.keySet()) {
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            GasType gas = (GasType)e;
            Map map = gasWeight;
            Object v = massPerGas.get(gas);
            Intrinsics.checkNotNull(v);
            map.put(gas, ((Number)v).doubleValue() / totalMass);
        }
        double specificGasConstant = 0.0;
        double sutherlandConstant = 0.0;
        double adiabaticIndex = 0.0;
        for (Object k : gasWeight.keySet()) {
            Intrinsics.checkNotNullExpressionValue(k, (String)"next(...)");
            GasType gas = (GasType)k;
            Object v = gasWeight.get(gas);
            Intrinsics.checkNotNull(v);
            specificGasConstant += ((Number)v).doubleValue() * (8.314 / (gas.getDensity() * 22.4));
            Object v2 = gasWeight.get(gas);
            Intrinsics.checkNotNull(v2);
            sutherlandConstant += ((Number)v2).doubleValue() * gas.getSutherlandConstant();
            Object v3 = gasWeight.get(gas);
            Intrinsics.checkNotNull(v3);
            adiabaticIndex += ((Number)v3).doubleValue() * gas.getAdiabaticIndex();
        }
        return new Triple((Object)specificGasConstant, (Object)sutherlandConstant, (Object)adiabaticIndex);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\n\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\t\u001a\u00020\u0002\u0012\u0006\u0010\n\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0010\u0010\u0003\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ.\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\t\u001a\u00020\u00022\b\b\u0002\u0010\n\u001a\u00020\u00022\b\b\u0002\u0010\u000b\u001a\u00020\u0006H\u00c6\u0001\u00a2\u0006\u0004\b\f\u0010\rJ\u001a\u0010\u0010\u001a\u00020\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\u0006H\u00d6\u0001\u00a2\u0006\u0004\b\u0012\u0010\bJ\u0010\u0010\u0014\u001a\u00020\u0013H\u00d6\u0001\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u0017\u0010\t\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\u0016\u001a\u0004\b\u0017\u0010\u0004R\u0017\u0010\n\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\n\u0010\u0016\u001a\u0004\b\u0018\u0010\u0004R\u0017\u0010\u000b\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010\u0019\u001a\u0004\b\u001a\u0010\b\u00a8\u0006\u001d"}, d2={"Lorg/valkyrienskies/clockwork/util/AerodynamicUtils$Parameters;", "", "", "component1", "()D", "component2", "", "component3", "()I", "maxY", "seaLevel", "priority", "copy", "(DDI)Lorg/valkyrienskies/clockwork/util/AerodynamicUtils$Parameters;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "", "toString", "()Ljava/lang/String;", "D", "getMaxY", "getSeaLevel", "I", "getPriority", "<init>", "(DDI)V", "clockwork"})
    public static final class Parameters {
        private final double maxY;
        private final double seaLevel;
        private final int priority;

        public Parameters(double maxY, double seaLevel, int priority) {
            this.maxY = maxY;
            this.seaLevel = seaLevel;
            this.priority = priority;
        }

        public /* synthetic */ Parameters(double d, double d2, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 4) != 0) {
                n = -1;
            }
            this(d, d2, n);
        }

        public final double getMaxY() {
            return this.maxY;
        }

        public final double getSeaLevel() {
            return this.seaLevel;
        }

        public final int getPriority() {
            return this.priority;
        }

        public final double component1() {
            return this.maxY;
        }

        public final double component2() {
            return this.seaLevel;
        }

        public final int component3() {
            return this.priority;
        }

        @NotNull
        public final Parameters copy(double maxY, double seaLevel, int priority) {
            return new Parameters(maxY, seaLevel, priority);
        }

        public static /* synthetic */ Parameters copy$default(Parameters parameters, double d, double d2, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                d = parameters.maxY;
            }
            if ((n2 & 2) != 0) {
                d2 = parameters.seaLevel;
            }
            if ((n2 & 4) != 0) {
                n = parameters.priority;
            }
            return parameters.copy(d, d2, n);
        }

        @NotNull
        public String toString() {
            return "Parameters(maxY=" + this.maxY + ", seaLevel=" + this.seaLevel + ", priority=" + this.priority + ")";
        }

        public int hashCode() {
            int result = Double.hashCode(this.maxY);
            result = result * 31 + Double.hashCode(this.seaLevel);
            result = result * 31 + Integer.hashCode(this.priority);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Parameters)) {
                return false;
            }
            Parameters parameters = (Parameters)other;
            if (Double.compare(this.maxY, parameters.maxY) != 0) {
                return false;
            }
            if (Double.compare(this.seaLevel, parameters.seaLevel) != 0) {
                return false;
            }
            return this.priority == parameters.priority;
        }
    }
}

