/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.platform.forge;

import com.google.gson.JsonElement;
import com.simibubi.create.content.processing.basin.BasinBlockEntity;
import com.simibubi.create.content.processing.basin.BasinRecipe;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.recipe.DummyCraftingContainer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import net.createmod.catnip.data.Iterate;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.valkyrienskies.clockwork.ClockworkMod;
import org.valkyrienskies.clockwork.content.logistics.gas.crafter.GasCrafterBlockEntity;
import org.valkyrienskies.clockwork.content.logistics.gas.crafter.GasCraftingRecipe;
import org.valkyrienskies.kelvin.api.DuctNetwork;
import org.valkyrienskies.kelvin.api.GasType;
import org.valkyrienskies.kelvin.api.recipe.GasBaseRecipe;
import org.valkyrienskies.kelvin.api.recipe.GasReactionRequirement;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ+\u0010\b\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\b\u0010\t\u00a8\u0006\f"}, d2={"Lorg/valkyrienskies/clockwork/platform/forge/GasCrafterMethodsImpl;", "", "Lorg/valkyrienskies/clockwork/content/logistics/gas/crafter/GasCrafterBlockEntity;", "be", "Lnet/minecraft/world/item/crafting/Recipe;", "recipe", "", "test", "apply", "(Lorg/valkyrienskies/clockwork/content/logistics/gas/crafter/GasCrafterBlockEntity;Lnet/minecraft/world/item/crafting/Recipe;Z)Z", "<init>", "()V", "clockwork"})
@SourceDebugExtension(value={"SMAP\nGasCrafterMethodsImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GasCrafterMethodsImpl.kt\norg/valkyrienskies/clockwork/platform/forge/GasCrafterMethodsImpl\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,159:1\n216#2,2:160\n*S KotlinDebug\n*F\n+ 1 GasCrafterMethodsImpl.kt\norg/valkyrienskies/clockwork/platform/forge/GasCrafterMethodsImpl\n*L\n110#1:160,2\n*E\n"})
public final class GasCrafterMethodsImpl {
    @NotNull
    public static final GasCrafterMethodsImpl INSTANCE = new GasCrafterMethodsImpl();

    private GasCrafterMethodsImpl() {
    }

    @JvmStatic
    public static final boolean apply(@NotNull GasCrafterBlockEntity be, @NotNull Recipe<?> recipe, boolean test) {
        Object object;
        Object gasIngredients;
        BlazeBurnerBlock.HeatLevel heat;
        Intrinsics.checkNotNullParameter((Object)be, (String)"be");
        Intrinsics.checkNotNullParameter(recipe, (String)"recipe");
        boolean isGasCrafterRecipe = recipe instanceof GasCraftingRecipe;
        BasinBlockEntity basin = (BasinBlockEntity)OptionalsKt.getOrNull(be.getBasin());
        BasinBlockEntity basinBlockEntity = basin;
        IItemHandler availableItems = basinBlockEntity != null && (basinBlockEntity = basinBlockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER)) != null ? (IItemHandler)basinBlockEntity.orElse(null) : null;
        BasinBlockEntity basinBlockEntity2 = basin;
        IFluidHandler availableFluids = basinBlockEntity2 != null && (basinBlockEntity2 = basinBlockEntity2.getCapability(ForgeCapabilities.FLUID_HANDLER)) != null ? (IFluidHandler)basinBlockEntity2.orElse(null) : null;
        BasinBlockEntity basinBlockEntity3 = basin;
        if (basinBlockEntity3 != null) {
            BlazeBurnerBlock.HeatLevel heatLevel = BasinBlockEntity.getHeatLevelOf((BlockState)basinBlockEntity3.m_58900_());
            v4 = heatLevel;
            Intrinsics.checkNotNullExpressionValue((Object)heatLevel, (String)"getHeatLevelOf(...)");
        } else {
            v4 = heat = BlazeBurnerBlock.HeatLevel.NONE;
        }
        if (isGasCrafterRecipe && !((GasCraftingRecipe)recipe).getRequiredHeat().testBlazeBurner(heat)) {
            return false;
        }
        List recipeOutputItems = new ArrayList();
        List recipeOutputFluids = new ArrayList();
        List ingredients = new LinkedList((Collection)recipe.m_7527_());
        List fluidIngredients = isGasCrafterRecipe ? (List)((GasCraftingRecipe)recipe).getFluidIngredients() : (List)new ArrayList();
        GasCraftingRecipe gasCraftingRecipe = recipe instanceof GasCraftingRecipe ? (GasCraftingRecipe)recipe : null;
        Object baseGasRecipe = gasCraftingRecipe != null ? gasCraftingRecipe.getGasRecipe() : null;
        Object object2 = baseGasRecipe;
        if (object2 == null || (object2 = object2.getGasses()) == null || (object2 = MapsKt.toList((Map)((Map)object2))) == null) {
            object2 = gasIngredients = CollectionsKt.emptyList();
        }
        if ((object = baseGasRecipe) == null || (object = object.getResult()) == null || (object = MapsKt.toList((Map)((Map)object))) == null) {
            object = CollectionsKt.emptyList();
        }
        GasBaseRecipe gasResults = object;
        for (boolean simulate : Iterate.trueAndFalse) {
            int n;
            if (!simulate && test) {
                return true;
            }
            IFluidHandler iFluidHandler = availableFluids;
            int[] extractedFluidsFromTank = new int[iFluidHandler != null ? iFluidHandler.getTanks() : 0];
            IItemHandler iItemHandler = availableItems;
            int[] extractedItemsFromSlot = new int[iItemHandler != null ? iItemHandler.getSlots() : 0];
            boolean itemsAffected = false;
            if (availableItems != null) {
                block1: for (Ingredient ingredient : ingredients) {
                    int n2 = availableItems.getSlots();
                    for (int slot = 0; slot < n2; ++slot) {
                        ItemStack extracted;
                        if (simulate && availableItems.getStackInSlot(slot).m_41613_() <= extractedItemsFromSlot[slot]) continue;
                        Intrinsics.checkNotNullExpressionValue((Object)availableItems.extractItem(slot, 1, true), (String)"extractItem(...)");
                        if (!ingredient.test(extracted)) continue;
                        if (!simulate) {
                            availableItems.extractItem(slot, 1, false);
                        }
                        n = slot;
                        int n3 = extractedItemsFromSlot[n];
                        extractedItemsFromSlot[n] = n3 + 1;
                        itemsAffected = true;
                        continue block1;
                    }
                    return false;
                }
            }
            boolean fluidsAffected = false;
            if (availableFluids != null) {
                Ingredient ingredient;
                ingredient = fluidIngredients.iterator();
                block3: while (ingredient.hasNext()) {
                    FluidIngredient fluidIngredient = (FluidIngredient)ingredient.next();
                    int amountRequired = fluidIngredient.getRequiredAmount();
                    n = availableFluids.getTanks();
                    for (int tank = 0; tank < n; ++tank) {
                        FluidStack fluidStack;
                        Intrinsics.checkNotNullExpressionValue((Object)availableFluids.getFluidInTank(tank), (String)"getFluidInTank(...)");
                        if (simulate && fluidStack.getAmount() <= extractedFluidsFromTank[tank] || !fluidIngredient.test(fluidStack)) continue;
                        int drainedAmount = Math.min(amountRequired, fluidStack.getAmount());
                        if (!simulate) {
                            fluidStack.shrink(drainedAmount);
                            fluidsAffected = true;
                        }
                        if ((amountRequired -= drainedAmount) != 0) continue;
                        int n4 = tank;
                        extractedFluidsFromTank[n4] = extractedFluidsFromTank[n4] + drainedAmount;
                        continue block3;
                    }
                    return false;
                }
            }
            HashMap currentMasses = ClockworkMod.getKelvin().getGasMassAt(be.getDuctNodePosition());
            Iterator fluidIngredient = gasIngredients.iterator();
            while (fluidIngredient.hasNext()) {
                double mass;
                Pair amountRequired = (Pair)fluidIngredient.next();
                GasType gasType = (GasType)amountRequired.component1();
                double mass2 = mass = ((Number)amountRequired.component2()).doubleValue();
                Double d = (Double)currentMasses.get(gasType);
                double d2 = d != null ? d : 0.0;
                if (!(d2 < mass2)) continue;
                return false;
            }
            Object object3 = baseGasRecipe;
            if (object3 != null && (object3 = object3.getRequirements()) != null) {
                Map $this$forEach$iv = (Map)object3;
                boolean $i$f$forEach = false;
                Iterator mass = $this$forEach$iv.entrySet().iterator();
                while (mass.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry mass2 = element$iv = mass.next();
                    boolean bl = false;
                    GasReactionRequirement requirement = (GasReactionRequirement)mass2.getKey();
                    JsonElement element = (JsonElement)mass2.getValue();
                    Level level = be.m_58904_();
                    Intrinsics.checkNotNull((Object)level);
                    if (requirement.apply_requirement(level, be.getDuctNodePosition(), (DuctNetwork)ClockworkMod.getKelvin(), element)) continue;
                    return false;
                }
            }
            if (fluidsAffected) {
                BasinBlockEntity basinBlockEntity4 = basin;
                Intrinsics.checkNotNull((Object)basinBlockEntity4);
                ((SmartFluidTankBehaviour)basinBlockEntity4.getBehaviour(SmartFluidTankBehaviour.INPUT)).forEach(GasCrafterMethodsImpl::apply$lambda$1);
                ((SmartFluidTankBehaviour)basin.getBehaviour(SmartFluidTankBehaviour.OUTPUT)).forEach(GasCrafterMethodsImpl::apply$lambda$2);
            }
            if (simulate && itemsAffected) {
                CraftingContainer remainderContainer = (CraftingContainer)new DummyCraftingContainer(availableItems, extractedItemsFromSlot);
                if (recipe instanceof BasinRecipe) {
                    List list = ((BasinRecipe)recipe).rollResults();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"rollResults(...)");
                    recipeOutputItems.addAll(list);
                    Iterator iterator = ((BasinRecipe)recipe).getFluidResults().iterator();
                    Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
                    Iterator iterator2 = iterator;
                    while (iterator2.hasNext()) {
                        FluidStack fluidStack = (FluidStack)iterator2.next();
                        if (fluidStack.isEmpty()) continue;
                        recipeOutputFluids.add(fluidStack);
                    }
                    Iterator iterator3 = ((BasinRecipe)recipe).m_7457_((Container)remainderContainer).iterator();
                    Intrinsics.checkNotNullExpressionValue((Object)iterator3, (String)"iterator(...)");
                    iterator2 = iterator3;
                    while (iterator2.hasNext()) {
                        ItemStack stack = (ItemStack)iterator2.next();
                        if (stack.m_41619_()) continue;
                        recipeOutputItems.add(stack);
                    }
                } else {
                    BasinBlockEntity basinBlockEntity5 = basin;
                    Intrinsics.checkNotNull((Object)basinBlockEntity5);
                    Level level = basinBlockEntity5.m_58904_();
                    Intrinsics.checkNotNull((Object)level);
                    recipeOutputItems.add(recipe.m_8043_(level.m_9598_()));
                    if (recipe instanceof CraftingRecipe) {
                        Iterator iterator;
                        Intrinsics.checkNotNullExpressionValue((Object)((CraftingRecipe)recipe).m_7457_((Container)remainderContainer).iterator(), (String)"iterator(...)");
                        while (iterator.hasNext()) {
                            ItemStack stack = (ItemStack)iterator.next();
                            if (stack.m_41619_()) continue;
                            recipeOutputItems.add(stack);
                        }
                    }
                }
            }
            if (basin != null && !basin.acceptOutputs(recipeOutputItems, recipeOutputFluids, simulate)) {
                return false;
            }
            if (simulate) continue;
            Iterator iterator = gasResults.iterator();
            while (iterator.hasNext()) {
                double mass;
                Pair pair = (Pair)iterator.next();
                GasType gasType = (GasType)pair.component1();
                double mass3 = mass = ((Number)pair.component2()).doubleValue();
                ClockworkMod.getKelvin().modGasMass(be.getDuctNodePosition(), gasType, mass3);
            }
        }
        return true;
    }

    private static final void apply$lambda$1(SmartFluidTankBehaviour.TankSegment obj) {
        SmartFluidTankBehaviour.TankSegment tankSegment = obj;
        Intrinsics.checkNotNull((Object)tankSegment);
        tankSegment.onFluidStackChanged();
    }

    private static final void apply$lambda$2(SmartFluidTankBehaviour.TankSegment obj) {
        SmartFluidTankBehaviour.TankSegment tankSegment = obj;
        Intrinsics.checkNotNull((Object)tankSegment);
        tankSegment.onFluidStackChanged();
    }
}

