/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.integration.cc;

import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IPeripheral;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.createmod.catnip.animation.LerpedFloat;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.valkyrienskies.clockwork.ClockworkBlocks;
import org.valkyrienskies.clockwork.ClockworkMod;
import org.valkyrienskies.clockwork.content.logistics.gas.pockets.nozzle.GasNozzleBlockEntity;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u001d\u001a\u00020\u001c\u00a2\u0006\u0004\b\u001f\u0010 J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0007H\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000b\u001a\u00020\nH\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\r\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u000f\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u000f\u0010\u000eJ\u000f\u0010\u0010\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u0010\u0010\u000eJ\u000f\u0010\u0011\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u0011\u0010\u000eJ\u000f\u0010\u0012\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u0012\u0010\u000eJ\u000f\u0010\u0014\u001a\u00020\u0013H\u0007\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001a\u0010\u0017\u001a\u00020\u00072\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u0096\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u000f\u0010\u001a\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001d\u001a\u00020\u001c8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001e\u00a8\u0006!"}, d2={"Lorg/valkyrienskies/clockwork/integration/cc/GasNozzlePeripheral;", "Ldan200/computercraft/api/peripheral/IPeripheral;", "", "value", "", "setPointer", "(D)V", "", "hasBalloon", "()Z", "", "getPointer", "()F", "getPointerSpeed", "()D", "getPocketTemperature", "getTargetTemperature", "getDuctTemperature", "getBalloonVolume", "", "getLeaks", "()I", "p0", "equals", "(Ldan200/computercraft/api/peripheral/IPeripheral;)Z", "", "getType", "()Ljava/lang/String;", "Lorg/valkyrienskies/clockwork/content/logistics/gas/pockets/nozzle/GasNozzleBlockEntity;", "be", "Lorg/valkyrienskies/clockwork/content/logistics/gas/pockets/nozzle/GasNozzleBlockEntity;", "<init>", "(Lorg/valkyrienskies/clockwork/content/logistics/gas/pockets/nozzle/GasNozzleBlockEntity;)V", "clockwork"})
public final class GasNozzlePeripheral
implements IPeripheral {
    @NotNull
    private final GasNozzleBlockEntity be;

    public GasNozzlePeripheral(@NotNull GasNozzleBlockEntity be) {
        Intrinsics.checkNotNullParameter((Object)be, (String)"be");
        this.be = be;
    }

    @LuaFunction
    public final void setPointer(double value) {
        this.be.getPointer().chase(RangesKt.coerceIn((double)value, (double)0.0, (double)1.0), 0.3, LerpedFloat.Chaser.LINEAR);
        this.be.sendData();
    }

    @LuaFunction
    public final boolean hasBalloon() {
        return this.be.getHasPocket();
    }

    @LuaFunction
    public final float getPointer() {
        return this.be.getPointer().getValue();
    }

    @LuaFunction
    public final double getPointerSpeed() {
        return this.be.getPointerSpeed();
    }

    @LuaFunction
    public final double getPocketTemperature() {
        return this.be.getHasPocket() ? this.be.getPocketTemperature() : 0.0;
    }

    @LuaFunction
    public final double getTargetTemperature() {
        return ClockworkMod.getKelvin().getTemperatureAt(this.be.getDuctNodePosition()) * (double)this.be.getPointer().getValue();
    }

    @LuaFunction
    public final double getDuctTemperature() {
        return ClockworkMod.getKelvin().getTemperatureAt(this.be.getDuctNodePosition());
    }

    @LuaFunction
    public final double getBalloonVolume() {
        return this.be.getBalloonVolume();
    }

    @LuaFunction
    public final int getLeaks() {
        return this.be.getHasPocket() ? (int)this.be.getCurrentIdealOutput() : 0;
    }

    public boolean equals(@Nullable IPeripheral p0) {
        Level level = this.be.m_58904_();
        return level != null && (level = level.m_8055_(this.be.m_58899_())) != null ? level.m_60713_((Block)ClockworkBlocks.GAS_NOZZLE.get()) : false;
    }

    @NotNull
    public String getType() {
        return "cw_gas_nozzle";
    }
}

