/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.integration.cc;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.GenericPeripheral;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.PeripheralType;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.valkyrienskies.clockwork.ClockworkMod;
import org.valkyrienskies.kelvin.api.DuctNodePos;
import org.valkyrienskies.kelvin.api.GasType;
import org.valkyrienskies.kelvin.impl.DuctNetworkServer;
import org.valkyrienskies.kelvin.impl.registry.GasTypeRegistry;
import org.valkyrienskies.kelvin.util.INodeBlockEntity;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b5\u00106J\u000f\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000f\u0010\u0006\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007J+\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ#\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u000f0\u000b2\u0006\u0010\t\u001a\u00020\bH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\bH\u0007\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\bH\u0007\u00a2\u0006\u0004\b\u0014\u0010\u0013J\u0017\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\bH\u0007\u00a2\u0006\u0004\b\u0015\u0010\u0013J=\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u00022\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001aH\u0007\u00a2\u0006\u0004\b\u001d\u0010\u001eJ=\u0010!\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u00022\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001aH\u0007\u00a2\u0006\u0004\b!\u0010\u001eJ5\u0010\"\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00022\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001aH\u0007\u00a2\u0006\u0004\b\"\u0010#J5\u0010$\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u00022\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001aH\u0007\u00a2\u0006\u0004\b$\u0010#J\u001f\u0010'\u001a\u00020&2\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010%\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b'\u0010(J\u0017\u0010*\u001a\u00020)2\u0006\u0010\n\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b*\u0010+J5\u0010/\u001a\u00020\u001c2\u0006\u0010,\u001a\u00020&2\u0006\u0010-\u001a\u00020&2\u0006\u0010.\u001a\u00020)2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001aH\u0002\u00a2\u0006\u0004\b/\u00100J-\u00101\u001a\u00020\u001c2\u0006\u0010,\u001a\u00020&2\u0006\u0010-\u001a\u00020&2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001aH\u0002\u00a2\u0006\u0004\b1\u00102J\u001f\u00103\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\f0\u000b*\u00020)H\u0002\u00a2\u0006\u0004\b3\u00104\u00a8\u00067"}, d2={"Lorg/valkyrienskies/clockwork/integration/cc/GasHeatSource;", "Ldan200/computercraft/api/peripheral/GenericPeripheral;", "", "id", "()Ljava/lang/String;", "Ldan200/computercraft/api/peripheral/PeripheralType;", "getType", "()Ldan200/computercraft/api/peripheral/PeripheralType;", "Lorg/valkyrienskies/kelvin/util/INodeBlockEntity;", "heatable", "gasName", "", "", "getGasDetails", "(Lorg/valkyrienskies/kelvin/util/INodeBlockEntity;Ljava/lang/String;)Ljava/util/Map;", "", "getGasMass", "(Lorg/valkyrienskies/kelvin/util/INodeBlockEntity;)Ljava/util/Map;", "getHeatEnergy", "(Lorg/valkyrienskies/kelvin/util/INodeBlockEntity;)D", "getPressure", "getTemperature", "from", "Ldan200/computercraft/api/peripheral/IComputerAccess;", "computer", "toName", "Ljava/util/Optional;", "amount", "", "pushGas", "(Lorg/valkyrienskies/kelvin/util/INodeBlockEntity;Ldan200/computercraft/api/peripheral/IComputerAccess;Ljava/lang/String;Ljava/lang/String;Ljava/util/Optional;)V", "to", "fromName", "pullGas", "pushTemperature", "(Lorg/valkyrienskies/kelvin/util/INodeBlockEntity;Ldan200/computercraft/api/peripheral/IComputerAccess;Ljava/lang/String;Ljava/util/Optional;)V", "pullTemperature", "name", "Lorg/valkyrienskies/kelvin/api/DuctNodePos;", "getNodePosFromPeripheral", "(Ldan200/computercraft/api/peripheral/IComputerAccess;Ljava/lang/String;)Lorg/valkyrienskies/kelvin/api/DuctNodePos;", "Lorg/valkyrienskies/kelvin/api/GasType;", "getGasOrThrow", "(Ljava/lang/String;)Lorg/valkyrienskies/kelvin/api/GasType;", "origin", "end", "gas", "transferGas", "(Lorg/valkyrienskies/kelvin/api/DuctNodePos;Lorg/valkyrienskies/kelvin/api/DuctNodePos;Lorg/valkyrienskies/kelvin/api/GasType;Ljava/util/Optional;)V", "transferTemperature", "(Lorg/valkyrienskies/kelvin/api/DuctNodePos;Lorg/valkyrienskies/kelvin/api/DuctNodePos;Ljava/util/Optional;)V", "toLua", "(Lorg/valkyrienskies/kelvin/api/GasType;)Ljava/util/Map;", "<init>", "()V", "clockwork"})
@SourceDebugExtension(value={"SMAP\nGasHeatSource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GasHeatSource.kt\norg/valkyrienskies/clockwork/integration/cc/GasHeatSource\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,153:1\n477#2:154\n423#2:155\n1246#3,4:156\n*S KotlinDebug\n*F\n+ 1 GasHeatSource.kt\norg/valkyrienskies/clockwork/integration/cc/GasHeatSource\n*L\n33#1:154\n33#1:155\n33#1:156,4\n*E\n"})
public final class GasHeatSource
implements GenericPeripheral {
    @NotNull
    public static final GasHeatSource INSTANCE = new GasHeatSource();

    private GasHeatSource() {
    }

    @NotNull
    public String id() {
        return "vs_clockwork:kelvin";
    }

    @NotNull
    public PeripheralType getType() {
        String[] stringArray = new String[]{"kelvin"};
        PeripheralType peripheralType = PeripheralType.ofAdditional((String[])stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)peripheralType, (String)"ofAdditional(...)");
        return peripheralType;
    }

    @LuaFunction
    @JvmStatic
    @NotNull
    public static final Map<String, Object> getGasDetails(@NotNull INodeBlockEntity heatable, @NotNull String gasName) {
        Intrinsics.checkNotNullParameter((Object)heatable, (String)"heatable");
        Intrinsics.checkNotNullParameter((Object)gasName, (String)"gasName");
        return INSTANCE.toLua(INSTANCE.getGasOrThrow(gasName));
    }

    /*
     * WARNING - void declaration
     */
    @LuaFunction
    @JvmStatic
    @NotNull
    public static final Map<String, Double> getGasMass(@NotNull INodeBlockEntity heatable) {
        void $this$mapKeysTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)heatable, (String)"heatable");
        Map $this$mapKeys$iv = ClockworkMod.getKelvin().getGasMassAt(heatable.getDuctNodePosition());
        boolean $i$f$mapKeys = false;
        Map map = $this$mapKeys$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            GasType gas = (GasType)entry.getKey();
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            String string = gas.getName();
            Map map3 = map2;
            boolean bl2 = false;
            entry = it$iv$iv.getValue();
            map3.put(string, entry);
        }
        return destination$iv$iv;
    }

    @LuaFunction
    @JvmStatic
    public static final double getHeatEnergy(@NotNull INodeBlockEntity heatable) {
        Intrinsics.checkNotNullParameter((Object)heatable, (String)"heatable");
        return ClockworkMod.getKelvin().getHeatEnergy(heatable.getDuctNodePosition());
    }

    @LuaFunction
    @JvmStatic
    public static final double getPressure(@NotNull INodeBlockEntity heatable) {
        Intrinsics.checkNotNullParameter((Object)heatable, (String)"heatable");
        return ClockworkMod.getKelvin().getPressureAt(heatable.getDuctNodePosition());
    }

    @LuaFunction
    @JvmStatic
    public static final double getTemperature(@NotNull INodeBlockEntity heatable) {
        Intrinsics.checkNotNullParameter((Object)heatable, (String)"heatable");
        return ClockworkMod.getKelvin().getTemperatureAt(heatable.getDuctNodePosition());
    }

    @LuaFunction
    @JvmStatic
    public static final void pushGas(@NotNull INodeBlockEntity from, @NotNull IComputerAccess computer, @NotNull String toName, @NotNull String gasName, @NotNull Optional<Double> amount) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)computer, (String)"computer");
        Intrinsics.checkNotNullParameter((Object)toName, (String)"toName");
        Intrinsics.checkNotNullParameter((Object)gasName, (String)"gasName");
        Intrinsics.checkNotNullParameter(amount, (String)"amount");
        DuctNodePos origin = from.getDuctNodePosition();
        DuctNodePos end = INSTANCE.getNodePosFromPeripheral(computer, toName);
        GasType gas = INSTANCE.getGasOrThrow(gasName);
        INSTANCE.transferGas(origin, end, gas, amount);
    }

    @LuaFunction
    @JvmStatic
    public static final void pullGas(@NotNull INodeBlockEntity to, @NotNull IComputerAccess computer, @NotNull String fromName, @NotNull String gasName, @NotNull Optional<Double> amount) {
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Intrinsics.checkNotNullParameter((Object)computer, (String)"computer");
        Intrinsics.checkNotNullParameter((Object)fromName, (String)"fromName");
        Intrinsics.checkNotNullParameter((Object)gasName, (String)"gasName");
        Intrinsics.checkNotNullParameter(amount, (String)"amount");
        DuctNodePos end = to.getDuctNodePosition();
        DuctNodePos origin = INSTANCE.getNodePosFromPeripheral(computer, fromName);
        GasType gas = INSTANCE.getGasOrThrow(gasName);
        INSTANCE.transferGas(origin, end, gas, amount);
    }

    @LuaFunction
    @JvmStatic
    public static final void pushTemperature(@NotNull INodeBlockEntity from, @NotNull IComputerAccess computer, @NotNull String toName, @NotNull Optional<Double> amount) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)computer, (String)"computer");
        Intrinsics.checkNotNullParameter((Object)toName, (String)"toName");
        Intrinsics.checkNotNullParameter(amount, (String)"amount");
        DuctNodePos origin = from.getDuctNodePosition();
        DuctNodePos end = INSTANCE.getNodePosFromPeripheral(computer, toName);
        INSTANCE.transferTemperature(origin, end, amount);
    }

    @LuaFunction
    @JvmStatic
    public static final void pullTemperature(@NotNull INodeBlockEntity to, @NotNull IComputerAccess computer, @NotNull String fromName, @NotNull Optional<Double> amount) {
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Intrinsics.checkNotNullParameter((Object)computer, (String)"computer");
        Intrinsics.checkNotNullParameter((Object)fromName, (String)"fromName");
        Intrinsics.checkNotNullParameter(amount, (String)"amount");
        DuctNodePos end = to.getDuctNodePosition();
        DuctNodePos origin = INSTANCE.getNodePosFromPeripheral(computer, fromName);
        INSTANCE.transferTemperature(origin, end, amount);
    }

    private final DuctNodePos getNodePosFromPeripheral(IComputerAccess computer, String name) throws LuaException {
        IPeripheral iPeripheral = computer.getAvailablePeripheral(name);
        if (iPeripheral == null) {
            throw new LuaException("Target '" + name + "' does not exist!");
        }
        IPeripheral location = iPeripheral;
        Object object = location.getTarget();
        INodeBlockEntity iNodeBlockEntity = object instanceof INodeBlockEntity ? (INodeBlockEntity)object : null;
        if (iNodeBlockEntity == null) {
            throw new LuaException("Target '" + name + "' is not a valid Node!");
        }
        INodeBlockEntity other = iNodeBlockEntity;
        return other.getDuctNodePosition();
    }

    private final GasType getGasOrThrow(String gasName) throws LuaException {
        try {
            ResourceLocation resourceLocation = ResourceLocation.m_135820_((String)gasName);
            Intrinsics.checkNotNull((Object)resourceLocation);
            GasType gasType = GasTypeRegistry.INSTANCE.getGasType(resourceLocation);
            Intrinsics.checkNotNull((Object)gasType);
            return gasType;
        }
        catch (AssertionError e) {
            throw new LuaException("Gas `" + gasName + "` does not exist!");
        }
    }

    private final void transferGas(DuctNodePos origin, DuctNodePos end, GasType gas, Optional<Double> amount) throws LuaException {
        DuctNetworkServer kelvin = ClockworkMod.getKelvin();
        Double d = kelvin.getGasMassAt(origin).getOrDefault(gas, 0.0);
        Intrinsics.checkNotNullExpressionValue((Object)d, (String)"getOrDefault(...)");
        double currentAmount = ((Number)d).doubleValue();
        double actualAmount = ((Number)OptionalsKt.getOrDefault(amount, (Object)currentAmount)).doubleValue();
        double currentTemp = kelvin.getTemperatureAt(origin);
        if (actualAmount <= 0.0) {
            throw new LuaException("Cannot transfer zero or negative gas...");
        }
        if (currentAmount < actualAmount) {
            throw new LuaException("Exceeded Amount of `" + gas.getName() + "` in origin!");
        }
        kelvin.removeGas(origin, gas, actualAmount);
        kelvin.addGasAtTemperature(end, gas, actualAmount, currentTemp);
    }

    private final void transferTemperature(DuctNodePos origin, DuctNodePos end, Optional<Double> amount) throws LuaException {
        DuctNetworkServer kelvin = ClockworkMod.getKelvin();
        double currentAmount = kelvin.getTemperatureAt(origin);
        double actualAmount = ((Number)OptionalsKt.getOrDefault(amount, (Object)currentAmount)).doubleValue();
        if (actualAmount <= 1.0E-4) {
            throw new LuaException("Cannot transfer zero or negative temperature...");
        }
        if (currentAmount < actualAmount) {
            throw new LuaException("Exceeded Amount of temperature in origin!");
        }
        kelvin.modTemperature(origin, -actualAmount);
        kelvin.modTemperature(end, actualAmount);
    }

    private final Map<String, Object> toLua(GasType $this$toLua) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)$this$toLua.getName()), TuplesKt.to((Object)"density", (Object)$this$toLua.getDensity()), TuplesKt.to((Object)"viscosity", (Object)$this$toLua.getViscosity()), TuplesKt.to((Object)"specificHeatCapacity", (Object)$this$toLua.getSpecificHeatCapacity()), TuplesKt.to((Object)"thermalConductivity", (Object)$this$toLua.getThermalConductivity()), TuplesKt.to((Object)"sutherlandConstant", (Object)$this$toLua.getSutherlandConstant()), TuplesKt.to((Object)"adiabaticIndex", (Object)$this$toLua.getAdiabaticIndex())};
        return MapsKt.mapOf((Pair[])pairArray);
    }
}

