/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.physicalities.reactionwheel;

import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import net.createmod.catnip.animation.LerpedFloat;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.valkyrienskies.clockwork.content.forces.ReactionWheelController;
import org.valkyrienskies.clockwork.content.generic.IForceApplierBE;
import org.valkyrienskies.clockwork.content.physicalities.IClockworkWheelBE;
import org.valkyrienskies.clockwork.content.physicalities.reactionwheel.data.ReactionWheelCreateData;
import org.valkyrienskies.clockwork.content.physicalities.reactionwheel.data.ReactionWheelData;
import org.valkyrienskies.clockwork.content.physicalities.reactionwheel.data.ReactionWheelUpdateData;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u001a\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00022\u00020\u0007B#\u0012\n\u0010>\u001a\u0006\u0012\u0002\b\u00030=\u0012\u0006\u0010@\u001a\u00020?\u0012\u0006\u0010B\u001a\u00020A\u00a2\u0006\u0004\bC\u0010DJ\u000f\u0010\b\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\n\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001f\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0011H\u0014\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001f\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0011H\u0014\u00a2\u0006\u0004\b\u0016\u0010\u0015J\u000f\u0010\u0018\u001a\u00020\u0017H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u000f\u0010\u001a\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u000f\u0010\u001c\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001bJ\u000f\u0010\u001d\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001bR\"\u0010\u001f\u001a\u00020\u001e8\u0016@\u0016X\u0096\u000e\u00a2\u0006\u0012\n\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\"\u0010%\u001a\u00020\u00178\u0016@\u0016X\u0096\u000e\u00a2\u0006\u0012\n\u0004\b%\u0010&\u001a\u0004\b'\u0010\u0019\"\u0004\b(\u0010)R\"\u0010*\u001a\u00020\u00178\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b*\u0010&\u001a\u0004\b+\u0010\u0019\"\u0004\b,\u0010)R\"\u0010-\u001a\u00020\u00178\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b-\u0010&\u001a\u0004\b.\u0010\u0019\"\u0004\b/\u0010)R\"\u00100\u001a\u00020\u00118\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b0\u00101\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\"\u00107\u001a\u0002068\u0016@\u0016X\u0096\u000e\u00a2\u0006\u0012\n\u0004\b7\u00108\u001a\u0004\b9\u0010:\"\u0004\b;\u0010<\u00a8\u0006E"}, d2={"Lorg/valkyrienskies/clockwork/content/physicalities/reactionwheel/ReactionWheelBlockEntity;", "Lcom/simibubi/create/content/kinetics/base/KineticBlockEntity;", "Lorg/valkyrienskies/clockwork/content/generic/IForceApplierBE;", "Lorg/valkyrienskies/clockwork/content/physicalities/reactionwheel/data/ReactionWheelUpdateData;", "Lorg/valkyrienskies/clockwork/content/physicalities/reactionwheel/data/ReactionWheelData;", "Lorg/valkyrienskies/clockwork/content/physicalities/reactionwheel/data/ReactionWheelCreateData;", "Lorg/valkyrienskies/clockwork/content/forces/ReactionWheelController;", "Lorg/valkyrienskies/clockwork/content/physicalities/IClockworkWheelBE;", "newCreateData", "()Lorg/valkyrienskies/clockwork/content/physicalities/reactionwheel/data/ReactionWheelCreateData;", "newUpdateData", "()Lorg/valkyrienskies/clockwork/content/physicalities/reactionwheel/data/ReactionWheelUpdateData;", "Lnet/minecraft/world/phys/AABB;", "getRenderBoundingBox", "()Lnet/minecraft/world/phys/AABB;", "Lnet/minecraft/nbt/CompoundTag;", "compound", "", "clientPacket", "", "write", "(Lnet/minecraft/nbt/CompoundTag;Z)V", "read", "", "calculateTargetSpeed", "()D", "tick", "()V", "remove", "destroy", "Lnet/createmod/catnip/animation/LerpedFloat;", "visualSpeed", "Lnet/createmod/catnip/animation/LerpedFloat;", "getVisualSpeed", "()Lnet/createmod/catnip/animation/LerpedFloat;", "setVisualSpeed", "(Lnet/createmod/catnip/animation/LerpedFloat;)V", "angle", "D", "getAngle", "setAngle", "(D)V", "realSpeed", "getRealSpeed", "setRealSpeed", "targetSpeed", "getTargetSpeed", "setTargetSpeed", "reachedTarget", "Z", "getReachedTarget", "()Z", "setReachedTarget", "(Z)V", "", "physID", "I", "getPhysID", "()I", "setPhysID", "(I)V", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "typeIn", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "<init>", "(Lnet/minecraft/world/level/block/entity/BlockEntityType;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "clockwork"})
public final class ReactionWheelBlockEntity
extends KineticBlockEntity
implements IForceApplierBE<ReactionWheelUpdateData, ReactionWheelData, ReactionWheelCreateData, ReactionWheelController>,
IClockworkWheelBE {
    @NotNull
    private LerpedFloat visualSpeed;
    private double angle;
    private double realSpeed;
    private double targetSpeed;
    private boolean reachedTarget;
    private int physID;

    public ReactionWheelBlockEntity(@NotNull BlockEntityType<?> typeIn, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter(typeIn, (String)"typeIn");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(typeIn, pos, state);
        LerpedFloat lerpedFloat = LerpedFloat.linear();
        Intrinsics.checkNotNullExpressionValue((Object)lerpedFloat, (String)"linear(...)");
        this.visualSpeed = lerpedFloat;
        this.physID = -1;
    }

    @Override
    @NotNull
    public LerpedFloat getVisualSpeed() {
        return this.visualSpeed;
    }

    @Override
    public void setVisualSpeed(@NotNull LerpedFloat lerpedFloat) {
        Intrinsics.checkNotNullParameter((Object)lerpedFloat, (String)"<set-?>");
        this.visualSpeed = lerpedFloat;
    }

    @Override
    public double getAngle() {
        return this.angle;
    }

    @Override
    public void setAngle(double d) {
        this.angle = d;
    }

    public final double getRealSpeed() {
        return this.realSpeed;
    }

    public final void setRealSpeed(double d) {
        this.realSpeed = d;
    }

    public final double getTargetSpeed() {
        return this.targetSpeed;
    }

    public final void setTargetSpeed(double d) {
        this.targetSpeed = d;
    }

    public final boolean getReachedTarget() {
        return this.reachedTarget;
    }

    public final void setReachedTarget(boolean bl) {
        this.reachedTarget = bl;
    }

    @Override
    public int getPhysID() {
        return this.physID;
    }

    @Override
    public void setPhysID(int n) {
        this.physID = n;
    }

    @Override
    @NotNull
    public ReactionWheelCreateData newCreateData() {
        return ReactionWheelCreateData.Companion.fromBlockEntity(this);
    }

    @Override
    @NotNull
    public ReactionWheelUpdateData newUpdateData() {
        return new ReactionWheelUpdateData(this.realSpeed);
    }

    @NotNull
    public AABB getRenderBoundingBox() {
        AABB aABB = super.createRenderBoundingBox().m_82400_(2.0);
        Intrinsics.checkNotNullExpressionValue((Object)aABB, (String)"inflate(...)");
        return aABB;
    }

    protected void write(@NotNull CompoundTag compound, boolean clientPacket) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        compound.m_128347_("ServerSpeed", this.realSpeed);
        if (this.getPhysID() > -1) {
            compound.m_128405_("PhysID", this.getPhysID());
        }
        super.write(compound, clientPacket);
    }

    protected void read(@NotNull CompoundTag compound, boolean clientPacket) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        super.read(compound, clientPacket);
        if (clientPacket) {
            this.getVisualSpeed().chase(compound.m_128459_("ServerSpeed"), 0.05, LerpedFloat.Chaser.EXP);
        }
        if (compound.m_128441_("PhysID")) {
            this.setPhysID(compound.m_128451_("PhysID"));
        }
    }

    private final double calculateTargetSpeed() {
        return this.getSpeed();
    }

    public void tick() {
        boolean isOnShip;
        super.tick();
        Level level = this.f_58857_;
        boolean bl = level != null ? level.f_46443_ : false;
        if (bl) {
            this.getVisualSpeed().tickChaser();
            this.setAngle(this.getAngle() + (double)(this.getVisualSpeed().getValue() * (float)3 / 10.0f));
            this.setAngle(this.getAngle() % (double)360.0f);
            return;
        }
        if (this.f_58857_ == null) {
            return;
        }
        boolean bl2 = this.f_58857_ instanceof ServerLevel;
        if (_Assertions.ENABLED && !bl2) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        this.targetSpeed = this.calculateTargetSpeed();
        this.realSpeed = Mth.m_14139_((double)0.1, (double)this.realSpeed, (double)this.targetSpeed);
        if (!(this.realSpeed == this.targetSpeed) || !this.reachedTarget) {
            this.reachedTarget = Mth.m_14082_((double)this.realSpeed, (double)this.targetSpeed);
            this.sendData();
        }
        Level level2 = this.f_58857_;
        Intrinsics.checkNotNull((Object)level2);
        ServerLevel serverLevel = (ServerLevel)level2;
        BlockPos blockPos = this.f_58858_;
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"worldPosition");
        boolean bl3 = isOnShip = VSGameUtilsKt.getShipObjectManagingPos((ServerLevel)serverLevel, (Vec3i)((Vec3i)blockPos)) != null;
        if (isOnShip) {
            Level level3 = this.f_58857_;
            Intrinsics.checkNotNull((Object)level3);
            ServerLevel serverLevel2 = (ServerLevel)level3;
            BlockPos blockPos2 = this.f_58858_;
            Intrinsics.checkNotNullExpressionValue((Object)blockPos2, (String)"worldPosition");
            LoadedServerShip loadedServerShip = VSGameUtilsKt.getShipObjectManagingPos((ServerLevel)serverLevel2, (Vec3i)((Vec3i)blockPos2));
            Intrinsics.checkNotNull((Object)loadedServerShip);
            LoadedServerShip ship = loadedServerShip;
            ReactionWheelController reactionWheelController = ReactionWheelController.Companion.getOrCreate(ship);
            Intrinsics.checkNotNull((Object)reactionWheelController);
            ReactionWheelController attachment = reactionWheelController;
            this.tickData(attachment, true);
        }
    }

    public void remove() {
        BlockPos blockPos = this.f_58858_;
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"worldPosition");
        this.removeApplier(ReactionWheelController.class, this.f_58857_, blockPos);
        super.remove();
    }

    public void destroy() {
        BlockPos blockPos = this.f_58858_;
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"worldPosition");
        this.removeApplier(ReactionWheelController.class, this.f_58857_, blockPos);
        super.destroy();
    }
}

