/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.physicalities.gas_thruster;

import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.clockwork.ClockworkConfig;
import org.valkyrienskies.clockwork.ClockworkMod;
import org.valkyrienskies.clockwork.ClockworkSoundScapes;
import org.valkyrienskies.clockwork.content.physicalities.gas_thruster.GasThrusterBlock;
import org.valkyrienskies.clockwork.util.AerodynamicUtils;
import org.valkyrienskies.clockwork.util.KNodeBlockEntity;
import org.valkyrienskies.core.api.ships.PhysShip;
import org.valkyrienskies.core.api.world.PhysLevel;
import org.valkyrienskies.kelvin.KelvinMod;
import org.valkyrienskies.kelvin.api.DuctEdge;
import org.valkyrienskies.kelvin.api.DuctNode;
import org.valkyrienskies.kelvin.api.DuctNodePos;
import org.valkyrienskies.kelvin.api.GasType;
import org.valkyrienskies.kelvin.impl.DuctNetworkServer;
import org.valkyrienskies.kelvin.impl.client.DuctNetworkClient;
import org.valkyrienskies.kelvin.impl.registry.GasTypeRegistry;
import org.valkyrienskies.kelvin.util.KelvinExtensions;
import org.valkyrienskies.mod.api.BlockEntityPhysicsListener;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B%\u0012\f\u00108\u001a\b\u0012\u0002\b\u0003\u0018\u000107\u0012\u0006\u0010:\u001a\u000209\u0012\u0006\u0010<\u001a\u00020;\u00a2\u0006\u0004\b=\u0010>J\u001f\u0010\b\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0005H\u0014\u00a2\u0006\u0004\b\b\u0010\tJ\u001f\u0010\n\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0005H\u0014\u00a2\u0006\u0004\b\n\u0010\tJ\u001f\u0010\u000e\u001a\u00020\u00072\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\r\u0010\u0013\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014J\r\u0010\u0015\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0015\u0010\u0014J\u000f\u0010\u0016\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0014J!\u0010\u001b\u001a\u00020\u00072\b\u0010\u0018\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u001a\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cR&\u0010\u001f\u001a\u00060\u001dj\u0002`\u001e8\u0016@\u0016X\u0096.\u00a2\u0006\u0012\n\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\"\u0010&\u001a\u00020%8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b&\u0010'\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\"\u0010,\u001a\u00020%8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b,\u0010'\u001a\u0004\b-\u0010)\"\u0004\b.\u0010+R#\u00101\u001a\u000e\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u00020%0/8\u0006\u00a2\u0006\f\n\u0004\b1\u00102\u001a\u0004\b3\u00104R\u001a\u00105\u001a\u00020%8\u0006X\u0086D\u00a2\u0006\f\n\u0004\b5\u0010'\u001a\u0004\b6\u0010)\u00a8\u0006?"}, d2={"Lorg/valkyrienskies/clockwork/content/physicalities/gas_thruster/GasThrusterBlockEntity;", "Lorg/valkyrienskies/clockwork/util/KNodeBlockEntity;", "Lorg/valkyrienskies/mod/api/BlockEntityPhysicsListener;", "Lnet/minecraft/nbt/CompoundTag;", "tag", "", "clientPacket", "", "write", "(Lnet/minecraft/nbt/CompoundTag;Z)V", "read", "", "Lcom/simibubi/create/foundation/blockEntity/behaviour/BlockEntityBehaviour;", "behaviours", "addBehaviours", "(Ljava/util/List;)V", "Lorg/valkyrienskies/kelvin/api/DuctNodePos;", "getDuctNodePosition", "()Lorg/valkyrienskies/kelvin/api/DuctNodePos;", "clientTick", "()V", "clearMassFlow", "tick", "Lorg/valkyrienskies/core/api/ships/PhysShip;", "physShip", "Lorg/valkyrienskies/core/api/world/PhysLevel;", "physLevel", "physTick", "(Lorg/valkyrienskies/core/api/ships/PhysShip;Lorg/valkyrienskies/core/api/world/PhysLevel;)V", "", "Lorg/valkyrienskies/core/api/world/properties/DimensionId;", "dimension", "Ljava/lang/String;", "getDimension", "()Ljava/lang/String;", "setDimension", "(Ljava/lang/String;)V", "", "thrust", "D", "getThrust", "()D", "setThrust", "(D)V", "velocity", "getVelocity", "setVelocity", "Ljava/util/HashMap;", "Lorg/valkyrienskies/kelvin/api/GasType;", "gasMassFlow", "Ljava/util/HashMap;", "getGasMassFlow", "()Ljava/util/HashMap;", "massPerParticle", "getMassPerParticle", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "type", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "<init>", "(Lnet/minecraft/world/level/block/entity/BlockEntityType;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "clockwork"})
public final class GasThrusterBlockEntity
extends KNodeBlockEntity
implements BlockEntityPhysicsListener {
    public volatile String dimension;
    private volatile double thrust;
    private double velocity;
    @NotNull
    private final HashMap<GasType, Double> gasMassFlow;
    private final double massPerParticle;

    public GasThrusterBlockEntity(@Nullable BlockEntityType<?> type, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(type, pos, state);
        this.gasMassFlow = new HashMap();
        this.massPerParticle = 0.005;
    }

    @NotNull
    public String getDimension() {
        String string = this.dimension;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"dimension");
        return null;
    }

    public void setDimension(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.dimension = string;
    }

    public final double getThrust() {
        return this.thrust;
    }

    public final void setThrust(double d) {
        this.thrust = d;
    }

    public final double getVelocity() {
        return this.velocity;
    }

    public final void setVelocity(double d) {
        this.velocity = d;
    }

    @NotNull
    public final HashMap<GasType, Double> getGasMassFlow() {
        return this.gasMassFlow;
    }

    public final double getMassPerParticle() {
        return this.massPerParticle;
    }

    @Override
    protected void write(@NotNull CompoundTag tag, boolean clientPacket) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        CompoundTag compound = new CompoundTag();
        for (Map.Entry entry : ((Map)this.gasMassFlow).entrySet()) {
            GasType gas = (GasType)entry.getKey();
            double mass = ((Number)entry.getValue()).doubleValue();
            compound.m_128347_(gas.getResourceLocation().toString(), mass);
        }
        tag.m_128365_("GasMassFlow", (Tag)compound);
        tag.m_128347_("FlowRate", this.velocity);
        tag.m_128347_("Thrust", this.thrust);
        super.write(tag, clientPacket);
    }

    @Override
    protected void read(@NotNull CompoundTag tag, boolean clientPacket) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        super.read(tag, clientPacket);
        Tag tag2 = tag.m_128423_("GasMassFlow");
        CompoundTag compoundTag = tag2 instanceof CompoundTag ? (CompoundTag)tag2 : null;
        if (compoundTag == null) {
            return;
        }
        CompoundTag compound = compoundTag;
        for (String key : compound.m_128431_()) {
            GasType gasType;
            if (GasTypeRegistry.INSTANCE.getGasType(new ResourceLocation(key)) == null) continue;
            ((Map)this.gasMassFlow).put(gasType, compound.m_128459_(key));
        }
        this.velocity = tag.m_128459_("FlowRate");
        this.thrust = tag.m_128459_("Thrust");
    }

    public void addBehaviours(@Nullable List<BlockEntityBehaviour> behaviours) {
    }

    @Override
    @NotNull
    public DuctNodePos getDuctNodePosition() {
        if (this.f_58857_ != null) {
            Level level = this.f_58857_;
            Intrinsics.checkNotNull((Object)level);
            if (!level.m_5776_()) {
                BlockPos blockPos = this.m_58899_();
                Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
                Level level2 = this.f_58857_;
                Intrinsics.checkNotNull((Object)level2);
                ResourceLocation resourceLocation = level2.m_46472_().m_135782_();
                Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"location(...)");
                return KelvinExtensions.INSTANCE.toDuctNodePos(blockPos, resourceLocation);
            }
        }
        BlockPos blockPos = this.m_58899_();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
        return KelvinExtensions.toDuctNodePos$default((KelvinExtensions)KelvinExtensions.INSTANCE, (BlockPos)blockPos, null, (int)1, null);
    }

    public final void clientTick() {
        if (this.gasMassFlow.isEmpty() || this.velocity == 0.0) {
            return;
        }
        float pitch = 60.0f / (float)Math.cbrt(this.velocity);
        ClockworkSoundScapes.AmbienceGroup scape = ClockworkSoundScapes.AmbienceGroup.THRUSTER;
        BlockPos blockPos = this.f_58858_;
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"worldPosition");
        ClockworkSoundScapes.INSTANCE.play(scape, blockPos, pitch);
        DuctNetworkClient ductNetwork = KelvinMod.INSTANCE.getKelvinClient();
        block0: for (Map.Entry entry : ((Map)this.gasMassFlow).entrySet()) {
            GasType gas = (GasType)entry.getKey();
            double mass = ((Number)entry.getValue()).doubleValue();
            double particleCount = mass / this.massPerParticle;
            Direction direction = (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_);
            Vec3i vec3i = direction.m_122436_();
            Intrinsics.checkNotNullExpressionValue((Object)vec3i, (String)"getNormal(...)");
            Vector3d speed = VectorConversionsMCKt.toJOMLD((Vec3i)vec3i).mul(-Math.cbrt(Math.abs(this.velocity)) / (double)50);
            BlockPos blockPos2 = this.m_58899_();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos2, (String)"getBlockPos(...)");
            Vector3d position = VectorConversionsMCKt.toJOMLD((Vec3i)((Vec3i)blockPos2)).add(0.5, 0.5, 0.5);
            int count = 1;
            int n = (int)particleCount;
            if (count > n) continue;
            while (true) {
                Level level = this.f_58857_;
                Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.client.multiplayer.ClientLevel");
                ClientLevel clientLevel = (ClientLevel)level;
                BlockPos blockPos3 = this.m_58899_();
                Intrinsics.checkNotNullExpressionValue((Object)blockPos3, (String)"getBlockPos(...)");
                Level level2 = this.f_58857_;
                Intrinsics.checkNotNull((Object)level2);
                ResourceLocation resourceLocation = level2.m_46472_().m_135782_();
                Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"location(...)");
                ductNetwork.createGasParticle(clientLevel, gas, KelvinExtensions.INSTANCE.toDuctNodePos(blockPos3, resourceLocation), position.x + GasThrusterBlockEntity.clientTick$random(), position.y + GasThrusterBlockEntity.clientTick$random(), position.z + GasThrusterBlockEntity.clientTick$random(), speed.x, speed.y, speed.z);
                if (count == n) continue block0;
                ++count;
            }
        }
    }

    public final void clearMassFlow() {
        if (this.gasMassFlow.isEmpty()) {
            return;
        }
        this.gasMassFlow.clear();
        this.velocity = 0.0;
        this.thrust = 0.0;
        this.sendData();
    }

    public void tick() {
        super.tick();
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        if (level.f_46443_) {
            this.clientTick();
            return;
        }
        DuctNodePos ductnodepos = this.getDuctNodePosition();
        DuctNetworkServer kelvin = ClockworkMod.getKelvin();
        DuctNode ductNode = kelvin.getNodeAt(ductnodepos);
        if (ductNode == null) {
            this.clearMassFlow();
            return;
        }
        DuctNode node = ductNode;
        HashMap gasMasses = kelvin.getGasMassAt(ductnodepos);
        Collection collection = gasMasses.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        if (CollectionsKt.sumOfDouble((Iterable)collection) == 0.0) {
            this.clearMassFlow();
            return;
        }
        double d = this.m_58899_().m_123342_();
        Level level2 = this.f_58857_;
        Intrinsics.checkNotNull((Object)level2);
        double airPressure = AerodynamicUtils.INSTANCE.getAirPressureForY(d, VSGameUtilsKt.getDimensionId((Level)level2));
        double gasPressure = kelvin.getPressureAt(ductnodepos);
        double temp = kelvin.getTemperatureAt(ductnodepos);
        double avgSpecificHeat = kelvin.mixtureCapacity((Map)kelvin.getGasMassAt(ductnodepos));
        if (gasPressure < airPressure) {
            this.clearMassFlow();
            return;
        }
        this.velocity = 0.0;
        Iterator iterator = node.getNodeEdges().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Object e = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            DuctEdge edge = (DuctEdge)e;
            this.velocity += edge.getCurrentFlowRate();
        }
        double maxFlowRate = 0.11045 * gasPressure / Math.sqrt(temp) * Math.sqrt(avgSpecificHeat / 8.314) * Math.pow((avgSpecificHeat + 1.0) / (double)2, -(avgSpecificHeat + 1.0) / ((double)2 * (avgSpecificHeat - 1.0)));
        double flowRate = Math.min(maxFlowRate, this.velocity);
        for (Map.Entry gas : ((Map)gasMasses).entrySet()) {
            this.velocity += flowRate / (((GasType)gas.getKey()).getDensity() * 0.11045);
            double gasMassLoss = Math.max(flowRate * 0.05, ((Number)gas.getValue()).doubleValue());
            Double d2 = gasMassLoss;
            ((Map)this.gasMassFlow).put(gas.getKey(), d2);
            kelvin.removeGas(ductnodepos, (GasType)gas.getKey(), gasMassLoss);
        }
        this.thrust = (flowRate * this.velocity + (gasPressure - airPressure)) * ClockworkConfig.SERVER.getGasThrusterForceMul();
        this.sendData();
    }

    public void physTick(@Nullable PhysShip physShip, @NotNull PhysLevel physLevel) {
        Intrinsics.checkNotNullParameter((Object)physLevel, (String)"physLevel");
        if (physShip == null) {
            return;
        }
        if (!(this.m_58900_().m_60734_() instanceof GasThrusterBlock)) {
            return;
        }
        Vec3i vec3i = ((Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_)).m_122436_();
        Intrinsics.checkNotNullExpressionValue((Object)vec3i, (String)"getNormal(...)");
        Vector3d force = VectorConversionsMCKt.toJOMLD((Vec3i)vec3i).mul(this.thrust);
        Intrinsics.checkNotNull((Object)force);
        Vector3dc vector3dc = (Vector3dc)force;
        BlockPos blockPos = this.m_58899_();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
        Vector3d vector3d = VectorConversionsMCKt.toJOMLD((Vec3i)((Vec3i)blockPos)).add(0.5, 0.5, 0.5);
        Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"add(...)");
        physShip.applyModelForce(vector3dc, (Vector3dc)vector3d);
    }

    private static final double clientTick$random() {
        return Random.Default.nextDouble(-0.35, 0.35);
    }
}

