/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.physicalities;

import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityVisual;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.TransformedInstance;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.visual.SimpleDynamicVisual;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.createmod.catnip.math.AngleHelper;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.valkyrienskies.clockwork.content.physicalities.IClockworkWheelBE;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u001f\u0012\u0006\u0010(\u001a\u00020'\u0012\u0006\u0010)\u001a\u00020\u0002\u0012\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b*\u0010+J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u000b\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0011\u001a\u00020\u0006H\u0014\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001f\u0010\u0016\u001a\u00020\u00062\u000e\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u0013H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0019\u001a\u00020\u00188\u0006\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u001b\u0010\u001cR\"\u0010\u001d\u001a\u00020\t8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\fR\u0017\u0010#\u001a\u00020\"8\u0006\u00a2\u0006\f\n\u0004\b#\u0010$\u001a\u0004\b%\u0010&\u00a8\u0006,"}, d2={"Lorg/valkyrienskies/clockwork/content/physicalities/ClockworkWheelVisual;", "Lcom/simibubi/create/content/kinetics/base/KineticBlockEntityVisual;", "Lcom/simibubi/create/content/kinetics/base/KineticBlockEntity;", "Ldev/engine_room/flywheel/lib/visual/SimpleDynamicVisual;", "Ldev/engine_room/flywheel/api/visual/DynamicVisual$Context;", "ctx", "", "beginFrame", "(Ldev/engine_room/flywheel/api/visual/DynamicVisual$Context;)V", "", "angle", "animate", "(D)V", "", "partialTick", "updateLight", "(F)V", "_delete", "()V", "Ljava/util/function/Consumer;", "Ldev/engine_room/flywheel/api/instance/Instance;", "consumer", "collectCrumblingInstances", "(Ljava/util/function/Consumer;)V", "Ldev/engine_room/flywheel/lib/instance/TransformedInstance;", "wheel", "Ldev/engine_room/flywheel/lib/instance/TransformedInstance;", "getWheel", "()Ldev/engine_room/flywheel/lib/instance/TransformedInstance;", "lastAngle", "D", "getLastAngle", "()D", "setLastAngle", "Lorg/joml/Matrix4f;", "baseTransform", "Lorg/joml/Matrix4f;", "getBaseTransform", "()Lorg/joml/Matrix4f;", "Ldev/engine_room/flywheel/api/visualization/VisualizationContext;", "context", "blockEntity", "<init>", "(Ldev/engine_room/flywheel/api/visualization/VisualizationContext;Lcom/simibubi/create/content/kinetics/base/KineticBlockEntity;F)V", "clockwork"})
@SourceDebugExtension(value={"SMAP\nClockworkWheelVisual.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClockworkWheelVisual.kt\norg/valkyrienskies/clockwork/content/physicalities/ClockworkWheelVisual\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,94:1\n1#2:95\n*E\n"})
public final class ClockworkWheelVisual
extends KineticBlockEntityVisual<KineticBlockEntity>
implements SimpleDynamicVisual {
    @NotNull
    private final TransformedInstance wheel;
    private double lastAngle;
    @NotNull
    private final Matrix4f baseTransform;

    public ClockworkWheelVisual(@NotNull VisualizationContext context, @NotNull KineticBlockEntity blockEntity, float partialTick) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)blockEntity, (String)"blockEntity");
        super(context, blockEntity, partialTick);
        this.lastAngle = Double.NaN;
        this.baseTransform = new Matrix4f();
        Direction.Axis axis = this.rotationAxis();
        this.wheel = (TransformedInstance)this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.block((BlockState)this.blockState)).createInstance();
        Direction align = Direction.m_122387_((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
        ((TransformedInstance)((TransformedInstance)this.wheel.translate((Vec3i)this.getVisualPosition())).center()).rotate((Quaternionfc)new Quaternionf().rotateTo(0.0f, 1.0f, 0.0f, (float)align.m_122429_(), (float)align.m_122430_(), (float)align.m_122431_()));
        this.baseTransform.set((Matrix4fc)this.wheel.pose);
        this.animate(((IClockworkWheelBE)blockEntity).getAngle());
    }

    @NotNull
    public final TransformedInstance getWheel() {
        return this.wheel;
    }

    public final double getLastAngle() {
        return this.lastAngle;
    }

    public final void setLastAngle(double d) {
        this.lastAngle = d;
    }

    @NotNull
    public final Matrix4f getBaseTransform() {
        return this.baseTransform;
    }

    public void beginFrame(@NotNull DynamicVisual.Context ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        boolean bl = this.blockEntity instanceof IClockworkWheelBE;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-ClockworkWheelVisual$beginFrame$22 = false;
            String $i$a$-assert-ClockworkWheelVisual$beginFrame$22 = "ClockworkWheelVisual used with BE that doesn't implement IClockworkWheel";
            throw new AssertionError((Object)$i$a$-assert-ClockworkWheelVisual$beginFrame$22);
        }
        float partialTicks = ctx.partialTick();
        BlockEntity blockEntity = this.blockEntity;
        Intrinsics.checkNotNull((Object)blockEntity, (String)"null cannot be cast to non-null type org.valkyrienskies.clockwork.content.physicalities.IClockworkWheelBE");
        float speed = ((IClockworkWheelBE)blockEntity).getVisualSpeed().getValue(partialTicks) * (float)3 / 10.0f;
        BlockEntity blockEntity2 = this.blockEntity;
        Intrinsics.checkNotNull((Object)blockEntity2, (String)"null cannot be cast to non-null type org.valkyrienskies.clockwork.content.physicalities.IClockworkWheelBE");
        double angle = ((IClockworkWheelBE)blockEntity2).getAngle() + (double)(speed * partialTicks);
        if (Math.abs(angle - this.lastAngle) < 0.001) {
            return;
        }
        this.animate(angle);
        this.lastAngle = angle;
    }

    private final void animate(double angle) {
        ((TransformedInstance)this.wheel.setTransform((Matrix4fc)this.baseTransform).rotateY(AngleHelper.rad((double)angle)).uncenter()).setChanged();
    }

    public void updateLight(float partialTick) {
        FlatLit[] flatLitArray = new FlatLit[]{this.wheel};
        this.relight(flatLitArray);
    }

    protected void _delete() {
        this.wheel.delete();
    }

    public void collectCrumblingInstances(@NotNull Consumer<Instance> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        consumer.accept((Instance)this.wheel);
    }
}

