/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.logistics.gas.valve;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.createmod.catnip.animation.LerpedFloat;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.valkyrienskies.clockwork.ClockworkMod;
import org.valkyrienskies.clockwork.content.logistics.gas.IConnectable;
import org.valkyrienskies.clockwork.content.logistics.gas.valve.ValveDuctBlock;
import org.valkyrienskies.clockwork.util.ClockworkUtils;
import org.valkyrienskies.clockwork.util.KNodeKineticBlockEntity;
import org.valkyrienskies.kelvin.api.ConnectionType;
import org.valkyrienskies.kelvin.api.DuctEdge;
import org.valkyrienskies.kelvin.api.DuctNodePos;
import org.valkyrienskies.kelvin.api.edges.ApertureDuctEdge;
import org.valkyrienskies.kelvin.impl.DuctNetworkServer;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B#\u0012\n\u0010'\u001a\u0006\u0012\u0002\b\u00030&\u0012\u0006\u0010(\u001a\u00020\u001a\u0012\u0006\u0010*\u001a\u00020)\u00a2\u0006\u0004\b+\u0010,J\u000f\u0010\u0004\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0006\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0005J\u0017\u0010\t\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u001f\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0010H\u0014\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001f\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0010H\u0014\u00a2\u0006\u0004\b\u0014\u0010\u0013J7\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001cH\u0016\u00a2\u0006\u0004\b\u001f\u0010 R\u0017\u0010\"\u001a\u00020!8\u0006\u00a2\u0006\f\n\u0004\b\"\u0010#\u001a\u0004\b$\u0010%\u00a8\u0006-"}, d2={"Lorg/valkyrienskies/clockwork/content/logistics/gas/valve/ValveDuctBlockEntity;", "Lorg/valkyrienskies/clockwork/util/KNodeKineticBlockEntity;", "Lorg/valkyrienskies/clockwork/content/logistics/gas/IConnectable;", "", "lazyTick", "()V", "tick", "", "previousSpeed", "onSpeedChanged", "(F)V", "", "getChaseSpeed", "()D", "Lnet/minecraft/nbt/CompoundTag;", "compound", "", "clientPacket", "write", "(Lnet/minecraft/nbt/CompoundTag;Z)V", "read", "Lorg/valkyrienskies/kelvin/api/DuctNodePos;", "nodeA", "nodeB", "Lnet/minecraft/world/level/Level;", "level", "Lnet/minecraft/core/BlockPos;", "blockPos", "Lnet/minecraft/core/Direction;", "direction", "Lorg/valkyrienskies/kelvin/api/DuctEdge;", "getEdge", "(Lorg/valkyrienskies/kelvin/api/DuctNodePos;Lorg/valkyrienskies/kelvin/api/DuctNodePos;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/Direction;)Lorg/valkyrienskies/kelvin/api/DuctEdge;", "Lnet/createmod/catnip/animation/LerpedFloat;", "pointer", "Lnet/createmod/catnip/animation/LerpedFloat;", "getPointer", "()Lnet/createmod/catnip/animation/LerpedFloat;", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "typeIn", "pos", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "<init>", "(Lnet/minecraft/world/level/block/entity/BlockEntityType;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "clockwork"})
public final class ValveDuctBlockEntity
extends KNodeKineticBlockEntity
implements IConnectable {
    @NotNull
    private final LerpedFloat pointer;

    public ValveDuctBlockEntity(@NotNull BlockEntityType<?> typeIn, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter(typeIn, (String)"typeIn");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(typeIn, pos, state);
        LerpedFloat lerpedFloat = LerpedFloat.linear().startWithValue(0.0).chase(0.0, 0.0, LerpedFloat.Chaser.LINEAR);
        Intrinsics.checkNotNullExpressionValue((Object)lerpedFloat, (String)"chase(...)");
        this.pointer = lerpedFloat;
    }

    @NotNull
    public final LerpedFloat getPointer() {
        return this.pointer;
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        Level level = this.f_58857_;
        if (!(level != null ? !level.f_46443_ : false)) {
            return;
        }
        if (!(this.m_58900_().m_60734_() instanceof ValveDuctBlock)) {
            return;
        }
        BlockState blockState = this.m_58900_();
        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"getBlockState(...)");
        Direction dir = Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)ValveDuctBlock.Companion.getDuctAxis(blockState));
        Level level2 = this.f_58857_;
        Intrinsics.checkNotNull((Object)level2);
        BlockPos blockPos = this.m_58899_();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
        Intrinsics.checkNotNull((Object)dir);
        this.updateConnection(level2, blockPos, dir);
        Level level3 = this.f_58857_;
        Intrinsics.checkNotNull((Object)level3);
        BlockPos blockPos2 = this.m_58899_();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos2, (String)"getBlockPos(...)");
        Direction direction = dir.m_122424_();
        Intrinsics.checkNotNullExpressionValue((Object)direction, (String)"getOpposite(...)");
        this.updateConnection(level3, blockPos2, direction);
    }

    public void tick() {
        block7: {
            block6: {
                block5: {
                    super.tick();
                    this.pointer.tickChaser();
                    if (this.f_58857_ == null) break block5;
                    Level level = this.f_58857_;
                    Intrinsics.checkNotNull((Object)level);
                    if (!level.f_46443_ && this.m_58900_().m_60734_() instanceof ValveDuctBlock) break block6;
                }
                return;
            }
            BlockState blockState = this.m_58900_();
            Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"getBlockState(...)");
            Direction.Axis axis = ValveDuctBlock.Companion.getDuctAxis(blockState);
            BlockPos front = this.m_58899_().m_5487_(axis, -1);
            BlockPos back = this.m_58899_().m_5487_(axis, 1);
            if (this.f_58857_ == null) {
                return;
            }
            DuctNetworkServer ductNetworkServer = ClockworkMod.getKelvin();
            DuctNodePos ductNodePos = this.getDuctNodePosition();
            Intrinsics.checkNotNull((Object)back);
            DuctEdge backEdge = ductNetworkServer.getEdgeBetween(ductNodePos, ClockworkUtils.INSTANCE.getDuctNodePos(back, this.f_58857_));
            DuctNetworkServer ductNetworkServer2 = ClockworkMod.getKelvin();
            DuctNodePos ductNodePos2 = this.getDuctNodePosition();
            Intrinsics.checkNotNull((Object)front);
            DuctEdge frontEdge = ductNetworkServer2.getEdgeBetween(ductNodePos2, ClockworkUtils.INSTANCE.getDuctNodePos(front, this.f_58857_));
            ApertureDuctEdge apertureDuctEdge = backEdge instanceof ApertureDuctEdge ? (ApertureDuctEdge)backEdge : null;
            if (apertureDuctEdge != null) {
                apertureDuctEdge.setAperture((double)this.pointer.getValue() - ((ApertureDuctEdge)backEdge).getRadius());
            }
            ApertureDuctEdge apertureDuctEdge2 = frontEdge instanceof ApertureDuctEdge ? (ApertureDuctEdge)frontEdge : null;
            if (apertureDuctEdge2 == null) break block7;
            apertureDuctEdge2.setAperture((double)this.pointer.getValue() - ((ApertureDuctEdge)frontEdge).getRadius());
        }
    }

    public void onSpeedChanged(float previousSpeed) {
        super.onSpeedChanged(previousSpeed);
        double target = this.speed > 0.0f ? 1 : 0;
        this.pointer.chase(target, this.getChaseSpeed(), LerpedFloat.Chaser.LINEAR);
        this.sendData();
    }

    private final double getChaseSpeed() {
        return Mth.m_14008_((double)(Math.abs((double)this.getSpeed()) / 16.0 / 40.0), (double)0.0, (double)1.0);
    }

    @Override
    protected void write(@NotNull CompoundTag compound, boolean clientPacket) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        super.write(compound, clientPacket);
        compound.m_128365_("Pointer", (Tag)this.pointer.writeNBT());
    }

    @Override
    protected void read(@NotNull CompoundTag compound, boolean clientPacket) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        super.read(compound, clientPacket);
        this.pointer.readNBT(compound.m_128469_("Pointer"), clientPacket);
    }

    @Override
    @NotNull
    public DuctEdge getEdge(@NotNull DuctNodePos nodeA, @NotNull DuctNodePos nodeB, @NotNull Level level, @NotNull BlockPos blockPos, @NotNull Direction direction) {
        Intrinsics.checkNotNullParameter((Object)nodeA, (String)"nodeA");
        Intrinsics.checkNotNullParameter((Object)nodeB, (String)"nodeB");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        return (DuctEdge)new ApertureDuctEdge(ConnectionType.APERTURE, nodeA, nodeB, 0.0, 0.0, 0.0, (double)this.pointer.getValue() - 0.125, false, 184, null);
    }
}

