/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.logistics.gas.storage.tank;

import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.foundation.blockEntity.IMultiBlockEntityContainer;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.valkyrienskies.clockwork.content.logistics.gas.storage.tank.DuctTankBlock;
import org.valkyrienskies.clockwork.util.KNodeBlockEntity;
import org.valkyrienskies.kelvin.api.DuctNodePos;
import org.valkyrienskies.kelvin.util.KelvinExtensions;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B#\u0012\n\u0010O\u001a\u0006\u0012\u0002\b\u00030N\u0012\u0006\u0010\"\u001a\u00020\u0019\u0012\u0006\u0010Q\u001a\u00020P\u00a2\u0006\u0004\bR\u0010SJ\u001f\u0010\u0007\u001a\u00020\u00062\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\r\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000b\u0010\nJ\u001f\u0010\u0010\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000eH\u0014\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001f\u0010\u0012\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000eH\u0014\u00a2\u0006\u0004\b\u0012\u0010\u0011J\u000f\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0016\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0016\u0010\nJ\r\u0010\u0017\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0017\u0010\nJ\u000f\u0010\u0018\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0018\u0010\nJ\u0011\u0010\u001a\u001a\u0004\u0018\u00010\u0019H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ#\u0010\u001e\u001a\u0004\u0018\u00018\u0000\"\u0010\b\u0000\u0010\u001d*\u0004\u0018\u00010\u001c*\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u000f\u0010 \u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b \u0010!J\u0019\u0010#\u001a\u00020\u00062\b\u0010\"\u001a\u0004\u0018\u00010\u0019H\u0016\u00a2\u0006\u0004\b#\u0010$J\u0017\u0010&\u001a\u00020\u00062\u0006\u0010%\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b&\u0010'J\u000f\u0010(\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b(\u0010\u001bJ\u000f\u0010)\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b)\u0010\nJ\u000f\u0010+\u001a\u00020*H\u0016\u00a2\u0006\u0004\b+\u0010,J\u001f\u00100\u001a\u00020.2\u0006\u0010-\u001a\u00020*2\u0006\u0010/\u001a\u00020.H\u0016\u00a2\u0006\u0004\b0\u00101J\u000f\u00102\u001a\u00020.H\u0016\u00a2\u0006\u0004\b2\u00103J\u000f\u00104\u001a\u00020.H\u0016\u00a2\u0006\u0004\b4\u00103J\u0017\u00106\u001a\u00020\u00062\u0006\u00105\u001a\u00020.H\u0016\u00a2\u0006\u0004\b6\u00107J\u000f\u00108\u001a\u00020.H\u0016\u00a2\u0006\u0004\b8\u00103J\u0017\u00109\u001a\u00020\u00062\u0006\u0010/\u001a\u00020.H\u0016\u00a2\u0006\u0004\b9\u00107R\u001a\u0010:\u001a\u00020.8\u0004X\u0084D\u00a2\u0006\f\n\u0004\b:\u0010;\u001a\u0004\b<\u00103R\"\u0010=\u001a\u00020.8\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\b=\u0010;\u001a\u0004\b>\u00103\"\u0004\b?\u00107R\"\u0010@\u001a\u00020.8\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\b@\u0010;\u001a\u0004\bA\u00103\"\u0004\bB\u00107R$\u0010C\u001a\u0004\u0018\u00010\u00198\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\bC\u0010D\u001a\u0004\bE\u0010\u001b\"\u0004\bF\u0010$R*\u0010H\u001a\n G*\u0004\u0018\u00010\u00190\u00198\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\bH\u0010D\u001a\u0004\bI\u0010\u001b\"\u0004\bJ\u0010$R\"\u0010\u0017\u001a\u00020\u000e8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0017\u0010K\u001a\u0004\bL\u0010!\"\u0004\bM\u0010'\u00a8\u0006T"}, d2={"Lorg/valkyrienskies/clockwork/content/logistics/gas/storage/tank/DuctTankBlockEntity;", "Lorg/valkyrienskies/clockwork/util/KNodeBlockEntity;", "Lcom/simibubi/create/foundation/blockEntity/IMultiBlockEntityContainer;", "", "Lcom/simibubi/create/foundation/blockEntity/behaviour/BlockEntityBehaviour;", "behaviours", "", "addBehaviours", "(Ljava/util/List;)V", "tick", "()V", "queueConnectivityUpdate", "Lnet/minecraft/nbt/CompoundTag;", "tag", "", "clientPacket", "read", "(Lnet/minecraft/nbt/CompoundTag;Z)V", "write", "Lorg/valkyrienskies/kelvin/api/DuctNodePos;", "getDuctNodePosition", "()Lorg/valkyrienskies/kelvin/api/DuctNodePos;", "lazyTick", "updateConnectivity", "notifyMultiUpdated", "Lnet/minecraft/core/BlockPos;", "getController", "()Lnet/minecraft/core/BlockPos;", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "T", "getControllerBE", "()Lnet/minecraft/world/level/block/entity/BlockEntity;", "isController", "()Z", "pos", "setController", "(Lnet/minecraft/core/BlockPos;)V", "keepContents", "removeController", "(Z)V", "getLastKnownPos", "preventConnectivityUpdate", "Lnet/minecraft/core/Direction$Axis;", "getMainConnectionAxis", "()Lnet/minecraft/core/Direction$Axis;", "longAxis", "", "width", "getMaxLength", "(Lnet/minecraft/core/Direction$Axis;I)I", "getMaxWidth", "()I", "getHeight", "height", "setHeight", "(I)V", "getWidth", "setWidth", "maxHeight", "I", "getMaxHeight", "heightCT", "getHeightCT", "setHeightCT", "widthCT", "getWidthCT", "setWidthCT", "controllerCT", "Lnet/minecraft/core/BlockPos;", "getControllerCT", "setControllerCT", "kotlin.jvm.PlatformType", "lastKnownPosCT", "getLastKnownPosCT", "setLastKnownPosCT", "Z", "getUpdateConnectivity", "setUpdateConnectivity", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "type", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "<init>", "(Lnet/minecraft/world/level/block/entity/BlockEntityType;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "clockwork"})
public final class DuctTankBlockEntity
extends KNodeBlockEntity
implements IMultiBlockEntityContainer {
    private final int maxHeight;
    private int heightCT;
    private int widthCT;
    @Nullable
    private BlockPos controllerCT;
    private BlockPos lastKnownPosCT;
    private boolean updateConnectivity;

    public DuctTankBlockEntity(@NotNull BlockEntityType<?> type, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(type, pos, state);
        this.maxHeight = 5;
        this.heightCT = 1;
        this.widthCT = 1;
        this.lastKnownPosCT = this.m_58899_();
    }

    protected final int getMaxHeight() {
        return this.maxHeight;
    }

    protected final int getHeightCT() {
        return this.heightCT;
    }

    protected final void setHeightCT(int n) {
        this.heightCT = n;
    }

    protected final int getWidthCT() {
        return this.widthCT;
    }

    protected final void setWidthCT(int n) {
        this.widthCT = n;
    }

    @Nullable
    protected final BlockPos getControllerCT() {
        return this.controllerCT;
    }

    protected final void setControllerCT(@Nullable BlockPos blockPos) {
        this.controllerCT = blockPos;
    }

    protected final BlockPos getLastKnownPosCT() {
        return this.lastKnownPosCT;
    }

    protected final void setLastKnownPosCT(BlockPos blockPos) {
        this.lastKnownPosCT = blockPos;
    }

    public final boolean getUpdateConnectivity() {
        return this.updateConnectivity;
    }

    public final void setUpdateConnectivity(boolean bl) {
        this.updateConnectivity = bl;
    }

    public void addBehaviours(@Nullable List<BlockEntityBehaviour> behaviours) {
    }

    public void tick() {
        super.tick();
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        if (level.f_46443_) {
            return;
        }
        if (this.updateConnectivity) {
            this.updateConnectivity();
        }
        this.sendData();
    }

    public final void queueConnectivityUpdate() {
        this.updateConnectivity = true;
    }

    @Override
    protected void read(@NotNull CompoundTag tag, boolean clientPacket) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        if (tag.m_128441_("Controller")) {
            this.controllerCT = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("Controller"));
        }
        if (tag.m_128441_("Height")) {
            this.heightCT = tag.m_128451_("Height");
        }
        if (tag.m_128441_("Width")) {
            this.widthCT = tag.m_128451_("Width");
        }
        super.read(tag, clientPacket);
    }

    @Override
    protected void write(@NotNull CompoundTag tag, boolean clientPacket) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        tag.m_128405_("Height", this.getHeight());
        tag.m_128405_("Width", this.getWidth());
        if (this.getController() != null) {
            BlockPos blockPos = this.getController();
            Intrinsics.checkNotNull((Object)blockPos);
            tag.m_128365_("Controller", (Tag)NbtUtils.m_129224_((BlockPos)blockPos));
        }
        super.write(tag, clientPacket);
    }

    @Override
    @NotNull
    public DuctNodePos getDuctNodePosition() {
        BlockPos blockPos = this.getController();
        Intrinsics.checkNotNull((Object)blockPos);
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        ResourceLocation resourceLocation = level.m_46472_().m_135782_();
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"location(...)");
        return KelvinExtensions.INSTANCE.toDuctNodePos(blockPos, resourceLocation);
    }

    @Override
    public void lazyTick() {
        if (!this.isController()) {
            return;
        }
        super.lazyTick();
    }

    public final void updateConnectivity() {
        this.updateConnectivity = false;
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        if (level.f_46443_) {
            return;
        }
        if (!this.isController()) {
            return;
        }
        ConnectivityHandler.formMulti((BlockEntity)((BlockEntity)this));
    }

    public void notifyMultiUpdated() {
        BlockState state = this.m_58900_();
        if (state.m_60734_() instanceof DuctTankBlock) {
            Property property = (Property)DuctTankBlock.Companion.getBOTTOM();
            BlockPos blockPos = this.getController();
            Intrinsics.checkNotNull((Object)blockPos);
            state = (BlockState)state.m_61124_(property, (Comparable)Boolean.valueOf(blockPos.m_123342_() == this.m_58899_().m_123342_()));
            Property property2 = (Property)DuctTankBlock.Companion.getTOP();
            BlockPos blockPos2 = this.getController();
            Intrinsics.checkNotNull((Object)blockPos2);
            state = (BlockState)state.m_61124_(property2, (Comparable)Boolean.valueOf(blockPos2.m_123342_() + this.getHeight() - 1 == this.m_58899_().m_123342_()));
            state = (BlockState)state.m_61124_((Property)DuctTankBlock.Companion.getLARGE(), (Comparable)Boolean.valueOf(this.getWidth() > 1));
            Level level = this.f_58857_;
            Intrinsics.checkNotNull((Object)level);
            level.m_7731_(this.m_58899_(), state, 6);
            Block block = this.m_58900_().m_60734_();
            DuctTankBlock ductTankBlock = block instanceof DuctTankBlock ? (DuctTankBlock)block : null;
            if (ductTankBlock != null) {
                BlockState blockState = this.m_58900_();
                Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"getBlockState(...)");
                Level level2 = this.f_58857_;
                Intrinsics.checkNotNull((Object)level2);
                BlockPos blockPos3 = this.m_58899_();
                Intrinsics.checkNotNullExpressionValue((Object)blockPos3, (String)"getBlockPos(...)");
                BlockState blockState2 = this.m_58900_();
                Intrinsics.checkNotNullExpressionValue((Object)blockState2, (String)"getBlockState(...)");
                ductTankBlock.nodeRemove(blockState, level2, blockPos3, blockState2, false);
            }
            if (this.isController()) {
                block = this.m_58900_().m_60734_();
                DuctTankBlock ductTankBlock2 = block instanceof DuctTankBlock ? (DuctTankBlock)block : null;
                if (ductTankBlock2 != null) {
                    BlockState blockState = this.m_58900_();
                    Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"getBlockState(...)");
                    Level level3 = this.f_58857_;
                    Intrinsics.checkNotNull((Object)level3);
                    BlockPos blockPos4 = this.m_58899_();
                    Intrinsics.checkNotNullExpressionValue((Object)blockPos4, (String)"getBlockPos(...)");
                    BlockState blockState3 = this.m_58900_();
                    Intrinsics.checkNotNullExpressionValue((Object)blockState3, (String)"getBlockState(...)");
                    ductTankBlock2.nodePlace(blockState, level3, blockPos4, blockState3, false);
                }
            }
        }
        this.m_6596_();
        this.notifyUpdate();
    }

    @Nullable
    public BlockPos getController() {
        return this.isController() ? this.m_58899_() : this.controllerCT;
    }

    @Nullable
    public <T extends BlockEntity> T getControllerBE() {
        BlockEntity blockEntity;
        if (this.isController()) {
            return (T)((BlockEntity)this);
        }
        Level level = this.f_58857_;
        if (level != null) {
            BlockPos blockPos = this.controllerCT;
            Intrinsics.checkNotNull((Object)blockPos);
            blockEntity = level.m_7702_(blockPos);
        } else {
            blockEntity = null;
        }
        BlockEntity blockEntity2 = blockEntity;
        return (T)(blockEntity2 instanceof BlockEntity ? blockEntity2 : null);
    }

    public boolean isController() {
        return this.controllerCT == null || Intrinsics.areEqual((Object)this.controllerCT, (Object)this.m_58899_());
    }

    public void setController(@Nullable BlockPos pos) {
        this.controllerCT = pos;
        this.notifyUpdate();
        this.m_6596_();
        this.sendData();
    }

    public void removeController(boolean keepContents) {
        Block block;
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        if (level.f_46443_) {
            return;
        }
        if (this.isController()) {
            block = this.m_58900_().m_60734_();
            DuctTankBlock ductTankBlock = block instanceof DuctTankBlock ? (DuctTankBlock)block : null;
            if (ductTankBlock != null) {
                BlockState blockState = this.m_58900_();
                Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"getBlockState(...)");
                Level level2 = this.f_58857_;
                Intrinsics.checkNotNull((Object)level2);
                BlockPos blockPos = this.m_58899_();
                Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
                BlockState blockState2 = this.m_58900_();
                Intrinsics.checkNotNullExpressionValue((Object)blockState2, (String)"getBlockState(...)");
                ductTankBlock.nodeRemove(blockState, level2, blockPos, blockState2, false);
            }
        }
        this.controllerCT = null;
        this.heightCT = 1;
        this.widthCT = 1;
        this.queueConnectivityUpdate();
        this.notifyMultiUpdated();
        block = this.m_58900_().m_60734_();
        DuctTankBlock ductTankBlock = block instanceof DuctTankBlock ? (DuctTankBlock)block : null;
        if (ductTankBlock != null) {
            BlockState blockState = this.m_58900_();
            Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"getBlockState(...)");
            Level level3 = this.f_58857_;
            Intrinsics.checkNotNull((Object)level3);
            BlockPos blockPos = this.m_58899_();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
            BlockState blockState3 = this.m_58900_();
            Intrinsics.checkNotNullExpressionValue((Object)blockState3, (String)"getBlockState(...)");
            ductTankBlock.nodePlace(blockState, level3, blockPos, blockState3, false);
        }
        BlockState state = this.m_58900_();
        state = (BlockState)state.m_61124_((Property)DuctTankBlock.Companion.getTOP(), (Comparable)Boolean.valueOf(true));
        state = (BlockState)state.m_61124_((Property)DuctTankBlock.Companion.getBOTTOM(), (Comparable)Boolean.valueOf(true));
        state = (BlockState)state.m_61124_((Property)DuctTankBlock.Companion.getLARGE(), (Comparable)Boolean.valueOf(false));
        Level level4 = this.f_58857_;
        Intrinsics.checkNotNull((Object)level4);
        level4.m_7731_(this.f_58858_, state, 23);
        this.m_6596_();
        this.sendData();
    }

    @NotNull
    public BlockPos getLastKnownPos() {
        BlockPos blockPos = this.lastKnownPosCT;
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"lastKnownPosCT");
        return blockPos;
    }

    public void preventConnectivityUpdate() {
        this.updateConnectivity = false;
    }

    @NotNull
    public Direction.Axis getMainConnectionAxis() {
        return Direction.Axis.Y;
    }

    public int getMaxLength(@NotNull Direction.Axis longAxis, int width) {
        Intrinsics.checkNotNullParameter((Object)longAxis, (String)"longAxis");
        return longAxis == Direction.Axis.Y ? this.maxHeight : this.getMaxWidth();
    }

    public int getMaxWidth() {
        return 3;
    }

    public int getHeight() {
        return this.heightCT;
    }

    public void setHeight(int height) {
        this.heightCT = height;
    }

    public int getWidth() {
        return this.widthCT;
    }

    public void setWidth(int width) {
        this.widthCT = width;
    }
}

