/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.logistics.gas.smart;

import io.netty.buffer.ByteBuf;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.createmod.catnip.gui.ScreenOpener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3dc;
import org.valkyrienskies.clockwork.content.logistics.gas.smart.SmartDuctScreen;
import org.valkyrienskies.clockwork.platform.api.network.ClientNetworkContext;
import org.valkyrienskies.clockwork.platform.api.network.S2CCWPacket;
import org.valkyrienskies.core.util.VSCoreUtilKt;
import org.valkyrienskies.kelvin.api.DuctNodePos;
import org.valkyrienskies.kelvin.api.edges.SmartEdge;
import org.valkyrienskies.kelvin.util.KelvinExtensions;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\u0006\u0010\u000e\u001a\u00020\u000b\u0012\u0006\u0010\u0010\u001a\u00020\u000f\u0012\u0006\u0010\u0013\u001a\u00020\u0012\u0012\u0006\u0010\u0016\u001a\u00020\u0015\u0012\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u0018\u00a2\u0006\u0004\b\u001f\u0010 B\u0011\b\u0016\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\u001f\u0010\nJ\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\t\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\t\u0010\nR\u0014\u0010\f\u001a\u00020\u000b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\rR\u0014\u0010\u0010\u001a\u00020\u000f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0013\u001a\u00020\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0016\u001a\u00020\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017R$\u0010\u0019\u001a\u0004\u0018\u00010\u00188\u0016@\u0016X\u0096\u000e\u00a2\u0006\u0012\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001e\u00a8\u0006!"}, d2={"Lorg/valkyrienskies/clockwork/content/logistics/gas/smart/SmartScreenOpenPacket;", "Lorg/valkyrienskies/clockwork/platform/api/network/S2CCWPacket;", "Lorg/valkyrienskies/clockwork/platform/api/network/ClientNetworkContext;", "context", "", "handle", "(Lorg/valkyrienskies/clockwork/platform/api/network/ClientNetworkContext;)V", "Lnet/minecraft/network/FriendlyByteBuf;", "buffer", "write", "(Lnet/minecraft/network/FriendlyByteBuf;)V", "Lorg/valkyrienskies/kelvin/api/DuctNodePos;", "nodeA", "Lorg/valkyrienskies/kelvin/api/DuctNodePos;", "nodeB", "Lorg/valkyrienskies/kelvin/api/edges/SmartEdge$FilterType;", "filter", "Lorg/valkyrienskies/kelvin/api/edges/SmartEdge$FilterType;", "", "comparisonValue", "D", "", "moreThan", "Z", "Lnet/minecraft/world/entity/player/Player;", "player", "Lnet/minecraft/world/entity/player/Player;", "getPlayer", "()Lnet/minecraft/world/entity/player/Player;", "setPlayer", "(Lnet/minecraft/world/entity/player/Player;)V", "<init>", "(Lorg/valkyrienskies/kelvin/api/DuctNodePos;Lorg/valkyrienskies/kelvin/api/DuctNodePos;Lorg/valkyrienskies/kelvin/api/edges/SmartEdge$FilterType;DZLnet/minecraft/world/entity/player/Player;)V", "clockwork"})
public final class SmartScreenOpenPacket
implements S2CCWPacket {
    @NotNull
    private final DuctNodePos nodeA;
    @NotNull
    private final DuctNodePos nodeB;
    @NotNull
    private final SmartEdge.FilterType filter;
    private final double comparisonValue;
    private final boolean moreThan;
    @Nullable
    private Player player;

    public SmartScreenOpenPacket(@NotNull DuctNodePos nodeA, @NotNull DuctNodePos nodeB, @NotNull SmartEdge.FilterType filter, double comparisonValue, boolean moreThan, @Nullable Player player) {
        Intrinsics.checkNotNullParameter((Object)nodeA, (String)"nodeA");
        Intrinsics.checkNotNullParameter((Object)nodeB, (String)"nodeB");
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        this.nodeA = nodeA;
        this.nodeB = nodeB;
        this.filter = filter;
        this.comparisonValue = comparisonValue;
        this.moreThan = moreThan;
        this.player = player;
    }

    public /* synthetic */ SmartScreenOpenPacket(DuctNodePos ductNodePos, DuctNodePos ductNodePos2, SmartEdge.FilterType filterType, double d, boolean bl, Player player, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            player = null;
        }
        this(ductNodePos, ductNodePos2, filterType, d, bl, player);
    }

    @Override
    @Nullable
    public Player getPlayer() {
        return this.player;
    }

    @Override
    public void setPlayer(@Nullable Player player) {
        this.player = player;
    }

    public SmartScreenOpenPacket(@NotNull FriendlyByteBuf buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Vector3dc vector3dc = (Vector3dc)VSCoreUtilKt.readVec3d((ByteBuf)((ByteBuf)buffer));
        ResourceLocation resourceLocation = buffer.m_130281_();
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"readResourceLocation(...)");
        DuctNodePos ductNodePos = KelvinExtensions.INSTANCE.toDuctNodePos(vector3dc, resourceLocation);
        Vector3dc vector3dc2 = (Vector3dc)VSCoreUtilKt.readVec3d((ByteBuf)((ByteBuf)buffer));
        ResourceLocation resourceLocation2 = buffer.m_130281_();
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation2, (String)"readResourceLocation(...)");
        DuctNodePos ductNodePos2 = KelvinExtensions.INSTANCE.toDuctNodePos(vector3dc2, resourceLocation2);
        Enum enum_ = buffer.m_130066_(SmartEdge.FilterType.class);
        Intrinsics.checkNotNullExpressionValue((Object)enum_, (String)"readEnum(...)");
        this(ductNodePos, ductNodePos2, (SmartEdge.FilterType)enum_, buffer.readDouble(), buffer.readBoolean(), null, 32, null);
    }

    @Override
    public void handle(@NotNull ClientNetworkContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        context.enqueueWork(() -> SmartScreenOpenPacket.handle$lambda$0(this));
        context.setPacketHandled(true);
    }

    @Override
    public void write(@NotNull FriendlyByteBuf buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        VSCoreUtilKt.writeVec3d((ByteBuf)((ByteBuf)buffer), (Vector3dc)((Vector3dc)KelvinExtensions.INSTANCE.toVector3d(KelvinExtensions.INSTANCE.toMinecraft(this.nodeA))));
        buffer.m_130085_(this.nodeA.getDimensionId());
        VSCoreUtilKt.writeVec3d((ByteBuf)((ByteBuf)buffer), (Vector3dc)((Vector3dc)KelvinExtensions.INSTANCE.toVector3d(KelvinExtensions.INSTANCE.toMinecraft(this.nodeB))));
        buffer.m_130085_(this.nodeB.getDimensionId());
        buffer.m_130068_((Enum)this.filter);
        buffer.writeDouble(this.comparisonValue / (double)1000);
        buffer.writeBoolean(this.moreThan);
    }

    private static final void handle$lambda$0(SmartScreenOpenPacket this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        ScreenOpener.open((Screen)((Screen)new SmartDuctScreen(this$0.nodeA, this$0.nodeB, this$0.filter, this$0.comparisonValue, this$0.moreThan)));
    }
}

