/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.logistics.gas.pockets.nozzle;

import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.math.MathKt;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.lang.LangBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3ic;
import org.valkyrienskies.clockwork.ClockworkAugmentations;
import org.valkyrienskies.clockwork.ClockworkLang;
import org.valkyrienskies.clockwork.ClockworkMod;
import org.valkyrienskies.clockwork.ClockworkModClient;
import org.valkyrienskies.clockwork.ClockworkSounds;
import org.valkyrienskies.clockwork.content.forces.BalloonController;
import org.valkyrienskies.clockwork.content.forces.data.BalloonData;
import org.valkyrienskies.clockwork.content.logistics.gas.pockets.nozzle.GasNozzleBlock;
import org.valkyrienskies.clockwork.content.logistics.gas.pockets.nozzle.GasNozzleSoundInstance;
import org.valkyrienskies.clockwork.content.logistics.gas.pockets.nozzle.LeakParticleData;
import org.valkyrienskies.clockwork.util.ClockworkUtils;
import org.valkyrienskies.clockwork.util.KNodeKineticBlockEntity;
import org.valkyrienskies.clockwork.util.KelvinParticleHelper;
import org.valkyrienskies.clockwork.util.gui.ClockworkTooltipHelper;
import org.valkyrienskies.clockwork.util.gui.DuctTextUtil;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.kelvin.KelvinMod;
import org.valkyrienskies.kelvin.api.DuctNodePos;
import org.valkyrienskies.kelvin.api.GasType;
import org.valkyrienskies.kelvin.impl.client.DuctNetworkClient;
import org.valkyrienskies.kelvin.impl.registry.GasTypeRegistry;
import org.valkyrienskies.kelvin.util.KelvinExtensions;
import org.valkyrienskies.mod.api.ValkyrienSkies;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B#\u0012\n\u0010^\u001a\u0006\u0012\u0002\b\u00030]\u0012\u0006\u0010`\u001a\u00020_\u0012\u0006\u0010b\u001a\u00020a\u00a2\u0006\u0004\bc\u0010dJ\u001f\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004H\u0014\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001f\u0010\t\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004H\u0014\u00a2\u0006\u0004\b\t\u0010\bJ\u001f\u0010\r\u001a\u00020\u00062\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001d\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0015\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\r\u0010\u0017\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0017\u0010\u0016J\u000f\u0010\u0018\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0016J\r\u0010\u0019\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0019\u0010\u0016J\u0017\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001aH\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\r\u0010\u001e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u000f\u0010 \u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b \u0010\u0016J\u000f\u0010!\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b!\u0010\u0016J\u000f\u0010\"\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\"\u0010\u0016J\u000f\u0010$\u001a\u00020#H\u0016\u00a2\u0006\u0004\b$\u0010%J'\u0010*\u001a\u00020\u00042\u000e\u0010(\u001a\n\u0012\u0004\u0012\u00020'\u0018\u00010&2\u0006\u0010)\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b*\u0010+R\"\u0010,\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b,\u0010-\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R\"\u00102\u001a\u00020\u000f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b2\u00103\u001a\u0004\b4\u0010\u001f\"\u0004\b5\u00106R\"\u00108\u001a\u0002078\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b8\u00109\u001a\u0004\b:\u0010;\"\u0004\b<\u0010=R\u0017\u0010?\u001a\u00020>8\u0006\u00a2\u0006\f\n\u0004\b?\u0010@\u001a\u0004\bA\u0010BR\"\u0010C\u001a\u00020\u000f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bC\u00103\u001a\u0004\bD\u0010\u001f\"\u0004\bE\u00106R\"\u0010F\u001a\u00020\u000f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bF\u00103\u001a\u0004\bG\u0010\u001f\"\u0004\bH\u00106R\"\u0010I\u001a\u00020\u000f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bI\u00103\u001a\u0004\bJ\u0010\u001f\"\u0004\bK\u00106R$\u0010M\u001a\u0004\u0018\u00010L8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bM\u0010N\u001a\u0004\bO\u0010P\"\u0004\bQ\u0010RR\"\u0010S\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bS\u0010-\u001a\u0004\bT\u0010/\"\u0004\bU\u00101R$\u0010W\u001a\u0004\u0018\u00010V8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\bW\u0010X\u001a\u0004\bY\u0010Z\"\u0004\b[\u0010\\\u00a8\u0006e"}, d2={"Lorg/valkyrienskies/clockwork/content/logistics/gas/pockets/nozzle/GasNozzleBlockEntity;", "Lorg/valkyrienskies/clockwork/util/KNodeKineticBlockEntity;", "Lnet/minecraft/nbt/CompoundTag;", "tag", "", "clientPacket", "", "write", "(Lnet/minecraft/nbt/CompoundTag;Z)V", "read", "", "Lcom/simibubi/create/foundation/blockEntity/behaviour/BlockEntityBehaviour;", "behaviours", "addBehaviours", "(Ljava/util/List;)V", "", "deviation", "Lnet/minecraft/util/RandomSource;", "random", "randomPos", "(DLnet/minecraft/util/RandomSource;)D", "invalidate", "()V", "clientInvalidate", "tick", "fetchBloon", "", "previousSpeed", "onSpeedChanged", "(F)V", "getChaseSpeed", "()D", "heatBalloon", "heatPocket", "heatPocketOld", "Lorg/valkyrienskies/kelvin/api/DuctNodePos;", "getDuctNodePosition", "()Lorg/valkyrienskies/kelvin/api/DuctNodePos;", "", "Lnet/minecraft/network/chat/Component;", "tooltip", "isPlayerSneaking", "addToGoggleTooltip", "(Ljava/util/List;Z)Z", "hasPocket", "Z", "getHasPocket", "()Z", "setHasPocket", "(Z)V", "pointerSpeed", "D", "getPointerSpeed", "setPointerSpeed", "(D)V", "", "scanCooldown", "I", "getScanCooldown", "()I", "setScanCooldown", "(I)V", "Lnet/createmod/catnip/animation/LerpedFloat;", "pointer", "Lnet/createmod/catnip/animation/LerpedFloat;", "getPointer", "()Lnet/createmod/catnip/animation/LerpedFloat;", "currentIdealOutput", "getCurrentIdealOutput", "setCurrentIdealOutput", "pocketTemperature", "getPocketTemperature", "setPocketTemperature", "balloonVolume", "getBalloonVolume", "setBalloonVolume", "Lorg/valkyrienskies/clockwork/content/forces/data/BalloonData;", "balloon", "Lorg/valkyrienskies/clockwork/content/forces/data/BalloonData;", "getBalloon", "()Lorg/valkyrienskies/clockwork/content/forces/data/BalloonData;", "setBalloon", "(Lorg/valkyrienskies/clockwork/content/forces/data/BalloonData;)V", "shouldFetchNextTick", "getShouldFetchNextTick", "setShouldFetchNextTick", "Lorg/valkyrienskies/clockwork/content/logistics/gas/pockets/nozzle/GasNozzleSoundInstance;", "soundInstance", "Lorg/valkyrienskies/clockwork/content/logistics/gas/pockets/nozzle/GasNozzleSoundInstance;", "getSoundInstance", "()Lorg/valkyrienskies/clockwork/content/logistics/gas/pockets/nozzle/GasNozzleSoundInstance;", "setSoundInstance", "(Lorg/valkyrienskies/clockwork/content/logistics/gas/pockets/nozzle/GasNozzleSoundInstance;)V", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "type", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "<init>", "(Lnet/minecraft/world/level/block/entity/BlockEntityType;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "clockwork"})
@SourceDebugExtension(value={"SMAP\nGasNozzleBlockEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GasNozzleBlockEntity.kt\norg/valkyrienskies/clockwork/content/logistics/gas/pockets/nozzle/GasNozzleBlockEntity\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,472:1\n216#2,2:473\n216#2,2:475\n*S KotlinDebug\n*F\n+ 1 GasNozzleBlockEntity.kt\norg/valkyrienskies/clockwork/content/logistics/gas/pockets/nozzle/GasNozzleBlockEntity\n*L\n296#1:473,2\n328#1:475,2\n*E\n"})
public final class GasNozzleBlockEntity
extends KNodeKineticBlockEntity {
    private boolean hasPocket;
    private double pointerSpeed;
    private int scanCooldown;
    @NotNull
    private final LerpedFloat pointer;
    private double currentIdealOutput;
    private double pocketTemperature;
    private double balloonVolume;
    @Nullable
    private BalloonData balloon;
    private boolean shouldFetchNextTick;
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    private GasNozzleSoundInstance soundInstance;

    public GasNozzleBlockEntity(@NotNull BlockEntityType<?> type, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(type, pos, state);
        LerpedFloat lerpedFloat = LerpedFloat.linear().startWithValue(0.5).chase(0.5, this.pointerSpeed, LerpedFloat.Chaser.LINEAR);
        Intrinsics.checkNotNullExpressionValue((Object)lerpedFloat, (String)"chase(...)");
        this.pointer = lerpedFloat;
    }

    public final boolean getHasPocket() {
        return this.hasPocket;
    }

    public final void setHasPocket(boolean bl) {
        this.hasPocket = bl;
    }

    public final double getPointerSpeed() {
        return this.pointerSpeed;
    }

    public final void setPointerSpeed(double d) {
        this.pointerSpeed = d;
    }

    public final int getScanCooldown() {
        return this.scanCooldown;
    }

    public final void setScanCooldown(int n) {
        this.scanCooldown = n;
    }

    @NotNull
    public final LerpedFloat getPointer() {
        return this.pointer;
    }

    public final double getCurrentIdealOutput() {
        return this.currentIdealOutput;
    }

    public final void setCurrentIdealOutput(double d) {
        this.currentIdealOutput = d;
    }

    public final double getPocketTemperature() {
        return this.pocketTemperature;
    }

    public final void setPocketTemperature(double d) {
        this.pocketTemperature = d;
    }

    public final double getBalloonVolume() {
        return this.balloonVolume;
    }

    public final void setBalloonVolume(double d) {
        this.balloonVolume = d;
    }

    @Nullable
    public final BalloonData getBalloon() {
        return this.balloon;
    }

    public final void setBalloon(@Nullable BalloonData balloonData) {
        this.balloon = balloonData;
    }

    public final boolean getShouldFetchNextTick() {
        return this.shouldFetchNextTick;
    }

    public final void setShouldFetchNextTick(boolean bl) {
        this.shouldFetchNextTick = bl;
    }

    @Nullable
    public final GasNozzleSoundInstance getSoundInstance() {
        return this.soundInstance;
    }

    public final void setSoundInstance(@Nullable GasNozzleSoundInstance gasNozzleSoundInstance) {
        this.soundInstance = gasNozzleSoundInstance;
    }

    @Override
    protected void write(@NotNull CompoundTag tag, boolean clientPacket) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        tag.m_128347_("pointer_value", (double)this.pointer.getValue());
        tag.m_128347_("pointer_target", (double)this.pointer.getChaseTarget());
        tag.m_128347_("pointer_speed", this.pointerSpeed);
        tag.m_128379_("has_pocket", this.hasPocket);
        tag.m_128347_("pocket_temperature", this.pocketTemperature);
        tag.m_128347_("balloon_volume", this.balloonVolume);
        tag.m_128405_("leaks", (int)this.currentIdealOutput);
        super.write(tag, clientPacket);
    }

    @Override
    protected void read(@NotNull CompoundTag tag, boolean clientPacket) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        super.read(tag, clientPacket);
        double target = tag.m_128459_("pointer_target");
        this.pointerSpeed = tag.m_128459_("pointer_speed");
        this.hasPocket = tag.m_128471_("has_pocket");
        this.pocketTemperature = tag.m_128459_("pocket_temperature");
        this.balloonVolume = tag.m_128459_("balloon_volume");
        this.currentIdealOutput = tag.m_128451_("leaks");
        this.pointer.startWithValue(tag.m_128459_("pointer_value"));
        this.pointer.chase(target, this.pointerSpeed, LerpedFloat.Chaser.LINEAR);
    }

    public void addBehaviours(@Nullable List<BlockEntityBehaviour> behaviours) {
    }

    public final double randomPos(double deviation, @NotNull RandomSource random) {
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        return 0.5 - deviation / 2.0 + random.m_188500_() * deviation;
    }

    public void invalidate() {
        if (this.f_58857_ != null) {
            Level level = this.f_58857_;
            Intrinsics.checkNotNull((Object)level);
            if (level.f_46443_) {
                this.clientInvalidate();
            }
        }
        super.invalidate();
    }

    public final void clientInvalidate() {
        GasNozzleSoundInstance gasNozzleSoundInstance = this.soundInstance;
        if (gasNozzleSoundInstance != null) {
            gasNozzleSoundInstance.stopNow();
        }
        this.soundInstance = null;
    }

    public void tick() {
        block18: {
            block17: {
                super.tick();
                this.pointer.tickChaser();
                if (this.f_58857_ != null) {
                    Level level = this.f_58857_;
                    Intrinsics.checkNotNull((Object)level);
                    if (level.f_46443_ && this.hasPocket) {
                        Level level2 = this.f_58857_;
                        Intrinsics.checkNotNull((Object)level2);
                        BlockState state = level2.m_8055_(this.m_58899_());
                        if (!(state.m_60734_() instanceof GasNozzleBlock)) {
                            return;
                        }
                        Direction facing = Direction.UP;
                        Level level3 = this.f_58857_;
                        Intrinsics.checkNotNull((Object)level3);
                        RandomSource random = level3.f_46441_;
                        DuctNetworkClient network = ClockworkModClient.getKelvin();
                        HashMap entry = network.getGasMassAt(this.getDuctNodePosition());
                        double pressure = network.getPressureAt(this.getDuctNodePosition());
                        double MASS_PER_EXHAUST = 0.001;
                        int i = 1;
                        Collection collection = entry.values();
                        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
                        int n = (int)Math.floor(CollectionsKt.sumOfDouble((Iterable)collection) * (double)this.pointer.getValue() / MASS_PER_EXHAUST);
                        int n2 = 60;
                        int n3 = Math.min(n, n2);
                        if (i <= n3) {
                            while (true) {
                                Level level4 = this.f_58857_;
                                Intrinsics.checkNotNull((Object)level4, (String)"null cannot be cast to non-null type net.minecraft.client.multiplayer.ClientLevel");
                                ClientLevel clientLevel = (ClientLevel)level4;
                                DuctNodePos ductNodePos = this.getDuctNodePosition();
                                BlockPos blockPos = this.m_58899_();
                                Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
                                Vector3d vector3d = VectorConversionsMCKt.toJOMLD((Vec3i)((Vec3i)blockPos));
                                Intrinsics.checkNotNull((Object)random);
                                Vector3d vector3d2 = vector3d.add(this.randomPos(0.3, random), this.randomPos(0.3, random), this.randomPos(0.3, random));
                                Intrinsics.checkNotNullExpressionValue((Object)vector3d2, (String)"add(...)");
                                Vector3dc vector3dc = (Vector3dc)vector3d2;
                                Vec3i vec3i = facing.m_122436_();
                                Intrinsics.checkNotNullExpressionValue((Object)vec3i, (String)"getNormal(...)");
                                Vector3d vector3d3 = VectorConversionsMCKt.toJOMLD((Vec3i)vec3i).mul(Mth.m_14008_((double)(0.0025 * Math.pow(pressure, 0.4)), (double)0.1, (double)5.0));
                                Intrinsics.checkNotNullExpressionValue((Object)vector3d3, (String)"mul(...)");
                                KelvinParticleHelper.INSTANCE.spawnParticleWithRatio(clientLevel, ductNodePos, vector3dc, (Vector3dc)vector3d3);
                                if (i == n3) break;
                                ++i;
                            }
                        }
                        if (this.soundInstance == null) {
                            Intrinsics.checkNotNull((Object)random);
                            this.soundInstance = new GasNozzleSoundInstance(this, random);
                            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)this.soundInstance);
                        }
                    }
                }
                if (this.f_58857_ == null) break block17;
                Level level = this.f_58857_;
                Intrinsics.checkNotNull((Object)level);
                if (!level.f_46443_) break block18;
            }
            return;
        }
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        ServerLevel serverLevel = (ServerLevel)level;
        boolean oldHas = this.hasPocket;
        if (this.shouldFetchNextTick && this.scanCooldown <= 0) {
            this.fetchBloon();
            this.shouldFetchNextTick = false;
        }
        if (this.scanCooldown > 0) {
            int random = this.scanCooldown;
            this.scanCooldown = random + -1;
        }
        if (oldHas != this.hasPocket) {
            if (this.hasPocket) {
                BlockPos blockPos = this.m_58899_();
                Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
                LoadedServerShip shipOn = VSGameUtilsKt.getLoadedShipManagingPos((ServerLevel)serverLevel, (Vec3i)((Vec3i)blockPos));
                Vector3f upInWorld = shipOn != null ? shipOn.getTransform().getRotation().transform(Direction.UP.m_253071_()) : Direction.UP.m_253071_();
                BlockPos blockPos2 = this.m_58899_();
                SoundEvent soundEvent = ClockworkSounds.INSTANCE.getGAS_NOZZLE_START().getMainEvent();
                Intrinsics.checkNotNull((Object)soundEvent);
                serverLevel.m_5594_(null, blockPos2, soundEvent, SoundSource.BLOCKS, 1.0f, 0.5f + 0.5f * serverLevel.f_46441_.m_188501_());
                Intrinsics.checkNotNull((Object)upInWorld);
                serverLevel.m_8767_((ParticleOptions)new LeakParticleData(upInWorld, 2.0f), (double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 1.0, (double)this.m_58899_().m_123343_() + 0.5, 5, 0.3, 0.3, 0.3, 1.0);
            }
            this.sendData();
        }
        if (this.hasPocket) {
            BalloonData balloonData = this.balloon;
            boolean bl = balloonData != null ? balloonData.getShouldRemove() : false;
            if (bl || this.balloon == null) {
                this.shouldFetchNextTick = true;
                this.hasPocket = false;
                this.sendData();
                return;
            }
            this.heatBalloon();
            if (this.balloon != null) {
                double currentPocketTemperature;
                HashMap pocketGasMass = new HashMap();
                BalloonData balloonData2 = this.balloon;
                Intrinsics.checkNotNull((Object)balloonData2);
                for (Map.Entry entry : ((Map)balloonData2.getGasMasses()).entrySet()) {
                    GasType gasType;
                    String key = (String)entry.getKey();
                    double value = ((Number)entry.getValue()).doubleValue();
                    if (GasTypeRegistry.INSTANCE.getGasType(new ResourceLocation(key)) == null) continue;
                    Double d = value;
                    ((Map)pocketGasMass).put(gasType, d);
                }
                BalloonData balloonData3 = this.balloon;
                Intrinsics.checkNotNull((Object)balloonData3);
                double pocketHeatEnergy = balloonData3.getCurrentEnergy();
                double pocketCapacity = ClockworkMod.getKelvin().mixtureCapacity((Map)pocketGasMass);
                this.pocketTemperature = currentPocketTemperature = pocketHeatEnergy / pocketCapacity;
                BalloonData balloonData4 = this.balloon;
                Intrinsics.checkNotNull((Object)balloonData4);
                this.balloonVolume = balloonData4.getCurrentVolume();
                BalloonData balloonData5 = this.balloon;
                Intrinsics.checkNotNull((Object)balloonData5);
                this.currentIdealOutput = balloonData5.getMissingExternalPositions();
                this.sendData();
            }
        }
    }

    public final void fetchBloon() {
        Level level = this.f_58857_;
        ServerLevel serverLevel = level instanceof ServerLevel ? (ServerLevel)level : null;
        if (serverLevel == null) {
            return;
        }
        ServerLevel serverLevel2 = serverLevel;
        BlockPos blockPos = this.m_58899_();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
        LoadedServerShip loadedServerShip = VSGameUtilsKt.getLoadedShipManagingPos((ServerLevel)serverLevel2, (Vec3i)((Vec3i)blockPos));
        if (loadedServerShip == null) {
            return;
        }
        LoadedServerShip ship = loadedServerShip;
        BalloonController controller = BalloonController.Companion.getOrCreate(ship);
        BlockPos blockPos2 = this.m_58899_().m_7494_();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos2, (String)"above(...)");
        int balloonId = controller.tryGetOrCreateBalloon(blockPos2, (Level)serverLevel2);
        this.balloon = controller.getBalloonById(balloonId);
        this.hasPocket = this.balloon != null;
        BalloonData balloonData = this.balloon;
        this.balloonVolume = balloonData != null ? balloonData.getCurrentVolume() : 0.0;
        this.scanCooldown = 60;
    }

    public void onSpeedChanged(float previousSpeed) {
        super.onSpeedChanged(previousSpeed);
        float speed = this.getSpeed();
        double target = speed > 0.0f ? 1 : 0;
        this.pointerSpeed = this.getChaseSpeed();
        this.pointer.chase(target, this.pointerSpeed, LerpedFloat.Chaser.LINEAR);
        this.sendData();
    }

    public final double getChaseSpeed() {
        return Mth.m_14008_((double)(Math.abs((double)this.getSpeed()) / 16.0 / 40.0), (double)0.0, (double)1.0);
    }

    private final void heatBalloon() {
        BalloonData balloonData = this.balloon;
        if (balloonData == null) {
            return;
        }
        BalloonData balloon = balloonData;
        if (this.pointer.getValue() <= 0.0f) {
            return;
        }
        HashMap pocketGasMass = new HashMap();
        for (Map.Entry entry : ((Map)balloon.getGasMasses()).entrySet()) {
            GasType gasType;
            String key = (String)entry.getKey();
            double value = ((Number)entry.getValue()).doubleValue();
            if (GasTypeRegistry.INSTANCE.getGasType(new ResourceLocation(key)) == null) continue;
            Double d = value;
            ((Map)pocketGasMass).put(gasType, d);
        }
        double pocketHeatEnergy = balloon.getCurrentEnergy();
        HashMap gasMass = ClockworkMod.getKelvin().getGasMassAt(this.getDuctNodePosition());
        Collection collection = gasMass.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        double gasMassTotal = CollectionsKt.sumOfDouble((Iterable)collection);
        double heatEnergy = ClockworkMod.getKelvin().getHeatEnergy(this.getDuctNodePosition());
        double pocketCapacity = ClockworkMod.getKelvin().mixtureCapacity((Map)pocketGasMass);
        double currentPocketTemperature = pocketHeatEnergy / pocketCapacity;
        double targetTemperature = ClockworkMod.getKelvin().getTemperatureAt(this.getDuctNodePosition()) * (double)this.pointer.getValue();
        if (currentPocketTemperature >= targetTemperature) {
            return;
        }
        double maxEnergyAddedThisTick = heatEnergy / 2.0;
        double energyToAdd = Math.min(pocketCapacity * Math.min(targetTemperature - currentPocketTemperature, 100.0), maxEnergyAddedThisTick);
        double usedUpMass = gasMassTotal * (double)this.pointer.getValue();
        double usedEnergy = Math.min(heatEnergy, energyToAdd) * (double)this.pointer.getValue();
        balloon.setCurrentEnergy(pocketHeatEnergy + usedEnergy);
        Map $this$forEach$iv = gasMass;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator.next();
            boolean bl = false;
            KelvinMod.INSTANCE.getKelvin().removeGas(this.getDuctNodePosition(), (GasType)it.getKey(), usedUpMass * ((Number)it.getValue()).doubleValue() / gasMassTotal);
        }
        this.sendData();
    }

    private final void heatPocket() {
        Pair<HashMap<GasType, Double>, Double> pair = this.f_58857_;
        ServerLevel serverLevel = pair instanceof ServerLevel ? (ServerLevel)pair : null;
        if (serverLevel == null) {
            return;
        }
        ServerLevel serverLevel2 = serverLevel;
        BlockPos pocketRef = this.m_58899_().m_7494_();
        Intrinsics.checkNotNull((Object)pocketRef);
        pair = ClockworkUtils.INSTANCE.retrieveGasInfoFromPocket((Vector3ic)KelvinExtensions.INSTANCE.toVector3i(pocketRef), serverLevel2);
        HashMap pocketGasMass = (HashMap)pair.component1();
        double pocketHeatEnergy = ((Number)pair.component2()).doubleValue();
        Collection collection = pocketGasMass.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        double pocketGasMassTotal = CollectionsKt.sumOfDouble((Iterable)collection);
        HashMap gasMass = ClockworkMod.getKelvin().getGasMassAt(this.getDuctNodePosition());
        Collection collection2 = gasMass.values();
        Intrinsics.checkNotNullExpressionValue(collection2, (String)"<get-values>(...)");
        double gasMassTotal = CollectionsKt.sumOfDouble((Iterable)collection2);
        double heatEnergy = ClockworkMod.getKelvin().getHeatEnergy(this.getDuctNodePosition());
        double usedUpMass = gasMassTotal * (double)this.pointer.getValue();
        double usedEnergy = heatEnergy * (double)this.pointer.getValue();
        this.pocketTemperature = (pocketHeatEnergy + usedEnergy) / ClockworkMod.getKelvin().mixtureCapacity((Map)pocketGasMass);
        VSGameUtilsKt.getShipObjectWorld((ServerLevel)serverLevel2).setAirComponentAugmentation(ClockworkAugmentations.INSTANCE.getComponentAugmentation("heatEnergy"), this.m_58899_().m_123341_(), this.m_58899_().m_123342_() + 1, this.m_58899_().m_123343_(), VSGameUtilsKt.getDimensionId((Level)((Level)serverLevel2)), pocketHeatEnergy + usedEnergy);
        Map $this$forEach$iv = gasMass;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator.next();
            boolean bl = false;
            KelvinMod.INSTANCE.getKelvin().removeGas(this.getDuctNodePosition(), (GasType)it.getKey(), usedUpMass * ((Number)it.getValue()).doubleValue() / gasMassTotal);
        }
        this.sendData();
    }

    private final void heatPocketOld() {
    }

    @Override
    @NotNull
    public DuctNodePos getDuctNodePosition() {
        if (this.f_58857_ != null) {
            BlockPos blockPos = this.m_58899_();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
            Level level = this.f_58857_;
            Intrinsics.checkNotNull((Object)level);
            ResourceLocation resourceLocation = level.m_46472_().m_135782_();
            Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"location(...)");
            return KelvinExtensions.INSTANCE.toDuctNodePos(blockPos, resourceLocation);
        }
        BlockPos blockPos = this.m_58899_();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
        return KelvinExtensions.toDuctNodePos$default((KelvinExtensions)KelvinExtensions.INSTANCE, (BlockPos)blockPos, null, (int)1, null);
    }

    @Override
    public boolean addToGoggleTooltip(@Nullable List<? extends Component> tooltip, boolean isPlayerSneaking) {
        LangBuilder langBuilder = ClockworkLang.translate("gui.gas_nozzle.info.title", new Object[0]);
        Intrinsics.checkNotNull(tooltip, (String)"null cannot be cast to non-null type kotlin.collections.MutableList<net.minecraft.network.chat.Component>");
        langBuilder.forGoggles(TypeIntrinsics.asMutableList(tooltip));
        if (!ValkyrienSkies.isBlockInShipyard((Level)this.f_58857_, (int)this.m_58899_().m_123341_(), (int)this.m_58899_().m_123342_(), (int)this.m_58899_().m_123343_())) {
            ClockworkTooltipHelper.addHint$default(ClockworkTooltipHelper.INSTANCE, tooltip, "gui.gas_nozzle.info.no_ship", ChatFormatting.GOLD, 0, 0, new Object[0], 24, null);
        }
        if (!this.hasPocket || Double.isNaN(this.pocketTemperature)) {
            Object[] objectArray = new Object[]{Minecraft.m_91087_().f_91066_.f_92095_.m_90863_()};
            ClockworkTooltipHelper.INSTANCE.addHint(tooltip, "gui.gas_nozzle.info.no_pocket", ChatFormatting.GOLD, 0, 0, objectArray);
        } else {
            Object[] objectArray = new Object[1];
            LangBuilder langBuilder2 = ClockworkLang.builder();
            Intrinsics.checkNotNullExpressionValue((Object)langBuilder2, (String)"builder(...)");
            objectArray[0] = DuctTextUtil.translateVolume$default(langBuilder2, this.balloonVolume, true, null, 8, null);
            ClockworkLang.translate("gui.gas_nozzle.info.volume", objectArray).style(ChatFormatting.GREEN).forGoggles(tooltip);
            objectArray = new Object[1];
            LangBuilder langBuilder3 = ClockworkLang.builder();
            Intrinsics.checkNotNullExpressionValue((Object)langBuilder3, (String)"builder(...)");
            objectArray[0] = DuctTextUtil.translateTemperature$default(langBuilder3, this.pocketTemperature, true, null, 8, null);
            ClockworkLang.translate("gui.gas_nozzle.info.temperature", objectArray).style(ChatFormatting.GOLD).forGoggles(tooltip);
            if (isPlayerSneaking) {
                double targetTemperature = ClockworkModClient.getKelvin().getTemperatureAt(this.getDuctNodePosition()) * (double)this.pointer.getValue();
                Object[] objectArray2 = new Object[1];
                LangBuilder langBuilder4 = ClockworkLang.builder();
                Intrinsics.checkNotNullExpressionValue((Object)langBuilder4, (String)"builder(...)");
                objectArray2[0] = DuctTextUtil.translateTemperature$default(langBuilder4, targetTemperature, true, null, 8, null);
                ClockworkLang.translate("gui.gas_nozzle.info.target_temperature", objectArray2).style(ChatFormatting.YELLOW).style(ChatFormatting.ITALIC).forGoggles(tooltip);
            }
            if ((int)this.currentIdealOutput != 0) {
                Component component = CommonComponents.f_237098_;
                Intrinsics.checkNotNullExpressionValue((Object)component, (String)"EMPTY");
                tooltip.add(component);
                ClockworkTooltipHelper.addHint$default(ClockworkTooltipHelper.INSTANCE, tooltip, "gui.gas_nozzle.info.leak", ChatFormatting.RED, -2, 0, new Object[0], 16, null);
                Object[] objectArray3 = new Object[]{MathKt.roundToInt((double)this.currentIdealOutput)};
                ClockworkLang.translate("gui.gas_nozzle.info.leak.count", objectArray3).style(ChatFormatting.RED).forGoggles(tooltip);
            }
        }
        Component component = CommonComponents.f_237098_;
        Intrinsics.checkNotNullExpressionValue((Object)component, (String)"EMPTY");
        tooltip.add(component);
        return super.addToGoggleTooltip(tooltip, isPlayerSneaking);
    }
}

