/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.logistics.gas.heater;

import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.ranges.RangesKt;
import net.createmod.catnip.lang.LangBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.valkyrienskies.clockwork.ClockworkConfig;
import org.valkyrienskies.clockwork.ClockworkLang;
import org.valkyrienskies.clockwork.ClockworkMod;
import org.valkyrienskies.clockwork.content.logistics.gas.heater.GasHeaterBlock;
import org.valkyrienskies.clockwork.util.KNodeBlockEntity;
import org.valkyrienskies.clockwork.util.gui.ClockworkTooltipHelper;
import org.valkyrienskies.clockwork.util.gui.DuctTextUtil;
import org.valkyrienskies.kelvin.api.DuctNode;
import org.valkyrienskies.kelvin.api.DuctNodePos;
import org.valkyrienskies.kelvin.impl.DuctNetworkServer;
import org.valkyrienskies.kelvin.util.KelvinExtensions;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B#\u0012\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u0019\u0012\u0006\u0010\u001c\u001a\u00020\u001b\u0012\u0006\u0010\u001e\u001a\u00020\u001d\u00a2\u0006\u0004\b\u001f\u0010 J\u001f\u0010\u0006\u001a\u00020\u00052\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0002H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\u000b\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ'\u0010\u0012\u001a\u00020\u00102\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r2\u0006\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0015\u001a\u00020\u00148\u0006X\u0086D\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006!"}, d2={"Lorg/valkyrienskies/clockwork/content/logistics/gas/heater/GasHeaterBlockEntity;", "Lorg/valkyrienskies/clockwork/util/KNodeBlockEntity;", "", "Lcom/simibubi/create/foundation/blockEntity/behaviour/BlockEntityBehaviour;", "behaviours", "", "addBehaviours", "(Ljava/util/List;)V", "Lorg/valkyrienskies/kelvin/api/DuctNodePos;", "getDuctNodePosition", "()Lorg/valkyrienskies/kelvin/api/DuctNodePos;", "tick", "()V", "", "Lnet/minecraft/network/chat/Component;", "tooltip", "", "isPlayerSneaking", "addToGoggleTooltip", "(Ljava/util/List;Z)Z", "", "heatLossPerLevel", "D", "getHeatLossPerLevel", "()D", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "type", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "<init>", "(Lnet/minecraft/world/level/block/entity/BlockEntityType;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "clockwork"})
public final class GasHeaterBlockEntity
extends KNodeBlockEntity {
    private final double heatLossPerLevel;

    public GasHeaterBlockEntity(@NotNull BlockEntityType<?> type, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(type, pos, state);
        this.heatLossPerLevel = 100.0;
    }

    public void addBehaviours(@Nullable List<BlockEntityBehaviour> behaviours) {
    }

    @Override
    @NotNull
    public DuctNodePos getDuctNodePosition() {
        if (this.f_58857_ != null) {
            BlockPos blockPos = this.m_58899_();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
            Level level = this.f_58857_;
            Intrinsics.checkNotNull((Object)level);
            ResourceLocation resourceLocation = level.m_46472_().m_135782_();
            Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"location(...)");
            return KelvinExtensions.INSTANCE.toDuctNodePos(blockPos, resourceLocation);
        }
        BlockPos blockPos = this.m_58899_();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
        return KelvinExtensions.toDuctNodePos$default((KelvinExtensions)KelvinExtensions.INSTANCE, (BlockPos)blockPos, null, (int)1, null);
    }

    public final double getHeatLossPerLevel() {
        return this.heatLossPerLevel;
    }

    public void tick() {
        super.tick();
        Level level = this.f_58857_;
        if (!(level != null ? !level.f_46443_ : false)) {
            return;
        }
        DuctNetworkServer kelvin = ClockworkMod.getKelvin();
        DuctNode ductNode = kelvin.getNodeAt(this.getDuctNodePosition());
        if (ductNode == null) {
            return;
        }
        DuctNode node = ductNode;
        double temp = kelvin.getTemperatureAt(this.getDuctNodePosition());
        Level level2 = this.f_58857_;
        Intrinsics.checkNotNull((Object)level2);
        BlockState state = level2.m_8055_(this.m_58899_());
        if (!(state.m_60734_() instanceof GasHeaterBlock)) {
            return;
        }
        BlazeBurnerBlock.HeatLevel heatLevel = temp >= (double)ClockworkConfig.SERVER.getHeaterSeethingTemp() ? BlazeBurnerBlock.HeatLevel.SEETHING : (temp >= (double)ClockworkConfig.SERVER.getHeaterKindledTemp() ? BlazeBurnerBlock.HeatLevel.KINDLED : (temp >= (double)ClockworkConfig.SERVER.getHeaterSmoulderingTemp() ? BlazeBurnerBlock.HeatLevel.SMOULDERING : BlazeBurnerBlock.HeatLevel.NONE));
        double energyInHeater = kelvin.getHeatEnergy(this.getDuctNodePosition());
        kelvin.modHeatEnergy(this.getDuctNodePosition(), -RangesKt.coerceAtMost((double)((double)heatLevel.ordinal() * this.heatLossPerLevel), (double)energyInHeater));
        if (state.m_61143_((Property)BlazeBurnerBlock.HEAT_LEVEL) == heatLevel) {
            return;
        }
        state = (BlockState)state.m_61124_((Property)BlazeBurnerBlock.HEAT_LEVEL, (Comparable)heatLevel);
        Level level3 = this.f_58857_;
        Intrinsics.checkNotNull((Object)level3);
        level3.m_46597_(this.m_58899_(), state);
        this.notifyUpdate();
    }

    @Override
    public boolean addToGoggleTooltip(@Nullable List<? extends Component> tooltip, boolean isPlayerSneaking) {
        LangBuilder langBuilder = ClockworkLang.translate("gui.gas_heater.info.title", new Object[0]);
        Intrinsics.checkNotNull(tooltip, (String)"null cannot be cast to non-null type kotlin.collections.MutableList<net.minecraft.network.chat.Component>");
        langBuilder.forGoggles(TypeIntrinsics.asMutableList(tooltip));
        BlazeBurnerBlock.HeatLevel heatLevel = (BlazeBurnerBlock.HeatLevel)this.m_58900_().m_61143_((Property)BlazeBurnerBlock.HEAT_LEVEL);
        switch (heatLevel == null ? -1 : WhenMappings.$EnumSwitchMapping$0[heatLevel.ordinal()]) {
            case 1: 
            case 2: {
                ClockworkTooltipHelper.addHint$default(ClockworkTooltipHelper.INSTANCE, tooltip, "gui.gas_heater.info.heat_level.superheated", ChatFormatting.AQUA, 0, 0, new Object[0], 24, null);
                break;
            }
            case 3: {
                ClockworkTooltipHelper.addHint$default(ClockworkTooltipHelper.INSTANCE, tooltip, "gui.gas_heater.info.heat_level.heated", ChatFormatting.GOLD, 0, 0, new Object[0], 24, null);
                if (!isPlayerSneaking) break;
                Object[] objectArray = new Object[1];
                LangBuilder langBuilder2 = ClockworkLang.builder();
                Intrinsics.checkNotNullExpressionValue((Object)langBuilder2, (String)"builder(...)");
                objectArray[0] = DuctTextUtil.translateTemperature$default(langBuilder2, ClockworkConfig.SERVER.getHeaterSeethingTemp(), true, null, 8, null);
                ClockworkLang.translate("gui.gas_heater.info.heat_level.next", objectArray).style(ChatFormatting.DARK_GRAY).forGoggles(tooltip);
                break;
            }
            case 4: {
                ClockworkTooltipHelper.addHint$default(ClockworkTooltipHelper.INSTANCE, tooltip, "gui.gas_heater.info.heat_level.passive", ChatFormatting.RED, 0, 0, new Object[0], 24, null);
                if (!isPlayerSneaking) break;
                Object[] objectArray = new Object[1];
                LangBuilder langBuilder3 = ClockworkLang.builder();
                Intrinsics.checkNotNullExpressionValue((Object)langBuilder3, (String)"builder(...)");
                objectArray[0] = DuctTextUtil.translateTemperature$default(langBuilder3, ClockworkConfig.SERVER.getHeaterKindledTemp(), true, null, 8, null);
                ClockworkLang.translate("gui.gas_heater.info.heat_level.next", objectArray).style(ChatFormatting.DARK_GRAY).forGoggles(tooltip);
                break;
            }
            default: {
                ClockworkTooltipHelper.addHint$default(ClockworkTooltipHelper.INSTANCE, tooltip, "gui.gas_heater.info.heat_level.none", ChatFormatting.GRAY, 0, 0, new Object[0], 24, null);
                if (!isPlayerSneaking) break;
                Object[] objectArray = new Object[1];
                LangBuilder langBuilder4 = ClockworkLang.builder();
                Intrinsics.checkNotNullExpressionValue((Object)langBuilder4, (String)"builder(...)");
                objectArray[0] = DuctTextUtil.translateTemperature$default(langBuilder4, ClockworkConfig.SERVER.getHeaterSmoulderingTemp(), true, null, 8, null);
                ClockworkLang.translate("gui.gas_heater.info.heat_level.next", objectArray).style(ChatFormatting.DARK_GRAY).forGoggles(tooltip);
            }
        }
        Component component = CommonComponents.f_237098_;
        Intrinsics.checkNotNullExpressionValue((Object)component, (String)"EMPTY");
        tooltip.add((Component)component);
        return super.addToGoggleTooltip(tooltip, isPlayerSneaking);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BlazeBurnerBlock.HeatLevel.values().length];
            try {
                nArray[BlazeBurnerBlock.HeatLevel.SEETHING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlazeBurnerBlock.HeatLevel.FADING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlazeBurnerBlock.HeatLevel.KINDLED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlazeBurnerBlock.HeatLevel.SMOULDERING.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

