/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.logistics.gas.generation.creative_generator;

import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.valkyrienskies.clockwork.ClockworkMod;
import org.valkyrienskies.clockwork.util.KNodeBlockEntity;
import org.valkyrienskies.kelvin.api.DuctNode;
import org.valkyrienskies.kelvin.api.DuctNodePos;
import org.valkyrienskies.kelvin.api.GasType;
import org.valkyrienskies.kelvin.impl.DuctNetworkServer;
import org.valkyrienskies.kelvin.impl.registry.GasTypeRegistry;
import org.valkyrienskies.kelvin.util.KelvinExtensions;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B#\u0012\n\u0010&\u001a\u0006\u0012\u0002\b\u00030%\u0012\u0006\u0010(\u001a\u00020'\u0012\u0006\u0010*\u001a\u00020)\u00a2\u0006\u0004\b+\u0010,J\u000f\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001f\u0010\b\u001a\u00020\u00022\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001f\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000fH\u0014\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001f\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000fH\u0014\u00a2\u0006\u0004\b\u0013\u0010\u0012R>\u0010\u0018\u001a\u001e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014j\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0016`\u00178\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\"\u0010\u001f\u001a\u00020\u001e8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$\u00a8\u0006-"}, d2={"Lorg/valkyrienskies/clockwork/content/logistics/gas/generation/creative_generator/CreativeGeneratorBlockEntity;", "Lorg/valkyrienskies/clockwork/util/KNodeBlockEntity;", "", "tick", "()V", "", "Lcom/simibubi/create/foundation/blockEntity/behaviour/BlockEntityBehaviour;", "behaviours", "addBehaviours", "(Ljava/util/List;)V", "Lorg/valkyrienskies/kelvin/api/DuctNodePos;", "getDuctNodePosition", "()Lorg/valkyrienskies/kelvin/api/DuctNodePos;", "Lnet/minecraft/nbt/CompoundTag;", "tag", "", "clientPacket", "read", "(Lnet/minecraft/nbt/CompoundTag;Z)V", "write", "Ljava/util/HashMap;", "Lorg/valkyrienskies/kelvin/api/GasType;", "", "Lkotlin/collections/HashMap;", "gasValues", "Ljava/util/HashMap;", "getGasValues", "()Ljava/util/HashMap;", "setGasValues", "(Ljava/util/HashMap;)V", "", "temperature", "D", "getTemperature", "()D", "setTemperature", "(D)V", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "type", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "<init>", "(Lnet/minecraft/world/level/block/entity/BlockEntityType;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "clockwork"})
@SourceDebugExtension(value={"SMAP\nCreativeGeneratorBlockEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CreativeGeneratorBlockEntity.kt\norg/valkyrienskies/clockwork/content/logistics/gas/generation/creative_generator/CreativeGeneratorBlockEntity\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,80:1\n1279#2,2:81\n1293#2,4:83\n216#3,2:87\n*S KotlinDebug\n*F\n+ 1 CreativeGeneratorBlockEntity.kt\norg/valkyrienskies/clockwork/content/logistics/gas/generation/creative_generator/CreativeGeneratorBlockEntity\n*L\n22#1:81,2\n22#1:83,4\n72#1:87,2\n*E\n"})
public final class CreativeGeneratorBlockEntity
extends KNodeBlockEntity {
    @NotNull
    private HashMap<GasType, Integer> gasValues;
    private double temperature;

    /*
     * WARNING - void declaration
     */
    public CreativeGeneratorBlockEntity(@NotNull BlockEntityType<?> type, @NotNull BlockPos pos, @NotNull BlockState state) {
        void $this$associateWith$iv;
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(type, pos, state);
        Iterable iterable = GasTypeRegistry.INSTANCE.getGAS_TYPES().values();
        CreativeGeneratorBlockEntity creativeGeneratorBlockEntity = this;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        void $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            GasType gasType = (GasType)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            Integer n = 0;
            map.put(t, n);
        }
        Map map = result$iv;
        creativeGeneratorBlockEntity.gasValues = new HashMap(map);
    }

    @NotNull
    public final HashMap<GasType, Integer> getGasValues() {
        return this.gasValues;
    }

    public final void setGasValues(@NotNull HashMap<GasType, Integer> hashMap) {
        Intrinsics.checkNotNullParameter(hashMap, (String)"<set-?>");
        this.gasValues = hashMap;
    }

    public final double getTemperature() {
        return this.temperature;
    }

    public final void setTemperature(double d) {
        this.temperature = d;
    }

    public void tick() {
        super.tick();
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        if (level.f_46443_) {
            return;
        }
        DuctNetworkServer kelvin = ClockworkMod.getKelvin();
        BlockPos blockPos = this.m_58899_();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
        Level level2 = this.f_58857_;
        Intrinsics.checkNotNull((Object)level2);
        ResourceLocation resourceLocation = level2.m_46472_().m_135782_();
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"location(...)");
        DuctNode ductNode = kelvin.getNodeAt(KelvinExtensions.INSTANCE.toDuctNodePos(blockPos, resourceLocation));
        if (ductNode == null) {
            return;
        }
        DuctNode node = ductNode;
        HashMap masses = kelvin.getGasMassAt(this.getDuctNodePosition());
        Iterator<GasType> iterator = this.gasValues.keySet().iterator();
        while (iterator.hasNext()) {
            GasType gas;
            Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
            Integer n = this.gasValues.get(gas);
            if (n != null && n == 0) continue;
            double gasMass = 0.0;
            if (masses.get(gas) == null) {
                gasMass = 0.0;
            } else {
                Object v = masses.get(gas);
                Intrinsics.checkNotNull(v);
                gasMass = ((Number)v).doubleValue();
            }
            DuctNodePos ductNodePos = this.getDuctNodePosition();
            Integer n2 = this.gasValues.get(gas);
            Intrinsics.checkNotNull((Object)n2);
            kelvin.addGasAtTemperature(ductNodePos, gas, Math.max(((Number)n2).doubleValue() / 1000.0 - gasMass, 0.0), this.temperature);
        }
    }

    public void addBehaviours(@Nullable List<BlockEntityBehaviour> behaviours) {
    }

    @Override
    @NotNull
    public DuctNodePos getDuctNodePosition() {
        if (this.f_58857_ != null) {
            BlockPos blockPos = this.m_58899_();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
            Level level = this.f_58857_;
            Intrinsics.checkNotNull((Object)level);
            ResourceLocation resourceLocation = level.m_46472_().m_135782_();
            Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"location(...)");
            return KelvinExtensions.INSTANCE.toDuctNodePos(blockPos, resourceLocation);
        }
        BlockPos blockPos = this.m_58899_();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
        return KelvinExtensions.toDuctNodePos$default((KelvinExtensions)KelvinExtensions.INSTANCE, (BlockPos)blockPos, null, (int)1, null);
    }

    @Override
    protected void read(@NotNull CompoundTag tag, boolean clientPacket) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        super.read(tag, clientPacket);
        this.temperature = tag.m_128459_("Temperature");
        Tag tag2 = tag.m_128423_("GasValues");
        CompoundTag compoundTag = tag2 instanceof CompoundTag ? (CompoundTag)tag2 : null;
        if (compoundTag == null) {
            return;
        }
        CompoundTag gasValuesTag = compoundTag;
        for (String gasTypeLocation : gasValuesTag.m_128431_()) {
            GasType gasType;
            if (GasTypeRegistry.INSTANCE.getGasType(new ResourceLocation(gasTypeLocation)) == null) continue;
            ((Map)this.gasValues).put(gasType, gasValuesTag.m_128451_(gasTypeLocation));
        }
    }

    @Override
    protected void write(@NotNull CompoundTag tag, boolean clientPacket) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        CompoundTag gasValuesTag = new CompoundTag();
        Map $this$forEach$iv = this.gasValues;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator.next();
            boolean bl = false;
            gasValuesTag.m_128405_(((GasType)it.getKey()).getResourceLocation().toString(), ((Number)it.getValue()).intValue());
        }
        tag.m_128365_("GasValues", (Tag)gasValuesTag);
        tag.m_128347_("Temperature", this.temperature);
        super.write(tag, clientPacket);
    }
}

