/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.logistics.gas.generation.compressor;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.foundation.particle.AirParticleData;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.valkyrienskies.clockwork.ClockworkPartials;
import org.valkyrienskies.clockwork.content.logistics.gas.generation.compressor.AirCompressorBlockEntity;
import org.valkyrienskies.clockwork.util.EaseHelper;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001e2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001eB\u0011\u0012\b\u0010\u001b\u001a\u0004\u0018\u00010\u001a\u00a2\u0006\u0004\b\u001c\u0010\u001dJ?\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0014\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001f\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001f\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001f\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001f"}, d2={"Lorg/valkyrienskies/clockwork/content/logistics/gas/generation/compressor/AirCompressorRenderer;", "Lcom/simibubi/create/content/kinetics/base/KineticBlockEntityRenderer;", "Lorg/valkyrienskies/clockwork/content/logistics/gas/generation/compressor/AirCompressorBlockEntity;", "be", "", "partialTicks", "Lcom/mojang/blaze3d/vertex/PoseStack;", "ms", "Lnet/minecraft/client/renderer/MultiBufferSource;", "buffer", "", "light", "overlay", "", "renderSafe", "(Lorg/valkyrienskies/clockwork/content/logistics/gas/generation/compressor/AirCompressorBlockEntity;FLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;II)V", "updateClientSize", "(Lorg/valkyrienskies/clockwork/content/logistics/gas/generation/compressor/AirCompressorBlockEntity;F)V", "Lnet/minecraft/world/level/Level;", "level", "handleParticleSpawning", "(Lorg/valkyrienskies/clockwork/content/logistics/gas/generation/compressor/AirCompressorBlockEntity;Lnet/minecraft/world/level/Level;)V", "Lnet/minecraft/core/BlockPos;", "pos", "spawnAirBurstParticles", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/Level;)V", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;", "context", "<init>", "(Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;)V", "Companion", "clockwork"})
public final class AirCompressorRenderer
extends KineticBlockEntityRenderer<AirCompressorBlockEntity> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final float SPEED_TO_SIZE_FACTOR = 6.6666666E-4f;
    private static final float BASE_FABRIC_SCALE_Y = 0.5f;
    private static final float TOP_TRANSLATION_FACTOR = 1.5f;
    private static final int PARTICLE_BURST_COUNT = 36;
    private static final float PARTICLE_Y_OFFSET = 1.6f;
    private static final double PARTICLE_VERTICAL_SPEED = 0.05;
    private static final float PARTICLE_AIR_DATA_SCALE = 0.0f;
    private static final float PARTICLE_AIR_DATA_DRAG = 0.005f;
    private static final float PARTICLE_HORIZONTAL_SPREAD = 0.5f;

    public AirCompressorRenderer(@Nullable BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(@NotNull AirCompressorBlockEntity be, float partialTicks, @NotNull PoseStack ms, @NotNull MultiBufferSource buffer, int light, int overlay) {
        SuperByteBuffer superByteBuffer;
        Intrinsics.checkNotNullParameter((Object)be, (String)"be");
        Intrinsics.checkNotNullParameter((Object)ms, (String)"ms");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Level level = be.m_58904_();
        if (level == null) {
            return;
        }
        Level level2 = level;
        BlockPos blockPos = be.m_58899_();
        int lightBelow = LevelRenderer.m_109541_((BlockAndTintGetter)((BlockAndTintGetter)level2), (BlockPos)blockPos.m_7495_());
        int lightAbove = LevelRenderer.m_109541_((BlockAndTintGetter)((BlockAndTintGetter)level2), (BlockPos)blockPos.m_7494_());
        VertexConsumer vb = buffer.m_6299_(RenderType.m_110457_());
        SuperByteBuffer axisPartial = CachedBuffers.partial((PartialModel)ClockworkPartials.INSTANCE.getCOMPRESSOR_AXIS(), (BlockState)be.m_58900_());
        KineticBlockEntityRenderer.standardKineticRotationTransform((SuperByteBuffer)axisPartial, (KineticBlockEntity)be, (int)lightBelow).renderInto(ms, vb);
        this.updateClientSize(be, partialTicks);
        this.handleParticleSpawning(be, level2);
        SuperByteBuffer fabricPartial = CachedBuffers.partial((PartialModel)ClockworkPartials.INSTANCE.getCOMPRESSOR_FABRIC(), (BlockState)be.m_58900_());
        SuperByteBuffer topPartial = CachedBuffers.partial((PartialModel)ClockworkPartials.INSTANCE.getCOMPRESSOR_TOP(), (BlockState)be.m_58900_());
        float easedHalfSize = EaseHelper.INSTANCE.easeInOutQuad(be.getClientSize()) / 2.0f;
        SuperByteBuffer $this$renderSafe_u24lambda_u240 = superByteBuffer = fabricPartial;
        boolean bl = false;
        $this$renderSafe_u24lambda_u240.scale(1.0f, 0.5f + easedHalfSize, 1.0f);
        $this$renderSafe_u24lambda_u240.translate(0.0, (double)(0.5f - easedHalfSize) / 2.0, 0.0);
        $this$renderSafe_u24lambda_u240.light(lightAbove);
        superByteBuffer.renderInto(ms, vb);
        SuperByteBuffer $this$renderSafe_u24lambda_u241 = superByteBuffer = topPartial;
        boolean bl2 = false;
        $this$renderSafe_u24lambda_u241.translate(0.0, (double)((easedHalfSize - 0.5f) * 1.5f), 0.0);
        $this$renderSafe_u24lambda_u241.light(lightAbove);
        superByteBuffer.renderInto(ms, vb);
    }

    private final void updateClientSize(AirCompressorBlockEntity be, float partialTicks) {
        Minecraft minecraft = Minecraft.m_91087_();
        float sizeMultiplier = minecraft.m_91104_() ? 0.0f : (be.getClientParticles() || !be.getActive() ? -1.0f : 1.0f);
        be.setClientSize(be.getClientSize() + partialTicks * Math.abs(be.getSpeed()) * sizeMultiplier * 6.6666666E-4f);
        be.setClientSize(Mth.m_14036_((float)be.getClientSize(), (float)0.0f, (float)1.0f));
    }

    private final void handleParticleSpawning(AirCompressorBlockEntity be, Level level) {
        if (be.getClientSize() >= 1.0f && !be.getClientParticles()) {
            be.setClientParticles(true);
            BlockPos blockPos = be.m_58899_();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
            this.spawnAirBurstParticles(blockPos, level);
            float pitch = Math.abs(be.getSpeed()) / 256.0f + level.f_46441_.m_188501_() + 0.25f;
            BlockPos blockPos2 = be.m_58899_();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos2, (String)"getBlockPos(...)");
            AllSoundEvents.STEAM.playAt(level, VectorConversionsMCKt.toDoubles((Vec3i)((Vec3i)blockPos2)), 0.4f, pitch, true);
        }
        if (be.getClientSize() <= 0.0f) {
            be.setClientParticles(false);
        }
    }

    private final void spawnAirBurstParticles(BlockPos pos, Level level) {
        double xBase = (double)pos.m_123341_() + 0.5;
        float yBase = (float)pos.m_123342_() + 1.6f;
        double zBase = (double)pos.m_123343_() + 0.5;
        int n = 36;
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            float rX = (level.f_46441_.m_188501_() - 0.5f) * (float)2 * 0.5f;
            double rY = level.f_46441_.m_188501_();
            float rZ = (level.f_46441_.m_188501_() - 0.5f) * (float)2 * 0.5f;
            level.m_7106_((ParticleOptions)new AirParticleData(0.0f, 0.005f), xBase + (double)rX, (double)yBase + rY, zBase + (double)rZ, 0.0, 0.05, 0.0);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0004R\u0014\u0010\u0005\u001a\u00020\u00028\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0004R\u0014\u0010\u0006\u001a\u00020\u00028\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0004R\u0014\u0010\b\u001a\u00020\u00078\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00028\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\n\u0010\u0004R\u0014\u0010\f\u001a\u00020\u000b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u00028\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u0004R\u0014\u0010\u000f\u001a\u00020\u00028\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0004R\u0014\u0010\u0010\u001a\u00020\u00028\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0004\u00a8\u0006\u0013"}, d2={"Lorg/valkyrienskies/clockwork/content/logistics/gas/generation/compressor/AirCompressorRenderer$Companion;", "", "", "SPEED_TO_SIZE_FACTOR", "F", "BASE_FABRIC_SCALE_Y", "TOP_TRANSLATION_FACTOR", "", "PARTICLE_BURST_COUNT", "I", "PARTICLE_Y_OFFSET", "", "PARTICLE_VERTICAL_SPEED", "D", "PARTICLE_AIR_DATA_SCALE", "PARTICLE_AIR_DATA_DRAG", "PARTICLE_HORIZONTAL_SPREAD", "<init>", "()V", "clockwork"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

