/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.logistics.gas.generation.compressor;

import java.util.List;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import net.createmod.catnip.lang.LangBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.valkyrienskies.clockwork.ClockworkConfig;
import org.valkyrienskies.clockwork.ClockworkLang;
import org.valkyrienskies.clockwork.ClockworkMod;
import org.valkyrienskies.clockwork.util.AerodynamicUtils;
import org.valkyrienskies.clockwork.util.KNodeKineticBlockEntity;
import org.valkyrienskies.clockwork.util.gui.ClockworkTooltipHelper;
import org.valkyrienskies.clockwork.util.gui.DuctTextUtil;
import org.valkyrienskies.kelvin.api.GasType;
import org.valkyrienskies.kelvin.impl.DuctNetworkServer;
import org.valkyrienskies.kelvin.impl.registry.GasTypeRegistry;
import org.valkyrienskies.mod.api.ValkyrienSkies;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001>B#\u0012\n\u00107\u001a\u0006\u0012\u0002\b\u000306\u0012\u0006\u00109\u001a\u000208\u0012\u0006\u0010;\u001a\u00020:\u00a2\u0006\u0004\b<\u0010=J\r\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\r\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0004J\u000f\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ'\u0010\u000e\u001a\u00020\f2\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\u0006\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0010\u0010\bJ\u001f\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\fH\u0014\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001f\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\fH\u0014\u00a2\u0006\u0004\b\u0016\u0010\u0015R*\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00178\u0006@FX\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\"\u0010\u001f\u001a\u00020\f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\"\u0010&\u001a\u00020%8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b&\u0010'\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u0016\u0010-\u001a\u0004\u0018\u00010,8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b-\u0010.R\u0016\u0010/\u001a\u0004\u0018\u00010,8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b/\u0010.R\u0011\u00101\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b0\u0010\"R\u0011\u00103\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b2\u0010\"R\u0011\u00105\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b4\u0010\"\u00a8\u0006?"}, d2={"Lorg/valkyrienskies/clockwork/content/logistics/gas/generation/compressor/AirCompressorBlockEntity;", "Lorg/valkyrienskies/clockwork/util/KNodeKineticBlockEntity;", "", "getAirDensity", "()D", "getAirTemperature", "", "tick", "()V", "", "Lnet/minecraft/network/chat/Component;", "tooltip", "", "isPlayerSneaking", "addToGoggleTooltip", "(Ljava/util/List;Z)Z", "remove", "Lnet/minecraft/nbt/CompoundTag;", "tag", "clientPacket", "read", "(Lnet/minecraft/nbt/CompoundTag;Z)V", "write", "Lorg/valkyrienskies/clockwork/content/logistics/gas/generation/compressor/AirCompressorBlockEntity$CompressorStatus;", "value", "status", "Lorg/valkyrienskies/clockwork/content/logistics/gas/generation/compressor/AirCompressorBlockEntity$CompressorStatus;", "getStatus", "()Lorg/valkyrienskies/clockwork/content/logistics/gas/generation/compressor/AirCompressorBlockEntity$CompressorStatus;", "setStatus", "(Lorg/valkyrienskies/clockwork/content/logistics/gas/generation/compressor/AirCompressorBlockEntity$CompressorStatus;)V", "clientParticles", "Z", "getClientParticles", "()Z", "setClientParticles", "(Z)V", "", "clientSize", "F", "getClientSize", "()F", "setClientSize", "(F)V", "Lorg/valkyrienskies/kelvin/api/GasType;", "airGas", "Lorg/valkyrienskies/kelvin/api/GasType;", "heliumGas", "getActive", "active", "getExhausted", "exhausted", "getObstructed", "obstructed", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "typeIn", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "<init>", "(Lnet/minecraft/world/level/block/entity/BlockEntityType;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "CompressorStatus", "clockwork"})
public final class AirCompressorBlockEntity
extends KNodeKineticBlockEntity {
    @NotNull
    private CompressorStatus status;
    private boolean clientParticles;
    private float clientSize;
    @Nullable
    private final GasType airGas;
    @Nullable
    private final GasType heliumGas;

    public AirCompressorBlockEntity(@NotNull BlockEntityType<?> typeIn, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter(typeIn, (String)"typeIn");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(typeIn, pos, state);
        this.status = CompressorStatus.INACTIVE;
        this.airGas = GasTypeRegistry.INSTANCE.getGasType("kelvin", "air");
        this.heliumGas = GasTypeRegistry.INSTANCE.getGasType("vs_clockwork", "aether");
    }

    @NotNull
    public final CompressorStatus getStatus() {
        return this.status;
    }

    public final void setStatus(@NotNull CompressorStatus value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        if (this.status != value) {
            this.status = value;
            this.sendData();
        }
    }

    public final boolean getClientParticles() {
        return this.clientParticles;
    }

    public final void setClientParticles(boolean bl) {
        this.clientParticles = bl;
    }

    public final float getClientSize() {
        return this.clientSize;
    }

    public final void setClientSize(float f) {
        this.clientSize = f;
    }

    public final boolean getActive() {
        return this.status == CompressorStatus.ACTIVE;
    }

    public final boolean getExhausted() {
        return this.status == CompressorStatus.EXHAUSTED;
    }

    public final boolean getObstructed() {
        return this.status == CompressorStatus.OBSTRUCTED;
    }

    public final double getAirDensity() {
        BlockPos blockPos = this.m_58899_();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
        Vec3 position = VSGameUtilsKt.toWorldCoordinates((Level)this.f_58857_, (BlockPos)blockPos);
        double d = position.f_82480_;
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        return AerodynamicUtils.INSTANCE.getAirDensityForY(d, ValkyrienSkies.getDimensionIdNonnull((Level)level));
    }

    public final double getAirTemperature() {
        BlockPos blockPos = this.m_58899_();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
        Vec3 position = VSGameUtilsKt.toWorldCoordinates((Level)this.f_58857_, (BlockPos)blockPos);
        double d = position.f_82480_;
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        return AerodynamicUtils.INSTANCE.getAirTemperatureForY(d, ValkyrienSkies.getDimensionIdNonnull((Level)level));
    }

    public void tick() {
        super.tick();
        if (this.airGas == null || this.heliumGas == null) {
            ClockworkMod.INSTANCE.getLOGGER().error("Could not get GasType `kelvin:air` or `vs_clockwork:aether`. Is Gas Registry broken?");
            return;
        }
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        if (level.f_46443_) {
            return;
        }
        DuctNetworkServer kelvin = ClockworkMod.getKelvin();
        if (kelvin.getNodeAt(this.getDuctNodePosition()) == null) {
            return;
        }
        float speed = Math.abs(this.getSpeed());
        Level level2 = this.f_58857_;
        Intrinsics.checkNotNull((Object)level2);
        if (level2.m_8055_(this.m_58899_().m_7494_()).m_60795_()) {
            if (speed > 0.0f) {
                if (kelvin.getPressureAt(this.getDuctNodePosition()) < ClockworkConfig.SERVER.getAirCompressorMaxPressure()) {
                    this.setStatus(CompressorStatus.ACTIVE);
                    double heliumShare = Math.max(0.0, 1.0 - this.getAirDensity() / ClockworkConfig.SERVER.getAirCompressorHeliumAirDensity());
                    double deltaVolume = ClockworkConfig.SERVER.getAirCompressorSpeed() * (double)speed;
                    kelvin.addGasAtTemperature(this.getDuctNodePosition(), this.airGas, (1.0 - heliumShare) * deltaVolume, this.getAirTemperature());
                    kelvin.addGasAtTemperature(this.getDuctNodePosition(), this.heliumGas, heliumShare * deltaVolume, this.getAirTemperature());
                } else {
                    this.setStatus(CompressorStatus.EXHAUSTED);
                }
            } else {
                this.setStatus(CompressorStatus.INACTIVE);
            }
        } else {
            this.setStatus(CompressorStatus.OBSTRUCTED);
        }
    }

    @Override
    public boolean addToGoggleTooltip(@Nullable List<? extends Component> tooltip, boolean isPlayerSneaking) {
        if (this.status != CompressorStatus.INACTIVE) {
            LangBuilder langBuilder = ClockworkLang.translate("gui.air_compressor.info.title", new Object[0]);
            Intrinsics.checkNotNull(tooltip, (String)"null cannot be cast to non-null type kotlin.collections.MutableList<net.minecraft.network.chat.Component>");
            langBuilder.forGoggles(TypeIntrinsics.asMutableList(tooltip));
            switch (WhenMappings.$EnumSwitchMapping$0[this.status.ordinal()]) {
                case 1: {
                    ClockworkTooltipHelper.addHint$default(ClockworkTooltipHelper.INSTANCE, tooltip, "gui.air_compressor.info.obstructed", null, 0, 0, new Object[0], 28, null);
                    break;
                }
                case 2: {
                    ClockworkTooltipHelper.addHint$default(ClockworkTooltipHelper.INSTANCE, tooltip, "gui.air_compressor.info.exhausted", null, 0, 0, new Object[0], 28, null);
                    break;
                }
                case 3: {
                    ClockworkLang.translate("gui.air_compressor.info.active.title", new Object[0]).style(ChatFormatting.GREEN).forGoggles(tooltip);
                    Object[] objectArray = new Object[1];
                    LangBuilder langBuilder2 = ClockworkLang.builder();
                    Intrinsics.checkNotNullExpressionValue((Object)langBuilder2, (String)"builder(...)");
                    objectArray[0] = DuctTextUtil.translateTemperature$default(langBuilder2, this.getAirTemperature(), true, null, 8, null).style(ChatFormatting.GOLD);
                    ClockworkLang.translate("gui.air_compressor.info.active", objectArray).style(ChatFormatting.GRAY).forGoggles(tooltip);
                }
            }
            Component component = CommonComponents.f_237098_;
            Intrinsics.checkNotNullExpressionValue((Object)component, (String)"EMPTY");
            tooltip.add((Component)component);
        }
        return super.addToGoggleTooltip(tooltip, isPlayerSneaking);
    }

    @Override
    public void remove() {
        super.remove();
    }

    @Override
    protected void read(@NotNull CompoundTag tag, boolean clientPacket) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        String string = tag.m_128461_("status");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        this.setStatus(CompressorStatus.valueOf(string));
        super.read(tag, clientPacket);
    }

    @Override
    protected void write(@NotNull CompoundTag tag, boolean clientPacket) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        tag.m_128359_("status", this.status.toString());
        super.write(tag, clientPacket);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lorg/valkyrienskies/clockwork/content/logistics/gas/generation/compressor/AirCompressorBlockEntity$CompressorStatus;", "", "<init>", "(Ljava/lang/String;I)V", "ACTIVE", "INACTIVE", "EXHAUSTED", "OBSTRUCTED", "clockwork"})
    public static final class CompressorStatus
    extends Enum<CompressorStatus> {
        public static final /* enum */ CompressorStatus ACTIVE = new CompressorStatus();
        public static final /* enum */ CompressorStatus INACTIVE = new CompressorStatus();
        public static final /* enum */ CompressorStatus EXHAUSTED = new CompressorStatus();
        public static final /* enum */ CompressorStatus OBSTRUCTED = new CompressorStatus();
        private static final /* synthetic */ CompressorStatus[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static CompressorStatus[] values() {
            return (CompressorStatus[])$VALUES.clone();
        }

        public static CompressorStatus valueOf(String value) {
            return Enum.valueOf(CompressorStatus.class, value);
        }

        @NotNull
        public static EnumEntries<CompressorStatus> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = compressorStatusArray = new CompressorStatus[]{CompressorStatus.ACTIVE, CompressorStatus.INACTIVE, CompressorStatus.EXHAUSTED, CompressorStatus.OBSTRUCTED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CompressorStatus.values().length];
            try {
                nArray[CompressorStatus.OBSTRUCTED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CompressorStatus.EXHAUSTED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CompressorStatus.ACTIVE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

