/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.logistics.gas.generation.coal_burner;

import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import dev.architectury.registry.fuel.FuelRegistry;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Clearable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.valkyrienskies.clockwork.ClockworkMod;
import org.valkyrienskies.clockwork.content.logistics.gas.generation.coal_burner.CoalBurnerBlock;
import org.valkyrienskies.clockwork.util.KNodeBlockEntity;
import org.valkyrienskies.kelvin.api.DuctNodePos;
import org.valkyrienskies.kelvin.impl.DuctNetworkServer;
import org.valkyrienskies.kelvin.util.KelvinExtensions;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 :2\u00020\u00012\u00020\u0002:\u0001:B#\u0012\n\u00103\u001a\u0006\u0012\u0002\b\u000302\u0012\u0006\u00105\u001a\u000204\u0012\u0006\u00107\u001a\u000206\u00a2\u0006\u0004\b8\u00109J\u000f\u0010\u0004\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001f\u0010\t\u001a\u00020\u00032\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u001f\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0010H\u0014\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001f\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0010H\u0014\u00a2\u0006\u0004\b\u0014\u0010\u0013J\u000f\u0010\u0015\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0005J\u000f\u0010\u0016\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0005J'\u0010\u001b\u001a\u00020\u00102\u000e\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u00172\u0006\u0010\u001a\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cR\"\u0010\u001e\u001a\u00020\u001d8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\"\u0010%\u001a\u00020$8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b%\u0010&\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\"\u0010,\u001a\u00020+8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b,\u0010-\u001a\u0004\b.\u0010/\"\u0004\b0\u00101\u00a8\u0006;"}, d2={"Lorg/valkyrienskies/clockwork/content/logistics/gas/generation/coal_burner/CoalBurnerBlockEntity;", "Lorg/valkyrienskies/clockwork/util/KNodeBlockEntity;", "Lnet/minecraft/world/Clearable;", "", "tick", "()V", "", "Lcom/simibubi/create/foundation/blockEntity/behaviour/BlockEntityBehaviour;", "behaviours", "addBehaviours", "(Ljava/util/List;)V", "Lorg/valkyrienskies/kelvin/api/DuctNodePos;", "getDuctNodePosition", "()Lorg/valkyrienskies/kelvin/api/DuctNodePos;", "Lnet/minecraft/nbt/CompoundTag;", "tag", "", "clientPacket", "read", "(Lnet/minecraft/nbt/CompoundTag;Z)V", "write", "destroy", "clearContent", "", "Lnet/minecraft/network/chat/Component;", "tooltip", "isPlayerSneaking", "addToGoggleTooltip", "(Ljava/util/List;Z)Z", "", "fuelTicks", "I", "getFuelTicks", "()I", "setFuelTicks", "(I)V", "", "maxBurnTime", "D", "getMaxBurnTime", "()D", "setMaxBurnTime", "(D)V", "Lnet/minecraft/world/item/ItemStack;", "storedFuelStack", "Lnet/minecraft/world/item/ItemStack;", "getStoredFuelStack", "()Lnet/minecraft/world/item/ItemStack;", "setStoredFuelStack", "(Lnet/minecraft/world/item/ItemStack;)V", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "type", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "<init>", "(Lnet/minecraft/world/level/block/entity/BlockEntityType;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "Companion", "clockwork"})
public final class CoalBurnerBlockEntity
extends KNodeBlockEntity
implements Clearable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int fuelTicks;
    private double maxBurnTime;
    @NotNull
    private ItemStack storedFuelStack;
    public static final double FUEL_ENERGY_DENSITY = 17000.0;
    public static final double LOG_BURN_TIME = 300.0;

    public CoalBurnerBlockEntity(@NotNull BlockEntityType<?> type, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(type, pos, state);
        ItemStack itemStack = ItemStack.f_41583_;
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
        this.storedFuelStack = itemStack;
    }

    public final int getFuelTicks() {
        return this.fuelTicks;
    }

    public final void setFuelTicks(int n) {
        this.fuelTicks = n;
    }

    public final double getMaxBurnTime() {
        return this.maxBurnTime;
    }

    public final void setMaxBurnTime(double d) {
        this.maxBurnTime = d;
    }

    @NotNull
    public final ItemStack getStoredFuelStack() {
        return this.storedFuelStack;
    }

    public final void setStoredFuelStack(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"<set-?>");
        this.storedFuelStack = itemStack;
    }

    public void tick() {
        super.tick();
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        if (level.f_46443_) {
            return;
        }
        DuctNetworkServer kelvin = ClockworkMod.getKelvin();
        BlockPos blockPos = this.m_58899_();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
        Level level2 = this.f_58857_;
        Intrinsics.checkNotNull((Object)level2);
        ResourceLocation resourceLocation = level2.m_46472_().m_135782_();
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"location(...)");
        if (kelvin.getNodeAt(KelvinExtensions.INSTANCE.toDuctNodePos(blockPos, resourceLocation)) == null) {
            return;
        }
        if (this.fuelTicks > 0) {
            double maxEnergyAddedThisTick;
            double targetTemperature;
            double currentInternalHeatCapacity;
            double energyToAdd;
            --this.fuelTicks;
            BlockPos blockPos2 = this.m_58899_();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos2, (String)"getBlockPos(...)");
            Level level3 = this.f_58857_;
            Intrinsics.checkNotNull((Object)level3);
            ResourceLocation resourceLocation2 = level3.m_46472_().m_135782_();
            Intrinsics.checkNotNullExpressionValue((Object)resourceLocation2, (String)"location(...)");
            HashMap currentInternalGasses = kelvin.getGasMassAt(KelvinExtensions.INSTANCE.toDuctNodePos(blockPos2, resourceLocation2));
            BlockPos blockPos3 = this.m_58899_();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos3, (String)"getBlockPos(...)");
            Level level4 = this.f_58857_;
            Intrinsics.checkNotNull((Object)level4);
            ResourceLocation resourceLocation3 = level4.m_46472_().m_135782_();
            Intrinsics.checkNotNullExpressionValue((Object)resourceLocation3, (String)"location(...)");
            double currentInternalTemperature = kelvin.getTemperatureAt(KelvinExtensions.INSTANCE.toDuctNodePos(blockPos3, resourceLocation3));
            Collection collection = currentInternalGasses.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            if (CollectionsKt.sumOfDouble((Iterable)collection) > 1.0E-5 && (energyToAdd = Math.min((currentInternalHeatCapacity = kelvin.mixtureCapacity((Map)currentInternalGasses)) * ((targetTemperature = 1000.0) - currentInternalTemperature), maxEnergyAddedThisTick = 17000.0 * (this.maxBurnTime / 300.0) / 20.0)) > 0.0) {
                BlockPos blockPos4 = this.m_58899_();
                Intrinsics.checkNotNullExpressionValue((Object)blockPos4, (String)"getBlockPos(...)");
                Level level5 = this.f_58857_;
                Intrinsics.checkNotNull((Object)level5);
                ResourceLocation resourceLocation4 = level5.m_46472_().m_135782_();
                Intrinsics.checkNotNullExpressionValue((Object)resourceLocation4, (String)"location(...)");
                kelvin.modHeatEnergy(KelvinExtensions.INSTANCE.toDuctNodePos(blockPos4, resourceLocation4), energyToAdd);
            }
            if (Intrinsics.areEqual((Object)this.m_58900_().m_61143_((Property)CoalBurnerBlock.Companion.getLIT()), (Object)false)) {
                Level level6 = this.f_58857_;
                Intrinsics.checkNotNull((Object)level6);
                level6.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)CoalBurnerBlock.Companion.getLIT(), (Comparable)Boolean.valueOf(true)), 15);
            }
        } else {
            boolean bl = this.storedFuelStack.m_41619_();
            Comparable comparable = this.m_58900_().m_61143_((Property)CoalBurnerBlock.Companion.getLIT());
            Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"getValue(...)");
            if (bl & (Boolean)comparable) {
                Level level7 = this.f_58857_;
                Intrinsics.checkNotNull((Object)level7);
                level7.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)CoalBurnerBlock.Companion.getLIT(), (Comparable)Boolean.valueOf(false)), 15);
            }
            if (!this.storedFuelStack.m_41619_()) {
                int burnTime = FuelRegistry.get((ItemStack)this.storedFuelStack);
                this.fuelTicks += burnTime;
                this.maxBurnTime = burnTime;
                ItemStack itemStack = this.storedFuelStack;
                itemStack.m_41764_(itemStack.m_41613_() - 1);
                this.sendData();
            }
        }
    }

    public void addBehaviours(@Nullable List<BlockEntityBehaviour> behaviours) {
    }

    @Override
    @NotNull
    public DuctNodePos getDuctNodePosition() {
        if (this.f_58857_ != null) {
            BlockPos blockPos = this.m_58899_();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
            Level level = this.f_58857_;
            Intrinsics.checkNotNull((Object)level);
            ResourceLocation resourceLocation = level.m_46472_().m_135782_();
            Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"location(...)");
            return KelvinExtensions.INSTANCE.toDuctNodePos(blockPos, resourceLocation);
        }
        BlockPos blockPos = this.m_58899_();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
        return KelvinExtensions.toDuctNodePos$default((KelvinExtensions)KelvinExtensions.INSTANCE, (BlockPos)blockPos, null, (int)1, null);
    }

    @Override
    protected void read(@NotNull CompoundTag tag, boolean clientPacket) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Tag subTag = tag.m_128423_("StoredFuelStack");
        this.storedFuelStack = subTag == null ? ItemStack.f_41583_ : ItemStack.m_41712_((CompoundTag)((CompoundTag)subTag));
        super.read(tag, clientPacket);
    }

    @Override
    protected void write(@NotNull CompoundTag tag, boolean clientPacket) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        CompoundTag subTag = new CompoundTag();
        this.storedFuelStack.m_41739_(subTag);
        tag.m_128365_("StoredFuelStack", (Tag)subTag);
        super.write(tag, clientPacket);
    }

    public void destroy() {
        BlockPos blockPos = this.m_58899_();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
        Vector3d vec3d = VectorConversionsMCKt.toJOMLD((Vec3i)((Vec3i)blockPos));
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        ItemEntity ie = new ItemEntity(level, vec3d.x, vec3d.y, vec3d.z, this.storedFuelStack);
        Level level2 = this.f_58857_;
        Intrinsics.checkNotNull((Object)level2);
        level2.m_7967_((Entity)ie);
        super.destroy();
    }

    public void m_6211_() {
        this.storedFuelStack = ItemStack.f_41583_;
    }

    @Override
    public boolean addToGoggleTooltip(@Nullable List<? extends Component> tooltip, boolean isPlayerSneaking) {
        if (!this.storedFuelStack.m_41619_()) {
            Intrinsics.checkNotNull(tooltip, (String)"null cannot be cast to non-null type kotlin.collections.MutableList<net.minecraft.network.chat.Component>");
            List list = TypeIntrinsics.asMutableList(tooltip);
            MutableComponent mutableComponent = Component.m_237113_((String)"    Coal burner Info").m_130940_(ChatFormatting.GRAY);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"withStyle(...)");
            list.add(mutableComponent);
            MutableComponent mutableComponent2 = Component.m_237113_((String)"Fuel: ").m_130940_(ChatFormatting.GOLD).m_7220_(this.storedFuelStack.m_41611_()).m_7220_((Component)Component.m_237113_((String)("x " + this.storedFuelStack.m_41613_())).m_130940_(ChatFormatting.GOLD));
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent2, (String)"append(...)");
            tooltip.add((Component)mutableComponent2);
        }
        return super.addToGoggleTooltip(tooltip, isPlayerSneaking);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0014\u0010\u0003\u001a\u00020\u00028\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0004R\u0014\u0010\u0005\u001a\u00020\u00028\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0004\u00a8\u0006\b"}, d2={"Lorg/valkyrienskies/clockwork/content/logistics/gas/generation/coal_burner/CoalBurnerBlockEntity$Companion;", "", "", "FUEL_ENERGY_DENSITY", "D", "LOG_BURN_TIME", "<init>", "()V", "clockwork"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

