/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.logistics.gas.exhaust;

import com.simibubi.create.content.kinetics.fan.AirCurrent;
import com.simibubi.create.content.kinetics.fan.IAirCurrentSource;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.clockwork.ClockworkMod;
import org.valkyrienskies.clockwork.ClockworkModClient;
import org.valkyrienskies.clockwork.content.logistics.gas.exhaust.ExhaustBlock;
import org.valkyrienskies.clockwork.mixinduck.MixinAirCurrentDuck;
import org.valkyrienskies.clockwork.util.KNodeBlockEntity;
import org.valkyrienskies.clockwork.util.KelvinParticleHelper;
import org.valkyrienskies.core.api.ships.PhysShip;
import org.valkyrienskies.core.api.world.PhysLevel;
import org.valkyrienskies.kelvin.KelvinMod;
import org.valkyrienskies.kelvin.api.DuctNetwork;
import org.valkyrienskies.kelvin.api.DuctNodePos;
import org.valkyrienskies.kelvin.api.GasType;
import org.valkyrienskies.mod.api.BlockEntityPhysicsListener;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B#\u0012\n\u0010V\u001a\u0006\u0012\u0002\b\u00030U\u0012\u0006\u0010W\u001a\u00020\u001c\u0012\u0006\u0010Y\u001a\u00020X\u00a2\u0006\u0004\bZ\u0010[J\u001f\u0010\b\u001a\u00020\u00072\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u001d\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\r\u0010\u0012\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0012\u0010\u0011J\u000f\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0011\u0010\u0017\u001a\u0004\u0018\u00010\u0016H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0011\u0010\u001a\u001a\u0004\u0018\u00010\u0019H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0011\u0010\u001d\u001a\u0004\u0018\u00010\u001cH\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0011\u0010 \u001a\u0004\u0018\u00010\u001fH\u0016\u00a2\u0006\u0004\b \u0010!J\u0011\u0010\"\u001a\u0004\u0018\u00010\u001fH\u0016\u00a2\u0006\u0004\b\"\u0010!J\u000f\u0010$\u001a\u00020#H\u0016\u00a2\u0006\u0004\b$\u0010%J!\u0010*\u001a\u00020\u00072\b\u0010'\u001a\u0004\u0018\u00010&2\u0006\u0010)\u001a\u00020(H\u0016\u00a2\u0006\u0004\b*\u0010+R\u001a\u0010,\u001a\u00020\n8\u0006X\u0086D\u00a2\u0006\f\n\u0004\b,\u0010-\u001a\u0004\b.\u0010/R\u0017\u00100\u001a\u00020\u001f8\u0006\u00a2\u0006\f\n\u0004\b0\u00101\u001a\u0004\b2\u0010!R&\u00105\u001a\u000603j\u0002`48\u0016@\u0016X\u0096.\u00a2\u0006\u0012\n\u0004\b5\u00106\u001a\u0004\b7\u00108\"\u0004\b9\u0010:R\u001a\u0010;\u001a\u00020\u00138\u0006X\u0086D\u00a2\u0006\f\n\u0004\b;\u0010<\u001a\u0004\b=\u0010\u0015R\u0017\u0010>\u001a\u00020\u00138\u0006\u00a2\u0006\f\n\u0004\b>\u0010<\u001a\u0004\b?\u0010\u0015R\u0018\u0010@\u001a\u0004\u0018\u00010\u00168\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0006\n\u0004\b@\u0010AR\"\u0010C\u001a\u00020B8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bC\u0010D\u001a\u0004\bE\u0010F\"\u0004\bG\u0010HR\"\u0010I\u001a\u00020B8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bI\u0010D\u001a\u0004\bJ\u0010F\"\u0004\bK\u0010HR\"\u0010L\u001a\u00020#8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bL\u0010M\u001a\u0004\bN\u0010%\"\u0004\bO\u0010PR\"\u0010Q\u001a\u00020\n8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bQ\u0010-\u001a\u0004\bR\u0010/\"\u0004\bS\u0010T\u00a8\u0006\\"}, d2={"Lorg/valkyrienskies/clockwork/content/logistics/gas/exhaust/ExhaustBlockEntity;", "Lorg/valkyrienskies/clockwork/util/KNodeBlockEntity;", "Lcom/simibubi/create/content/kinetics/fan/IAirCurrentSource;", "Lorg/valkyrienskies/mod/api/BlockEntityPhysicsListener;", "", "Lcom/simibubi/create/foundation/blockEntity/behaviour/BlockEntityBehaviour;", "behaviours", "", "addBehaviours", "(Ljava/util/List;)V", "", "deviation", "Lnet/minecraft/util/RandomSource;", "random", "randomPos", "(DLnet/minecraft/util/RandomSource;)D", "tick", "()V", "updateAirCurrent", "", "getSpeed", "()F", "Lcom/simibubi/create/content/kinetics/fan/AirCurrent;", "getAirCurrent", "()Lcom/simibubi/create/content/kinetics/fan/AirCurrent;", "Lnet/minecraft/world/level/Level;", "getAirCurrentWorld", "()Lnet/minecraft/world/level/Level;", "Lnet/minecraft/core/BlockPos;", "getAirCurrentPos", "()Lnet/minecraft/core/BlockPos;", "Lnet/minecraft/core/Direction;", "getAirflowOriginSide", "()Lnet/minecraft/core/Direction;", "getAirFlowDirection", "", "isSourceRemoved", "()Z", "Lorg/valkyrienskies/core/api/ships/PhysShip;", "physShip", "Lorg/valkyrienskies/core/api/world/PhysLevel;", "physLevel", "physTick", "(Lorg/valkyrienskies/core/api/ships/PhysShip;Lorg/valkyrienskies/core/api/world/PhysLevel;)V", "MASS_PER_EXHAUST", "D", "getMASS_PER_EXHAUST", "()D", "facing", "Lnet/minecraft/core/Direction;", "getFacing", "", "Lorg/valkyrienskies/core/api/world/properties/DimensionId;", "dimension", "Ljava/lang/String;", "getDimension", "()Ljava/lang/String;", "setDimension", "(Ljava/lang/String;)V", "MAX_AIRFLOW_SPEED", "F", "getMAX_AIRFLOW_SPEED", "PRESSURE_TO_SPEED", "getPRESSURE_TO_SPEED", "airCurrent", "Lcom/simibubi/create/content/kinetics/fan/AirCurrent;", "", "airCurrentUpdateCooldown", "I", "getAirCurrentUpdateCooldown", "()I", "setAirCurrentUpdateCooldown", "(I)V", "entitySearchCooldown", "getEntitySearchCooldown", "setEntitySearchCooldown", "updateAirFlow", "Z", "getUpdateAirFlow", "setUpdateAirFlow", "(Z)V", "currentAirflowThrust", "getCurrentAirflowThrust", "setCurrentAirflowThrust", "(D)V", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "type", "pos", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "<init>", "(Lnet/minecraft/world/level/block/entity/BlockEntityType;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "clockwork"})
public final class ExhaustBlockEntity
extends KNodeBlockEntity
implements IAirCurrentSource,
BlockEntityPhysicsListener {
    private final double MASS_PER_EXHAUST;
    @NotNull
    private final Direction facing;
    public String dimension;
    private final float MAX_AIRFLOW_SPEED;
    private final float PRESSURE_TO_SPEED;
    @JvmField
    @Nullable
    public AirCurrent airCurrent;
    private int airCurrentUpdateCooldown;
    private int entitySearchCooldown;
    private boolean updateAirFlow;
    private volatile double currentAirflowThrust;

    public ExhaustBlockEntity(@NotNull BlockEntityType<?> type, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(type, pos, state);
        this.MASS_PER_EXHAUST = 5.0E-4;
        Comparable comparable = state.m_61143_((Property)BlockStateProperties.f_61372_);
        Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"getValue(...)");
        this.facing = (Direction)comparable;
        this.MAX_AIRFLOW_SPEED = 256.0f;
        this.PRESSURE_TO_SPEED = 0.1024f;
        this.airCurrent = new AirCurrent((IAirCurrentSource)this);
        this.updateAirFlow = true;
    }

    public final double getMASS_PER_EXHAUST() {
        return this.MASS_PER_EXHAUST;
    }

    @NotNull
    public final Direction getFacing() {
        return this.facing;
    }

    @NotNull
    public String getDimension() {
        String string = this.dimension;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"dimension");
        return null;
    }

    public void setDimension(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.dimension = string;
    }

    public final float getMAX_AIRFLOW_SPEED() {
        return this.MAX_AIRFLOW_SPEED;
    }

    public final float getPRESSURE_TO_SPEED() {
        return this.PRESSURE_TO_SPEED;
    }

    public final int getAirCurrentUpdateCooldown() {
        return this.airCurrentUpdateCooldown;
    }

    public final void setAirCurrentUpdateCooldown(int n) {
        this.airCurrentUpdateCooldown = n;
    }

    public final int getEntitySearchCooldown() {
        return this.entitySearchCooldown;
    }

    public final void setEntitySearchCooldown(int n) {
        this.entitySearchCooldown = n;
    }

    public final boolean getUpdateAirFlow() {
        return this.updateAirFlow;
    }

    public final void setUpdateAirFlow(boolean bl) {
        this.updateAirFlow = bl;
    }

    public final double getCurrentAirflowThrust() {
        return this.currentAirflowThrust;
    }

    public final void setCurrentAirflowThrust(double d) {
        this.currentAirflowThrust = d;
    }

    public void addBehaviours(@Nullable List<BlockEntityBehaviour> behaviours) {
    }

    public final double randomPos(double deviation, @NotNull RandomSource random) {
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        return 0.5 - deviation / 2.0 + random.m_188500_() * deviation;
    }

    public void tick() {
        super.tick();
        Level level = this.f_58857_;
        DuctNetwork network = !(level != null ? level.f_46443_ : false) ? (DuctNetwork)ClockworkMod.getKelvin() : (DuctNetwork)ClockworkModClient.getKelvin();
        HashMap gasses = network.getGasMassAt(this.getDuctNodePosition());
        double pressure = network.getPressureAt(this.getDuctNodePosition());
        if (gasses.isEmpty()) {
            super.tick();
            return;
        }
        Level level2 = this.f_58857_;
        Intrinsics.checkNotNull((Object)level2);
        if (level2.f_46443_) {
            Level level3 = this.f_58857_;
            Intrinsics.checkNotNull((Object)level3);
            BlockState state = level3.m_8055_(this.m_58899_());
            if (!(state.m_60734_() instanceof ExhaustBlock)) {
                return;
            }
            Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
            Level level4 = this.f_58857_;
            Intrinsics.checkNotNull((Object)level4);
            RandomSource random = level4.f_46441_;
            int i = 1;
            Collection collection = gasses.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            int n = (int)Math.floor(CollectionsKt.sumOfDouble((Iterable)collection) / this.MASS_PER_EXHAUST);
            if (i <= n) {
                while (true) {
                    Level level5 = this.f_58857_;
                    Intrinsics.checkNotNull((Object)level5, (String)"null cannot be cast to non-null type net.minecraft.client.multiplayer.ClientLevel");
                    ClientLevel clientLevel = (ClientLevel)level5;
                    DuctNodePos ductNodePos = this.getDuctNodePosition();
                    BlockPos blockPos = this.m_58899_();
                    Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
                    Vector3d vector3d = VectorConversionsMCKt.toJOMLD((Vec3i)((Vec3i)blockPos));
                    Intrinsics.checkNotNull((Object)random);
                    Vector3d vector3d2 = vector3d.add(this.randomPos(0.3, random), this.randomPos(0.3, random), this.randomPos(0.3, random));
                    Intrinsics.checkNotNullExpressionValue((Object)vector3d2, (String)"add(...)");
                    Vector3dc vector3dc = (Vector3dc)vector3d2;
                    Vec3i vec3i = facing.m_122436_();
                    Intrinsics.checkNotNullExpressionValue((Object)vec3i, (String)"getNormal(...)");
                    Vector3d vector3d3 = VectorConversionsMCKt.toJOMLD((Vec3i)vec3i).mul(Mth.m_14008_((double)(0.0025 * Math.pow(pressure, 0.4)), (double)0.1, (double)5.0));
                    Intrinsics.checkNotNullExpressionValue((Object)vector3d3, (String)"mul(...)");
                    KelvinParticleHelper.INSTANCE.spawnParticleWithRatio(clientLevel, ductNodePos, vector3dc, (Vector3dc)vector3d3);
                    if (i != n) {
                        ++i;
                        continue;
                    }
                    break;
                }
            }
        } else {
            for (Map.Entry entry : ((Map)gasses).entrySet()) {
                GasType gas = (GasType)entry.getKey();
                double value = ((Number)entry.getValue()).doubleValue();
                network.removeGas(this.getDuctNodePosition(), gas, value);
            }
        }
        this.updateAirCurrent();
    }

    public final void updateAirCurrent() {
        int n;
        if (this.airCurrent == null) {
            return;
        }
        DuctNetwork ductNetwork = KelvinMod.INSTANCE.getKelvinByPlatform();
        if (ductNetwork == null) {
            return;
        }
        DuctNetwork network = ductNetwork;
        if (AllConfigs.server() != null) {
            n = this.airCurrentUpdateCooldown;
            this.airCurrentUpdateCooldown = n + -1;
            if (n <= 0) {
                this.airCurrentUpdateCooldown = ((Number)AllConfigs.server().kinetics.fanBlockCheckRate.get()).intValue();
                this.updateAirFlow = true;
            }
        }
        if (this.updateAirFlow) {
            MixinAirCurrentDuck duck;
            this.updateAirFlow = false;
            double temp = network.getTemperatureAt(this.getDuctNodePosition());
            AirCurrent airCurrent = this.airCurrent;
            MixinAirCurrentDuck mixinAirCurrentDuck = duck = airCurrent instanceof MixinAirCurrentDuck ? (MixinAirCurrentDuck)airCurrent : null;
            if (mixinAirCurrentDuck != null) {
                mixinAirCurrentDuck.disableParticles(true);
            }
            MixinAirCurrentDuck mixinAirCurrentDuck2 = duck;
            if (mixinAirCurrentDuck2 != null) {
                mixinAirCurrentDuck2.setOwnProcessingType(duck.getProcessingTypeFor(temp));
            }
            AirCurrent airCurrent2 = this.airCurrent;
            if (airCurrent2 != null) {
                airCurrent2.rebuild();
            }
            this.sendData();
        }
        this.currentAirflowThrust = this.getSpeed();
        if (this.getSpeed() == 0.0f) {
            return;
        }
        n = this.entitySearchCooldown;
        this.entitySearchCooldown = n + -1;
        if (n <= 0) {
            this.entitySearchCooldown = 5;
            AirCurrent airCurrent = this.airCurrent;
            Intrinsics.checkNotNull((Object)airCurrent);
            airCurrent.findEntities();
        }
        AirCurrent airCurrent = this.airCurrent;
        Intrinsics.checkNotNull((Object)airCurrent);
        airCurrent.tick();
    }

    public float getSpeed() {
        DuctNetwork ductNetwork = KelvinMod.INSTANCE.getKelvinByPlatform();
        if (ductNetwork == null) {
            return 0.0f;
        }
        DuctNetwork network = ductNetwork;
        double pressure = network.getPressureAt(this.getDuctNodePosition());
        return Math.min((float)(pressure * (double)this.PRESSURE_TO_SPEED), this.MAX_AIRFLOW_SPEED);
    }

    @Nullable
    public AirCurrent getAirCurrent() {
        return this.airCurrent;
    }

    @Nullable
    public Level getAirCurrentWorld() {
        return this.f_58857_;
    }

    @Nullable
    public BlockPos getAirCurrentPos() {
        return this.f_58858_;
    }

    @Nullable
    public Direction getAirflowOriginSide() {
        return (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_);
    }

    @Nullable
    public Direction getAirFlowDirection() {
        if (!(this.getSpeed() == 0.0f)) {
            return (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_);
        }
        return null;
    }

    public boolean isSourceRemoved() {
        return this.f_58859_;
    }

    public void physTick(@Nullable PhysShip physShip, @NotNull PhysLevel physLevel) {
        Intrinsics.checkNotNullParameter((Object)physLevel, (String)"physLevel");
    }
}

