/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.logistics.gas.duct;

import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.valkyrienskies.clockwork.content.logistics.gas.duct.DuctBlock;
import org.valkyrienskies.clockwork.content.logistics.gas.duct.DuctConnectionType;
import org.valkyrienskies.kelvin.api.DuctNodePos;
import org.valkyrienskies.kelvin.api.NodeBehaviorType;
import org.valkyrienskies.kelvin.api.nodes.ILeakNode;
import org.valkyrienskies.kelvin.api.nodes.PipeDuctNode;
import org.valkyrienskies.kelvin.util.KelvinExtensions;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B'\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u0005\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u0012\u0006\u0010\f\u001a\u00020\u0005\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lorg/valkyrienskies/clockwork/content/logistics/gas/duct/DuctPipeNode;", "Lorg/valkyrienskies/kelvin/api/nodes/PipeDuctNode;", "Lorg/valkyrienskies/kelvin/api/nodes/ILeakNode;", "Lnet/minecraft/world/level/Level;", "level", "", "getLeakRatio", "(Lnet/minecraft/world/level/Level;)D", "Lorg/valkyrienskies/kelvin/api/DuctNodePos;", "pos", "volume", "maxPressure", "maxTemperature", "<init>", "(Lorg/valkyrienskies/kelvin/api/DuctNodePos;DDD)V", "clockwork"})
@SourceDebugExtension(value={"SMAP\nDuctPipeNode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DuctPipeNode.kt\norg/valkyrienskies/clockwork/content/logistics/gas/duct/DuctPipeNode\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,22:1\n1863#2,2:23\n*S KotlinDebug\n*F\n+ 1 DuctPipeNode.kt\norg/valkyrienskies/clockwork/content/logistics/gas/duct/DuctPipeNode\n*L\n17#1:23,2\n*E\n"})
public final class DuctPipeNode
extends PipeDuctNode
implements ILeakNode {
    public DuctPipeNode(@NotNull DuctNodePos pos, double volume, double maxPressure, double maxTemperature) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        super(pos, NodeBehaviorType.PIPE, null, volume, maxPressure, maxTemperature, 4, null);
    }

    public double getLeakRatio(@NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        BlockState state = level.m_8055_(KelvinExtensions.INSTANCE.toMinecraft(this.getPos()));
        if (!(state.m_60734_() instanceof DuctBlock)) {
            return 0.0;
        }
        double leak = 0.0;
        Iterable $this$forEach$iv = (Iterable)EntriesMappings.entries$0;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Direction it = (Direction)element$iv;
            boolean bl = false;
            EnumProperty<DuctConnectionType> enumProperty = DuctBlock.Companion.getDIR_TO_CONNECTION().get(it);
            Intrinsics.checkNotNull(enumProperty);
            leak += state.m_61143_((Property)enumProperty) == DuctConnectionType.LEAK ? 0.16666666666666666 : 0.0;
        }
        return leak;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<Direction> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])Direction.values()));
        }
    }
}

