/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.logistics.gas.crafter;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.foundation.blockEntity.renderer.SmartBlockEntityRenderer;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.valkyrienskies.clockwork.ClockworkPartials;
import org.valkyrienskies.clockwork.content.logistics.gas.crafter.GasCrafterBlockEntity;
import org.valkyrienskies.clockwork.util.EaseHelper;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0012\u0010\u0013J?\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0014\u00a2\u0006\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0014"}, d2={"Lorg/valkyrienskies/clockwork/content/logistics/gas/crafter/GasCrafterBlockEntityRenderer;", "Lcom/simibubi/create/foundation/blockEntity/renderer/SmartBlockEntityRenderer;", "Lorg/valkyrienskies/clockwork/content/logistics/gas/crafter/GasCrafterBlockEntity;", "be", "", "partialTicks", "Lcom/mojang/blaze3d/vertex/PoseStack;", "ms", "Lnet/minecraft/client/renderer/MultiBufferSource;", "buffer", "", "light", "overlay", "", "renderSafe", "(Lorg/valkyrienskies/clockwork/content/logistics/gas/crafter/GasCrafterBlockEntity;FLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;II)V", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;", "context", "<init>", "(Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;)V", "clockwork"})
public final class GasCrafterBlockEntityRenderer
extends SmartBlockEntityRenderer<GasCrafterBlockEntity> {
    public GasCrafterBlockEntityRenderer(@NotNull BlockEntityRendererProvider.Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
    }

    protected void renderSafe(@NotNull GasCrafterBlockEntity be, float partialTicks, @NotNull PoseStack ms, @NotNull MultiBufferSource buffer, int light, int overlay) {
        Intrinsics.checkNotNullParameter((Object)be, (String)"be");
        Intrinsics.checkNotNullParameter((Object)ms, (String)"ms");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        SuperByteBuffer frame = CachedBuffers.partial((PartialModel)ClockworkPartials.INSTANCE.getGAS_CRAFTER_FRAME(), (BlockState)be.m_58900_());
        SuperByteBuffer tube = CachedBuffers.partial((PartialModel)ClockworkPartials.INSTANCE.getGAS_CRAFTER_TUBE(), (BlockState)be.m_58900_());
        SuperByteBuffer mesh = CachedBuffers.partial((PartialModel)ClockworkPartials.INSTANCE.getGAS_CRAFTER_MESH(), (BlockState)be.m_58900_());
        SuperByteBuffer glow_lamp = CachedBuffers.partial((PartialModel)ClockworkPartials.INSTANCE.getGAS_CRAFTER_GLOW(), (BlockState)be.m_58900_());
        float glow = (float)2 - be.getGlow().getValue(partialTicks);
        glow = (float)(1.0 - (double)2 * Math.pow(glow - 0.75f, 2.0));
        glow = Mth.m_14036_((float)glow, (float)-1.0f, (float)1.0f);
        int color = (int)((float)200 * glow);
        glow_lamp.color(color, color, color, 255).disableDiffuse();
        VertexConsumer cutout = buffer.m_6299_(RenderType.m_110463_());
        VertexConsumer translucent = buffer.m_6299_(RenderType.m_110466_());
        Direction direction = (Direction)be.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_);
        if (direction == null) {
            return;
        }
        Direction facing = direction;
        be.setClientProcessingTicks(Math.max(be.getClientProcessingTicks() - partialTicks, 0.0f));
        Vec3i vec3i = facing.m_122436_();
        Intrinsics.checkNotNullExpressionValue((Object)vec3i, (String)"getNormal(...)");
        mesh.translate((Vector3fc)VectorConversionsMCKt.toJOMLF((Vec3i)vec3i).mul(EaseHelper.INSTANCE.easeInQuad((float)Math.cos(be.getClientProcessingTicks() * 0.1f)) * 0.3f - 0.3f));
        if (be.getClientProcessingTicks() > 0.0f) {
            Vector3f randomOffset = new Vector3f(Random.Default.nextFloat(), Random.Default.nextFloat(), Random.Default.nextFloat()).mul(0.01f);
            frame.translate((Vector3fc)randomOffset);
            glow_lamp.translate((Vector3fc)randomOffset);
            tube.translate((Vector3fc)randomOffset);
        }
        Intrinsics.checkNotNull((Object)frame);
        Intrinsics.checkNotNull((Object)cutout);
        GasCrafterBlockEntityRenderer.renderSafe$rotateAndRender(facing, ms, frame, light, cutout);
        Intrinsics.checkNotNull((Object)mesh);
        Intrinsics.checkNotNull((Object)translucent);
        GasCrafterBlockEntityRenderer.renderSafe$rotateAndRender(facing, ms, mesh, light, translucent);
        Intrinsics.checkNotNull((Object)tube);
        GasCrafterBlockEntityRenderer.renderSafe$rotateAndRender(facing, ms, tube, 0xF000F0, cutout);
        Intrinsics.checkNotNull((Object)glow_lamp);
        GasCrafterBlockEntityRenderer.renderSafe$rotateAndRender(facing, ms, glow_lamp, 0xF000F0, translucent);
    }

    private static final void renderSafe$rotateAndRender(Direction facing, PoseStack $ms, SuperByteBuffer buffer, int light, VertexConsumer consumer) {
        ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)buffer.translate(0.5, 0.5, 0.5)).rotateToFace(facing)).translateBack(0.5, 0.5, 0.5)).light(light).renderInto($ms, consumer);
    }
}

